<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Product Price
 * Displays the product price.
 */


if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('wc_price', 'avia_please_install_woo');
	return;
}


if ( !class_exists( 'avia_wc_price' ) )
{
	class avia_wc_price extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Product Price', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."price-tag.png";
			$this->config['order']		= 94;
			$this->config['target']		= 'avia-target-insert';
			$this->config['modal_data'] = array('modal_class' => 'largescreen');
			$this->config['shortcode'] 	= 'wc_price';
			$this->config['tooltip'] 	= __('Displays the product price.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview'] 	= false;
			$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
		}
		
		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(	
							"name" 	=> __("Pricing Display", 'avia_framework' ),
							"desc" 	=> __("Select which style you would like the price displayed.<br /><h2>Inline = <sup style='position:relative;font-size:65%;top:-0.4em;vertical-align:baseline;'>$</sup>32.50</h2><h2>Superscripted = <sup style='position:relative;font-size:65%;top:-0.4em;vertical-align:baseline;'>$</sup>32<sup style='position:relative;font-size:65%;top:-0.4em;vertical-align:baseline;'>50</sup></h2>", 'avia_framework' ),
							"id" 	=> "price_style",
							"type" 	=> "select",
							"std" 	=> "inline",
							"subtype" => array("Inline"=>'inline',"Superscripted"=>'superscripted')
							), 
							
					array(	
						"name" 	=> __("Price Suffix", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed after the product price.<br /><strong>Example:</strong> per yard, each, etc.", 'avia_framework' ),
						"id" 	=> "suffix",
						"std" 	=> "",
						"type" 	=> "input"),
							
					array(	
							"name" 	=> __("Text Color", 'avia_framework' ),
							"desc" 	=> __("Select a color for your Product Price element.", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-heading')
							), 
					
					array(	
							"name" 	=> __("Custom Text Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom color for your Product Price element here.", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('color','equals','custom-color-heading')
						),
					
					array(	
						"name" 	=> __("Field Wrapper", 'avia_framework' ),
						"desc" 	=> __("Define what element you would like to wrap the repeater element values (i.e. li or p tag). Insert the tag without <>", 'avia_framework' ),
						"id" 	=> "wrapper",
						"std" 	=> __("h2", 'avia_framework' ),
						"type" 	=> "input"),
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('price_style'=>'','suffix'=>'','color'=>'','custom_font'=>'','wrapper'=>'h2'), $atts, $this->config['shortcode']));
			
			global $product;
				$product = wc_get_product();
				
			if($color == "custom-color-heading" && $custom_font)  
	        		{
	        			$styling .= "color:{$custom_font};";
	        		}
			if(!empty($styling)) $styling = "style='{$styling}'";
			
			$suffix = $atts['suffix'];
			if ($suffix) $suffix = '<small style="font-size:65%;"> '.$suffix.'</small>';
				
			if ($wrapper){
				$start_wrap = '<'.$wrapper.' '.$styling.' class="{$av_display_classes}">';
				$end_wrap = $suffix.'</'.$wrapper.'>';
			} else {
				$start_wrap = '<span '.$styling.' class="{$av_display_classes}">';
				$end_wrap = $suffix.'</span>';
			}
			$currency .= get_woocommerce_currency_symbol();
			$currency = "<sup style='position:relative;font-size:65%;top:-0.4em;vertical-align:baseline;'>".$currency."</sup>";
			
			if ($price_style == 'inline'){
				$price = $product->get_price();
				$output .= $currency.$price;	
			}
			if ($price_style == 'superscripted'){
				$price = $product->get_price();
				$price = explode('.', $price);
				$productprice = $currency.$price[0]."<sup style='position:relative;font-size:65%;top:-0.4em;vertical-align:baseline;'>".$price[1]."</sup>";
				$output .= $productprice;
			}
						
			return $start_wrap.$output.$end_wrap;
		}
	}
}
