<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * WooCommerce Product Image
 * Displays the product image with a sale badge if on sale.
 */

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('av_product_img', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_product_img' ) )
{
	class avia_product_img extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Product Image', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."product-img.png";
			$this->config['order']		= 97;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_product_img';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays the product image with a sale badge if on sale.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(
								"name" 	=> __("Sale Badge Visibility",'avia_framework' ),
								"desc" 	=> __("Tick the box to completely disable the sale badge element.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
							array(	
									"desc" 	=> __("Disable", 'avia_framework'),
									"id" 	=> "hide_badge",
									"std" 	=> "",
									"container_class" => 'av-multi-checkbox',
									"type" 	=> "checkbox"),
				            
				    array(	
						"name" 	=> __("Sale Tagline", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed in the sale badge if the product is on sale.<br /><strong>Example:</strong> 10% OFF", 'avia_framework' ),
						"id" 	=> "tagline",
						"std" 	=> "",
						"type" 	=> "input"),
						
					array(	
							"name" 	=> __("Link Settings", 'avia_framework' ),
							"desc" 	=> __("Select whether or not you would like the image linked to a larger image via lightbox.", 'avia_framework' ),
							"id" 	=> "link_img",
							"type" 	=> "select",
							"std" 	=> "lightbox-img",
							"subtype" => array("No Link"=>'no-link',"Lightbox"=>'lightbox-img')
							), 
													
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				

				);
		}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('tagline'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			global $woocommerce, $product;
			if(!is_object($woocommerce) || !is_object($woocommerce->query) || empty($product)) return;
			
			ob_start();
			
			global $product;
			if ( $product->is_on_sale() ) {
			$sale_badge_bg = "/wp-content/themes/enfold/shortcodes/spiderfly-elements/images/sale-ribbon.png";
			$sale_tagline = $tagline;
			if ($sale_tagline) {
			$sale_tag = " - " . $sale_tagline;
			}
			if (empty($atts['hide_badge'])) {
				if(is_rtl()):
					$sale_badge = "<h2 style='background: url(".$sale_badge_bg.") no-repeat scroll left center; background-size:cover; width: max-content; text-align:right; color:#f5f5f5; font-size:22px; padding:13px 13px 13px 20px; position:absolute; top:-4px; z-index:10;'>SALE". $sale_tag ."</h2>";
				else:
					$sale_badge = "<h2 style='background: url(".$sale_badge_bg.") no-repeat scroll right center; background-size:cover; width: max-content; text-align:left; color:#f5f5f5; font-size:22px; padding:13px 20px 13px 13px; position:absolute; top:-4px; z-index:10;'>SALE". $sale_tag ."</h2>";
				endif;
			}
			}
			$product_image = get_the_post_thumbnail( $post_id, 'shop_catalog' );
			$product_image_large = get_the_post_thumbnail_url( $post_id, 'large' );
			
			//html markup
						
			if($atts['link_img'] == "lightbox-img") {
	        		$output .= '<div class="product-image avia-image-container avia-builder-el-12 el_after_av_codeblock el_before_av_hr avia-align-center no-overlay '.$av_display_classes.' '.$meta['el_class'].'" itemscope="itemscope" itemtype="https://schema.org/ImageObject"><div class="avia-image-container-inner">';
					$output .= $sale_badge;
					$output .= '<a rel="lightbox" data-rel="gallery-1" class="lightbox" href="';
					$output .= $product_image_large;
					$output .= '">';
					$output .= $product_image;
					$output .= '</a></div></div><section class="av_textblock_section " itemscope="itemscope" itemtype="https://schema.org/CreativeWork"><div class="avia_textblock text-center no-margin " itemprop="text"><p><small>CLICK TO PREVIEW</small></p></div></section>';
			} 
			
			if($atts['link_img'] == "no-link") {
			$output .= '<div class="product-image avia-image-container avia-builder-el-12 el_after_av_codeblock el_before_av_hr avia-align-center no-overlay '.$av_display_classes.' '.$meta['el_class'].'" itemscope="itemscope" itemtype="https://schema.org/ImageObject"><div class="avia-image-container-inner">';
					$output .= $sale_badge;
					$output .= $product_image;
					$output .= '</a></div></div>';
				
			}
			
			return $output;
		}
	}
}
