<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Key Features
 * Displays a key feature list for your product or post.
 */

add_action('wp_head','feature_style');
function feature_style( ){
	if(is_rtl()):
		echo '<style>.feature-list-inline .product-feature {float:right; margin-left:25px;}</style>';
		echo '<style>.feature-list-newline .product-feature {float:none; margin-left:25px; margin-bottom:5px;}</style>';
		echo '<style>@media only screen and (max-width: 767px){.feature-list-inline .product-feature {float:none; margin-left:25px; margin-bottom:5px;} }</style>';
	else:
		echo '<style>.feature-list-inline .product-feature {float:left; margin-right:25px;}</style>';
		echo '<style>.feature-list-newline .product-feature {float:none; margin-right:25px; margin-bottom:5px;}</style>';
		echo '<style>@media only screen and (max-width: 767px){.feature-list-inline .product-feature {float:none; margin-right:25px; margin-bottom:5px;} }</style>';
	endif;
	}

if ( !class_exists( 'avia_wc_featurelist' ) )
{
	class avia_wc_featurelist extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Key Feature List', 'avia_framework' );
				$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."feature.png";
				$this->config['order']		= 93;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'wc_featurelist';
				$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
				$this->config['shortcode_nested'] = array('wc_featurelist_item');
				$this->config['tooltip'] 	= __('Creates a feature list.', 'avia_framework' );
				$this->config['preview'] 	= false;

			}

			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),

						array(
							"name" => __("Add/Edit List items", 'avia_framework' ),
							"desc" => __("Here you can add, remove and edit the items of your item list.", 'avia_framework' ),
							"type" 			=> "modal_group",
							"id" 			=> "content",
							"modal_title" 	=> __("Edit List Item", 'avia_framework' ),
							"std"			=> array(

													array('title'=>__('List Title 1', 'avia_framework' )),
													array('title'=>__('List Title 2', 'avia_framework' )),
													array('title'=>__('List Title 3', 'avia_framework' )),

													),

							'subelements' 	=> array(

									array(
									"name" 	=> __("List Item Title", 'avia_framework' ),
									"desc" 	=> __("Enter the list item title here (Better keep it short)", 'avia_framework' ) ,
									"id" 	=> "feature",
									"std" 	=> "Feature",
									"type" 	=> "input"),
									
									 array(	
							"name" 	=> __("Icon Color", 'avia_framework' ),
							"desc" 	=> __("Select a color for the icon.", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-icon')
							), 
							
					array(	
							"name" 	=> __("Custom Icon Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom icon color.", 'avia_framework' ),
							"id" 	=> "custom_icon",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('color','equals','custom-color-icon')
						),
						)
						
					),

					array(	
							"name" 	=> __("List Display", 'avia_framework' ),
							"desc" 	=> __("Select which style you would like the list displayed.<br /><strong>Inline</strong>: All features are listed in a row.<br /><strong>New Line</strong>: Each feature is listed on a separate line.", 'avia_framework' ),
							"id" 	=> "list_style",
							"type" 	=> "select",
							"std" 	=> "inline",
							"subtype" => array("Inline List"=>'inline',"New Line List"=>'newline')
							), 
					
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					
						
					array(
							"type" 	=> "tab",
							"name"	=> __("Screen Options",'avia_framework' ),
							'nodescription' => true
								),
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),
					
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),

				);

			}

			/**
			 * Editor Sub Element - this function defines the visual appearance of an element that is displayed within a modal window and on click opens its own modal window
			 * Works in the same way as Editor Element
			 * @param array $params this array holds the default values for $content and $args.
			 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
			 */
			function editor_sub_element($params)
			{
				$template = $this->update_template("feature", "{{feature}}");

				extract(av_backend_icon($params)); // creates $font and $display_char if the icon was passed as param "icon" and the font as "font" 

				$params['innerHtml']  = "";
				$params['innerHtml'] .= "<div class='avia_title_container'>";
				$params['innerHtml'] .= "<span {$template} >".$params['args']['feature']."</span></div>";

				return $params;
			}


			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				$this->screen_options = AviaHelper::av_mobile_sizes($atts);
				extract($this->screen_options); //return $av_font_classes, $av_title_font_classes and $av_display_classes
				
				extract(shortcode_atts(array(
				'color'=>'', 
				'custom_icon'=>'', 
				'feature'=>'',
				'list_style'=>'', 
				
				), $atts, $this->config['shortcode']));
				
				$output	 = "";
				if(is_rtl()):
					$output .= "<div class='feature-list-{$list_style}' style='clear:right; display:inline-block'>";
				else:
					$output .= "<div class='feature-list-{$list_style}' style='clear:left; display:inline-block'>";
				endif;
				$output .=ShortcodeHelper::avia_remove_autop( $content, true );
				$output .="</div>";

				return $output;
			}

			function wc_featurelist_item($atts, $content = "", $shortcodename = "")
			{			
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
				extract($this->screen_options); //return $av_font_classes, $av_title_font_classes and $av_display_classes
				
                $atts =  shortcode_atts(array('feature' => '', 'color' => '', 'custom_icon' => '', 'content'=>'', 'list_style'=>'',), $atts, 'wc_featurelist_item');
                
				$color  = $atts['color'];
				$custom_icon  = $atts['custom_icon'];
				// if the color is a custom hex value add the styling for both border and font
	        		if($color == "custom-color-icon" && $custom_icon)  
	        		{
	        			$styling .= "color:".$custom_icon." !important;";
	        		}
			//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
					
				$feature  = $atts['feature'];
				
					$output  = "";
					$output .= '<div class="product-feature '.$av_display_classes.'" itemprop="text"> <span class="av_font_icon avia_animate_when_visible  0 av-icon-style-  av-no-color avia-icon-pos-left  avia_start_animation avia_start_delayed_animation"><span class="av-icon-char" ';
					$output .= $styling;
					$output .= 'aria-hidden="true" data-av_icon="" data-av_iconfont="entypo-fontello"></span></span> ';
					$output .= $feature;
					$output .= '</div>';

				return $output;
			}
	}
}
