<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Ribbon Style Header
 * Displays a ribbon style header.
 */
 
// Don't load directly
if ( !defined('ABSPATH') ) { die('-1'); }

if ( !class_exists( 'avia_ribbon_heading' ) ) 
{
	class avia_ribbon_heading extends aviaShortcodeTemplate{
			
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Ribbon Heading', 'avia_framework' );
				$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."ribbon.png";
				$this->config['order']		= 21;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'ribbon_heading';
				$this->config['tinyMCE']    = array('disable'=>true);
				$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
				$this->config['tooltip'] 	= __('Creates a ribbon style heading.', 'avia_framework' );
				$this->config['preview'] 	= true;
			}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}
			
			
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
					array(	
						"name" 	=> __("Heading Text", 'avia_framework' ),
						"desc" 	=> __("Enter your header text. For best results, less is more.", 'avia_framework' ),
						"id" 	=> "heading",
						"std" 	=> __("Hello", 'avia_framework' ),
						"type" 	=> "input"),
					
					array(	"name" 	=> __("Heading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your Heading in pixels", 'avia_framework' ),
				            "id" 	=> "size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(12,45,1),
				            "std" => "16"),
				     
				    array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom color for your heading text here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
						),
						
					array(	
							"name" 	=> __("Custom Ribbon Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom color for you ribbon here.", 'avia_framework' ),
							"id" 	=> "custom_bg",
							"type" 	=> "colorpicker",
							"std" 	=> "#74a6d9",
						),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
									
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
								
						
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
					
				  
				);

			}

			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			 
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{

				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				
			    extract(shortcode_atts(array('heading'=>'', 'custom_font'=>'', 'custom_bg'=>'', 'size'=>'16', ), $atts, $this->config['shortcode']));
			
        		$output  = "";
        		$styling = "";
        		
				$size = $atts['size'];
				$ribbonbg = $atts['custom_bg'];
				$custom_font = $atts['custom_font'];
				
        		if($heading)
        		{
        			// add seo markup
                    $markup = avia_markup_helper(array('context' => 'entry_title','echo'=>false, 'custom_markup'=>$meta['custom_markup']));
					
					// filter heading for & symbol and convert them					
        			$heading = apply_filters('avia_ampersand', wptexturize($heading));
        			
        			//if the heading contains a strong tag make apply a custom class that makes the rest of the font appear smaller for a better effect
        			if( strpos($heading, '<strong>') !== false ) $class .= " av-thin-font";
					
					if($ribbonbg){
						$color .= "background-color:".$ribbonbg."!important;";
					}
						

        			
        			//apply the padding bottom styling
	        		$styling .= "color:{$custom_font} !important; font-size:{$size}px !important; ".$color;
	       
	        		//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
	        	
	        		//html markup
					if(is_rtl()):
						$ribbon_style = "<style>.ribbon .ribbon-content::before, .ribbon .ribbon-content::after {content: ''; border-color:".$ribbonbg." transparent transparent transparent !important;} .ribbon::before {content: ''; border-color:".$ribbonbg." !important; border-right-color: transparent !important;} .ribbon::after {content: ''; border-color:".$ribbonbg." !important; border-left-color: transparent !important;}</style>";
					else:
						$ribbon_style = "<style>.ribbon .ribbon-content::before, .ribbon .ribbon-content::after {content: ''; border-color:".$ribbonbg." transparent transparent transparent !important;} .ribbon::before {content: ''; border-color:".$ribbonbg." !important; border-left-color: transparent !important;} .ribbon::after {content: ''; border-color:".$ribbonbg." !important; border-right-color: transparent !important;}</style>";
					endif;
				
					
	        		$output .= 	$ribbon_style."<h2 ".$styling." class='ribbon ".$av_display_classes."'><strong class='ribbon-content'>".$heading."</strong></h2>";
        		}
        		
        		return $output;
        	}		
	}
}
