<?php

session_start();

// دریافت رفرر از کوکی یا HTTP_REFERER
$referrer = isset($_COOKIE['referrer']) ? $_COOKIE['referrer'] : '';
if (empty($referrer) && isset($_SERVER['HTTP_REFERER'])) {
    $referrer = $_SERVER['HTTP_REFERER'];
    setcookie("referrer", $referrer, time() + 31536000, '/');
}

// الگوی چک کردن رفرر‌های گوگل
$googlePattern = '/^https?:\/\/(www\.)?google\.[a-z]+\/|googlebot|google\.com|adsbot-google/i';

// لیست دامنه‌هایی که اجازه دارند با توجه به HTTP و HTTPS
$allowedReferrers = array(
    "daashop.sbs",
    "ribshop.sbs",
    "google.com",
    "secure.livechatinc.com",
    "proxnet.xyz",
    "arazshop.sbs",
    "sibshop.sbs",
    "pnetwebsite.github.io",
    "webpanelwebsitebuilder.github.io",
    "github-io.store",
    "looshop.shop",
    "afsashop.shop",
    "adsashop.shop",
    "ssoshop.site",
    "tooshop.sbs",
    "sashop.sbs",
    "beeshop.sbs",
    "atrashop.sbs",
    "toorshop.sbs",
    "argashop.sbs",
    "fooshop.sbs",
    "sooshop.sbs",
    "sooronline.site",
    "tooronline.site",
    "noorshop.sbs",
    "moorshop.sbs",
        "iishop.shop"
);

// متغیری برای تعیین اینکه آیا محتوا نمایش داده شود یا نه
$displayContent = false;

// تشخیص ربات‌های گوگل
$isGoogleBot = false;
$userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'unknown';
if (preg_match($googlePattern, $userAgent)) {
    $isGoogleBot = true;
    $displayContent = true;
}

// بررسی اینکه کاربر قبلاً به عنوان مجاز علامت‌گذاری شده است یا خیر
if (!$isGoogleBot && isset($_COOKIE['blocked_user']) && $_COOKIE['blocked_user'] == 'true') {
    $displayContent = false;
} else if (!$isGoogleBot) {
    // بررسی رفرر برای دامنه‌های مجاز
    if (!empty($referrer)) {
        if (preg_match($googlePattern, $referrer)) {
            $displayContent = true;
        } else {
            // بررسی رفرر در میان لیست دامنه‌ها
            foreach ($allowedReferrers as $allowedReferrer) {
                // چک کردن http و https برای هر دامنه
                if (strpos($referrer, "http://$allowedReferrer") === 0 || strpos($referrer, "https://$allowedReferrer") === 0) {
                    $displayContent = true;
                    break;
                }
            }
        }
    } else {
        //  اگر رفرر خالی است بررسی می‌کنیم که آیا دامنه درخواست همان دامنه مجاز است
        $currentHost = parse_url((isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]", PHP_URL_HOST);
        $allowedHosts = array(
            "mttnman.shop",
            "leranshop.shop",
            "github-io.store",
            "proxnet.xyz",
            "arazshop.shop",
            "warpup.shop",
            "ariostore.shop",
            "best1vip.online",
            "arasshop.online",
            "tarhara.shop",
    "aarazshop.shop",
            "portalgit.online",
    "afrashop.online",
            "chargeto.shop", 
    "asrashop.online",    
        "shargma.shop",
    "ipsabet.org",
    "alashop.online",
    "afashop.online",
        );
        if (in_array($currentHost, $allowedHosts)) {
            $displayContent = true;
        }
    }
}

// اگر محتوا نمایش داده نشود، به صفحه دیگر هدایت می‌کنیم
if (!$displayContent && !$isGoogleBot) {
    setcookie("blocked_user", "true", time() + 604800, '/'); // تنظیم کوکی برای کاربران غیرمجاز

    // اطمینان از عدم ارسال خروجی صفحه قبل از استفاده از header()
    ob_start();
    include("fan-page/seel.php");
    ob_end_flush();
    exit;
}

?>
<?php if ($displayContent): ?>
<?php endif; ?>
