<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>دامنه برای فروش است</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;700&display=swap" rel="stylesheet">

  <style>
    body {
      font-family: 'Vazirmatn', sans-serif;
      background: linear-gradient(135deg, #e7eaf6 0%, #fffbea 100%);
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .card-box {
      background: #fff;
      border-radius: 20px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.1);
      padding: 50px 35px;
      text-align: center;
      max-width: 440px;
    }
    .logo {
      width: 90px;
      height: 90px;
      margin: 0 auto 25px;
      border-radius: 50%;
      background: radial-gradient(circle at 30% 30%, #0d6efd 40%, #c6a300 100%);
      color: #fff;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 28px;
      font-weight: bold;
    }
    h1 {
      font-size: 1.8rem;
      color: #222;
      margin-bottom: 10px;
      font-weight: 700;
    }
    #domainName {
      font-size: 1.1rem;
      color: #0d6efd;
      font-weight: 600;
      margin-bottom: 20px;
      direction: ltr;
    }
    p {
      font-size: 1.1rem;
      color: #555;
      margin-bottom: 30px;
    }
    .call-btn {
      background: linear-gradient(135deg, #0d6efd, #c6a300);
      color: #fff;
      padding: 12px 30px;
      border-radius: 8px;
      font-size: 1.1rem;
      font-weight: 600;
      text-decoration: none;
      transition: 0.3s ease-in-out;
    }
    .call-btn:hover {
      transform: translateY(-3px);
      text-decoration: none;
      background: linear-gradient(135deg, #0056d2, #b89700);
    }
  </style>
</head>

<body>

  <div class="card-box">
    <div class="logo">فروش</div>
    <h1>این دامنه برای فروش می‌باشد</h1>
    <div id="domainName"></div>
    <p>برای اطلاعات بیشتر با شماره زیر تماس بگیرید:</p>
    <a href="tel:+989981114171" class="call-btn">تماس با ما</a>
  </div>

  <script>
    // نمایش دامنه‌ای که صفحه از آن باز شده
    const domainElement = document.getElementById('domainName');
    const domainName = window.location.hostname; // فقط نام دامنه بدون www یا مسیر
    domainElement.textContent = domainName;
  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
