<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Service;
use App\Model\Services;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $services = Services::allServices();
        return view('Admin.Services.serviceList')->with('services', $services);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response=>
     */
    public function create()
    {
        return view('Admin.Services.serviceInsert');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Service $request)
    {
        $check = Services::storeService(['title' => $request->title, 'text' => $request->text, 'image' => storeFile($request->image, 'file/service/')]);
        if ($check === true)
            return redirect()->route('Admin.services.create')->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Admin.services.create')->with('msgError', trans('langPanel.the_operation_failed'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public
    function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public
    function edit($id)
    {
        $service = Services::getService($id);
        $all_data = ['service' => $service];
        return view('Admin.Services.serviceUpdate')->with('data', $all_data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public
    function update(Service $request, $id)
    {
        $data = ['title' => $request->title, 'text' => $request->text];
        if (isset($request->image))
            $data['image'] = storeFile($request->image, 'file/service/');
        $check = Services::updateServices($id, $data);
        if ($check === true)
            return redirect()->route('Admin.services.edit', $id)->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Admin.services.edit', $id)->with('msgError', trans('langPanel.the_operation_failed'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public
    function destroy($id)
    {
        $check = Services::destroy($id);
        if ($check === true)
            return redirect()->route('Admin.services.index')->with('msgSuccess', trans('langPanel.mission_accomplished'));
        else
            return redirect()->route('Admin.services.index')->with('msgError', trans('langPanel.the_operation_failed'));

    }
}
