<?php
/* template name: Portfolio */
get_header();
$options = get_option('tiyara');
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );
?>

<div class="page-wrap archive-portfolio">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-10 mx-auto page-head">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo get_the_title(); ?>
                </h1>
                <?php get_template_part('templates/content/breadcrumb'); ?>
            </div>
            <div class="col-12">
                <div class="row">
                    <?php
                    $args = array(
                        'post_type' => 'portfolio',
                        'paged' 	=> $paged,
                        'post_status ' => 'publish',
                        'posts_per_page' => 12
                    );
                    $posts = new WP_Query($args);
                    if ($posts->have_posts()):
                        $i=0.25; while ($posts->have_posts()) : $posts->the_post();
                        echo '<div class="col-12 col-sm-6 col-lg-3 wow fadeInUp" data-wow-delay="<?php echo $i; ?>s">';
                            get_template_part('templates/card/portfolio', 'card');
                        echo '</div>';
                        $i+=0.25; endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
                <!-- Pagination -->
                <div class="pagination pagination_wrap">
                    <?php pagination_bar($posts); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer();?>
