<?php
/* Template Name: About Us*/
get_header();
$image = get_field('about_logo');
?>
<div class="page-wrap about-page">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-lg-10 mx-auto">
                <article class="page-article">
                    <?php if ($image) { ?>
                        <div class="about-logo text-center">
                            <img
                            src="<?php echo $image['url']; ?>"
                            width="<?php echo $image['width']; ?>"
                            height="<?php echo $image['height']; ?>"
                            alt="<?php echo $image['alt']; ?>" />
                        </div>
                    <?php } ?>
                    <div class="text-center mb-4">
                        <h1 class="section-title wow fadeInUp" data-wow-delay="0.25s">
                            <?php if (get_field('about_title') != '') {
                                echo get_field('about_title');
                            } else {
                                echo get_the_title();
                            } ?>
                        </h1>
                        <?php
                        if (get_field('about_tsubtitle') != '') {
                            echo '<span class="d-block subtitle">'
                                . get_field('about_tsubtitle') .
                                '</span>';
                        }
                        ?>
                    </div>
                    <div class="row align-items-center">
                        <div class="col-12 col-md-5">
                            <?php if (has_post_thumbnail()) { ?>
                                <div class="about-thumb wow fadeInUp" data-wow-delay="0.5s">
                                    <?php the_post_thumbnail('large'); ?>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="col-12 col-md-7">
                            <div class="default-editor"><?php the_content(); ?></div>
                        </div>
                    </div>
                </article>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>
