<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * The Events Calendar Support
 *
 * @link https://docs.theeventscalendar.com/
 */

if ( ! class_exists( 'Tribe__Events__Query' ) ) {
	return;
}

if ( ! function_exists( 'us_enqueue_the_events_calendar_styles' ) ) {
	/**
	 * Enqueue css file
	 */
	function us_enqueue_the_events_calendar_styles() {
		if (
			defined( 'US_DEV' )
			OR ! us_get_option( 'optimize_assets', 0 )
		) {
			global $us_template_directory_uri;
			$src = '/common/css/plugins/tribe-events' . ( ! defined( 'US_DEV' ) ? '.min' : '' ) . '.css';
			wp_register_style( 'us-tribe-events', $us_template_directory_uri . $src, array(), US_THEMEVERSION, 'all' );
			wp_enqueue_style( 'us-tribe-events' );
		}
	}
	add_action( 'wp_enqueue_scripts', 'us_enqueue_the_events_calendar_styles', 14 );
}

if ( ! function_exists( 'the_events_calendar_us_grid_listing_query_args' ) ) {
	add_filter( 'us_grid_listing_query_args', 'the_events_calendar_us_grid_listing_query_args', 501, 2 );
	/**
	 * Argument handler when requesting TEC events
	 *
	 * @link https://docs.theeventscalendar.com/reference/functions/tribe_get_events/
	 *
	 * @param array $query_args Array of query variables and their corresponding values
	 * @param array $defined_vars Array of all defined variables in request context
	 * @return array Returns a modified list of query arguments
	 */
	function the_events_calendar_us_grid_listing_query_args( $query_args, $defined_vars ) {
		if (
			! empty( $query_args['post_type'] )
			AND in_array( 'tribe_events', (array) $query_args['post_type'] )
			AND isset( $defined_vars['events_calendar_show_past'] )
		) {
			// Set how events are reflected
			$query_args['eventDisplay'] = (
				! empty( $defined_vars['events_calendar_show_past'] )
					? 'custom'
					: 'list'
			);

			// Force update of parameters generated by The Events Calendar tools
			if ( function_exists( 'tribe_get_events' ) ) {
				$wp_query = tribe_get_events( $query_args, /* return WP_Query */TRUE );
				if ( $wp_query instanceof WP_Query ) {
					$query_args = (array) $wp_query->query;
				}
			}
		}
		return $query_args;
	}
}
