<?php
use \ahura\app\mw_tools;
/**
 * Single Product Price
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/price.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

$digikala_onsale_style = is_single() && $product->is_on_sale() && $product->get_sale_price() && \ahura\app\mw_options::get_show_product_onsale_percent() && \ahura\app\mw_options::get_single_product_style() == 'digikala';
if($digikala_onsale_style): ?>
	<div class="d-flex flex-wrap onsale-price-area">
		<div class="digi-onsale-wrapper">
			<div class="digi-onsale">
				<span class="discounted">
					<?php
                    $percent = (($product->get_regular_price() - $product->get_sale_price()) * 100) / $product->get_regular_price();
                    echo $percent > 0 ? round($percent) : 0;
                    ?>
				</span>
				<span class="prefix">
					<?php echo __('%', 'ahura'); ?>
				</span>
			</div>
		</div>
<?php endif; ?>
<p class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); echo \ahura\app\mw_tools::render_woocommerce_price_position_class() ? ' ' . \ahura\app\mw_tools::render_woocommerce_price_position_class() : '';?>"><?php echo $product->get_price_html(); ?></p>
<?php if($digikala_onsale_style): ?></div><?php endif; ?>
