<!DOCTYPE html>
<html <?php language_attributes(); ?> class=" no-js">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php
    \ahura\app\mw_options::theme_viewport_meta_html();
    wp_head();
    ?>
</head>
<body <?php body_class('not-logged-in') ?>>
    <?php wp_body_open(); ?>
    <div class="site-container my-account-login-mode3-container">
        <?php
        $logo = \ahura\app\mw_options::get_my_account_logo_url();
        $register = isset($_POST['register']);
        $has_registration = get_option('woocommerce_enable_myaccount_registration') == 'yes';
        ?>
        <div class="my-account-login-mode3">
            <?php if ($logo): ?>
                <div class="ah-account-logo">
                    <a href="<?php echo esc_attr(site_url()) ?>">
                        <img src="<?php echo esc_attr($logo) ?>" alt="logo">
                    </a>
                </div>
            <?php endif; ?>
            <div class="d-flex justify-content-center align-items-center ah-my-account-form login-box">
                <div class="login-form">
                    <div class="login-form-container">
                        <?php
                        $is_lost_password = (isset($_GET['action']) && $_GET['action'] == 'lostpassword') || is_wc_endpoint_url('lost-password');

                        if($is_lost_password){
                            require_once locate_template('woocommerce/myaccount/custom/form-lost-password-3.php');
                        }  else {
                            require_once locate_template('woocommerce/myaccount/custom/form-login-3.php');
                        }
                        ?>
                        <?php if($has_registration && !$is_lost_password): ?>
                            <div class="register-link-wrap">
                                <a href="#" rel="nofollow noopener" class="ah-toggle-account-register-form" style="display:<?php echo $register ? 'none' : '' ?>">
                                    <?php _e('Sign up', 'ahura') ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="ah-account-foot">
                            <a href="<?php echo esc_attr(site_url()) ?>"><?php _e('Back to home', 'ahura') ?></a>
                        </div>
                    </div>
                </div>
                <?php if(get_theme_mod('ahura_login_my_account_custom_img')): ?>
                    <div class="login-page-image">
                        <img src="<?php echo get_theme_mod('ahura_login_my_account_custom_img'); ?>" alt="<?php __('login page image', 'ahura'); ?>">
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>