<?php

/**
 * Show options for ordering
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/orderby.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.6.0
 */

if (!defined('ABSPATH')) exit;

$current_grid = \ahura\app\woocommerce::get_current_shop_view();
$shop_views = \ahura\app\woocommerce::get_shop_views();
?>
<form class="woocommerce-ordering" method="get">
    <?php if (\ahura\app\mw_options::get_mod_shop_grid_status()): ?>
    <div class="ah-products-shop-view products-view-grid">
        <?php foreach ($shop_views as $name => $icon): ?>
            <a rel="nofollow noopener" href="<?php echo add_query_arg('shop_view', $name) ?>" class="shop-view per-row-<?php echo $name ?> <?php echo $current_grid == $name ? 'current-grid' : '' ?>">
                <?php echo ahura_get_file_content($icon); ?>
            </a>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
<?php
if( get_theme_mod( 'ahura_shop_orderby_status' ) ):
    $catalog_orderby_options = apply_filters( 'woocommerce_catalog_orderby', [
        'menu_order' => __( 'Default', 'ahura' ),
        'popularity' => __( 'Popularity', 'ahura' ),
        'rating'     => __( 'Average rating', 'ahura' ),
        'price'      => __( 'Price: low to high', 'ahura' ),
        'price-desc' => __( 'Price: high to low', 'ahura' )
    ] );

    if ( get_option( 'woocommerce_enable_review_rating' ) == 'no' ) unset( $catalog_orderby_options[ 'rating' ] );
    if ( get_theme_mod( 'ahura_shop_orderby_default_status' ) ) unset( $catalog_orderby_options[ 'menu_order' ] );
    if ( get_theme_mod( 'ahura_shop_orderby_popularity_status' ) ) unset( $catalog_orderby_options[ 'popularity' ] );
    if ( get_theme_mod( 'ahura_shop_orderby_rating_status' ) ) unset( $catalog_orderby_options[ 'rating' ] );
    if ( get_theme_mod( 'ahura_shop_orderby_price_status' ) ) unset( $catalog_orderby_options[ 'price' ] );
    if ( get_theme_mod( 'ahura_shop_orderby_pricedesc_status' ) ) unset( $catalog_orderby_options[ 'price-desc' ] );

    if($catalog_orderby_options): ?>
        <div class="orderby-list-area">
            <label for="orderby-dropdown-list"><?php echo __( 'Shop order: ', 'ahura' ); ?></label>
            <ul class="orderby-dropdown-list">
                <?php foreach ( $catalog_orderby_options as $id => $name ) echo '<li><a href="' . get_permalink( wc_get_page_id( 'shop' ) ) . '?orderby=' . $id . '" >' . esc_attr( $name ) . '</a></li>'; ?>
            </ul>
        </div>
    <?php endif; ?>
<?php else: ?>
        <select name="orderby" class="orderby" aria-label="<?php esc_attr_e( 'Shop order', 'woocommerce' ); ?>">
            <?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
                <option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
            <?php endforeach; ?>
        </select>
        <input type="hidden" name="paged" value="1" />
        <?php wc_query_string_form_fields( null, [ 'orderby', 'submit', 'paged', 'product-page' ] ); ?>
<?php endif; ?>
</form>