<?php
$show_thumb = has_post_thumbnail() && (get_theme_mod('show_single_post_thumbnail') != 'none' && get_post_meta(get_the_ID(), 'hide_thumbnail', true) !== 'no');
?>
<div class="wrapper single-post-template-3">
    <section class="post-box content">
        <?php
        if (isset($right_sidebar) && $right_sidebar){
            $sidebar->col($right_sidebar)->display();
        }
        ?>
        <div class="theiaStickySidebar">
            <?php
            if (\ahura\app\mw_options::page_has_breadcsrumb()) {
                include get_template_directory() . '/template-parts/single/bread-crumb2.php';
            }
            ?>
            <article class="post-entry post-entry-custom post-custom">
                <div class="post-title-wrap">
                    <?php if (\ahura\app\mw_options::get_mod_show_single_post_title()): ?>
                        <header class="post-title">
                            <h1><?php the_title(); ?></h1>
                        </header>
                    <?php endif; ?>
                </div>
                <div class="post-meta-wrap">
                    <?php if (\ahura\app\mw_options::get_mod_show_content_types()): ?>
                        <div class="post-types-list">
                            <?php ahura_html_content_types(get_the_ID()); ?>
                        </div>
                    <?php endif; ?>
                    <ul class="post-meta">
                        <?php if (get_theme_mod('single_post_meta_time')) : ?>
                            <li class="post-date">
                                <i class="fa fa-clock"></i>
                                <?php echo get_the_date('d F Y'); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_author', true)) : ?>
                            <li class="post-author-name">
                                <i class="fa fa-user"></i>
                                <?php the_author(); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_categories', true)) : ?>
                            <li class="post-cats">
                                <i class="fa fa-book"></i>
                                <?php the_category(', '); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('post-meta-comments') && get_comments_number()): ?>
                            <li class="post-comment-count">
                                <i class="fa fa-comments"></i>
                                <?php printf(_nx('One Comment', '%1$s Comments', get_comments_number(), 'comments title', 'ahura'), number_format_i18n(get_comments_number())); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_date')): ?>
                            <li class="post-date">
                                <i class="fa fa-clock"></i>
                                <?php echo get_the_date('Y/m/d'); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_update_date')) : ?>
                            <li class="post-modified-date">
                                <i class="<?php echo get_theme_mod('post_update_date_icon') ? get_theme_mod('post_update_date_icon') : 'fas fa-history'; ?> pl-1"></i>
                                <?php if (get_theme_mod('post_update_date_text')): ?>
                                    <span class="pl-1"><?php echo get_theme_mod('post_update_date_text'); ?><?php echo the_modified_time('j F Y'); ?></span>
                                <?php else: ?>
                                    <?php the_modified_time('j F Y'); ?>
                                <?php endif; ?>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="row post-content-row">
                    <?php if (has_excerpt()): ?>
                        <div class="col-12 <?php echo sprintf('col-md-%1$s col-lg-%1$s', ($show_thumb ? '6' : '12')) ?>">
                            <div class="post-excerpt"><?php the_excerpt() ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if ($show_thumb): ?>
                        <div class="col-12 <?php echo sprintf('col-md-%1$s col-lg-%1$s', (has_excerpt() ? '6' : '12')) ?>">
                            <div class="post-thumbnail-wrap">
                                <div class="single-post-thumbnail"><?php the_post_thumbnail('full'); ?></div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="post-content-wrap">
                    <?php if (!dynamic_sidebar('ahura_start_content_widget')) : ?>
                    <?php endif; ?>
                    <?php
                    the_content();
                    ?>
                    <?php if (!dynamic_sidebar('ahura_content_widget')) : ?>
                    <?php endif; ?>
                </div>
                <?php
                ahura_single_post_like_template(get_the_ID());

                if (\ahura\app\mw_options::get_mod_show_post_sharing()):
                    $share_temp = \ahura\app\mw_options::get_post_sharing_mode();
                    include_once ahura_get_full_path('template-parts.single', "share-buttons-{$share_temp}.php");
                endif;
                ?>
                <?php if (get_theme_mod('show_star_rating')): ?>
                    <div class="post-rating-wrap">
                        <div class="box-title"><?php _e('Was this post helpful to you?', 'ahura') ?></div>
                        <?php
                        if (empty(get_post_meta(get_the_id(), '_post_star_meta', true))):
                            $post_rating = 5;
                        else:
                            $post_rating = get_post_meta(get_the_id(), '_post_star_meta', true);
                        endif;
                        $args = array(
                            'rating' => $post_rating,
                            'type' => 'rating',
                            'number' => 1270,
                        );
                        require_once(ABSPATH . 'wp-admin/includes/template.php');
                        wp_star_rating($args);
                        ?>
                    </div>
                <?php endif; ?>
                <?php if (\ahura\app\mw_options::get_mod_show_post_author()): ?>
                    <div class="post-author-wrap">
                        <div class="author-avatar-wrap"><?php echo get_avatar(get_the_author_meta('email'), '125'); ?></div>
                        <div class="author-des-wrap">
                            <?php $author_url = get_the_author_meta('url'); ?>
                            <span class="author-name">
                            <?php
                            the_author();
                            if ($author_url): ?>
                                <a target="_blank" rel="nofollow" href="<?php echo $author_url; ?>">
                                    <i class="fas fa-globe"></i>
                                    <?php echo __('Website', 'ahura'); ?>
                                </a>
                            <?php endif; ?>
                        </span>
                            <div class="author-text">
                                <?php the_author_meta('description'); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </article>
            <?php
            if (\ahura\app\mw_options::get_mod_show_related_posts()):
                do_action('ah_render_single_related_posts_template');
            endif;
            ?>
            <div class="post-entry ah-post-comments-wrap single-post-comments-wrap ah-simple-box-style">
                <?php comments_template(); ?>
            </div>
            <?php if (\ahura\app\mw_options::get_mod_show_post_tags() && has_tag()): ?>
                <div class="post-tags-wrap">
                    <div class="box-title"><?php _e('Tags', 'ahura') ?></div>
                    <div id="post-tags">
                        <?php the_tags('', '', ''); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <?php
    if (isset($left_sidebar) && $left_sidebar){
        $sidebar->col($left_sidebar)->display();
    }
    ?>
</div>
<div class="clear"></div>
