<div class="archive-template-container archive-template-2">
    <section class="site-container">
        <?php if (!get_theme_mod('blog_archive_hide_title_box')): ?>
        <div class="cat-heading">
            <h3><?php single_cat_title(); ?></h3>
            <?php
            if (!get_theme_mod('blog_archive_hide_description')) {
                the_archive_description('<div class="cat-description-inner">', '</div>');
            }
            ?>
        </div>
        <?php endif; ?>
        <div class="archive-content">
            <?php if (have_posts()) : ?>
                <div class="flex row">
                    <?php while (have_posts()) : the_post(); ?>
                        <div class="<?php echo esc_attr($postClass); ?>">
                            <a href="<?php the_permalink() ?>">
                                <div class="post-float-details">
                                    <?php if (get_theme_mod('ahura_new_posts_label_status') && ahura_is_new_post()): ?>
                                        <span class="new"><?php echo esc_html__('New', 'ahura') ?></span>
                                    <?php endif; ?>
                                    <?php
                                    $content_types = get_the_terms(get_the_ID(), 'content_types');
                                    if ($content_types && !is_wp_error($content_types) && \ahura\app\mw_options::get_mod_show_content_types_in_archive()):?>
                                        <span class="post-content-types">
                                            <?php
                                                foreach ($content_types as $type):
                                                    $icon_id = \ahura\app\taxonomies::get_term_meta($type->term_id, 'icon');
                                                    $icon_url = wp_get_attachment_url($icon_id);
                                                    ?>
                                                    <span class="type">
                                                      <?php if (!empty($icon_url)): ?>
                                                          <span class="icon"><img src="<?php echo $icon_url ?>" alt="type_icon_<?php echo get_the_title() ?>"></span>
                                                      <?php endif; ?>
                                                      <span class="name"><?php echo $type->name ?></span>
                                                    </span>
                                                <?php endforeach; ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="post-top-details">
                                    <div class="post-thumb fimage">
                                        <?php
                                        $thumb_url = get_the_post_thumbnail_url();
                                        if(!empty($thumb_url) || !\ahura\app\mw_options::get_default_post_image_status()){
                                            the_post_thumbnail();
                                        } else {
                                            ahura_placeholder_image(get_the_title());
                                        }
                                        ?>
                                    </div>
                                    <div class="post-title ">
                                        <h3><?php the_title() ?></h3>
                                    </div>
                                    <?php if (has_excerpt() && !get_theme_mod('cat_box_desc')): ?>
                                        <div class="post-excerpt excerpt">
                                            <?php echo '<p>' . wp_trim_words(get_the_excerpt(), get_theme_mod('post_description_excerpt_length', 55)) . '</p>'; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="post-bottom-details">
                                    <div class="meta">
                                        <?php if (get_theme_mod('post-meta-author', true)): ?>
                                            <span class="post-author">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-user-filled" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#000000" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path stroke="none" d="M0 0h24v24H0z" fill="none"/> <path d="M12 2a5 5 0 1 1 -5 5l.005 -.217a5 5 0 0 1 4.995 -4.783z" stroke-width="0" fill="currentColor" /> <path d="M14 14a5 5 0 0 1 5 5v1a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-1a5 5 0 0 1 5 -5h4z" stroke-width="0" fill="currentColor" /> </svg>
                                                <?php the_author(); ?>
                                            </span>
                                        <?php endif; ?>
                                        <?php if (get_theme_mod('post-meta-time', true)): ?>
                                            <span class="post-meta">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-clock-filled" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#000000" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path stroke="none" d="M0 0h24v24H0z" fill="none"/> <path d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-5 2.66a1 1 0 0 0 -.993 .883l-.007 .117v5l.009 .131a1 1 0 0 0 .197 .477l.087 .1l3 3l.094 .082a1 1 0 0 0 1.226 0l.094 -.083l.083 -.094a1 1 0 0 0 0 -1.226l-.083 -.094l-2.707 -2.708v-4.585l-.007 -.117a1 1 0 0 0 -.993 -.883z" stroke-width="0" fill="currentColor" /> </svg>
                                                <?php echo get_the_date('d F Y'); ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <span class="post-read-more">
                                        <?php _e('Read More', 'ahura') ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24" fill="none" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-up-right"><line x1="7" y1="17" x2="17" y2="7"/><polyline points="7 7 17 7 17 17"/></svg>
                                    </span>
                                </div>
                            </a>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php
            else:
                \ahura\app\mw_partials::load_404_template();
            endif;
            ?>
        </div>
        <?php mihanwp_numeric_posts_nav(); ?>
    </section>
</div>

