jQuery(document).ready(function ($){
    $('.ah-comments-template-3 li.comment').each(function (k, item){
        item = $(item);

        if(item.find('ul.children').length){
            item.find('.reply').remove();
        }
    });

    $(document).on('click', '.ah-comments-template-3 .children .comment-body', function (e){
        e.preventDefault();
        let text = $(this).find('p').text();
        $('body').append(
            $('<div/>', {class:'comment-content-modal'}).append(
                $('<div/>', {class: 'ccm-text', text: text}).append(
                    $('<span/>', {class: 'close-ccm', text: '+'})
                )
            )
        )
    });

    $(document).on('click', '.close-ccm', function (e){
        e.preventDefault();
        $('.comment-content-modal').fadeOut(function (){
            $(this).remove();
        });
    });

    let commentsSwiper = new Swiper('.ah-comments-template-3 .swiper', {
        slidesPerView: 1,
        spaceBetween: 20,
        loop: false,
        slideClass: 'comment',
        breakpoints: {
            640: {
                slidesPerView: 1,
            },
            768: {
                slidesPerView: 2,
            },
            1024: {
                slidesPerView: 3,
            },
        },
    });
});