jQuery(document).ready(function ($) {
    let videos = $('body:not(.elementor-page) video');

    videos.each(function (index) {
        let video_src = $(this).attr('src');
        if(typeof video_src !== "undefined" && video_src != ""){
            let video_cover = $(this).attr('poster');
            $(this).replaceWith(`
            <div class="ahura_player">
                <div class="video-play-button is-visible"><i class="fa fa-play"></i></div>
                <video src="${video_src}" poster="${video_cover}"></video>
                <div class="video_controls">
                    <div class="video_controls_wrapper">
                        <div class="video_controls_top">
                            <input type="range" min="0" value="0" class="current_time"/>
                            <div class="video_play"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path d="M4 11.9999V8.43989C4 4.01989 7.13 2.2099 10.96 4.4199L14.05 6.1999L17.14 7.9799C20.97 10.1899 20.97 13.8099 17.14 16.0199L14.05 17.7999L10.96 19.5799C7.13 21.7899 4 19.9799 4 15.5599V11.9999Z" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> </svg></div>
                            <div class="video_pause"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path opacity="0.4" d="M10.65 19.11V4.89C10.65 3.54 10.08 3 8.64 3H5.01C3.57 3 3 3.54 3 4.89V19.11C3 20.46 3.57 21 5.01 21H8.64C10.08 21 10.65 20.46 10.65 19.11Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path d="M20.9996 19.11V4.89C20.9996 3.54 20.4296 3 18.9896 3H15.3596C13.9296 3 13.3496 3.54 13.3496 4.89V19.11C13.3496 20.46 13.9196 21 15.3596 21H18.9896C20.4296 21 20.9996 20.46 20.9996 19.11Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg></div>
                        </div>
                        <div class="video_controls_left">
                            <div class="video_audio_wrapper">
                                <input type="range" class="video_audio" step="0.1" min="0" max="1" value="1"/>
                                <span class="v-up"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path d="M2 9.99979V13.9998C2 15.9998 3 16.9998 5 16.9998H6.43C6.8 16.9998 7.17 17.1098 7.49 17.2998L10.41 19.1298C12.93 20.7098 15 19.5598 15 16.5898V7.40979C15 4.42979 12.93 3.28979 10.41 4.86979L7.49 6.69979C7.17 6.88979 6.8 6.99979 6.43 6.99979H5C3 6.99979 2 7.99979 2 9.99979Z" stroke="#292D32" stroke-width="1.5"/> <path opacity="0.4" d="M18 8C19.78 10.37 19.78 13.63 18 16" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.4" d="M19.8301 5.5C22.7201 9.35 22.7201 14.65 19.8301 18.5" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg></span>
                                <span class="v-mute" style="display:none;"><svg xmlns="http://www.w3.org/2000/svg" width="22" height="18" viewBox="0 0 22 18" fill="none"> <path d="M1 7.00077V11.0008C1 13.0008 2 14.0008 4 14.0008H5.43C5.8 14.0008 6.17 14.1108 6.49 14.3008L9.41 16.1308C11.93 17.7108 14 16.5608 14 13.5908V4.41077C14 1.43077 11.93 0.290766 9.41 1.87077L6.49 3.70077C6.17 3.89077 5.8 4.00077 5.43 4.00077H4C2 4.00077 1 5.00077 1 7.00077Z" stroke="#292D32" stroke-width="1.5"/> <g opacity="0.4"> <path d="M20.9991 10.961L17.0391 7.00098" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M20.96 7.04102L17 11.001" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> </g> </svg></span>
                            </div>
                            <span class="video_timer"><i class="video_time_duration">00:00</i> / <i class="video_time_current">00:00</i></span>
                        </div>
                        <div class="video_controls_right">
                            <div class="video_fullscreen"><i class="fa fa-expand"></i></div>
                        </div>
                    </div>
                </div>
            </div>
            `)
            let player = $('.ahura_player')
            delete videos
            let videos = $('.ahura_player video')
            player.each(function(){
                let playerWrap = $(this);
                let currentVideo = $(this).find('video')
                let largePlayButton = $(this).find('.video-play-button');
                let controls = $(this).find('.video_controls')
                let play = $(controls).find('.video_play')
                let pause = $(controls).find('.video_pause')
                let full_screen = $(controls).find('.video_fullscreen')
                let audio = $(controls).find('.video_audio')
                let videoTime = $(controls).find('.currentTime')
                let video_Time = $(controls).find('.current_time')
                let current_timer = $(controls).find('.video_time_current')
                let duration_timer = $(controls).find('.video_time_duration')

                $(currentVideo).on('timeupdate',function(){
                    $(videoTime).val(videos[index].currentTime)
                    $(video_Time).val(videos[index].currentTime)

                    const videoCureent = Math.round(videos[index].currentTime);
                    const time_cureent = formatTime(videoCureent)
                    current_timer.text(time_cureent.minutes + ':' + time_cureent.seconds)
                })

                $(currentVideo).on('loadedmetadata',function(){
                    const videoDuration = Math.round(videos[index].duration)
                    const time_duration = formatTime(videoDuration)
                    duration_timer.text(time_duration.minutes + ':' + time_duration.seconds)
                })

                $(currentVideo).on('loadedmetadata', function() {
                    $(videoTime).attr('max', videos[index].duration);
                    $(video_Time).attr('max', videos[index].duration);
                });

                $(video_Time).on('change input',function(){
                    videos[index].currentTime = $(this).val()
                })

                $(currentVideo).on('click', function () {
                    if (videos[index].paused) {
                        currentVideo.trigger('play')
                        HandleStartVideoCss()
                    } else {
                        currentVideo.trigger('pause')
                        HandleStopVideoCss()
                    }
                })

                largePlayButton.on('click', function (e) {
                    e.preventDefault();
                    if(largePlayButton.hasClass('is-visible')){
                        currentVideo.trigger('play');
                        HandleStartVideoCss();
                        largePlayButton.removeClass('is-visible');
                    } else {
                        largePlayButton.addClass('is-visible');
                    }
                })

                $(currentVideo).dblclick(function(){
                    if(document.fullscreenElement){
                        document.exitFullscreen()
                    }
                    let video = document.getElementsByClassName('ahura_player')[0]
                    if (!video.fullscreenElement) {
                        video.requestFullscreen();
                    }else if (!video.webkitRequestFullscreen) {
                        video.webkitRequestFullscreen();
                    }else if (!video.msRequestFullscreen) {
                        video.msRequestFullscreen();
                    }
                })
                $(play).on('click', function () {
                    currentVideo.trigger('play')
                    largePlayButton.hide();
                    HandleStartVideoCss()
                })
                $(pause).on('click', function () {
                    currentVideo.trigger('pause')
                    largePlayButton.show();
                    HandleStopVideoCss()
                })
                $(full_screen).on('click', function (i) {
                    if(document.fullscreenElement){
                        document.exitFullscreen()
                    }else{
                        document.getElementsByClassName('ahura_player')[0].requestFullscreen()
                    }
                })

                playerWrap.find('.v-up').on('click',function(){
                    if(videos[index].volume > 0){
                        videos[index].volume = 0;
                        playerWrap.find('.v-mute').show();
                        playerWrap.find('.v-up').hide();
                        $(audio).val(0)
                    }
                });

                playerWrap.find('.v-mute').on('click',function(){
                    if(videos[index].volume <= 0){
                        videos[index].volume = 1;
                        playerWrap.find('.v-mute').hide();
                        playerWrap.find('.v-up').show();
                        $(audio).val(1)
                    }
                });

                $(audio).on('change input', function () {
                    let video = videos[index]
                    video.volume = $(this).val()
                })

                $(currentVideo).on('mouseover',function(e){
                    let timeout
                    let x = e.clientX
                    let y = e.clientY
                    $(currentVideo).on('mousemove',function(w){
                        let x1 = w.clientX
                        let y1 = w.clientY
                        clearTimeout(timeout)
                        timeout = setTimeout(function(){
                            if(x == x1 && y == y1){
                                HandleHideVideoControlsCss()
                            }else{
                                clearTimeout(timeout)
                                setTimeout(function(){
                                    HandleHideVideoControlsCss()
                                },3000)
                            }
                        }, 3000)
                    })
                    $(currentVideo).on('mousemove',function(){
                        HandleVisibleVideoControlsCss()
                    })
                })

                $(videos[index]).on('ended',function(){
                    HandleStopVideoCss();
                })

                $(currentVideo).on('error',function(e){
                    if(e.target.error){
                        $(this).html(ahura_player.msg.no_video).addClass('no-video');
                    }
                })

                function HandleStartVideoCss(){
                    $(play).css('display','none')
                    $(pause).css('display','flex')
                }

                function HandleStopVideoCss(){
                    $(play).css('display','flex')
                    $(pause).css('display','none')
                    largePlayButton.addClass('is-visible');
                }

                function HandleHideVideoControlsCss(){
                    $(controls).removeClass('show-video-controls')
                }

                function HandleVisibleVideoControlsCss(){
                    $(controls).addClass('show-video-controls')
                }

                function formatTime(timeInSeconds){
                    const result = new Date(timeInSeconds * 1000).toISOString().substr(11,8)
                    return {
                        minutes: result.substr(3, 2),
                        seconds: result.substr(6, 2),
                    };
                }
            })
        }
    })
})