document.addEventListener('DOMContentLoaded', function() {
    const tabContainers = document.querySelectorAll('.templates-tab-container');

    tabContainers.forEach(container => {
        const widgetId = container.getAttribute('data-widget-id');
        const tabs = container.querySelectorAll('.tab-title');
        const contents = container.querySelectorAll('.tab-content');

        tabs.forEach((tab, index) => {
            tab.addEventListener('click', () => {
                tabs.forEach(t => t.classList.remove('active'));
                tab.classList.add('active');

                contents.forEach(content => content.classList.remove('active'));
                contents[index].classList.add('active');
            });
        });

        if (tabs.length > 0) {
            tabs[0].classList.add('active');
            contents[0].classList.add('active');
        }
    });
});
