const handlePostCarousel7Element = function (params){
    let options = {
        slidesPerView: 1,
        spaceBetween: params.margin,
        loop: true,
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
        },
        navigation: {
            nextEl: ".swiper-btn-next",
            prevEl: ".swiper-btn-prev",
        },
        breakpoints: {
            640: {
                slidesPerView: 1,
            },
            768: {
                slidesPerView: 3,
            },
            1024: {
                slidesPerView: params.slidesPerView,
            },
        },
    };

    if(params.autoplay){
        options.autoplay = {
            delay: 3000,
            disableOnInteraction: false,
        };
    }

    if(params.centeredSlides){
        options.centeredSlides = true;
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/post_carousel7.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel7'),
            slider = wrap.find('.posts-carousel'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handlePostCarousel7Element(sliderData);
    });
});