<?php
namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\Post_Meta;
use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class team_members2 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('team_members2_js', mw_assets::get_js('elementor.team_members2'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('team_members2_css', mw_assets::get_css('elementor.team_members2'));
        if(!is_rtl()){
            $this->register_elementor_style('team_members2_ltr_css', mw_assets::get_css('elementor.ltr.team_members2_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('team_members2_js')];
    }

    public function get_name()
    {
        return 'ahura_team_members2';
    }

    public function get_title()
    {
        return esc_html__('Team Members 2', 'ahura');
    }

    public function get_icon()
    {
        return 'eicon-person';
    }

    public function get_categories()
    {
        return ['ahuraelements'];
    }

    public function get_keywords()
    {
        return ['ahura', 'team members 2', 'team', esc_html__('ahura' , 'ahura'), esc_html__('Team Members 2', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'tabs_content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $teams = [];
        $posts = get_posts(['post_type' => 'team', 'numberposts' => -1]);

        if(!empty($posts)){
            foreach ($posts as $post){
                $teams[$post->ID] = $post->post_title;
            }
        }

        $repeater->add_control(
            'item_id',
            [
                'label' => esc_html__('Item', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $teams,
                'default' => key($teams),
                'label_block' => true,
                'multiple' => false,
            ]
        );

        $repeater->add_control(
            'show_socials',
            [
                'label' => esc_html__('Show Socials', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'show_bio',
            [
                'label' => esc_html__('Bio', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['show_bio' => 'yes']
                ]
            ]
        );

        $this->add_control('divider1', ['type' => Controls_Manager::DIVIDER]);

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'label' => esc_html__('Avatar', 'ahura'),
                'name' => 'item_cover',
                'default' => 'full',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_settings',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4500,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                    6 => '6',
                ],
                'default' => 4,
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         *
         * Styles
         *
         *
         *
         */
        $this->start_controls_section(
            'items_style_section',
            [
                'label' => __( 'Items', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 500
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 385
                ],
                'selectors' => [
                    '{{WRAPPER}} .team-member-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_responsive_control(
            'item_text_alignment',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => (is_rtl()) ? 'right' : 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .team-member-item' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_cover_shadow_color',
            [
                'label' => esc_html__('Cover Shadow Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgba(255, 211, 66, 0.44)',
                'selectors' => [
                    '{{WRAPPER}} .item-overlay' => str_replace('%deg%', (is_rtl() ? '165deg' : '-165deg'), 'background-image:linear-gradient(%deg%, rgba(0, 0, 0, 0.0) 60%, {{VALUE}})'),
                ],
            ]
        );

        $this->add_control(
            'item_cover_color',
            [
                'label' => esc_html__('Cover Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgba(0, 0, 0, 0.7)',
                'selectors' => [
                    '{{WRAPPER}} .item-overlay:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .item-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 600],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_subtitle_color',
            [
                'label' => esc_html__('Subtitle Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffd342',
                'selectors' => [
                    '{{WRAPPER}} .item-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Subtitle Typography', 'ahura'),
                'name' => 'item_subtitle_typo',
                'selector' => '{{WRAPPER}} .item-subtitle',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_socials_color',
            [
                'label' => esc_html__('Socials Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-socials a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_bio_color',
            [
                'label' => esc_html__('Bio Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-excerpt p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Bio Typography', 'ahura'),
                'name' => 'item_excerpt_typo',
                'selector' => '{{WRAPPER}} .item-excerpt p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '13',
                        ]
                    ]
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .team-member-item',
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .team-member-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'paginate_style_section',
            [
                'label' => __( 'Pagination', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_pagination' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'paginate_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'paginate_bg',
                'selector' => '{{WRAPPER}} .swiper-pagination',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#f0f0f0']
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'active_paginate_bg',
                'label' => esc_html__('Active Background', 'ahura'),
                'selector' => '{{WRAPPER}} .swiper-pagination .swiper-pagination-progressbar-fill',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#ffd342']
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     *
     * Render content for display
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $has_paginate = ($settings['show_pagination'] == 'yes');

        $slider_data = [
            'widgetID' => $wid,
            'autoPlay' => $settings['autoplay'] == 'yes',
            'transitionDuration' => (intval($settings['transition_duration'])) ? $settings['transition_duration'] : 4500,
            'loop' => $settings['infinite_loop'] == 'yes',
            'slidesPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'pagination' => $has_paginate,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $items = $settings['items'];
        if (!$items){
            $this->renderElementorNotice(__('Sorry,no team members were found for display.', 'ahura'));
            return false;
        }
        ?>
        <div class="team-members2-element">
            <div class="swiper team-carousel" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="swiper-wrapper">
                    <?php
                    foreach ($items as $item):
                        $post = !empty($item['item_id']) ? get_post($item['item_id']) : null;
                        if (!$post)
                            continue;

                        $subtitle = Post_Meta::get_team_subtitle($post->ID);

                        $styles = [];

                        if (has_post_thumbnail($post->ID)){
                            $styles['background-image'] = sprintf("url(%s)", get_the_post_thumbnail_url($post->ID, $settings['item_cover_size']));
                        }

                        $socials = Post_Meta::get_team_socials($post->ID);
                        ?>
                        <div class="swiper-slide">
                            <div class="team-member-item" style="<?php echo $this->array_to_style($styles) ?>">
                               <div class="item-content">
                                   <div class="item-head">
                                       <h3 class="item-title"><?php echo $post->post_title ?></h3>
                                       <?php if (!empty($subtitle)): ?>
                                           <h4 class="item-subtitle"><?php echo $subtitle ?></h4>
                                       <?php endif; ?>
                                       <?php if ($item['show_socials'] == 'yes' && $socials): ?>
                                           <div class="item-socials">
                                               <?php foreach ($socials as $social): ?>
                                                   <a href="<?php echo $social['url'] ?? '' ?>" target="_blank">
                                                       <i class="<?php echo $social['icon'] ?? '' ?>"></i>
                                                   </a>
                                               <?php endforeach; ?>
                                           </div>
                                       <?php endif; ?>
                                   </div>
                                   <?php if($item['show_bio'] == 'yes' && !empty($post->post_excerpt)): ?>
                                       <div class="item-bottom">
                                           <div class="item-excerpt">
                                               <p><?php echo $post->post_excerpt; ?></p>
                                           </div>
                                       </div>
                                   <?php endif; ?>
                               </div>
                                <div class="item-overlay"></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php if($has_paginate): ?>
                    <div class="swiper-pagination"></div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}