<?php
namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class services_box4 extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __register_assets()
    {
        $this->register_elementor_style('services_box4', mw_assets::get_css('elementor.services_box4'));
    }

    public function get_name() {
        return 'ahura_services_box4';
    }

    public function get_title() {
        return __( 'Services Box 4', 'ahura' );
    }

    public function get_icon() {
        return 'aicon-svg-services-box-3';
    }

    public function get_categories() {
        return [ 'ahuraelements' ];
    }

    function get_keywords()
    {
		return ['ahura', 'service', 'services box 4', esc_html__('ahura', 'ahura'), esc_html__('service', 'ahura'),  esc_html__( 'Services Box 4' , 'ahura')];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_cover',
            [
                'label' => esc_html__( 'Choose Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'item_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-plane',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Default title', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'item_description',
            [
                'label' => esc_html__( 'Description', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => ahura_get_lorem_ipsum(20),
            ]
        );

        $repeater->add_control(
            'btn_more_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'show_btn',
            [
                'label' => esc_html__( 'Show Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'item_btn_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-left',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $repeater->add_control(
            'item_btn_text',
            [
                'label' => esc_html__( 'Button Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'rows' => 10,
                'default' => __('Read More', 'ahura'),
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $repeater->add_control(
            'item_btn_link',
            [
                'label' => esc_html__( 'Link', 'ahura' ),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'dynamic' => ['active' => true],
            ]
        );

        $this->add_control(
            'services',
            [
                'type' => \Elementor\Controls_Manager::REPEATER,
                'label' => __('Items', 'ahura'),
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{item_title}}}',
                'default' => [
                    ['item_title' => esc_html__( 'Default title', 'ahura' )],
                    ['item_title' => esc_html__( 'Default title', 'ahura' )],
                    ['item_title' => esc_html__( 'Default title', 'ahura' )],
                    ['item_title' => esc_html__( 'Default title', 'ahura' )],
                ]
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'settings_content',
            [
                'label' => __( 'Settings', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'item_columns',
            [
                'label' => esc_html__('Columns', 'ahura'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    12 => sprintf(esc_html__('%d Column', 'ahura'), 1),
                    6 => sprintf(esc_html__('%d Column', 'ahura'), 2),
                    4 => sprintf(esc_html__('%d Column', 'ahura'), 3),
                    3 => sprintf(esc_html__('%d Column', 'ahura'), 4),
                ],
                'default' => 3,
                'desktop_default' => 3,
                'tablet_default' => 4,
                'mobile_default' => 12,
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'cover_styles',
            [
                'label' => __( 'Cover', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'cover_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 250,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-cover img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'cover_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .service-cover img',
            ]
        );

        $this->add_responsive_control(
            'cover_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .service-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 0,
                    'left' => 0,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'cover_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .service-item img',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'title_styles',
            [
                'label' => __( 'Title', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'title_background',
                'label' => esc_html__('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .item-title',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#00000059']
                ]
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-title' => 'color: {{VALUE}};'
                ],
                'default' => '#fff',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .item-title',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => 17,
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'title_icon_color',
            [
                'label' => esc_html__('Icon color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-title i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .item-title :is(svg,path)' => 'fill: {{VALUE}};'
                ],
                'default' => '#fff',
            ]
        );

        $this->add_responsive_control(
            'title_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .item-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'des_styles',
            [
                'label' => __( 'Description', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'des_color',
            [
                'label' => esc_html__('Text color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-des' => 'color: {{VALUE}};'
                ],
                'default' => '#333',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'des_typography',
                'selector' => '{{WRAPPER}} .item-des',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => 16,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'btn_styles',
            [
                'label' => __( 'Button', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $text_alignment = [
            'left' => [
                'title' => __('Left', 'ahura'),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', 'ahura'),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', 'ahura'),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'btn_alignment',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $text_alignment : array_reverse($text_alignment),
                'default' => is_rtl() ? 'left' : 'right',
                'selectors' => [
                    '{{WRAPPER}} .item-button-wrap' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_background',
                'label' => esc_html__('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .item-button-wrap a',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#D85820']
                ]
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Text color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-button-wrap a' => 'color: {{VALUE}};'
                ],
                'default' => '#fff',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .item-button-wrap a',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-button-wrap a i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .item-button-wrap a :is(svg,path)' => 'fill: {{VALUE}};'
                ],
                'default' => '#fff',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .item-button-wrap a',
            ]
        );

        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .item-button-wrap a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => 20,
                    'bottom' => 0,
                    'left' => 20,
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .item-button-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'allowed_dimensions' => ['top', 'bottom'],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .item-button-wrap a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_styles',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'label' => esc_html__('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-item',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#ffffff']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .service-item',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .service-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
                ]
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .service-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .service-item',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 20,
                            'blur' => 35,
                            'spread' => 0,
                            'color' => '#0000000d'
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $services = $settings['services'];

        if (empty($services))
            return false;
        ?>
        <div class="services-box4-element">
            <div class="service-items">
                <div class="row">
                    <?php foreach ($services as $item): ?>
                        <div class="col-<?php echo $settings['item_columns_mobile'] ?? 12 ?> col-md-<?php echo $settings['item_columns_tablet'] ?? 6 ?> col-lg-<?php echo $settings['item_columns'] ?>">
                            <div class="service-item">
                                <div class="service-cover">
                                    <?php
                                    if (!empty($item['item_cover']['id'])){
                                        echo wp_get_attachment_image( $item['item_cover']['id'], 'full' );
                                    } else {
                                        echo '<img src="' . $item['item_cover']['url'] . '" alt="'. $item['item_title'] .'">';
                                    }
                                    ?>
                                    <div class="item-title-wrap">
                                        <h4 class="item-title">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            <?php echo $item['item_title'] ?>
                                        </h4>
                                    </div>
                                </div>
                                <?php if (!empty($item['item_description'])): ?>
                                    <div class="item-des">
                                        <?php echo $item['item_description'] ?>
                                    </div>
                                <?php endif; ?>
                                <?php
                                if ($item['show_btn'] == 'yes'):
                                    if(!empty($item['item_btn_link']['url'])){
                                        $this->add_link_attributes('item_link_' . $item['_id'], $item['item_btn_link']);
                                    }
                                    ?>
                                    <div class="item-button-wrap">
                                        <a <?php echo $this->get_render_attribute_string('item_link_' . $item['_id']); ?>>
                                            <span><?php echo $item['item_btn_text'] ?></span>
                                            <?php \Elementor\Icons_Manager::render_icon( $item['item_btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
    }
}
