<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class products_category2 extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\Taxonomy_Utilities;

    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('products_category2_js', mw_assets::get_js('elementor.products_category2'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('products_category2_css', mw_assets::get_css('elementor.products_category2'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('products_category2_js')];
    }
    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'ahura_products_category2';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Product Categories Carousel 2', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'eicon-product-categories';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements','ahura_woocommerce'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    function get_keywords()
    {
        return ['ahura', 'product', 'products category 2', esc_html__('ahura', 'ahura'), esc_html__('product', 'ahura'), esc_html__('Product Categories Carousel 2', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_mode',
            [
                'label' => esc_html__('Mode', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'all' => esc_html__('All', 'ahura'),
                    'custom' => esc_html__('Select Categories', 'ahura'),
                ],
                'default' => 'all'
            ]
        );

        $this->add_control(
            'cat_ids',
            [
                'label' => esc_html__('Categories', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $this->get_taxonomy_ids('product_cat'),
                'label_block' => true,
                'multiple' => true,
                'condition' => [
                    'show_mode' => 'custom'
                ]
            ]
        );

        $this->add_control(
            'show_count',
            [
                'label' => esc_html__('Counter', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                    6 => '6',
                    7 => '7',
                    8 => '8',
                ],
                'default' => 5,
            ]
        );

        $this->add_control(
            'show_arrows',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 2500,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
		/**
         *
         *
         * Start box style
         *
         */

        $this->start_controls_section(
            'items_wrap_style',
            [
                'label' => esc_html__('Items', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('box_wrap_style_tabs');
        $this->start_controls_tab(
            'box_wrap_normal_tab',
            [
                'label' => esc_html__('Normal', 'ahura'),
            ]
        );
		
		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .product-cat-item span',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ],
                ]
            ]
        );
		
		$this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item span' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_bg_color',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f0f0f0',
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_wrap_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .product-cat-item',
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_responsive_control(
            'item_wrap_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ]
            ]
        );
		
		$this->add_control(
			'counter_more',
			[
				'label' => esc_html__('Counter', 'ahura'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'show_count' => 'yes'
				]
			]
		);
		
		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_count_typo',
                'selector' => '{{WRAPPER}} .product-cat-item em',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ],
                ],
				'condition' => [
					'show_count' => 'yes'
				]
            ]
        );
		
		$this->add_control(
            'box_count_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item em' => 'color: {{VALUE}}',
                ],
				'condition' => [
					'show_count' => 'yes'
				]
            ]
        );

        $this->add_control(
            'box_count_bg_color',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#919191',
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item em' => 'background-color: {{VALUE}}',
                ],
				'condition' => [
					'show_count' => 'yes'
				]
            ]
        );
		
		$this->add_responsive_control(
            'box_count_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item em' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ],
				'condition' => [
					'show_count' => 'yes'
				]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'box_wrap_hover_tab',
            [
                'label' => esc_html__('Hover', 'ahura'),
            ]
        );

        $this->add_control(
            'box_title_color_hover',
            [
                'label' => esc_html__('Title color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#673ab7',
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item:hover span' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'box_bg_color_hover',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item:hover' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_wrap_border_hover',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .product-cat-item:hover',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		
		$this->add_control(
			'counter_more_hover',
			[
				'label' => esc_html__('Counter', 'ahura'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'show_count' => 'yes'
				]
			]
		);
		
		$this->add_control(
            'box_count_color_hover',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item:hover em' => 'color: {{VALUE}}',
                ],
				'condition' => [
					'show_count' => 'yes'
				]
            ]
        );

        $this->add_control(
            'box_count_bg_color_hover',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#673ab7',
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item:hover em' => 'background-color: {{VALUE}}',
                ],
				'condition' => [
					'show_count' => 'yes'
				]
            ]
        );
		
		$this->add_responsive_control(
            'box_count_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .product-cat-item:hover em' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition' => [
					'show_count' => 'yes'
				]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
		$this->start_controls_section(
            'box_navigation_style',
            [
                'label' => esc_html__('Navigation', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'nav_options',
			[
				'label' => esc_html__('Navigation', 'ahura'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'box_nav_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .ahura-products-category2 .apc-swiper-button-next, {{WRAPPER}} .ahura-products-category2 .apc-swiper-button-prev' => 'color: {{VALUE}}',
                ],
            ]
        );
		
		$this->add_control(
            'box_nav_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .ahura-products-category2 .apc-swiper-button-next, {{WRAPPER}} .ahura-products-category2 .apc-swiper-button-prev' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
		$this->start_controls_section(
            'box_wrap_style',
            [
                'label' => esc_html__('Box', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_control(
            'box_bg_color',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .ahura-products-category2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		
		$this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'rem', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .ahura-products-category2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                ],
            ]
        );
		
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_wrap_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .ahura-products-category2',
            ]
        );
		
		$this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_wrap_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .ahura-products-category2',
            ]
        );
		
		$this->end_controls_section();

        $this->register_additional_controls();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        
        if (!\ahura\app\woocommerce::is_active()) {
            if(is_admin()) {
                ?>
                <div class="productcategorybox mw_elem_empty_box"><h3><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></h3></div>
                <?php
            }
            return false;
        }

        $wid = $this->get_id();
        $show_mode = $settings['show_mode'];
        $cats = $show_mode == 'custom' ? $this->get_terms('product_cat', $settings['cat_ids']) : $this->get_terms('product_cat');
        $has_navigate = ($settings['show_arrows'] == 'yes');

        if(!$cats)
            return false;

        $slider_data = [
            'widgetID' => $wid,
            'loop' => $settings['infinite_loop'] == 'yes',
            'slidesPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'navigation' => $has_navigate,
            'autoPlay' => $settings['autoplay'] == 'yes',
            'transitionDuration' => (intval($settings['transition_duration'])) ? $settings['transition_duration'] : 2500,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];
        ?>
       <div class="ahura-products-category2 ah-has-bg ahura-products-category2-<?php echo $wid; ?><?php echo $has_navigate ? ' has-navigate' : '' ?>">
        <div class="swiper ahura-products-category2-carousel ahura-products-category2-carousel-<?php echo $wid; ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
            <div class="swiper-wrapper">
                <?php
                foreach($cats as $cat):
					$cat_id = is_array($cat) ? $cat['term_id'] : $cat->term_id;
                    $img_id = get_term_meta($cat_id, 'thumbnail_id', true);
                    $img = intval($img_id) ? wp_get_attachment_url($img_id) : wc_placeholder_img_src(); 
                ?>
                <div class="swiper-slide">
                    <a href="<?php echo get_category_link($cat_id) ?>" class="product-cat-item ah-has-secondary-bg">
                        <?php if(intval($img)): ?>
                            <?php echo wp_get_attachment_image($img, 'thumbnail') ?>
                        <?php else: ?>
                            <img src="<?php echo $img ?>" alt="<?php echo $cat->name ?>">
                        <?php endif; ?>
                        <div class="product-cat-item-details">
                            <span class="ah-has-text"><?php echo $cat->name ?></span>
                            <?php if($settings['show_count'] == 'yes' && intval($cat->count)): ?>
                            <em><?php echo $cat->count ?></em>
                            <?php endif; ?>
						</div>
                    </a>
                </div>
                <?php endforeach;  ?>
            </div>
        </div>
        <?php if($has_navigate): ?>
            <div class="swiper-nav-button apc-swiper-button-prev"><i class="fas fa-angle-right"></i></div>
            <div class="swiper-nav-button apc-swiper-button-next"><i class="fas fa-angle-left"></i></div>
        <?php endif; ?>
       </div>
        <?php
    }
}