<?php

namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;
class product_package extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\WoocommerceMethods;

    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('product_package_js', mw_assets::get_js('elementor.product_package'));
        mw_assets::localize('product_package_js', 'product_package_data', ['ajax_url' => admin_url('admin-ajax.php')]);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('product_package_css', mw_assets::get_css('elementor.product_package'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('product_package_js')];
    }

    public function get_name()
    {
        return 'ahura_product_package';
    }

    public function get_title()
    {
        return esc_html__('Product Package', 'ahura');
    }

    public function get_icon() {
        return 'eicon-products';
    }

    public function get_categories()
    {
        return ['ahuraelements','ahura_woocommerce'];
    }

    public function get_keywords()
    {
        return ['ahura', 'Product Package', 'product', esc_html__('ahura', 'ahura'), esc_html__('product', 'ahura'), $this->get_title()];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'details_section',
            [
                'label' => esc_html__('Details', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Apple products package', 'ahura' ),
            ]
        );

        $this->add_control(
            'box_des',
            [
                'label' => esc_html__( 'Description', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('This package includes a great discount for buying four products together, don`t miss this package...', 'ahura' ),
            ]
        );

        $this->add_control(
            'show_box_label',
            [
                'label' => esc_html__('Show Label', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'box_label',
            [
                'label' => esc_html__( 'Label', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '15% Discount', 'ahura' ),
                'condition' => ['show_box_label' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_title',
            [
                'label' => esc_html__( 'Button Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Buy Package', 'ahura' ),
            ]
        );

        $this->add_control(
            'box_btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-cart-plus',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $options = [];

        $products = $this->get_products_array();

        if($products){
            foreach($products as $product) {
                $options[$product['ID']] = $product['post_title'];
            }
        }

        $default = ($options) ? key($options) : 0;

        $repeater->add_control(
            'pid',
            [
                'label' => esc_html__('Product', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $options,
                'default' => $default
            ]
        );

        $this->add_control(
            'products',
            [
                'label' => esc_html__('Products', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['pid' => $default],
                    ['pid' => $default],
                    ['pid' => $default],
                    ['pid' => $default],
                ],
                'title_field' => '{{{pid}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_labels_section',
            [
                'label' => esc_html__('Labels', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_box_labels',
            [
                'label' => esc_html__('Show Labels', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'label_title',
            [
                'label' => esc_html__( 'Label Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Fast Delivery', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'label_icon',
            [
                'label' => esc_html__( 'Label Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-check',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'label_color',
            [
                'label' => __( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'label_icon_color',
            [
                'label' => __( 'Icon Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .icon' => 'color: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .icon svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'box_labels',
            [
                'label' => esc_html__('Labels', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['label_title' => __('Fast Delivery')],
                    ['label_title' => __('Guarantee of the originality product')],
                ],
                'title_field' => '{{{label_title}}}',
                'condition' => [
                    'show_box_labels' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                    6 => '6',
                ],
                'default' => 3,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */

        $this->start_controls_section(
            'details_box_style',
            [
                'label' => esc_html__('Details Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'det_box_bg',
                'selector' => '{{WRAPPER}} .package-details',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#fff']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'det_box_border',
                'selector' => '{{WRAPPER}} .package-details',
            ]
        );

        $this->add_responsive_control(
            'det_box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'bottom' => 10,
                    'right' => 10,
                    'left' => 10,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .package-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'det_box_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'bottom' => 10,
                    'right' => 10,
                    'left' => 10,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .package-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'det_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .package-details',
            ]
        );

        $this->add_control(
            'det_box_title_options',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'det_box_title_color',
            [
                'label' => esc_html__( 'Title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .package-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'det_box_title_typography',
                'label' => esc_html__('Title typography', 'ahura'),
                'selector' => '{{WRAPPER}} .package-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20'
                        ]
                    ],
                ]
            ]
        );

        $this->add_control(
            'det_box_label_options',
            [
                'label' => esc_html__( 'Label', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'det_box_label_color',
            [
                'label' => esc_html__( 'Title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .package-discount-wrap span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'det_box_label_typography',
                'label' => esc_html__('Label typography', 'ahura'),
                'selector' => '{{WRAPPER}} .package-discount-wrap span',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'det_box_label_bg',
                'selector' => '{{WRAPPER}} .package-discount-wrap span',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#dd0a0a']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'det_box_label_border',
                'selector' => '{{WRAPPER}} .package-discount-wrap span',
            ]
        );

        $this->add_responsive_control(
            'det_box_label_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 4,
                    'bottom' => 4,
                    'right' => 4,
                    'left' => 4,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .package-discount-wrap span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'det_box_label_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 7,
                    'bottom' => 7,
                    'right' => 7,
                    'left' => 7,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .package-discount-wrap span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'det_box_des_options',
            [
                'label' => esc_html__( 'Description', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'det_box_des_color',
            [
                'label' => esc_html__( 'Description color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .box-des' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'det_box_des_typography',
                'label' => esc_html__('Description typography', 'ahura'),
                'selector' => '{{WRAPPER}} .box-des',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                ]
            ]
        );

        $this->add_control(
            'det_box_price_options',
            [
                'label' => esc_html__( 'Price', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'det_box_price_color',
            [
                'label' => esc_html__( 'Price color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#044B09',
                'selectors' => [
                    '{{WRAPPER}} .box-price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'det_box_price_typography',
                'label' => esc_html__('Price typography', 'ahura'),
                'selector' => '{{WRAPPER}} .box-price',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '19'
                        ]
                    ],
                ]
            ]
        );

        $this->add_control(
            'det_box_button_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'det_box_btn_icon_color',
            [
                'label' => esc_html__( 'Icon color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .buy-package .icon' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .buy-package .icon svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .buy-package .icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'det_box_btn_color',
            [
                'label' => esc_html__( 'Button color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .buy-package' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'det_box_btn_typography',
                'label' => esc_html__('Button typography', 'ahura'),
                'selector' => '{{WRAPPER}} .buy-package',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'det_box_btn_bg',
                'selector' => '{{WRAPPER}} .buy-package',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#36b95e']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'det_box_btn_border',
                'selector' => '{{WRAPPER}} .buy-package',
            ]
        );

        $this->add_responsive_control(
            'det_box_btn_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 8,
                    'bottom' => 8,
                    'right' => 13,
                    'left' => 13,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .buy-package' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'det_box_btn_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'bottom' => 10,
                    'right' => 10,
                    'left' => 10,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .buy-package' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'products_style',
            [
                'label' => esc_html__('Products', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'product_image_height',
            [
                'label' => esc_html__( 'Image height', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 240,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'product_bg',
                'selector' => '{{WRAPPER}} .product-item',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'product_border',
                'selector' => '{{WRAPPER}} .product-item',
            ]
        );

        $this->add_responsive_control(
            'product_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .product-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'product_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .product-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'product_title_options',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'product_title_color',
            [
                'label' => esc_html__( 'Title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .product-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'product_title_typography',
                'label' => esc_html__('Title typography', 'ahura'),
                'selector' => '{{WRAPPER}} .product-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                ]
            ]
        );

        $this->add_control(
            'product_price_options',
            [
                'label' => esc_html__( 'Price', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'product_price_color',
            [
                'label' => esc_html__( 'Price color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#044B09',
                'selectors' => [
                    '{{WRAPPER}} .product-price-wrap' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'product_price_typography',
                'label' => esc_html__('Price typography', 'ahura'),
                'selector' => '{{WRAPPER}} .product-price-wrap',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18'
                        ]
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'products_box_style',
            [
                'label' => esc_html__('Products Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'products_box_bg',
                'selector' => '{{WRAPPER}} .package-products',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'products_box_border',
                'selector' => '{{WRAPPER}} .package-products',
            ]
        );

        $this->add_responsive_control(
            'products_box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .package-products' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'products_box_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .package-products' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'products_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .package-products',
            ]
        );

        $this->end_controls_section();
    }

    private function get_product_ids($settings)
    {

        $items = $settings['products'] ?? null;
        $ids = [];

        if(!empty($items)){
            foreach ($items as $item){
                $ids[] = $item['pid'];
            }
        }

        return $ids;
    }

    private function get_products($ids, $settings)
    {
        $args = [
            'post_type'	=> 'product',
            'post_status' => 'publish',
            'posts_per_page' => -1,
            'post__in' => $ids
        ];

        return !empty($ids) ? new \WP_Query($args) : false;
    }

    private function get_total_price($query)
    {
        $total_price = 0;

        if ($query && $query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();

                $product_id = get_the_ID();
                $product = wc_get_product($product_id);

                if ($product && $product->get_price()) {
                    $total_price += $product->get_price();
                }
            }
            wp_reset_postdata();
        }

        return $total_price;
    }

    public static function handle_add_product_to_cart()
    {
        $id = $_POST['id'] ?? null;

        if (empty($id)) {
            wp_send_json_error(['msg' => __('Invalid request.', 'ahura')]);
        }

        if (is_numeric($id)) {
            $product_id = (int) $id;

            $product = wc_get_product($product_id);

            if ($product) {
                WC()->cart->add_to_cart($product_id);
            }
        }

        wp_send_json_success([
            'msg' => __('Product added to cart successfully.', 'ahura'),
            'redirect' => wc_get_cart_url()
        ]);
    }

    public static function handle_add_products_to_cart()
    {
        $ids = $_POST['ids'] ?? null;

        if (empty($ids)) {
            wp_send_json_error(['msg' => __('Invalid request.', 'ahura')]);
        }

        $product_ids = explode(',', $ids);

        $i = 0;
        foreach ($product_ids as $product_id) {
            $product_id = trim($product_id);

            if (is_numeric($product_id)) {
                $product_id = (int) $product_id;

                $product = wc_get_product($product_id);

                if ($product) {
                    WC()->cart->add_to_cart($product_id);
                    $i++;
                }
            }
        }

        if(!$i){
            wp_send_json_success(['msg' => __('No products were added to the cart.', 'ahura')]);
        }

        wp_send_json_success([
            'msg' => __('Products added to cart successfully.', 'ahura'),
            'redirect' => wc_get_cart_url()
        ]);
    }

    /**
     *
     * Render content for display
     *
     */
    public function render() {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $show_box_labels = $settings['show_box_labels'] == 'yes';
        $box_labels = $settings['box_labels'];

        $slider_data = [
            'widgetID' => $wid,
            'autoPlay' => $settings['autoplay'] == 'yes',
            'loop' => $settings['infinite_loop'] == 'yes',
            'desktopPerView'=> (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'tabletPerView'=> (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'mobilePerView'=> (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];


        $ids = $this->get_product_ids($settings);

        $products = $this->get_products($ids, $settings);
        $total_price = $this->get_total_price($products);
        ?>
        <div class="ah-product-package-element">
            <div class="is-element-loader">
                <span class="loader-span"></span>
            </div>
            <div class="package-wrap">
                <div class="package-details has-tb">
                    <div class="details-top w-full">
                        <div class="package-title-wrap">
                            <h4 class="package-title"><?php echo $settings['box_title'] ?></h4>
                            <?php if ($settings['show_box_label'] == 'yes'): ?>
                                <div class="package-discount-wrap">
                                    <span><?php echo $settings['box_label'] ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($settings['box_des'])): ?>
                            <div class="box-des">
                                <?php echo $settings['box_des'] ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="details-bottom-wrap w-full">
                        <?php if ($show_box_labels && $box_labels): ?>
                            <div class="box-labels">
                                <?php foreach ($box_labels as $label): ?>
                                    <span class="elementor-repeater-item-<?php echo esc_attr($label['_id']) ?>">
                                        <span class="icon"><?php \Elementor\Icons_Manager::render_icon( $label['label_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
                                        <?php echo $label['label_title'] ?>
                                    </span>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                        <div class="details-bottom">
                            <div class="details-b-wrap">
                                <div class="box-price">
                                    <?php if ($total_price): ?>
                                        <?php echo wc_price($total_price); ?>
                                    <?php else: ?>
                                        <span class="is-free-label"><?php echo __('Free') ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="box-button">
                                <a href="#" class="buy-package" data-ids="<?php echo implode(',', $ids) ?>">
                                    <span class="icon"><?php \Elementor\Icons_Manager::render_icon( $settings['box_btn_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
                                    <?php echo $settings['box_btn_title'] ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="package-products-wrap">
                    <div class="package-products">
                        <?php if ($products && $products->have_posts()): ?>
                            <div class="swiper" data-slider='<?php echo json_encode($slider_data) ?>'>
                                <div class="swiper-wrapper">
                                    <?php while ($products->have_posts()):
                                        $products->the_post();
                                        global $product;
                                        ?>
                                        <div class="swiper-slide">
                                            <div class="product-item has-tb">
                                                <a href="<?php the_permalink() ?>">
                                                    <div class="product-top w-full">
                                                        <div class="product-cover">
                                                            <?php the_post_thumbnail(); ?>
                                                            <div class="p-button-abs">
                                                                <span class="buy-product" data-id="<?php echo get_the_ID() ?>">+</span>
                                                            </div>
                                                        </div>
                                                        <div class="product-title-wrap">
                                                            <h3 class="product-title"><?php the_title() ?></h3>
                                                        </div>
                                                    </div>
                                                    <div class="product-bottom w-full">
                                                        <div class="product-price-wrap">
                                                            <?php echo wc_price($product->get_price()); ?>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                    <?php wp_reset_postdata(); ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <?php $this->renderElementorNotice(__('Select the products you want.')); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}