<?php

namespace ahura\inc\widgets;
// Block direct access to the main plugin file.

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

defined('ABSPATH') or die('No script kiddies please!');

class items_carousel extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\mw_elementor;
    function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('items_carousel_js', mw_assets::get_js('elementor.items_carousel'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('items_carousel_css', mw_assets::get_css('elementor.items_carousel'));
    }

    function get_script_depends()
    {
        return [mw_assets::get_handle_name('items_carousel_js')];
    }

    public function get_name()
    {
        return 'ahura_items_carousel';
    }
    function get_title()
    {
        return esc_html__('Items carousel', 'ahura');
    }
    public function get_icon() {
		return 'aicon-svg-items-carousel';
	}
    function get_categories()
    {
        return ['ahuraelements'];
    }
    function get_keywords()
    {
        return ['ahura', 'carousel', 'items carousel', esc_html__('ahura', 'ahura'), esc_html__('Items carousel', 'ahura')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'conetent_section',
            [
                'label' => esc_html__('Content', 'ahura'),
            ]
        );

        $this->add_control(
			'auto_play',
			[
				'label' => esc_html__( 'Auto Play', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'auto_play_speed',
			[
				'label' => esc_html__( 'Auto Play Speed', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 10000,
				'step' => 1,
				'default' => 1000,
                'condition' => ['auto_play' => 'yes']
			]
		);

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => 3,
				'tablet_default' => 2,
				'mobile_default' => 1,
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'ahura'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        

        $repeater->add_control(
            'top_title',
            [
                'label' => __('Top title', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Top title', 'ahura'),
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Title', 'ahura'),
            ]
        );

        $repeater->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => esc_html__( 'Default description', 'ahura' ),
				'placeholder' => esc_html__( 'Type your description here', 'ahura' ),
			]
		);

        $repeater->add_control(
            'link_text',
            [
                'label' => __('Button Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Read more', 'ahura')
            ]
        );

        $repeater->add_control(
            'link_url',
            [
                'label' => __('Button url', 'ahura'),
                'type' => \Elementor\Controls_Manager::URL,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '#'
                ]
            ]
        );

        $repeater->add_responsive_control(
            'image_top',
            [
                'label' => esc_html__('Image top', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 40
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-image img' => 'margin-top: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $repeater->start_controls_tabs('item_style_tabs');
        $repeater->start_controls_tab('item_style_title_tab', ['label' => esc_html__( 'Content', 'ahura' )]);

        $repeater->add_control(
            'item_toptitle_color',
            [
                'label' => esc_html__( 'Top title Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content h5' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'item_title_color',
            [
                'label' => esc_html__( 'Title Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'item_desc_color',
            [
                'label' => esc_html__( 'Description Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->end_controls_tab();
        $repeater->start_controls_tab('item_style_btn_tab', ['label' => esc_html__( 'Button', 'ahura' )]);

        $repeater->add_control(
			'button_icon',
			[
				'label' => esc_html__( 'Icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $repeater->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'Icon width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-link svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $repeater->add_control(
            'link_color',
            [
                'label' => __('Button color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#5C79D1',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content svg' => 'fill: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'link_background_color',
                'label' => __( 'Button background color', 'ahura' ),
                'types' => [ 'classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content a',
                'fields_options' => [
                    'background' =>
                        [
                            'default' => 'classic'
                        ],
                    'color' =>
                        [
                            'default' => '#fff'
                        ]
                ]
            ]
        );

        $repeater->add_control(
            'link_hovercolor',
            [
                'label' => __('Button hover color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#5C79D1',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content a:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content a:hover svg' => 'fill: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'link_background_hovercolor',
                'label' => __( 'Button background hover color', 'ahura' ),
                'types' => [ 'classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content a:hover',
                'fields_options' => [
                    'background' =>
                        [
                            'default' => 'classic'
                        ],
                    'color' =>
                        [
                            'default' => '#fff'
                        ]
                ]
            ]
        );

        $repeater->add_control(
            'button_border_color',
            [
                'label' => __('Button border color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff00',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content a' => 'border-color: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_responsive_control(
			'button_border_width',
			[
				'label' => esc_html__( 'Border width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-content a' => 'border-style: solid;border-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $repeater->end_controls_tab();

        $repeater->start_controls_tab('image_style_box_tab', ['label' => esc_html__( 'Image', 'ahura' )]);

        $repeater->add_responsive_control(
			'absolute_img',
			[
				'label' => esc_html__( 'Absolute position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
        $repeater->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 45,
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-image img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $repeater->add_responsive_control(
			'img_horizontal',
			[
				'label' => esc_html__( 'Horizontal position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 45,
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-image img' => 'left: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'absolute_img' => 'yes'
                ]
			]
		);
        
        $repeater->add_responsive_control(
			'img_vertical',
			[
				'label' => esc_html__( 'Vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 45,
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .items-carousel-image img' => 'top: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'absolute_img' => 'yes'
                ]
			]
		);

        $repeater->add_control(
			'hide_image',
			[
				'label' => esc_html__( 'Hide image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $repeater->end_controls_tab();

        $repeater->start_controls_tab('item_style_box_tab', ['label' => esc_html__( 'Box', 'ahura' )]);

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
                'fields_options' => [
                    'background' =>
                        [
                            'default' => 'gradient'
                        ],
                    'color' =>
                        [
                            'default' => '#5c79d1'
                        ],
                    'color_b' =>
                        [
                            'default' => '#9c70f4'
                        ],
                ]
            ]
        );

        $repeater->add_control(
            'btn_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
                ]
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_btn_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
            ]
        );

        $repeater->end_controls_tab();
        $repeater->end_controls_tabs();

        $this->add_control(
            'items',
            [
                'label' => __('Slides', 'ahura'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('Title','ahura')
                    ],[
                        'title' => __('Title','ahura')
                    ],[
                        'title' => __('Title','ahura')
                    ]
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         * Styles
         *
         *
         */

        $this->start_controls_section(
            'genral_styles',
            [
                'label' => esc_html__('General', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'slide_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 270,
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel .swiper-slide' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slides_space',
			[
				'label' => esc_html__( 'Slides space between', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 200,
				'step' => 1,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => 60,
				'tablet_default' => 30,
				'mobile_default' => 15,
			]
		);

        $this->add_responsive_control(
			'content_image_align',
			[
				'label' => esc_html__( 'Content alignment vs image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'row-reverse' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-h-align-right',
					],
					'row' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-h-align-left',
					],
					'column-reverse' => [
						'title' => esc_html__( 'Top', 'ahura' ),
						'icon' => 'eicon-v-align-top',
					],
					'column' => [
						'title' => esc_html__( 'Bottom', 'ahura' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'default' => 'row-reverse',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .items-carousel .swiper-slide' => 'flex-direction: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_h_align',
			[
				'label' => esc_html__( 'Horizontal alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-align-start-h',
					],
					'center' => [
						'title' => esc_html__( 'Middle', 'ahura' ),
						'icon' => 'eicon-align-center-h',
					],
					'end' => [
						'title' => esc_html__( 'left', 'ahura' ),
						'icon' => 'eicon-align-end-h',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .items-carousel .swiper-slide' => 'align-items: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_v_align',
			[
				'label' => esc_html__( 'Vertical alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'ahura' ),
						'icon' => 'eicon-align-start-v',
					],
					'center' => [
						'title' => esc_html__( 'Middle', 'ahura' ),
						'icon' => 'eicon-align-center-v',
					],
					'space-between' => [
						'title' => esc_html__( 'Space between', 'ahura' ),
						'icon' => 'eicon-justify-space-between-v',
					],
					'space-around' => [
						'title' => esc_html__( 'Space around', 'ahura' ),
						'icon' => 'eicon-justify-space-around-v',
					],
					'space-evenly' => [
						'title' => esc_html__( 'Space evenly', 'ahura' ),
						'icon' => 'eicon-justify-space-evenly-v',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'ahura' ),
						'icon' => 'eicon-align-end-v',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .items-carousel .swiper-slide' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'content_width',
			[
				'label' => esc_html__( 'Content area width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel .items-carousel-content' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .items-carousel .items-carousel-image' => 'width: calc(100{{UNIT}} - {{SIZE}}{{UNIT}});',
				],
                'conditions' => ['terms' => [[
                    'relation' => 'or',
                    'terms' => [['name' => 'content_image_align', 'value' => 'row'], ['name' => 'content_image_align', 'value' => 'row-reverse']],
                ]]],
			]
		);

        $this->add_responsive_control(
			'slide_padding',
			[
				'label' => esc_html__( 'Slide padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel .swiper-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'last_slide_mask_status',
			[
				'label' => esc_html__( 'Last slide mask', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'last_slide_mask',
			[
				'label' => esc_html__( 'Last slide mask filter', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0.0,
				'max' => 1,
				'step' => 0.1,
				'default' => 1,
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide-duplicate-prev' => '-webkit-mask-image: linear-gradient(to left, rgba(0,0,0,1), rgba(0,0,0,{{VALUE}})), linear-gradient(to left, rgba(0,0,0,1), rgba(0,0,0,{{VALUE}}));'
                ],
				'condition' => [ 'last_slide_mask_status' => 'yes' ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Content padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel .items-carousel-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Top title Typography', 'ahura'),
                'name' => 'toptitle_typography',
                'selector' => '{{WRAPPER}} .items-carousel-content h5',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '23',
                        ]
                    ],
                    'font_weight' => [
                        'default' => '500'
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '40',
                        ]
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
			'toptitle_align',
			[
				'label' => esc_html__( 'Top title alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .items-carousel-content h5' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'toptitle_padding',
			[
				'label' => esc_html__( 'Top title padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel-content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Title Typography', 'ahura'),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .items-carousel-content h6',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '35',
                        ]
                    ],
                    'font_weight' => [
                        'default' => '900'
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '40',
                        ]
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
			'title_align',
			[
				'label' => esc_html__( 'Title alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .items-carousel-content h6' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 33,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel-content h6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Description Typography', 'ahura'),
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .items-carousel-content p',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18',
                        ]
                    ],
                    'font_weight' => [
                        'default' => '500'
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '40',
                        ]
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
			'description_align',
			[
				'label' => esc_html__( 'Description alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'justify' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-justify',
					],
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .items-carousel-content p' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'desc_padding',
			[
				'label' => esc_html__( 'Description padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'img_styles',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
			'img_overflow',
			[
				'label' => esc_html__( 'Overflow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
        $this->add_responsive_control(
			'img_vertical_overflow',
			[
				'label' => esc_html__( 'Overflow from bottom', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-wrapper' => 'padding-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide' => 'overflow: visible;',
				],
                'condition' => [
                    'img_overflow' => 'yes'
                ]
			]
		);
        
        $this->add_responsive_control(
			'img_horizontal_overflow',
			[
				'label' => esc_html__( 'Overflow from right', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-wrapper' => 'padding-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide' => 'overflow: visible;',
				],
                'condition' => [
                    'img_overflow' => 'yes'
                ]
			]
		);

        $this->add_control(
            'img_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .items-carousel img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_img_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .items-carousel img',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'img_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .items-carousel img',
            ]
        );

        $this->add_responsive_control(
			'image_padding',
			[
				'label' => esc_html__( 'Image padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel .items-carousel-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'image_margin',
			[
				'label' => esc_html__( 'Image margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel .items-carousel-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'btn_styles',
            [
                'label' => esc_html__('Button', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => esc_html__( 'Slider button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Button Typography', 'ahura'),
                'name' => 'item_btn_typography',
                'selector' => '{{WRAPPER}} .items-carousel-link',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ],
                ],
                'condition' => [ 'show_button' => 'yes' ]
            ]
        );

        $this->add_control(
            'btn_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .items-carousel-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ],
                'condition' => [ 'show_button' => 'yes' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_btn_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .items-carousel-link',
                'condition' => [ 'show_button' => 'yes' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .items-carousel-link',
                'condition' => [ 'show_button' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
			'button_align',
			[
				'label' => esc_html__( 'Button alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .items-carousel-button' => 'text-align: {{VALUE}};',
				],
                'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_control(
			'fullwidth_button',
			[
				'label' => esc_html__( 'Fullwidth button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
                'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Button padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 8,
					'right' => 25,
					'bottom' => 8,
					'left' => 25,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' => esc_html__( 'Button margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'default' => [
					'top' => 30,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .items-carousel-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'nav_styles',
            [
                'label' => esc_html__('Navigation', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $pagination_style_default = 'border-radius: 100%';
        $pagination_style1 = 'border-radius: 5px;';

        $this->add_control(
			'pagination_styles',
			[
				'label' => esc_html__( 'Active pagination style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => $pagination_style_default,
				'options' => [
					$pagination_style_default => esc_html__( 'Default', 'ahura' ),
					$pagination_style1 => esc_html__( 'Style 1', 'ahura' ),
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => '{{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_style1_width',
			[
				'label' => esc_html__( 'Style1 width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'condition' => [ 'show_pagination' => 'yes', 'pagination_styles' => $pagination_style1 ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_vertical_position',
			[
				'label' => esc_html__( 'Pagination vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_width',
			[
				'label' => esc_html__( 'Pagination size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'active_pagination_color',
			[
				'label' => esc_html__( 'Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color:{{VALUE}};color:{{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'notactive_pagination_color',
			[
				'label' => esc_html__( 'Not-Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background-color:{{VALUE}};opacity:1',
				],
			]
		);

        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'active_styles',
            [
                'label' => esc_html__('Active Box', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __( 'Active box shadow', 'ahura' ),
                'selector' => '{{WRAPPER}} .items-carousel .swiper-slide-next',
                'fields_options' =>
                    [
                        'box_shadow_type' =>
                            [
                                'default' =>'yes'
                            ],
                        'box_shadow' => [
                            'default' =>
                                [
                                    'horizontal' => 0,
                                    'vertical' => 0,
                                    'blur' => 20,
                                    'spread' => 5,
                                    'color' => 'rgba(156,112,244,0.33)'
                                ]
                        ]
                    ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $has_paginate = isset($settings['show_pagination']) ? $settings['show_pagination'] == 'yes' : false;
        $has_arrows = isset($settings['show_arrow']) ? $settings['show_arrow'] == 'yes' : false;
        $vertical_content_image = isset($settings['content_image_align']) ? $settings['content_image_align'] == 'column' || $settings['content_image_align'] == 'column-reverse' : null;
        $fullwidth_btn = isset($settings['fullwidth_button']) && 'yes' == $settings['fullwidth_button'] ? true : false;
        $wid = $this->get_id();

        $slider_data = [
            'widgetID' => $wid,
            'spaceBetween' => (isset($settings['slides_space']) && intval($settings['slides_space'])) ? $settings['slides_space'] : 60,
            'spaceBetweenTablet' => (isset($settings['slides_space_tablet']) && intval($settings['slides_space_tablet'])) ? $settings['slides_space_tablet'] : 30,
            'spaceBetweenMobile' => (isset($settings['slides_space_mobile']) && intval($settings['slides_space_mobile'])) ? $settings['slides_space_mobile'] : 15,
            'autoPlayStatus' => $settings['auto_play'] === 'yes',
            'playDelay' => $settings['auto_play'] === 'yes' ? $settings['auto_play_speed'] : 99999,
            'desktopPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'pagination' => $has_paginate,
            'arrows' => $has_arrows,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];
        ?>
        <div class="swiper swiper-items-carousel items-carousel items-carousel-<?php echo $wid; ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
            <div class="swiper-wrapper">
                <?php if ($settings['items']):
                    foreach ($settings['items'] as $item):
                        $item_id = !empty($item['_id']) ? $item['_id'] : uniqid();
                        if ( ! empty( $item['link_url']['url'] ) ) {
                            $this->add_link_attributes( 'link_url_' . $item_id, $item['link_url'] );
                            $img_position = 'yes' == $item['absolute_img'] ? 'position: absolute' : 'position: relative';
                        } ?>
                        <div class="swiper-slide elementor-repeater-item-<?php echo $item_id; ?>">
                            <?php if($item['hide_image'] != 'yes' && !empty($item['image']['url'])): ?>
                                <div class="items-carousel-image">
                                    <?php if (!empty($item['image']['id'])): ?>
                                        <?php echo wp_get_attachment_image($item['image']['id'], 'full', '', ["style" => $img_position]) ?>
                                    <?php elseif(!empty($item['image']['url'])): ?>
                                        <img <?php echo 'yes' == $item['absolute_img'] ? 'style=' . $img_position : ''; ?> src="<?php echo $item['image']['url']; ?>" alt="element">
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <div class="items-carousel-content"<?php echo ($item['hide_image'] == 'yes' || empty($item['image']['url']) || $vertical_content_image) ? " style='width:100%'" : ''; ?>>
                                <?php if($item['top_title']): ?>
                                    <div class="items-carousel-toptitle w-100">
                                        <h5><?php echo $item['top_title']; ?></h5>
                                    </div>
                                <?php endif; ?>
                                <?php if($item['title']): ?>
                                    <div class="items-carousel-title w-100">
                                        <h6><?php echo $item['title']; ?></h6>
                                    </div>
                                <?php endif; ?>
                                <?php if($item['description']): ?>
                                    <div class="items-carousel-description w-100">
                                        <p><?php echo $item['description']; ?></p>
                                    </div>
                                <?php endif; ?>
                                <?php if('yes' === $settings['show_button']): ?>
                                    <div class="items-carousel-button w-100">
                                        <a <?php echo $this->get_render_attribute_string( 'link_url_' . $item_id ); ?> <?php echo $fullwidth_btn ? 'style="width:100%"' : ''; ?> class="items-carousel-link">
                                        <?php if($item['button_icon']['value']): ?>
                                            <?php \Elementor\Icons_Manager::render_icon( $item['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        <?php else: ?>
                                            <?php echo $item['link_text']; ?>
                                        <?php endif; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            <?php if($has_arrows): ?>
                <div class="items-carousel-button-prev"><i class="fa fa-chevron-left"></i></div>
                <div class="items-carousel-button-next"><i class="fa fa-chevron-right"></i></div>
            <?php endif; ?>
            <?php if($has_paginate): ?>
                <div class="swiper-pagination w-100"></div>
            <?php endif; ?>
        </div>
    <?php
    }
}
