<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class item_videobox extends \ahura\app\elementor\Elementor_Widget_Base {
	use \ahura\app\traits\mw_elementor;
	public function __register_assets()
    {
        $this->register_elementor_style('videobox_widget_style', mw_assets::get_css('elementor.video_box'));
    }

    public function get_name() {
		return 'item_videobox';
	}

	public function get_title() {
		return __( 'Video Box', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-item-videobox';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}

	function get_keywords()
	{
		return ['ahura', 'video box', 'item video box', esc_html__('ahura', 'ahura'), esc_html__( 'Video Box' , 'ahura')];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'image_section',
			[
				'label' => __( 'Image', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'video_title',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'video_subtitle',
			[
				'label' => esc_html__( 'Subtitle', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'item_image',
			[
				'label' => esc_html__( 'Choose Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'item_image_size',
			[
				'label' => esc_html__( 'Image size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'auto' => esc_html__( 'Auto', 'ahura' ),
					'contain'  => esc_html__( 'Contain', 'ahura' ),
					'cover' => esc_html__( 'Cover', 'ahura' ),
				],
				'default' => 'auto',
				'selectors' => [
					'{{WRAPPER}} .videbox_content' => 'background-size: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'use_image_icon',
            [
                'label' => __('Use image or icon', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Image', 'ahura'),
                'label_off' => __('Icon', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [ 'use_image_icon' => 'yes' ]
			]
		);

        $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [ 'use_image_icon!' => 'yes' ]
			]
		);

        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Button link', 'ahura' ),
                'type' => \Elementor\Controls_Manager::URL,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => site_url(),
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'hover_style',
            [
                'label' => __('Hover style', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'ahura'),
                'label_off' => __('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'box_styles',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
			'content_vertical_alignment',
			[
				'label' => esc_html__( 'Content vertical alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'ahura' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-v-align-middle',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'ahura' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .videbox_content a' => 'justify-content: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'content_alignment',
			[
				'label' => esc_html__( 'Content alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .videbox_content a' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
            'image_height',
            [
                'label' => esc_html__( 'Height', 'ahura' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .videbox_content' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400,
                ]
            ]
        );

        $this->add_control(
            'image_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .videbox_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .videbox_content .image-overlay' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->add_control(
            'image_position',
            [
                'label' => __( 'Images Position', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'initial',
                'options' => [
                    'initial'  => __( 'initial', 'ahura' ),
                    'left' => __( 'left', 'ahura' ),
                    'right' => __( 'right', 'ahura' ),
                    'top' => __( 'top', 'ahura' ),
                    'bottom' => __( 'bottom', 'ahura' ),
                    'center' => __( 'center', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .videbox_content' => 'background-position: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .videbox_content a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'wrap_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .videbox_content',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'btn_styles',
            [
                'label' => __( 'button', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon_player svg' => 'color: {{VALUE}}',
					'{{WRAPPER}} .icon_player svg' => 'fill: {{VALUE}}',
				],
                'condition' => [ 'use_image_icon!' => 'yes' ]
			]
		);

        $this->add_control(
			'icon_backcolor',
			[
				'label' => esc_html__( 'Icon background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-container' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'use_image_icon!' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .icon_player' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon_player svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon_player img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'icon_opacity',
			[
				'label' => esc_html__( 'Icon opacity', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 1,
				'step' => 0.1,
				'default' => 0.5,
			]
		);

        $this->add_control(
			'icon_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .icon-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'use_image_icon!' => 'yes' ]
			]
		);

        $this->add_control(
			'icon_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .icon-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'use_image_icon!' => 'yes' ]
			]
		);

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__( 'Hover Animation', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'titles_styles',
            [
                'label' => __( 'Titles', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} h2',
			]
		);
        
        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h2' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'subtitle_options',
			[
				'label' => esc_html__( 'Subtitle', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} h3',
			]
		);
        
        $this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__( 'Title color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h3' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'subtitle_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'hover_styles',
            [
                'label' => __( 'Hover', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [ 'hover_style' => 'yes' ]
            ]
        );

        $this->add_control(
			'hover_top_position',
			[
				'label' => esc_html__( 'Top position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => -30,
				],
				'selectors' => [
					'{{WRAPPER}} .videbox_content:hover a' => 'transform: translateY({{SIZE}}%)',
				],
                'condition' => [ 'hover_style' => 'yes' ]
			]
		);

        $this->add_control(
			'hover_overlay_color',
			[
				'label' => esc_html__( 'Overlay color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000aa',
				'selectors' => [
					'{{WRAPPER}} .videbox_content:hover .image-overlay' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'hover_style' => 'yes' ]
			]
		);

        $this->add_control(
			'hover_button_color',
			[
				'label' => esc_html__( 'Button color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF754C',
				'selectors' => [
					'{{WRAPPER}} .videbox_content:hover .icon-container' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'hover_style' => 'yes' ]
			]
		);
        
        $this->add_control(
			'hover_button_radius',
			[
				'label' => esc_html__( 'Button border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .videbox_content:hover .icon-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'hover_style' => 'yes' ]
			]
		);

        $this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

        if($settings['image']) {
            $this->add_render_attribute( 'image', 'src', $settings['image']['url'] );
            $this->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
            $this->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
        }

        $elementClass = 'icon_player';
		if ( $settings['hover_animation'] ) {
			$elementClass .= ' elementor-animation-' . $settings['hover_animation'];
		}
		$this->add_render_attribute( 'wrapper', 'class', $elementClass );

        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }

        $image = $settings['item_image'];
        $bg = '';
        if (!empty($image['url'])){
            $bg = $image['url'];
        } elseif(!empty($image['id'])) {
            $bg = wp_get_attachment_image_url($image['id']);
        }
        
		?>
        <div class="item-videobox-element videbox_content" style="background-image: url(<?php echo $bg ?>);">
            <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>>
                <?php if(!empty($settings['video_title'])): ?>
                    <?php echo '<h2>' . sanitize_text_field($settings['video_title']) . '</h2>'; ?>
                <?php endif; ?>
                <?php if(!empty($settings['video_subtitle'])): ?>
                    <?php echo '<h3>' . sanitize_text_field($settings['video_subtitle']) . '</h3>'; ?>
                <?php endif; ?>
                <div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?> style="background-image: url(<?php echo (empty($settings['icon']['value']) && empty($settings['image'])) ? get_template_directory_uri() . '/img/play.svg' : ''; ?>); opacity: <?php echo $settings['icon_opacity']; ?>;">
                    <div class="icon-container">
                        <?php if($settings['use_image_icon'] !== 'yes'): ?>
                            <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php else: ?>
                            <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' ); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </a>
            <div class="image-overlay"></div>
        </div>
		<?php
	}

}
