<?php

namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use Elementor\Controls_Manager;
use \ahura\app\elementor\controls\Control_Jdate_Picker;

class countdown4 extends \ahura\app\elementor\Elementor_Widget_Base
{

    // Use prepared methods
    use \ahura\app\traits\mw_elementor;

    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('countdown_js', mw_assets::get_js('countdown'));
        mw_assets::register_script('countdown4_js', mw_assets::get_js('elementor.countdown4'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('countdown4_css', mw_assets::get_css('elementor.countdown4'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('countdown_js'), mw_assets::get_handle_name('countdown4_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'countdown4';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Countdown 4', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'aicon-svg-countdown-3';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    function get_keywords()
    {
        return ['ahura', 'countdown', 'countdown 4', esc_html__('ahura', 'ahura'), esc_html__('Countdown 4', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         * Start content section
         *
         */
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'use_jdate',
            [
                'label' => esc_html__('Use Jalali Date', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => is_rtl() ? 'yes' : 'no',
            ]
        );

        $this->add_control(
            'jdate',
            [
                'label' => esc_html__('Time', 'ahura'),
                'type' => Control_Jdate_Picker::JDATE_TIME,
                'default' => ahura_jdate('Y-m-d H:i', strtotime('+1 month')),
                'condition' => [
                    'use_jdate' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'date',
            [
                'label' => esc_html__('Time', 'ahura'),
                'type' => \Elementor\Controls_Manager::DATE_TIME,
                'default' => gmdate('Y-m-d h:m', strtotime('+1 month') + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS )),
                'condition' => [
                    'use_jdate!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'end_text',
            [
                'label' => esc_html__('End Text', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => esc_html__('Finished!', 'ahura'),
                'placeholder' => esc_html__('End text...', 'ahura'),
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         *
         * Start styles
         *
         *
         */

        /**
         *
         *
         * Timer styles
         *
         *
         */
        $this->start_controls_section(
            'box_timer_style',
            [
                'label' => esc_html__('Timer', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs('style_tabs');

        $this->start_controls_tab('style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .time-down',
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .time-down' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .time-down',
            ]
        );

        $this->add_control(
            'num_more_options',
            [
                'label' => esc_html__( 'Number', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'timer_num_color',
            [
                'label' => esc_html__('Number Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .time-down .num' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_timer_num_typo',
                'label' => esc_html__('Number Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .time-down .num',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '19'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'timer_num_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .time-down',
            ]
        );

        $this->add_control(
            'label_more_options',
            [
                'label' => esc_html__( 'Label', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'timer_label_color',
            [
                'label' => esc_html__('Label Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .time-down .text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_timer_label_typo',
                'label' => esc_html__('Label Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .time-down .text',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'timer_label_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .time-down .text',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'ahura' ),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border_hover',
                'selector' => '{{WRAPPER}} .time-down:hover',
            ]
        );

        $this->add_control(
            'item_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .time-down:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow_hover',
                'selector' => '{{WRAPPER}} .time-down:hover',
            ]
        );

        $this->add_control(
            'num_more_options_hover',
            [
                'label' => esc_html__( 'Number', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'timer_num_color_hover',
            [
                'label' => esc_html__('Number Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time-down:hover .num' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'timer_num_background_hover',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .time-down:hover',
            ]
        );

        $this->add_control(
            'label_more_options_hover',
            [
                'label' => esc_html__( 'Label', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'timer_label_color_hover',
            [
                'label' => esc_html__('Label Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .time-down:hover .text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'timer_label_background_hover',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .time-down:hover .text',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $widget_id = $this->get_id();

        if (empty($settings['date']) && empty($settings['jdate'])) return false;

        $is_jdate = ($settings['use_jdate'] === 'yes');

        if($is_jdate){
            $jdate = ($is_jdate) ? explode(' ', $settings['jdate']) : false;
            $jdate_date = explode('-', $jdate['0']);
            $gmtime = ahura_jalali_to_gregorian((int)$jdate_date[0], (int)$jdate_date[1], (int)$jdate_date[2]);
            $gmtime = (is_array($gmtime)) ? "{$gmtime[0]}-{$gmtime[1]}-{$gmtime[2]}" : '';
        }

        $formatted_time = $is_jdate ? date('c', strtotime($gmtime)) : date('c', strtotime($settings['date']));

        $countdown_data = [
            'time' => $formatted_time,
            'labels' => [
                'day' => __('Day', 'ahura'),
                'hour' => __('Hour', 'ahura'),
                'minute' => __('Minute', 'ahura'),
                'seconds' => __('Seconds', 'ahura'),
            ]
        ];
        ?>
        <div class="ahura-countdown4 countdown4-<?php echo $widget_id ?> countdown-wrap" data-countdown='<?php echo json_encode($countdown_data) ?>'>
            <div class="end-content" style="display: none"><?php echo $settings['end_text'] ?></div>
            <div class="counter"></div>
        </div>
        <?php
    }
}