<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\customization\ios_checkbox;
use ahura\app\customization\simple_select_box;
use ahura\app\customization\simple_text;

$theme_modes = [
    0 => __('Default', 'ahura'),
    'movie' => __('Movie & Series', 'ahura'),
    'estate' => __('Real Estate', 'ahura'),
    'download' => __('Download', 'ahura'),
];

$this->customizer->add_setting('ahura_theme_mode', ['default' => 0]);
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_theme_mode', [
    'section' => $this->current_section,
    'label' => __('Theme Mode', 'ahura'),
    'choices' => apply_filters('ahura_theme_mode_items', $theme_modes),
]));

$this->customizer->add_setting('ahura_theme_currency_unit', ['default'  => __('Toman','ahura')]);
$this->customizer->add_control(new simple_text($this->customizer, 'ahura_theme_currency_unit', array(
    'label' => __('Currency Unit', 'ahura'),
    'section' => $this->current_section,
    'type'    => 'text',
    'active_callback' => ['\ahura\app\mw_options','is_estate_theme_mode']
)));

$theme_post_types = \ahura\app\mw_post_type::get_post_types();
$types = array();
if($theme_post_types){
    foreach ($theme_post_types as $key => $value) {
        if(is_array($value) && isset($value['is_public'])){
            if($value['is_public'] == true){
                $types[$key] = $value['labels']['singular_name'];
            }
        }
    }
}

$this->customizer->add_setting('ahura_disabled_post_types');
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_disabled_post_types', [
    'section' => $this->current_section,
    'label' => __('Disabled post types', 'ahura'),
    'choices' => $types,
    'input_attrs' => [
        'multiple' => true,
        'class' => 'ahura-select'
    ],
]));

$this->customizer->add_setting('ahura_convert_dates_to_jalali');
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_convert_dates_to_jalali', array(
    'label'      => __('Convert Dates to Jalali', 'ahura'),
    'section'    => $this->current_section,
)));

$this->customizer->add_setting('ahura_wp_images_lazyload_status', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_wp_images_lazyload_status', array(
    'label'      => __('WP Images Lazyload', 'ahura'),
    'section'    => $this->current_section,
    'description' => __('If you see a problem or slowness in loading website images, you can disable this option (in general, the lazy load feature usually does not work properly in sliders).', 'ahura')
)));

$this->customizer->add_setting('ahura_allow_upload_font_files', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_allow_upload_font_files', array(
    'label'      => __('Allow Upload Font Files', 'ahura'),
    'section'    => $this->current_section,
)));

$this->customizer->add_setting('ahura_allow_upload_svg', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_allow_upload_svg', array(
    'label'      => __('Allow Upload SVG File', 'ahura'),
    'section'    => $this->current_section,
    'description' => __('Uploading this type of file is not safe, temporarily enable it.', 'ahura')
)));

$this->customizer->add_setting('ahura_allow_upload_json', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_allow_upload_json', array(
    'label'      => __('Allow Upload JSON File', 'ahura'),
    'section'    => $this->current_section,
    'description' => __('Uploading this type of file is not safe, temporarily enable it.', 'ahura')
)));

$this->customizer->add_setting('ahura_allow_upload_webp', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_allow_upload_webp', array(
    'label'      => __('Allow Upload WEBP File', 'ahura'),
    'section'    => $this->current_section,
)));

$this->customizer->add_setting('ahura_allow_upload_ico', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_allow_upload_ico', array(
    'label'      => __('Allow Upload ICO File', 'ahura'),
    'section'    => $this->current_section,
)));

$this->customizer->add_setting('ahura_images_lightbox_status');
$this->customizer->add_control(new ios_checkbox( $this->customizer, 'ahura_images_lightbox_status', [
    'section' => $this->current_section,
    'label' => __('Enable images lightbox', 'ahura'),
    'description' => __('This feature is activated only on the single post and products.', 'ahura'),
]));

$this->customizer->add_setting('ahura_optimize_swiper_script', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_optimize_swiper_script', array(
    'label' => __('Optimize swiper script loading', 'ahura'),
    'description' => __('This feature will force Ahura to load the swiper script on only necessary pages (This feature is on experimental stage).', 'ahura'),
    'section' => $this->current_section,
)));

$this->customizer->add_setting('ahura_elementor_template_cpt_state', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_elementor_template_cpt_state', array(
    'label' => __('Elementor template on custom post types', 'ahura'),
    'section' => $this->current_section,
)));

$this->customizer->add_setting('ahura_elementor_template_cpt_list');
$this->customizer->add_control(new simple_text($this->customizer, 'ahura_elementor_template_cpt_list', [
    'label' => __("Custom post types list", 'ahura'),
    'description' => __('Separated by comma(,) - Default WordPress and Ahura post types will be escaped (post, page, product, team, portfolio, testimonial)', 'ahura'),
    'section' => $this->current_section,
    'active_callback'   =>  ['\ahura\app\mw_options','get_mod_is_active_elementor_template_cpt']
]));