{if isset($RSThemes['pages'][$templatefile]) && file_exists($RSThemes['pages'][$templatefile]['fullPath'])}
    {include file=$RSThemes['pages'][$templatefile]['fullPath']}
{else}  
    {assign var=iconsPages value=['clientareadomains', 'supportticketslist', 'clientareainvoices', 'clientareaproducts', 'clientareaquotes']}
    {if $invoices}
        {include file="$template/includes/tablelist.tpl" tableName="InvoicesList" filterColumn="4" ajaxUrl="{$WEB_ROOT}/modules/addons/RSThemes/src/Api/clientApi.php?controller=ClientData&method=getClientInvoices" tableIncludes="invoices"}
        <script type="text/javascript">
            jQuery(document).ready( function ()
            {
                var table = jQuery('#tableInvoicesList').removeClass('hidden').DataTable();
                {if $orderby == 'default'}
                    table.order([4, 'desc'], 
                        {if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Invoice Number Asc"}
                            [0, 'asc']
                        {else if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Invoice Number Desc"}
                            [0, 'desc']
                        {else if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Invoice Date Asc"}
                            [1, 'asc']
                        {else if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Invoice Date Desc"}
                            [1, 'desc']
                        {else if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Due Date Asc"}
                            [2, 'asc']
                        {else if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Due Date Desc"}
                            [2, 'desc']
                        {else if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Total Asc"}
                            [3, 'asc']
                        {else if $RSThemes['pages'][$templatefile]['config']['sortingTableOption'] === "Total Desc"}
                            [3, 'desc']            
                        {else if !isset($RSThemes['pages'][$templatefile]['config']['sortingTableOption'])}
                            [2, 'asc']
                        {/if});
                {elseif $orderby == 'invoicenum'}
                    table.order(0, '{$sort}');
                {elseif $orderby == 'date'}
                    table.order(1, '{$sort}');
                {elseif $orderby == 'duedate'}
                    table.order(2, '{$sort}');
                {elseif $orderby == 'total'}
                    table.order(3, '{$sort}');
                {elseif $orderby == 'status'}
                    table.order(4, '{$sort}');
                {/if}
                table.draw();
                {if isset($RSThemes.addonSettings.enable_table_ajax_load) && $RSThemes.addonSettings.enable_table_ajax_load == "enabled"}
                {else}
                    jQuery('.table-container').removeClass('loading');
                    jQuery('#tableLoading').addClass('hidden');
                {/if}    
            });
        </script>
        <div class="table-container {if isset($RSThemes.addonSettings.enable_table_ajax_load) && $RSThemes.addonSettings.enable_table_ajax_load == "enabled"}table-container-ajax{/if} loading clearfix">
            <div class="table-top">
                <div class="d-flex">
                    <label>{$LANG.clientareahostingaddonsview}</label>
                    <div 
                        class="dropdown view-filter-btns {if $RSThemes.addonSettings.show_status_icon == 'displayed'}iconsEnabled{/if}"
                        data-table-filters 
                        {if isset($RSThemes['pages'][$templatefile]) && isset($RSThemes['pages'][$templatefile]['config']['defaultStatusFilter']) && $RSThemes['pages'][$templatefile]['config']['defaultStatusFilter'] != "all" && !empty($RSThemes['pages'][$templatefile]['config']['defaultStatusFilter'])}
                            data-default-filter="{$RSThemes['pages'][$templatefile]['config']['defaultStatusFilter']}"
                        {/if}
                    >
                        <button type="button" class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown">
                            {if $RSThemes.addonSettings.show_status_icon == 'displayed'}
                                {if file_exists("templates/$template/assets/img/status-icons/status-all.tpl")}
                                    <span class="status-icon status-status-all" style="font-size: 0;">
                                        {include file="$template/assets/img/status-icons/status-all.tpl"}      
                                    </span>
                                {/if}
                            {else}
                                <span class="status hidden"></span>
                            {/if}
                            <span class="filter-name">{$rslang->trans('generals.all_entries')}</span>
                            <i class="ls ls-caret"></i>
                        </button>
                        <ul class="dropdown-menu" role="menu">
                            <li>
                                <a href="#">
                                    <span data-value="all">
                                        {if $RSThemes.addonSettings.show_status_icon == 'displayed'}
                                            {if file_exists("templates/$template/assets/img/status-icons/status-all.tpl")}
                                                <span class="status-icon status-status-all">
                                                    {include file="$template/assets/img/status-icons/status-all.tpl"}      
                                                </span>
                                            {/if}
                                            <span class="filter-name">{$rslang->trans('generals.all_entries')}</span>
                                        {else}
                                            {$rslang->trans('generals.all_entries')}
                                        {/if}
                                    </span>
                                </a>
                            </li>
                            {foreach key=num item=status from=$RSInvoicesStatuses}
                                {if $RSThemes.addonSettings.show_status_icon == 'displayed' && in_array($templatefile, $iconsPages)}
                                    <li data-status="{$status.rawstatus|capitalize}">
                                        <a href="#">
                                            <span 
                                                class="status status-{$status.statusClass} {if $RSThemes.addonSettings.show_status_icon == 'displayed'}dot-hidden{/if}" 
                                                {if isset($RSThemes.addonSettings.enable_table_ajax_load) && $RSThemes.addonSettings.enable_table_ajax_load == "enabled"}
                                                     data-value="{$status.rawstatus}" 
                                                {else}   
                                                    data-value="{$status.statustext}" 
                                                {/if}
                                                data-status-class="{$status.statusClass}"
                                            >
                                                {if $RSThemes.addonSettings.show_status_icon == 'displayed'}
                                                    {if file_exists("templates/$template/assets/img/status-icons/{$status.statusClass}.tpl")}
                                                        <span class="status-icon status-{$status.statusClass}">
                                                            {include file="$template/assets/img/status-icons/{$status.statusClass}.tpl"}      
                                                        </span>
                                                    {else}
                                                        <span class="status-icon status-{$status.statusClass}">
                                                            {include file="$template/assets/img/status-icons/default.tpl"}      
                                                        </span>
                                                    {/if}                     
                                                {/if}
                                                <span class="filter-name">{$status.statustext}</span>
                                            </span>
                                        </a>
                                    </li>
                                {else}
                                    <li data-status="{$status.rawstatus|capitalize}"><a href="#"><span class="status status-{$status.statusClass}" data-value="{$status.statustext}" data-status-class="{$status.statusClass}">{$status.statustext}</span></a></li>
                                {/if}
                            {/foreach}
                        </ul>
                    </div>
                    <button id="clearFilters" type="button" class="btn btn-link btn-xs hidden">{$rslang->trans('generals.clear_filters')}<i class="ls ls-close"></i></button>
                </div>       
            </div>
            <table id="tableInvoicesList" class="table table-list">
                <thead>
                    <tr>
                        <th data-priority="1"><button type="button" class="btn-table-collapse"></button>{$LANG.invoicestitle}<span class="sorting-arrows"></span></th>
                        <th data-priority="3">{$LANG.invoicesdatecreated}<span class="sorting-arrows"></span></th>
                        <th data-priority="4">{$LANG.invoicesdatedue}<span class="sorting-arrows"></span></th>
                        <th data-priority="5">{$LANG.invoicestotal}<span class="sorting-arrows"></span></th>
                        <th data-priority="2">{$LANG.invoicesstatus}<span class="sorting-arrows"></span></th>          
                        {if isset($RSThemes['pages'][$templatefile]) && $RSThemes['pages'][$templatefile]['config']['showPdfButton'] == "1"}   
                            <th></th> 
                        {/if}
                        {if isset($RSThemes['pages'][$templatefile]) && $RSThemes['pages'][$templatefile]['config']['showManageButton'] == "1"}
                            <th></th> 
                        {/if}     
                    </tr>
                </thead>
                <tbody>
                    {if !isset($RSThemes.addonSettings.enable_table_ajax_load) || $RSThemes.addonSettings.enable_table_ajax_load == "disabled"}
                        {foreach key=num item=invoice from=$invoices}
                            <tr data-url="viewinvoice.php?id={$invoice.id}">
                                <td><button type="button" class="btn-table-collapse"></button>{$invoice.invoicenum}</td>
                                <td><span class="hidden">{$invoice.normalisedDateCreated}</span>{$invoice.datecreated}</td>
                                <td><span class="hidden">{$invoice.normalisedDateDue}</span>{$invoice.datedue}</td>
                                <td data-order="{$invoice.totalnum}">{$invoice.total}</td>
                                {if $RSThemes.addonSettings.show_status_icon == 'displayed' && in_array($templatefile, $iconsPages)}
                                    <td>
                                        <span class="status status-{$invoice.statusClass} {if $RSThemes.addonSettings.show_status_icon == 'displayed'}dot-hidden{/if}">
                                            {if $RSThemes.addonSettings.show_status_icon == 'displayed'}
                                                {if file_exists("templates/$template/assets/img/status-icons/{$invoice.statusClass}.tpl")}
                                                    <span class="status-icon">
                                                        {include file="$template/assets/img/status-icons/{$invoice.statusClass}.tpl"}      
                                                    </span>
                                                {else}
                                                    <span class="status-icon">
                                                        {include file="$template/assets/img/status-icons/default.tpl"}      
                                                    </span>
                                                {/if}                     
                                            {/if}
                                            {$invoice.status}
                                        </span>
                                    </td>
                                {else}
                                    <td><span class="status status-{$invoice.statusClass}">{$invoice.status}</span></td>                                
                                {/if}
                                {if isset($RSThemes['pages'][$templatefile]) && $RSThemes['pages'][$templatefile]['config']['showPdfButton'] == "1"}
                                        <td class="cell-action">
                                                <a href="dl.php?type=i&amp;id={$invoice.id}" class="btn btn-default btn-sm btn-manage">{$LANG.invoicesdownload}</a>
                                        </td>
                                {/if}
                                {if isset($RSThemes['pages'][$templatefile]) && $RSThemes['pages'][$templatefile]['config']['showManageButton'] == "1"}
                                    <td class="cell-action cell-action--last">
                                        <a href="viewinvoice.php?id={$invoice.id}" class="btn btn-default btn-sm btn-manage">{$_LANG['manage']}</a>
                                    </td>
                                {/if}   
                            </tr>
                        {/foreach}
                    {/if}    
                </tbody>
            </table>
            <div class="loader loader-table" id="tableLoading">
                {include file="$template/includes/common/loader.tpl"}    
            </div>
        </div>
    {else}
        <div class="message message-no-data">
            <div class="message-image">
                {include file="$template/includes/common/svg-icon.tpl" icon="invoice"}       
            </div>
            <h6 class="message-title">{$LANG.invoicesnoinvoices}</h6>
        </div>
    {/if}
{/if}    
