<?php

use greenmodule\WHMCS\IrnicResellerClient\Core\Settings;
use WHMCS\Database\Capsule;

require_once ROOTDIR . "/modules/addons/IrnicResellerClient/include/bootstrap.php";

if (function_exists('openprovider_additional_fields')) {
    $additionaldomainfields = openprovider_additional_fields();
}

foreach (IrnicResellerClient_getSupportedTLDs() as $tld) {
    $additionaldomainfields[$tld] = [];

    $additionaldomainfields[$tld][] = [
        'Name' => 'domain_holder',
        'DisplayName' => IrnicResellerClient_translate('IRNIC_DOMAIN_HOLDER'),
        'Type' => 'text',
        'Size' => '30',
        'Default' => '',
        'Required' => true,
        'Description' => IrnicResellerClient_translate('IRNIC_DOMAIN_HOLDER_DESC'),
    ];

    if (Settings::get('ask_handles')) {
        $additionaldomainfields[$tld][] = [
            'Name' => 'contact_admin',
            'DisplayName' => IrnicResellerClient_translate('IRNIC_DOMAIN_CONTACT_ADMIN'),
            'Type' => 'text',
            'Default' => Settings::get('admin_handle'),
            'Required' => true,
        ];
        $additionaldomainfields[$tld][] = [
            'Name' => 'contact_bill',
            'DisplayName' => IrnicResellerClient_translate('IRNIC_DOMAIN_CONTACT_BILL'),
            'Type' => 'text',
            'Default' => Settings::get('bill_handle'),
            'Required' => true,
        ];
        $additionaldomainfields[$tld][] = [
            'Name' => 'contact_tech',
            'DisplayName' => IrnicResellerClient_translate('IRNIC_DOMAIN_CONTACT_TECH'),
            'Type' => 'text',
            'Default' => Settings::get('tech_handle'),
            'Required' => true,
        ];
        continue;
    }

    $additionaldomainfields[$tld][0]['Description'] .= '<br />' . IrnicResellerClient_translate('IRNIC_DOMAIN_HOLDER_DESC2');
}

if (is_file(__DIR__ . "/additionalfields.others.php")) {
    require_once __DIR__ . "/additionalfields.others.php";
}