<?php

namespace WHMCS\Module\Widget;

use App;
use WHMCS\Module\AbstractWidget;

/**
 * NetworkStatus Widget.
 *
 * @copyright Copyright (c) WHMCS Limited 2005-2021
 * @license https://www.whmcs.com/eula/ WHMCS Eula
 */
class NetworkStatus extends AbstractWidget
{
    protected $title = 'وضعیت شبکه';
    protected $description = 'مروری بر وضعیت شبکه.';
    protected $weight = 450;
    protected $cache = true;

    public function getData()
    {
        return localAPI('GetServers', array('fetchStatus' => App::getFromRequest('refresh')));
    }

    public function generateOutput($data)
    {
        $output = '';
        foreach ($data['servers'] as $server) {
            $online = $data['fetchStatus'] ? (bool) $server['status']['http'] : null;
            if ($data['fetchStatus']) {
                $uptime = $server['status']['uptime'] ? $server['status']['uptime'] : '-';
                $load = $server['status']['load'] ? $server['status']['load'] : '-';
            } else {
                $uptime = $load = 'در دسترس نیست';
            }

            $serverAddress = $server['hostname'] ? $server['hostname'] : $server['ipaddress'];

            $output .= '
<div class="item">
    <div class="name">
        <div class="data">' . $server['name'] . '</div>
        <div class="note"><a href="http://' . $serverAddress . '" target="_blank">' . $serverAddress . '</a></div>
    </div>
    <div class="stats text-center">
        <div class="status">
            <div class="data color-' . (is_null($online) || $online ? 'green' : 'pink') . '">' . (is_null($online) ? 'در دسترس نیست' : ($online ? 'آنلاین' : 'آفلاین')) . '</div>
            <div class="note">وضعیت</div>
        </div>
        <div class="uptime">
            <div class="data">' . (is_null($uptime) ? 'در دسترس نیست' : $uptime) . '</div>
            <div class="note">آپتایم</div>
        </div>
        <div class="load">
            <div class="data text-info">' . (is_null($load) ? 'در دسترس نیست' : $load) . '</div>
            <div class="note">میانگین لود</div>
        </div>
    </div>
</div>';
        }
        if (count($data['servers']) == 0) {
            $output = '<div class="text-center">
                هیچ سروری پیکربندی نشده است.
                <br /><br />
                <a href="configservers.php" class="btn btn-primary btn-sm">اکنون اولین خود را اضافه کنید</a>
                <br /><br />
            </div>';
        }

        return <<<EOF
<div class="widget-content-padded">
    <div class="items-wrapper">
        {$output}
    </div>
</div>
EOF;
    }
}
