<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;
use WHMCS\Invoices;
use WHMCS\Module\GatewaySetting;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$reportdata['isPrintable'] = false;
$reportdata['canCsvExport'] = false;

$reportdata["title"] = "خروجی  گروهی فاکتور ";
$reportdata["description"] = <<<DESCRIPTION
از این ابزار می توان برای تولید و دانلود دسته ای خروجی  فاکتورها در قالب پی دی اف (یک در هر صفحه) استفاده کرد.<br />
کاربردهای معمولی برای این شامل تولید نسخه‌های کاغذی سخت برای ارسال به مشتریان یا نگهداری سوابق است.
DESCRIPTION;

require("../includes/gatewayfunctions.php");

if ($noresults) {
    infoBox("هیچ فاکتوری با معیار مطابقت ندارد", "هیچ فاکتوری مطابق با معیارهای شما پیدا نشد");
    $reportdata["description"] .= $infobox;
}

$range = App::getFromRequest('range');
if (!$range) {
    $today = Carbon::today()->endOfDay();
    $lastMonth = Carbon::today()->subDays(29)->startOfDay();
    $range = $lastMonth->toAdminDateFormat() . ' - ' . $today->toAdminDateFormat();
}

$clientsDropDown = $aInt->clientsDropDown($userid, false, 'userid', true);

$gatewayOptions = '';

foreach (GatewaySetting::getActiveGatewayFriendlyNames() as $gateway => $friendlyName) {
    $gatewayOptions .= "<option value=\"{$gateway}\" selected>{$friendlyName}</option>";
}

$statusOptions = '';
foreach (Invoices::getInvoiceStatusValues() as $invoiceStatusOption) {
    if ($invoiceStatusOption == 'Unpaid') {
        $isSelected = 'selected';
    } else {
        $isSelected = '';
    }
    $optionName = $aInt->lang('status', strtolower(str_replace(' ', '', $invoiceStatusOption)));
    $statusOptions .= "<option value=\"{$invoiceStatusOption}\" {$isSelected}>{$optionName}</option>";
}

$reportdata["headertext"] = <<<HTML
<form method="post" action="csvdownload.php?type=pdfbatch">
    <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
        <tr>
            <td width="20%" class="fieldlabel">
                نام مشتری
            </td>
            <td class="fieldarea">
                {$clientsDropDown}
            </td>
        </tr>
        <tr>
            <td class="fieldlabel">
                فیلتر شده توسط
            </td>
            <td class="fieldarea">
                <select name="filterby" class="form-control select-inline">
                    <option>تاریخ ایجاد</option>
                    <option>سررسید</option>
                    <option>تاریخ پرداخت</option>
                </select>
            </td>
        </tr>
        <tr>
            <td class="fieldlabel">
                محدوده زمانی
            </td>
            <td class="fieldarea">
                <div class="form-group date-picker-prepend-icon">
                    <label for="inputFilterDate" class="field-icon">
                        <i class="fal fa-calendar-alt"></i>
                    </label>
                    <input id="inputFilterDate"
                    type="text"
                    name="range"
                    value="{$range}"
                    class="form-control date-picker-search input-inline"
                    />
                </div>
            </td>
        </tr>
        <tr>
            <td class="fieldlabel">
                روش های پرداخت
            </td>
            <td class="fieldarea">
                <select name="paymentmethods[]" class="form-control input-250" size="8" multiple="true">
                    {$gatewayOptions}
                </select>
            </td>
        </tr>
        <tr>
            <td class="fieldlabel">
                وضعیت خا
            </td>
            <td class="fieldarea">
                <select name="statuses[]" class="form-control input-150" size="6" multiple="true">
                    {$statusOptions}
                </select>
            </td>
        </tr>
        <tr>
            <td class="fieldlabel">
                ترتیب مرتب سازی
            </td>
            <td class="fieldarea">
                <select name="sortorder" class="form-control select-inline">
                    <option>شناسه فاکتور</option>
                    <option>شماره فاکتور</option>
                    <option>تاریخ پرداخت</option>
                    <option>سررسید</option>
                    <option>شناسه مشتری</option>
                    <option>نام مشتری</option>
                </select>
            </td>
        </tr>
    </table>
    <p align=center>
        <input type="submit" value="دانلود فایل" class="btn btn-default">
    </p>
</form>
HTML;

$report = '';
