<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

/** @var string $requeststr */

$reportdata["title"] = "مشتریان جدید";
$reportdata["description"] = "این گزارش تعداد کل مشتریان جدید، سفارش‌ها و سفارش‌های کامل را نشان می‌دهد و هر یک از آنها را با سال قبل در نمودار مقایسه می‌کند.";

$reportdata["tableheadings"] = array("ماه", "ثبت نام های جدید", "سفارشات ثبت شده", "سفارشات تکمیل شده");

$show = App::getFromRequest('show');
if (!$show) {
    $show = 'signups';
}

for ($rawmonth = 1; $rawmonth <= 12; $rawmonth++) {
    $dateRange = Carbon::create($year, $rawmonth, 1);
    $dateRangeLastYear = Carbon::create(($year - 1), $rawmonth, 1);

    $firstOfMonth = $dateRange->firstOfMonth()->toDateTimeString();
    $firstOfMonth2 = $dateRangeLastYear->firstOfMonth()->toDateTimeString();
    $lastOfMonth = $dateRange->endOfMonth()->toDateTimeString();
    $lastOfMonth2 = $dateRangeLastYear->endOfMonth()->toDateTimeString();

    $newsignups = Capsule::table('tblclients')
        ->whereBetween(
            'datecreated',
            [
                $firstOfMonth,
                $lastOfMonth
            ]
        )->count();

    $totalorders = Capsule::table('tblorders')
        ->whereBetween(
            'date',
            [
                $firstOfMonth,
                $lastOfMonth
            ]
        )->count();

    $completedorders = Capsule::table('tblorders')
        ->where('status', 'Active')
        ->whereBetween(
            'date',
            [
                $firstOfMonth,
                $lastOfMonth
            ]
        )->count();

    $newsignups2 = Capsule::table('tblclients')
        ->whereBetween(
            'datecreated',
            [
                $firstOfMonth2,
                $lastOfMonth2
            ]
        )->count();

    $totalorders2 = Capsule::table('tblorders')
        ->whereBetween(
            'date',
            [
                $firstOfMonth2,
                $lastOfMonth2
            ]
        )->count();

    $completedorders2 = Capsule::table('tblorders')
        ->where('status', 'Active')
        ->whereBetween(
            'date',
            [
                $firstOfMonth2,
                $lastOfMonth2
            ]
        )->count();

    $reportdata["tablevalues"][] = array(
        $months[$rawmonth] . ' ' . $year,
        $newsignups,
        $totalorders,
        $completedorders
    );

    switch ($show) {
        case 'orders':
            $chartdata['rows'][] = array(
                'c' => array(
                    array('v' => $months[$rawmonth]),
                    array('v' => (int) $totalorders),
                    array('v' => (int) $totalorders2),
                ),
            );
            break;
        case 'orderscompleted':
            $chartdata['rows'][] = array(
                'c' => array(
                    array('v' => $months[$rawmonth]),
                    array('v' => (int) $completedorders),
                    array('v' => (int) $completedorders2),
                ),
            );
            break;
        case 'show':
        default:
            $chartdata['rows'][] = array(
                'c' => array(
                    array('v' => $months[$rawmonth]),
                    array('v' => (int) $newsignups),
                    array('v' => (int) $newsignups2),
                ),
            );
    }
}

$chartdata['cols'][] = array('label' => 'Month', 'type' => 'string');
$chartdata['cols'][] = array('label' => $year, 'type' => 'number');
$chartdata['cols'][] = array('label' => ($year - 1), 'type' => 'number');

$args = array();
if (!$show || $show == "signups") {
    $args['title'] = 'ثبت نام های جدید';
    $args['colors'] = '#3366CC,#888888';
}
if ($show == "orders") {
    $args['title'] = 'سفارشات ثبت شده';
    $args['colors'] = '#DC3912,#888888';
}
if ($show == "orderscompleted") {
    $args['title'] = 'سفارشات تکمیل شده';
    $args['colors'] = '#FF9900,#888888';
}
$args['legendpos'] = 'right';

include  __DIR__ . '../../addons/jalalidate_pro/src/reports/new_customers.php';

$reportdata["headertext"] = $chart->drawChart('Area', $chartdata, $args, '400px') .
    '<p align="center">' .
    '<a href="reports.php' . $requeststr . '&show=signups">ثبت نام های جدید
</a>'
    . ' | <a href="reports.php' . $requeststr . '&show=orders">سفارشات ثبت شده</a>'
    . ' | <a href="reports.php' . $requeststr . '&show=orderscompleted">سفارشات تکمیل شده</a>'
    . '</p>';

$reportdata["yearspagination"] = true;
