<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$reportdata["title"] = "فروش بر اساس محصول برای " . $months[(int) $month] . " " . $year;
$reportdata["description"] = "این گزارش به تفکیک تعداد واحدهای فروخته شده هر محصول در هر ماه می پردازد";

$reportdata["currencyselections"] = true;

$total = 0;
$prevgroup = '';

$datefilter = Carbon::create(
    $year,
    $month,
    1
);

$reportdata["tableheadings"] = ["نام محصول", "تعدادهای فروخته شده", "مقدار",];

$results = Capsule::table('tblproducts')
    ->select(
        'tblproducts.id',
        'tblproducts.name',
        'tblproductgroups.name as groupname'
    )
    ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
    ->orderBy('tblproductgroups.order', 'asc')
    ->orderBy('tblproducts.order', 'asc')
    ->orderBy('tblproducts.name', 'asc')
    ->get()
    ->all();

foreach ($results as $result) {
    $pid = $result->id;
    $group = $result->groupname;
    $prodname = $result->name;

    if ($group != $prevgroup) {
        $reportdata["tablevalues"][] = ["**<b>$group</b>",];
    }

    $data = Capsule::table('tblhosting')
        ->select(
            [
                Capsule::raw('COUNT(tblhosting.id) as total'),
                Capsule::raw('SUM(tblhosting.firstpaymentamount) as amount')
            ]
        )
        ->where('tblhosting.packageid', $pid)
        ->where('tblhosting.domainstatus', 'Active')
        ->whereBetween(
            'tblhosting.regdate',
            [
                $datefilter->startOfMonth()->toDateTimeString(),
                $datefilter->endOfMonth()->toDateTimeString()
            ]
        )
        ->where('tblclients.currency', $currencyid)
        ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
        ->first();
    $number = $data->total;
    $amount = $data->amount;

    $total += $amount;

    $amount = formatCurrency($amount);

    $reportdata["tablevalues"][] = [$prodname, $number, $amount,];

    $prevgroup = $group;
}

$reportdata["tablevalues"][] = ["**<b>افزونه ها</b>",];

$results = Capsule::table('tbladdons')
    ->orderBy('name', 'asc')
    ->get()
    ->all();

foreach ($results as $result) {
    $pid = $result->id;
    $prodname = $result->name;

    $data = Capsule::table('tblhostingaddons')
        ->select(
            [
                Capsule::raw('COUNT(tblhostingaddons.id) as total'),
                Capsule::raw('SUM(tblhostingaddons.setupfee + tblhostingaddons.recurring) as amount')
            ]
        )
        ->where('tblhostingaddons.addonid', $pid)
        ->where('tblhostingaddons.status', 'Active')
        ->whereBetween(
            'tblhostingaddons.regdate',
            [
                $datefilter->startOfMonth()->toDateTimeString(),
                $datefilter->endOfMonth()->toDateTimeString()
            ]
        )
        ->where('tblclients.currency', $currencyid)
        ->join('tblhosting', 'tblhosting.id', '=', 'tblhostingaddons.hostingid')
        ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
        ->first();
    $number = $data->total;
    $amount = $data->amount;

    $total += $amount;

    $amount = formatCurrency($amount);

    $reportdata["tablevalues"][] = [$prodname, $number, $amount,];

    $prevgroup = $group;
}

$total = formatCurrency($total);

include  __DIR__ . '../../addons/jalalidate_pro/src/reports/monthly_orders.php';

$reportdata["footertext"] = '<p align="center"><strong>جمع: ' . $total . '</strong></p>';

$reportdata["monthspagination"] = true;
