<?php

use WHMCS\Billing\Invoice;
use WHMCS\Database\Capsule;
use WHMCS\Payment\PayMethod\Adapter\BankAccount;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

if (!function_exists('getClientDefaultBankDetails')) {
    require ROOTDIR . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'clientfunctions.php';
}

$reportdata["title"] = "پردازش بدهی مستقیم";
$reportdata["description"] = "این گزارش تمام صورت‌حساب‌های پرداخت نشده اختصاص‌یافته به روش پرداخت مستقیم و جزئیات حساب بانکی مرتبط ذخیره شده برای صاحبان آن‌ها را آماده پردازش نشان می‌دهد.";

$reportdata["tableheadings"] = array("شناسه فاکتور","نام مشتری","تاریخ فاکتور","سررسید","جمع فرعی","مالیات","اعتبار","جمع","نام بانک","نوع حساب بانک","کد بانک","شماره حساب بانک");

$defaultBankDetailsPerUser = [];

$results = Capsule::table('tblinvoices')
    ->select('tblinvoices.*', 'tblclients.firstname', 'tblclients.lastname')
    ->join('tblclients', 'tblclients.id', '=', 'tblinvoices.userid')
    ->where('tblinvoices.paymentmethod', '=', 'directdebit')
    ->where('tblinvoices.status', '=', 'Unpaid')
    ->orderBy('duedate', 'asc')
    ->get()
    ->all();
foreach ($results as $result) {
    $id = $result->id;
    $userid = $result->userid;
    $client = $result->firstname . " " . $result->lastname;
    $date = $result->date;
    $duedate = $result->duedate;
    $subtotal = $result->subtotal;
    $credit = $result->credit;
    $tax = ($result->tax + $result->tax2);
    $total = $result->total;

    $invoice = Invoice::find($id);

    if ($invoice && $invoice->payMethod && $invoice->payMethod->payment->isBankAccount()) {
        /** @var BankAccount $payment */
        $payment = $invoice->payMethod->payment;

        $bankDetails["bankname"] = $payment->getBankName();
        $bankDetails["banktype"] = $payment->getAccountType();
        $bankDetails["bankcode"] = $payment->getRoutingNumber();
        $bankDetails["bankacct"] = $payment->getAccountNumber();
    } else {
        if (!isset($defaultBankDetailsPerUser[$userid])) {
            $defaultBankDetailsPerUser[$userid] = getClientDefaultBankDetails($userid);
        }

        $bankDetails = $defaultBankDetailsPerUser[$userid];
    }

    $bankname = $bankDetails["bankname"];
    $banktype = $bankDetails["banktype"];
    $bankcode = $bankDetails["bankcode"];
    $bankacct = $bankDetails["bankacct"];

    $currency = getCurrency($userid);
    $date = fromMySQLDate($date);
    $duedate = fromMySQLDate($duedate);
    $subtotal = formatCurrency($subtotal);
    $credit = formatCurrency($credit);
    $tax = formatCurrency($tax);
    $total = formatCurrency($total);

    $reportdata["tablevalues"][] = [
        '<a href="invoices.php?action=edit&id=' . $id . '">' . $id . '</a>',
        $client,
        $date,
        $duedate,
        $subtotal,
        $tax,
        $credit,
        $total,
        $bankname,
        $banktype,
        $bankcode,
        $bankacct,
    ];
}

$reportdata["footertext"] = 'بومی سازی شده توسط <a href="https://hosseinkhorsandi.ir" target="_blank">حسین خرسندی</a> برای شما هموطن عزیز';

