<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;
use WHMCS\User\Admin;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$range = App::getFromRequest('range');
$userId = (int) App::getFromRequest('userid');
$min = App::getFromRequest('min');
$max = App::getFromRequest('max');
$adminId = App::getFromRequest('adminid');

$reportdata["title"] = "بررسی کننده اعتبار";
$reportdata["description"] = "این گزارش به شما امکان می دهد تمام اعتبارات صادر شده برای مشتریان را بین 2 تاریخی که شما مشخص کرده اید بررسی کنید";

$activeAdminUserOptions = [];
foreach (Admin::where('disabled', 0)->get() as $user) {
    $activeAdminUserOptions[] = '<option value="' . $user->id . '"'
        . ($user->id == $adminId ? ' selected' : '') . '>' . $user->fullName . '</option>';
}
$disabledAdminUserOptions = [];
foreach (Admin::where('disabled', 1)->get() as $user) {
    $disabledAdminUserOptions[] = '<option value="' . $user->id . '"'
        . ($user->id == $adminId ? ' selected' : '') . '>' . $user->fullName . '</option>';
}
$adminUserOptions = '<option value="0">' . AdminLang::trans('global.-any-') . '</option>'
    . '<optgroup label="کاربران فعال">' . implode($activeAdminUserOptions);
if (count($disabledAdminUserOptions) > 0) {
    $adminUserOptions .= '<optgroup label="کاربران غیر فعال">' . implode($disabledAdminUserOptions);
}

$langRequired = AdminLang::trans('global.required');

$reportdata['headertext'] = '';
if (!$print) {
    $reportdata["headertext"] = <<<HTML
<form method="post" action="reports.php?report={$report}">
    <div class="report-filters-wrapper">
        <div class="inner-container">
            <h3>فیلترها</h3>
            <div class="row">
                <div class="col-md-3 col-sm-6">
                    <div class="form-group">
                        <label for="inputFilterClient">{$aInt->lang('fields', 'client')}</label>
                        {$aInt->clientsDropDown($userId)}
                    </div>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="form-group">
                        <label for="inputFilterDate">{$dateRangeText}</label>
                        <div class="form-group date-picker-prepend-icon">
                            <label for="inputFilterDate" class="field-icon">
                                <i class="fal fa-calendar-alt"></i>
                            </label>
                            <input id="inputFilterDate"
                                   type="text"
                                   name="range"
                                   value="{$range}"
                                   class="form-control date-picker-search date-picker-search-100pc"
                                   placeholder="{$langRequired}"
                            />
                        </div>
                    </div>
                </div>
                <div class="col-md-2 col-sm-3">
                    <div class="form-group">
                        <label for="inputFilterMin">حداقل میزان</label>
                        <input type="number" name="min" value="{$min}" class="form-control" id="inputFilterMin" step="any" placeholder = "هر">
                    </div>
                </div>
                <div class="col-md-2 col-sm-3">
                    <div class="form-group">
                        <label for="inputFilterMax">حداکثر میزان</label>
                        <input type="number" name="max" value="{$max}" class="form-control" id="inputFilterMax" step="any" placeholder = "هر">
                    </div>
                </div>
                <div class="col-md-2 col-sm-6">
                    <div class="form-group">
                        <label for="inputAdmin">کاربر مدیر</label>
                        <select name="adminid" class="form-control">
                            {$adminUserOptions}
                        </select>
                    </div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary">
                {$aInt->lang('reports', 'generateReport')}
            </button>
        </div>
    </div>
</form>
HTML;
}

$reportdata["tableheadings"] = array(
    "شناسه اعتبار",
    "شناسه مشتری",
    "نام مشتری",
    "تاریخ",
    "توضیحات",
    "میزان",
    "کاربر مدیر",
);

if ($range) {

    $dateRange = Carbon::parseDateRangeValue($range);
    $dateFrom = $dateRange['from']->toDateTimeString();
    $dateTo = $dateRange['to']->toDateTimeString();
    $query = Capsule::table('tblcredit')
        ->join('tblclients', 'tblclients.id', '=', 'tblcredit.clientid')
        ->whereBetween(
            'tblcredit.date',
            [
                $dateFrom,
                $dateTo,
            ]
        );
    if ($userId) {
        $query->where('clientid', $userId);
    }
    if ($min != '') {
        $query->where('amount', '>=', $min);
    }
    if ($max != '' && ($min == '' || ($max > $min))) {
        $query->where('amount', '<=', $max);
    }
    if ($adminId) {
        $query->where('admin_id', $adminId);
    }
    $result = $query
        ->orderBy('date')
        ->get(['tblcredit.*', 'tblclients.firstname', 'tblclients.lastname'])
        ->all();

    /** @var stdClass $data */
    foreach ($result as $data) {
        $id = $data->id;
        $userid = $data->clientid;
        $clientname = $data->firstname . " " . $data->lastname;
        $date = fromMySQLDate($data->date);
        $description = $data->description;
        $amount = $data->amount;
        $currency = getCurrency($userid);
        $amount = formatCurrency($amount);
        $adminName = '-';
        if ($data->admin_id) {
            $adminName = getAdminName($data->admin_id);
            if (!trim($adminName)) {
                $adminName = '-';
            }
        }
        $reportdata["tablevalues"][] = array(
            $id,
            '<a href="clientssummary.php?userid=' . $userid . '">' . $userid . '</a>',
            '<a href="clientssummary.php?userid=' . $userid . '">' . $clientname . '</a>',
            $date,
            nl2br($description),
            $amount,
            $adminName,
        );
    }
}

$reportdata["footertext"] = 'بومی سازی شده توسط <a href="https://hosseinkhorsandi.ir" target="_blank">حسین خرسندی</a> برای شما هموطن عزیز';
