<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$today = Carbon::today();

$reportdata["title"] = "بررسی همکاری در فروش";
$reportdata["description"] = "مروری بر همکاری در فروش  برای سال جاری";

$reportdata["tableheadings"] = [
    'شناسه همکاری در فروش',
    'نام همکاری در فروش',
    'بازدید کنندگان',
    'کمیسیون های معلق',
    'در دسترس برای برداشت',
    'مبلغ برداشت شده',
    'کل کمیسیون های پرداخت شده YTD',
];

$results = Capsule::table('tblaffiliates')
    ->select(
        'tblaffiliates.id',
        'tblaffiliates.clientid',
        'tblaffiliates.visitors',
        'tblaffiliates.balance',
        'tblaffiliates.withdrawn',
        'tblclients.firstname',
        'tblclients.lastname',
        'tblclients.companyname'
    )
    ->join('tblclients', 'tblclients.id', '=', 'tblaffiliates.clientid')
    ->orderBy('visitors', 'desc')
    ->get()
    ->all();
foreach ($results as $result) {
    $affid = $result->id;
    $clientid = $result->clientid;
    $visitors = $result->visitors;
    $balance = $result->balance;
    $withdrawn = $result->withdrawn;
    $firstname = $result->firstname;
    $lastname = $result->lastname;
    $companyname = $result->companyname;

    $name = $firstname . ' ' . $lastname;
    if ($companyname) {
        $name .= ' (' . $companyname . ')';
    }

    $pendingcommissionsamount = Capsule::table('tblaffiliatespending')
        ->join('tblaffiliatesaccounts', 'tblaffiliatesaccounts.id', '=', 'tblaffiliatespending.affaccid')
        ->join('tblhosting', 'tblhosting.id', '=', 'tblaffiliatesaccounts.relid')
        ->join('tblproducts', 'tblproducts.id', '=', 'tblhosting.packageid')
        ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
        ->where('affiliateid', '=', $affid)
        ->orderBy('clearingdate', 'desc')
        ->sum('tblaffiliatespending.amount');

    $ytdtotal = Capsule::table('tblaffiliateshistory')
        ->where('affiliateid', $affid)
        ->whereBetween(
            'date',
            [
                $today->startOfYear()->toDateTimeString(),
                $today->endOfYear()->toDateTimeString(),
            ]
        )
        ->sum('amount');

    $currency = getCurrency($clientid);
    $pendingcommissionsamount = formatCurrency($pendingcommissionsamount);
    $ytdtotal = formatCurrency($ytdtotal);

    $reportdata["tablevalues"][] = [
        '<a href="affiliates.php?action=edit&id=' . $affid . '">' . $affid . '</a>',
        $name,
        $visitors,
        $pendingcommissionsamount,
        $balance,
        $withdrawn,
        $ytdtotal,
    ];
}
