{include file="orderforms/standard_cart/common.tpl"}

<div id="order-standard_cart">
    <div class="row">
        <div class="cart-sidebar sidebar">
            {include file="orderforms/phoenix-orderform/sidebar-categories.tpl"}
        </div>
        <div class="cart-body">

          <div class="header-lined">
                <h1 class="font-size-36">
                    {if $productGroup.headline}
                        {$productGroup.headline}
                    {else}
                        {$productGroup.name}
                    {/if}
                </h1>
                {if $productGroup.tagline}
                    <p>{$productGroup.tagline}</p>
                {/if}
            </div>
            {if $errormessage} 
                <div class="alert alert-danger">
                    {$errormessage}
                </div>
            {elseif !$productGroup}
                <div class="alert alert-info">
                    {lang key='orderForm.selectCategory'}
                </div>
            {/if}

            


            	<div class="row">
                 {foreach $products as $key => $product}
                 <div class="col-md-4">
							<div class="col my-col ppl shat">
								<h2 class="mg-md text-lg-center sup h2-bloc-7-style text-center">
									{$product.name}
								</h2>
                                <div class="product-pricing" id="product{$product@iteration}-price">
                                <div class="text-center">
                                    {if $product.bid}
                                        {$LANG.bundledeal}<br />
                                        
                                        {if $product.displayprice}
                                            <span class="price">{$product.displayprice}</span>
                                        {/if}
                                    {else}
                                        {if $product.pricing.hasconfigoptions}
                                            {$LANG.startingfrom}
                                            <br />
                                        {/if}
                                        <span class="price">{$product.pricing.minprice.price}</span>
                                        <div class="bolllm">
						                  {if $product.pricing.minprice.cycle eq "monthly"}
										  		
                                                                
                                            {$LANG.orderpaymenttermmonthly}
                                        {elseif $product.pricing.minprice.cycle eq "quarterly"}
														
                      
                                            {$LANG.orderpaymenttermquarterly}
                                        {elseif $product.pricing.minprice.cycle eq "semiannually"}
													
                      
                                            {$LANG.orderpaymenttermsemiannually}
                                        {elseif $product.pricing.minprice.cycle eq "annually"}
												
                      
                                            {$LANG.orderpaymenttermannually}
                                        {elseif $product.pricing.minprice.cycle eq "biennially"}
												
                      
                                            {$LANG.orderpaymenttermbiennially}
                                        {elseif $product.pricing.minprice.cycle eq "triennially"}
												
                      
                                            {$LANG.orderpaymenttermtriennially}
                                        {/if}
										</div>
                                        <br>
                                        {if $product.pricing.minprice.setupFee}
                                            <small>{$product.pricing.minprice.setupFee->toPrefixed()} {$LANG.ordersetupfee}</small>
                                        {/if}
                                    {/if}
                                </div>
                                </div>
                                	<div class="product-desc">
                                    {if $product.featuresdesc}
									<div class="prod-desc-div" id="product{$product@iteration}-description">
                                        {$product.featuresdesc}
									</div>
                                    {/if}
								<ul class="list-unstyled list-bloc-7-padding-right">
                                  {foreach $product.features as $feature => $value}
									<li class="topli">
										<h5 class="mg-md text-lg-center h5-style text-center">
											 <span class="feature-value">{$value}</span>
                                                {$feature}
										</h5>
									</li>
							      {/foreach}
								</ul>
                                </div>
                                
								<div class="text-center">
									<a href="{$WEB_ROOT}/cart.php?a=add&{if $product.bid}bid={$product.bid}{else}pid={$product.pid}{/if}" class="btn btn-d btn-lg my-j kilo"><span class="icon-spacer ion ion-ios-arrow-back icon-sm float-lg-right none icon-white"></span>{$LANG.ordernowbutton}</a>
								</div>
							</div>
							</div>
						   {/foreach}
						</div>

           
        </div>
    </div>
</div>
