<?php
$hook = array(
    'hook' => 'loginbymobile',
    'function' => 'loginbymobile',
    'description' => array(
        'english' => 'Login By Mobile',
        'persian' => 'پیامک احراز هویت ورود با موبایل'
    ),
    'type' => 'client',
    'extra' => '',
    'defaultmessage' => 'کد تأیید شماره همراه شما: {otp}',
    'variables' => '{otp}'
);
// هنگامی که کاربر شماره همراه خود را وارد کند به صورت آجاکسی
if(isset($_POST['action']) && $_POST['action'] == 'loginByPhone'){
	$class = new IppanelSms();
	$settings = $class->getSettings();
	if($settings['enable_mobilelogin'] == '1'){
		$mobile = $class->util_gsmnumber($_POST['mobile']);
		$validate = $class->validate_mobile($mobile);
		if(!$validate['status']) {
			echo json_encode(['code' => 0 , 'message' => $validate['result'] , 'data' => []]);
			exit;
		}
		$time = time()- $settings['loginotpexpire'];
		$mobileHistory = $class->getMobileOTPByMobile($mobile , $time);
		if(count($mobileHistory) > 4) {
			echo json_encode(['code' => 0 , 'message' => 'شما در مدت  زمان کمی 5 بار تلاش کردید تا پیامک تایید دریافت کنید. ممکن است ارسال پیامک سایت مشکل داشته باشد. لطفا با پشتیبانی سایت تماس بگیرید.' , 'data' => []]);
			exit;
		}

		$client = $class->getClientDetailsByMobile($settings, $mobile);
		if(count($client) < 1){
			echo json_encode(['code' => 0 , 'message' => 'کاربری با این شماره همراه وجود ندارد.' , 'data' => []]);
		}elseif(count($client) > 1){
			echo json_encode(['code' => 0 , 'message' => 'بیش از یک کاربر با این شماره همراه ثبت نام شده اند. بنابراین امکان ورود با این شماره وجود ندارد. با پشتیبان سایت تماس بگیرید.' , 'data' => []]);
		}elseif((int)$client[0]['status'] != 2){
			echo json_encode(['code' => 0 , 'message' => 'شماره همراه شما قبلاً در حساب کاربری احراز هویت نشده است. لطفاً با ایمیل وارد شده و احراز هویت موبایل خود را انجام دهید یا با پشتیبان سایت تماس بگیرید.' , 'data' => []]);
		}else{
			$client_id = $client[0]['id'];
			$position = 'ارسال کد تأیید ورود';
			$otp = $class->randomString($settings['loginotplength'] , true);
			$request = $class->randomString(20);
		//'variables' => '{otp},{firstname},{lastname},{request},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}'
			$template = $class->getTemplateDetails('loginbymobile');
			$template['variables'] = str_replace(" ", "", $template['variables']);
			$replacefrom = explode(",", $template['variables']);
			$replaceto = array(
				$otp,		    
			);
			$message = str_replace($replacefrom, $replaceto, $template['template']);
			$message = $class->extraVars($message);
			$class->setGsmnumber($mobile);
			$class->setUserid($client_id);
			$class->setPosition($position);
			$class->setMessage($message);

			//Insert the OTP
			$values = array(
				"mobile" => $mobile,
				"otp" => $otp,
				"relid" => $client_id,
				"request" => $request,
				"status" => 0,
				"timestamp" => time(),
			);

			if($otp_id = insert_query('mod_ippanelsms_login_otp', $values)){
				$class->addLog("Login OTP saved to the database");		
				$sendResult = $class->send();
				if($sendResult == true) {
					echo json_encode(['code' => 1 , 'message' => 'یک کد تأیید به شماره '. $mobile. ' ارسال شد. لطفا کد تأیید را در کادر زیر وارد نموده و ارسال را کلیک نمایید.', 'data' => ['id'=>$request]]);
				} else {
					echo json_encode(['code' => 0 , 'message' => 'ارسال پیامک با شکست مواجه شد. لطفاً مجدداً بررسی کنید و در صورت ادامه یافتن مشکل با پشتیبان سایت تماس بگیرید.', 'data' => []]);
				}
			}else{
				echo json_encode(['code' => 0 , 'message' => 'مشکلی در ثبت و ارسال کد تایید بوجود آمد. لطفا بعدا تلاش کنید و در صورت ادامه مشکلی با پشتیبان سایت تماس بگیرید.', 'data' => []]);

			}
			
		}
	} else {
		echo json_encode(['code' => 0 , 'message' => 'ورود با موبایل فعال نیست.', 'data' => []]);
	}
	exit;
}elseif(isset($_POST['action']) && $_POST['action'] == 'loginByPhoneVerify'){

	$class = new IppanelSms();
	$settings = $class->getSettings();
	if($settings['enable_mobilelogin'] == '1'){
		$request = $_POST['otp_id'];
		$otp = $_POST['otp'];
		$requestedOtp = $class->getMobileOTPByRequest($request);
		$error = null;
		if(count($requestedOtp) !== 1){
			$error = "کد تأیید وارد شده قابل قبول نیست. لطفا با اعداد انگلیسی وارد نمایید. در صورت نیاز صفحه را رفرش کنید تا کد جدید دریافت نمایید.";
		}else{
			if($requestedOtp[0]['otp'] == $otp && $requestedOtp[0]['relid']){
				$delaytime = time()-$requestedOtp[0]['timestamp'];	
				if ($delaytime > $settings['loginotpexpire']) {
					$error = "کد تأیید شما منقضی شده است. لطفا صفحه را رفرش کنید ودوباره درخواست احراز هویت نمایید.";
				} else {
					$clientId = $requestedOtp[0]['relid'];
					$client = $class->getClientDetailsByClientId($settings, $clientId,false);
					$UserInformation = mysql_fetch_assoc($client);
					$_SESSION['ippanel_user_login'] = $clientId;
	                $_SESSION['captchaValue'] = md5(strtoupper($request));
					echo json_encode(['code' => 1 , 'message' => 'کد تأیید پذیرفته شد. منتظر باشید تا وارد ناحیه کاربری شوید.', 'data' => ['id'=>$request]]);
					exit;
				}
				
			} else {
				$error = "کد تأیید وارد شده قابل قبول نیست. لطفا با اعداد انگلیسی وارد نمایید. در صورت نیاز صفحه را رفرش کنید تا کد جدید دریافت نمایید.";
			}
		}
	} else {
		$error = "ورود به موبایل فعال نیست.";
	}
	if($error) {
		echo json_encode(['code' => 0 , 'message' => $error, 'data' => []]);
	}
	exit;
}

function ippanel_loginshare($vars) {
	if(isset($_SESSION['ippanel_user_login'])){
		
		$class = new IppanelSms();
		$settings = $class->getSettings();
		if($settings['enable_mobilelogin'] == '1') {
			$userId = $_SESSION['ippanel_user_login'];
			$otp = $class->getMobileOTPByUserID( $userId );
			$sql = "DELETE FROM mod_ippanelsms_login_otp WHERE `relid` = '{$userId}';";
			mysql_query($sql);
			if($otp['request'] == $vars['username']){
				unset($_SESSION['ippanel_user_login']);
				return array('id'=>$userId);
			}
		}
	}
     return false;
}

add_hook("ClientLoginShare",1,"ippanel_loginshare");


add_hook('ClientAreaFooterOutput', 1, function($vars) {
	$class = new IppanelSms();
	$settings = $class->getSettings();
	if($settings['enable_mobilelogin'] == '1' && $vars['loginpage'] == 1) {
		$return = '<!-- Trigger the modal with a button -->
					<!-- Modal -->
					<form method="post" action="" onSubmit="return loginByPhone(this);" role="form" name="loginByPhoneRequest" id="frmLoginByPhone">
						<input type="hidden" id="action" name="action" value="loginByPhone">
						<div id="phonelogin-modal" class="modal fade" role="dialog">
						  <div class="modal-dialog">
						
							<!-- Modal content-->
							<div class="modal-content">
							  <div class="modal-header">
								<button type="button" class="close" data-dismiss="modal">&times;</button>
								<h4 class="modal-title">ورود با شماره همراه</h4>
								<p>جهت ورود، شماره همراه ثبت شده در پروفایل خود را درج کرده و دکمه احراز هویت را بزنید.</br>
								در صورتی که قبلا شماره همراه خود را در پروفایل خود درج نکرده باشید امکان استفاده از این گزینه را ندارید.
								</p>
							  </div>
							  <div class="modal-body">
								<div class="form-group">
									<label for="mobile">شماره همراه:</label>
									<input type="text" name="mobile" class="form-control" id="mobile" autocomplete="off">
								</div>
							  </div>
							  <div class="modal-footer">
								<button type="submit" id="loginByPhonesubmit" class="btn btn-primary">احراز هویت</button>
								<button type="button" class="btn btn-default" data-dismiss="modal">بستن</button>
							  </div>
							</div>
						
						  </div>
						</div>
					</form>
					<script type="text/javascript">
						  $(document).ready(function(){
							  var activeForm = 1;
							  $("input#login").after(" <a id=\'loginbymobile\' class=\'btn btn-default\'>ورود با شماره همراه</a> ");
							  $("#loginbymobile").on("click",function(){
								$("#phonelogin-modal").modal("show");  
								$("input#mobile").focus();
							  });
							 
						  });
								  
						  function loginByPhone(elements) {
							  if($("#frmLoginByPhone").hasClass("disable")) return false;
							  $("#frmLoginByPhone").addClass("disable");
							  $("#frmLoginByPhone .modal-body .alert").remove();
							  if(elements.mobile.value == "") {
								  $("#frmLoginByPhone .modal-body").prepend("<div class=\'alert alert-danger\'>لطفاً شماره همراه خود را وارد نمایید.</div>");
								  elements.mobile.focus();
								  $("#frmLoginByPhone").removeClass("disable");
							  } else {
								  
								  $.ajax({
										  url: "clientarea.php",
										  type: "post",
										  data: $(elements).serialize(),
										  //async: false,
										  beforeSend: function () {
											  //Can we add anything here.
											  $("#frmLoginByPhone .modal-body .alert").remove();
										  },
										  cache: false,
										  dataType: "json",
										  crossDomain: false,
										  success: function (data) {
											  if (data.code == 0) {
												  $("#frmLoginByPhone .modal-body").prepend("<div class=\'alert alert-danger\'>"+data.message+"</div>");
											  } else {
												  $("#frmLoginByPhone .modal-body").prepend("<div class=\'alert alert-success\'>"+data.message+"</div>");
												  $("#frmLoginByPhone .modal-body").append("<div class=\'form-group\'><label for=\'otp\'>کد تأیید:</label><input type=\'text\' name=\'otp\' class=\'form-control\' id=\'otp\' autocomplete=\'off\'><input type=\'hidden\' id=\'otp_id\' name=\'otp_id\' value=\'"+data.data.id+"\' /></div>");
												  $("#frmLoginByPhone .modal-body #mobile").parent().remove();
												  $("#frmLoginByPhone #action").val("loginByPhoneVerify");
												  $("form#frmLoginByPhone").attr("onSubmit", "return loginByPhoneVerify(this);");
												  $("#loginByPhonesubmit").text("ثبت کد تأیید");
												  $("input#otp").focus();
											  }
											  $("#frmLoginByPhone").removeClass("disable");
										  },
										  error: function (data) {
											  console.log("Error:", data);
											  $("#frmLoginByPhone").removeClass("disable");
										  }
									  });
							  }
							  
							  return false;
						  }
						  function loginByPhoneVerify(elements) {
							  if($("#frmLoginByPhone").hasClass("disable")) return false;
							  $("#frmLoginByPhone").addClass("disable");
							  $("#frmLoginByPhone .modal-body .alert").remove();
							  if(elements.otp.value == "") {
								  $("#frmLoginByPhone .modal-body").prepend("<div class=\'alert alert-danger\'>لطفاً کد تأیید خود را وارد نمایید.</div>");
								  elements.otp.focus();
								  $("#frmLoginByPhone").removeClass("disable");
							  } else {
								  
								  $.ajax({
										  url: "clientarea.php",
										  type: "post",
										  data: $(elements).serialize(),
										  //async: false,
										  beforeSend: function () {
											  //Can we add anything here.
											  $("#frmLoginByPhone .modal-body .alert").remove();
										  },
										  cache: false,
										  dataType: "json",
										  crossDomain: false,
										  success: function (data) {
											  console.log(data);
											  if (data.code == 0) {
												  $("#frmLoginByPhone .modal-body").prepend("<div class=\'alert alert-danger\'>"+data.message+"</div>");
												  $("#frmLoginByPhone").removeClass("disable");
											  } else {
												  $("#frmLoginByPhone .modal-body").prepend("<div class=\'alert alert-success\'>"+data.message+"</div>");
												  $("form.login-form").css("visibility","hidden");
												  $("#inputEmail").prop({type:"text"}).val(data.data.id);
												  $("#inputPassword").val(data.data.id);
												  $("#inputCaptcha").val(data.data.id);
												  //$("form.login-form").submit();
												  $("form.login-form").find("#login").trigger("click");
												  
												  
											  }
											  
										  },
										  error: function (data) {
											  console.log("Error:", data);
											  $("#frmLoginByPhone").removeClass("disable");
										  }
									  });
							  }
							  
							  return false;
						  }
						  
					  </script>
					  ';
		return $return;
	}

});
return $hook;