<?php

namespace LMTech\ClientPassword\Config;

use WHMCS\Module\Addon\Setting as AddonSetting;

/**
 * WHMCS Client Password Changer
 *
 * Allows admins to change a users password manually without the need to send an email
 * to the client and reset it that way.
 *
 * @package    WHMCS
 * @author     Lee Mahoney <lee@leemahoney.dev>
 * @copyright  Copyright (c) Lee Mahoney 2022
 * @license    MIT License
 * @version    1.0.3
 * @link       https://leemahoney.dev
 */

if (!defined("WHMCS")) {
    exit("This file cannot be accessed directly");
}

class Config {

    public static function populate() {

        return [
            'name'          => 'تغییر رمز عبور مشتری',
            'description'   => 'به راحتی گذرواژه های مشتریان/کاربران خود را از داخل قسمت مدیریت تغییر دهید	',
            'version'       => '1.0.3',
            'author'        => '<a href="https://leemahoney.dev">Lee Mahoney<br>
            فارسی شده توسط آنیکو وب</a>',
            'fields'        => [
                'showButtons'           => [
                    'FriendlyName'      => 'نمایش دکمه ها در صفحه مدیریت کاربران',
                    'Type'              => 'yesno',
                    'Size'              => '25',
                    'Description'       => 'اینکه آیا یک دکمه "تغییر رمز عبور" را برای هر کاربر در صفحه های مدیریت کاربر نشان داده شود یا خیر',
                    'Default'           => 'yes',
                ],
                'enableLogging'         => [
                    'FriendlyName'      => 'فعال کردن گزارش گیری',
                    'Type'              => 'yesno',
                    'Size'              => '25',
                    'Description'       => 'Log that the password has been manually changed on owned client accounts',
                    'Default'           => 'yes',
                ],
                'showModal'             => [
                    'FriendlyName'      => 'نمایش ماژول',
                    'Type'              => 'yesno',
                    'Size'              => '25',
                    'Description'       => 'نمایش ماژول برای تغییر رمز عبور در صفحات مدیریت کاربر، در صورت غیرفعال بودن به ماژول هدایت می شوید',
                    'Default'           => 'yes',
                ],
                'passwordLength'        => [
                    'FriendlyName'      => 'طول رمز عبور ایجاد شده	',
                    'Type'              => 'text',
                    'Size'              => '25',
                    'Description'       => 'طول رمز عبور تولید شده توسط ایجاد کننده رمز عبور',
                    'Default'           => '12',
                ],
                'specialChars'          => [
                    'FriendlyName'      => 'اجازه دادن به کاراکترهای خاص',
                    'Type'              => 'yesno',
                    'Size'              => '25',
                    'Description'       => 'اجازه دادن به کاراکترهای خاص در رمز عبور ایجاد شده توسط تولید کننده رمز عبور',
                    'Default'           => 'yes',
                ],
                'numbers'               => [
                    'FriendlyName'      => 'اجازه دادن استفاده از  اعداد',
                    'Type'              => 'yesno',
                    'Size'              => '25',
                    'Description'       => 'اعداد در رمز عبور تولید شده توسط تولید کننده رمز عبور مجاز است',
                    'Default'           => 'yes',
                ],
                'capitalLetters'        => [
                    'FriendlyName'      => 'حروف بزرگ مجاز است',
                    'Type'              => 'yesno',
                    'Size'              => '25',
                    'Description'       => 'اجازه دادن به حروف بزرگ در رمز عبور ایجاد شده توسط تولید کننده رمز عبور',
                    'Default'           => 'yes',
                ],
                'paginationLimit'       => [
                    'FriendlyName'      => 'محدودیت رکورد صفحه بندی	',
                    'Type'              => 'text',
                    'Size'              => '25',
                    'Description'       => 'تعداد رکورد برای نمایش در هر صفحه در لیست کاربران در داشبورد',
                    'Default'           => '10',
                ],
                'paginationSortOrder'   => [
                    'FriendlyName'      => 'ترتیب مرتب سازی صفحه بندی',
                    'Type'              => 'dropdown',
                    'Options'           => 'ASC,DESC',
                    'Description'       => 'ترتیب مرتب سازی لیست کاربران در داشبورد',
                    'Default'           => 'DESC',
                ],
                'paginationSortField'   => [
                    'FriendlyName'      => 'فیلد مرتب سازی صفحه بندی',
                    'Type'              => 'dropdown',
                    'Options'           => 'id,first_name,last_name,email,last_login,created_at,updated_at',
                    'Description'       => 'یلدی که برای مرتب کردن لیست کاربران در داشبورد استفاده می شود',
                    'Default'           => 'created_at',
                ],
                'showUpdateMessage'     => [
                    'FriendlyName'      => 'نمایش پیام به روز رسانی	',
                    'Type'              => 'yesno',
                    'Size'              => '25',
                    'Description'       => 'زمانی که نسخه جدیدی از این اسکریپت در دسترس است، هشدار به‌روزرسانی نشان داده شود یا خیر
',
                    'Default'           => 'yes',
                ],
            ],
        ];

    }

    
    public static function get($setting) {
        return AddonSetting::where('module', 'clientpassword')->where('setting', $setting)->first()->value;
    }

    public static function checkForUpdate() {
        
        $latestVersion = file_get_contents("https://raw.githubusercontent.com/leemahoney3/whmcs-client-password-changer/main/version");

        return (self::get('showUpdateMessage') && $latestVersion != self::populate()['version']) ? true : false;

    }

}