<?php
//--- custom Search Form -------------------------------------
function custom_search_form($custom_search)
{

	$default = array(
		'cat_show' => false,
		'tag_show' => false,
		'author_show' => false,
		'archive_show' => false,
		'field_show' => true,
		'label_show' => false,
		'button_show' => true,
		'rememberd' => true,
		'echo' => false
	); //default array
	foreach ((array)$custom_search as $key => $value) {
		$default[$key] = $value;
	}
	//--base vars------------------------
	global $WP_Query, $query, $wp_user;
	$cat_option = '';
	$tag_option = '';
	$author_option = '';
	$archive_option = '';
	$advance_option = '';
	$close_option = '';
	$field_option = '';
	$button_option = '';
	$tag_selected = get_query_var('tag');
	$cat_selected = get_query_var('cat');
	$author_selected = get_query_var('author');
	$day_selected = get_query_var('day');
	$month_selected = get_query_var('monthnum');
	$year_selected = get_query_var('year');
	if ($day_selected == 0) $day_selected = '';
	if ($month_selected == 0) $month_selected = '';
	if ($year_selected == 0) $year_selected = '';

	//--------category--------------------
	if ($default['cat_show'] == 1) :
		$categories = get_categories();
		$cat_option = '<li class="col-6 cat-custom-search"><ul>';
		if ($default['label_show']) :
			$cat_option .= '<li class="cat-label">' . __('Category', 'denver') . '</li>';
		endif;
		$cat_option .= '<li class="search-cat selectdiv"><select name="cat" id="searchcat" ><option value="">' . __('All', 'denver') . '</option>';
		foreach ($categories as $category) {
			$cat_option .= '<option value="' . $category->cat_ID . '"';
			if (($cat_selected == $category->cat_ID) && ($default['rememberd'] == 1)) :
				$cat_option .= ' selected';
			endif;
			$cat_option .= '>' . $category->cat_name;
			$cat_option .= '</option>';
		}
		$cat_option .= '</select></li></ul></li>';
	endif;
	//--------tag--------------------
	if ($default['tag_show'] == 1) :
		$tags = get_categories('taxonomy=post_tag');
		$tag_option = '<li class="col-6 tag-custom-search"><ul>';
		if ($default['label_show']) :
			$tag_option .= '<li class="tag-label">' . __('tag', 'denver') . '</li>';
		endif;
		$tag_option .= '<li class="search-tag selectdiv" ><select name="tag" id="searchtag" ><option value="">' . __('All', 'denver') . '</option>';

		foreach ($tags as $tag) {
			$tag_option .= '<option value="' . $tag->slug . '"';
			if (($tag_selected == $tag->slug) && ($default['rememberd'] == 1)) :
				$tag_option .= ' selected';
			endif;
			$tag_option .= '>' . $tag->cat_name;
			$tag_option .= '</option>';
		}
		$tag_option .= '</select></li></ul></li>';
	endif;

	//--------author--------------------
	if ($default['author_show'] == 1) :
		$authors = get_users(array('who' => 'authors', 'fields' => array('id', 'display_name')));
		$author_option = '<li class="col-6 author-custom-search"><ul>';
		if ($default['label_show']) :
			$author_option .= '<li class="author-label">' . __('author', 'denver') . '</li>';
		endif;
		$author_option .= '<li class="search-author selectdiv" ><select name="tag" id="searchauthor" ><option value="">' . __('All', 'denver') . '</option>';

		foreach ($authors as $author) {
			$author_option .= '<option value="' . $author->id . '"';
			if (($author_selected == $author->id) && ($default['rememberd'] == 1)) :
				$author_option .= ' selected';
			endif;
			$author_option .= '>' . $author->display_name;
			$author_option .= '</option>';
		}
		$author_option .= '</select></li></ul></li>';
	endif;

	//--------Date--------------------
	if ($default['archive_show'] == 1) :
		$archive_option = '<li class="col-6 archive-custom-search"><ul>';
		if ($default['label_show']) :
			$archive_option .= '<li class="archive-label">' . __('Date', 'denver') . '</li>';
		endif;
		$archive_option .= '<li class="archive-field">
  		<input type="text" value="' . $year_selected . '" name="year" id="year" size="3" placeholder="' . __('year', 'denver') . '" />
  		<input type="text" value="' . $month_selected . '" name="monthnum" id="monthnum" size="2" placeholder="' . __('monthnum', 'denver') . '" />
  		<input type="text" value="' . $day_selected . '" name="day" id="day" size="1" placeholder="' . __('day', 'denver') . '" />
  </li></ul></li>';
	endif;

	//--------search field--------------------
	if ($default['field_show'] == 1) :
		$field_option = '<li class="search-custom-search"><ul>';
		if ($default['label_show']) :
			$field_option .= '';
		endif;
		$field_option .= '<li class="search-field"><input type="text" value="' . get_search_query() . '" name="s"  placeholder="' . __('The desired word + Enter', 'denver') . '" />
        <button type="submit" class="search-submit fal_fa-search" value="' . esc_attr__('search', 'denver') . '" ></button>
        </li>
  		</ul>
  	</li>';
	endif;

	//--------final form-------------------
	$form = '<form role="search" method="get" class="searchform" action="' . home_url('/') . '" ><ul>
    			' . $field_option . $cat_option . $tag_option . $author_option . $archive_option . '
    			</ul></form>';

	if ($default['echo'] == 1) :
		echo $form;
	else :
		return $form;
	endif;
}
add_filter('get_search_form', 'custom_search_form', 10, 1);
