<?php
require_once $GLOBALS["RootFiles"].'/database/DataBaseConnection.php';



class LIVESTREAM_STREAM_ADMIN {

    public static function GetList($token,$lsid)
    {
        $usersDetails=USERS_ADMIN::GetOneByToken($token);
        if($usersDetails["status"]=="error"){
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid=$usersDetails["userdetail"][0]["uid"];
        if(LIVE_STREAM_ADMIN::CheckDuplicatedName($uid,$lsid)["status"]=="error"){
            return ["status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"];
        }
        $sql ="SELECT ".$GLOBALS['lssid']." as StreamId,".$GLOBALS['lssname']." as StreamName,".$GLOBALS['lssframerate']." as FrameRate,".
        $GLOBALS['lssbitrate']." as BitRate,".$GLOBALS['lsshls']." as HLS,".$GLOBALS['lssdash']." as DASH ,".$GLOBALS['lssaccess']." Ips from ".$GLOBALS["livestream_stream_tablename"]. " WHERE ".$GLOBALS['lss_lsdid_fk']."=".$lsid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if(!$result || mysqli_num_rows($result) == 0) {
            $result =["status"=>"error","message"=>"شما استریم به این بخش اضافه نکرده اید "];
            return $result;
        }
        else{
            $listOfRecordType=["status"=>"success","data"=>mysqli_fetch_all ($result,MYSQLI_ASSOC)];
        }
        $result -> free_result();

        $conn -> close();
        return $listOfRecordType;
    }
    public static function GetOne($token,$lssid,$lsid)
    {
        $usersDetails=USERS_ADMIN::GetOneByToken($token);
        if($usersDetails["status"]=="error"){
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid=$usersDetails["userdetail"][0]["uid"];
        if(LIVE_STREAM_ADMIN::CheckDuplicatedName($uid,$lsid)["status"]=="error"){
            return ["status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"];
        }
        $sql ="SELECT * FROM ".$GLOBALS["livestream_stream_tablename"]. " WHERE ".$GLOBALS['lssid']."=".$lssid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if(!$result || mysqli_num_rows($result) == 0) {
            $result =["status"=>"error","message"=>"اطلاعات ارسالی شما نامعتبر است"];
            return $result;
        }
        else{
            $listOfRecordType=["status"=>"success","data"=>mysqli_fetch_all ($result,MYSQLI_ASSOC)];
        }
        $result -> free_result();

        $conn -> close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedName($name,$lsid){

        $sql ="SELECT * FROM ".$GLOBALS["livestream_stream_tablename"]." WHERE ".$GLOBALS['lssname']."='".$name."' AND ".$GLOBALS['lss_lsdid_fk']."=".$lsid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if(!$result || mysqli_num_rows($result) == 0) {
            $result =["status"=>"success"];
            return $result;
        }
        else{
            $listOfRecordType=["status"=>"error"];
        }
        $result -> free_result();

        $conn -> close();
        return $listOfRecordType;

    }
    public static function AddStream($token,$domainid,$lssname,$framerate,$hls,$dash,$hlsresolution,$dashresolution,$type,$ip,$record,$pushurl)
    {
        $usersDetails=USERS_ADMIN::GetOneByToken($token);
        if($usersDetails["status"]=="error"){
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid=$usersDetails["userdetail"][0]["uid"];
        $streamDomainDetails=LIVE_STREAM_ADMIN::UserCanAccessToStreamDomain($uid,$domainid);
        if($streamDomainDetails["status"]=="error"){
            return ["status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید",$streamDomainDetails];
        }

        $name=TOOLS_ADMIN::seo_friendly_url($lssname);
        if(LIVESTREAM_STREAM_ADMIN::CheckDuplicatedName($name,$domainid)["status"]=="error"){
            return ["status" => "error", "message" => "نام درخواستی شما تکراری است و قابل ثبت نیست لطفا نام دیگری انتخاب نمایید"];
        }
        if ( !in_array($framerate, range(24,30 )) ) {
            return ["status" => "error", "message" => "ّframe rate  ارسالی شما نامعتبر است شما میتوانید از رنج 24  تا 30 انتخاب نمایید"];
        }
        $hlsOrDashStatus=["true","false"];
        $resolution=["360","480","720","1080"];
        if(!in_array($hls,$hlsOrDashStatus)){
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس HLS اشتباه است"];
        }
        if(!in_array($dash,$hlsOrDashStatus)){
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس DASH اشتباه است"];
        }
        $hlsRes=[];
        if($hls=="true"){
            $hlsRes=explode(",",$hlsresolution);
            if(count($hlsRes)==0){
                return ["status" => "error", "message" => "ّشما مقداری برای Resolution HLS ارسال نکرده اید"];
            }else{
                foreach($hlsRes as $m){
                    if(!in_array($m,$resolution)){
                        return ["status" => "error", "message" => "ّمقدار ارسالی برای Resolution HLS اشتباه است ","HLS-Resolution"=>$m];
                    }
                }
            }
        }
        else{
            $hlsresolution="";
        }
        $dashRes=[];

        if($dash=="true"){
            $dashRes=explode(",",$dashresolution);
            if(count($dashRes)==0){
                return ["status" => "error", "message" => "ّشما مقداری برای Resolution DASH ارسال نکرده اید"];
            }
            else{
                foreach($dashRes as $m){
                    if(!in_array($m,$resolution)){
                        return ["status" => "error", "message" => "ّمقدار ارسالی برای Resolution DASH اشتباه است ","DASH-Resolution"=>$m];

                    }
                }
            }
        }
        else{
            $dashresolution="";
        }
        if(!in_array($record,$hlsOrDashStatus)){
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس Record اشتباه است"];
        }

        $streamType=["pull","push"];
        if(!in_array($type,$streamType)){
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس Type اشتباه است"];
        }
        if($type=="pull"){
            $pushurl="";
        }
        if($type=="push"){
            if(!filter_var($pushurl, FILTER_VALIDATE_URL)){
                return ["status" => "error", "message" => "لینک ارسالی Push  شما اشتباه است"];
            }
            else{
                if(substr($pushurl,-5)!=".m3u8"){
                    return ["status" => "error", "message" => "لینک ارسالی Push  شما اشتباه است"];
                }
            }
        }
        $bitrateRes=["360"=>"350","480"=>"800","720"=>"1200","1080"=>"1900"];
        $countOfHlsResolution=count($hlsRes);
        $countOfDashResolution=count($dashRes);

        $bitrate=[];
        if($countOfDashResolution > $countOfHlsResolution){
            foreach($dashRes as $l){
                array_push($bitrate,$bitrateRes[$l]);
            }
        }
        else{
            foreach($hlsRes as $l){
                array_push($bitrate,$bitrateRes[$l]);
            }
        }

        $outbitrate=implode(",",$bitrate);
        if($ip!=""){
            $ips = explode(",", $ip);

                        $res = [];
                        $stat = 1;
                        $success_array = [];
                        foreach ($ips as $ip) {
                            if (strpos($ip, '/')) {
                                $nip = explode("/", $ip);
                                if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                                    $stat = 0;
                                    $out["status"] = "error";
                                    array_push(
                                        $res,
                                        ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                                    );
                                } else {

                                    array_push($success_array, ["ip" => $ip]);

                                    array_push($res, [
                                        "status" => "success", "ip" => $ip,
                                        "message" => "درخواست شما با موفقیت انجام شد"
                                    ]);
                                }
                            } else {
                                if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                                    $stat = 0;
                                    $out["status"] = "error";
                                    array_push(
                                        $res,
                                        ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                                    );
                                } else {

                                    array_push($success_array, ["ip" => $ip]);

                                    array_push($res, [
                                        "status" => "success", "ip" => $ip,
                                        "message" => "درخواست شما با موفقیت انجام شد"
                                    ]);
                                }
                            }
                        }

                        if($stat==0){
                            return ["status" => "error", "message" => "خطا در IP های ارسالی","IP"=>$out];
                        }
        }
        $streamkey=USERS_ADMIN::GenerateHash(24);
        $sqlins="INSERT INTO ".$GLOBALS["livestream_stream_tablename"]."(".$GLOBALS['lssname'].",".$GLOBALS['lssframerate'].",".$GLOBALS['lssbitrate'].","
                                                                          .$GLOBALS['lsshls'].",".$GLOBALS['lssdash'].",".$GLOBALS['lssaccess'].","
                                                                          .$GLOBALS['record'].",".$GLOBALS['lsstype'].",".$GLOBALS['lsspushurl'].","
                                                                          .$GLOBALS['lssstreamkey'].",".$GLOBALS['lss_lsdid_fk'].") VALUES ('".
                                                                           $name."','".$framerate."','".$outbitrate."','".$hls."','".$dash."','".$ip."','".$record."','".$type."','".$pushurl."','"
                                                                          .$streamkey."','".$domainid."')";
        $conn = GetConnection();

        $outputArray=["domain"=>$streamDomainDetails["data"][0]["lsdname"].".".$GLOBALS["liveStreamMainDomain"],
                    "framerate"=>$framerate,
                    "bitrate"=>["value"=>$outbitrate],
                    "hls"=>["resolution"=>$hlsresolution],
                    "dash"=>["resolution"=>$dashresolution],
                    "access"=>$ip,
                    "record"=>$record,
                    "streamkey"=>$streamkey,
                    "streamtype"=>["type"=>$type,
                                   "pushurl"=>$pushurl],
                    "folder"=>$name];
         if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType=["status"=>"success","message"=>"اطلاعات با موفقیت ثبت شد"];
        }
        else{
             $listOfRecordType =["status"=>"error","message"=>"اطلاعات ارسالی نامعتبر است"];
        }

        $conn -> close();
        return $listOfRecordType;
    }
    public static function RemoveStream($token,$streamdomainid,$streamid)
    {
        $usersDetails=USERS_ADMIN::GetOneByToken($token);
        if($usersDetails["status"]=="error"){
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid=$usersDetails["userdetail"][0]["uid"];
        $CanAccessToStreamDomain=LIVE_STREAM_ADMIN::UserCanAccessToStreamDomain($uid,$streamdomainid);

        if($CanAccessToStreamDomain["status"]=="success"){
            $sql="DELETE FROM ".$GLOBALS["livestream_stream_tablename"]." WHERE ".$GLOBALS["lss_lsdid_fk"]."=".$streamdomainid." AND ".$GLOBALS["lssid"]."=".$streamid;
            $conn = GetConnection();
            if($conn->query($sql)==TRUE){
                return ["status"=>"success","message"=>"درخواست شما انجام شد "];
            }
            else{
                return ["status" => "error", "message" => "شما امکان انجام این درخواست را ندارید"];
            }
        }
        return ["status" => "error", "message" => "شما امکان انجام این درخواست را ندارید"];
    }
}
