<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once '../../include/vars.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';

$domain = $_POST["domain"];
$_POST["wid"]=$_POST["websiteid"];
$_POST["did"]=$_POST["domainid"];
$validtimerange = ["3h" => "3", "6h" => "6", "12h" => "12", "1d" => "24", "1w" => "7d", "1m" => "30d"];
if (!isset($validtimerange[$_POST["timerange"]])) {
    echo json_encode([ "status" => "error", $dtse, "message" => "زمان درخواستی شما نامعتبر است" ]);
    return;
}

if (MAINRESTRICTION_ADMIN::CheckPlan($_POST["token"], $_POST["wid"])["status"] == "error") {
    echo json_encode(["status" => "error", "plans" => MAINRESTRICTION_ADMIN::CheckPlan($_POST["token"], $_POST["wid"])["plans"], "message" => "شما امکان دسترسی به این بخش ندارید"]);
    return;
}


// $_POST["domain"]="file.pmlm.ir";
$domain = $_POST["domain"];

if ($_POST["website"] != $domain) {
    $domain = $_POST["website"] . "." . $_POST["domain"];
}

if (!file_exists("ipvisitorss/" . $domain))
    mkdir("ipvisitorss/" . $domain);

$fp = "ipvisitorss/" . $domain . "/" . $validtimerange[$_POST["timerange"]] . ".report";

if (file_exists($fp)) {
    $response = file_get_contents($fp);

    $now = date("Y/m/d H:i:s");
    $rep = json_decode($response, true);
    $expire = $rep["expire"];
    if ($now > $expire) {
        $rep = API_REPORT_ADMIN::RunNewIPVisitor($domain, $validtimerange[$_POST["timerange"]], "ipvisitorss");
        //   $rep = json_decode($response, true);

        $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

        $dtss = ["expire" => $expire, "data" => $rep];
        $dmns = json_encode($dtss);
        $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
        fwrite($myfile, $dmns);
        fclose($myfile);
    } else {
        $rep = $rep["data"];
    }
} else {
    $rep = API_REPORT_ADMIN::RunNewIPVisitor($domain, $validtimerange[$_POST["timerange"]], "ipvisitorss");
    //   $rep = json_decode($response, true);

    $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

    $dtss = ["expire" => $expire, "data" => $rep];
    $dmns = json_encode($dtss);
    $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
    fwrite($myfile, $dmns);
    fclose($myfile);
}

$s = IPBLACKLIST_ADMIN::GetOneByWebsiteID($_POST["token"], $_POST["websiteid"]);

if ($s["code"] != "201") {
    foreach ($s["data"] as $n) {
        unset($rep[$n["ip"]]);
    }
}
$defaultTime = [];
foreach ($rep as $r => $ms) {
    array_push($defaultTime, $r);
    $defaultTime = $r;
    break;
}
arsort($rep);

$keys = array_keys($rep);
$arraySize = count($rep);
$o = "";
$allCountry = [];
if (!isset($_POST["page"])) {
    $_POST["page"] = 1;
}
if (!isset($_POST["countofrecord"])) {
    $_POST["countofrecord"] = 15;
}

$_POST["countofpage"] = intdiv(count($rep), $_POST["countofrecord"]);
$o = substr($o, 0, strlen($o) - 1);
$out = [];
$start = ($_POST["page"] - 1) * $_POST["countofrecord"];
$end = $start + $_POST["countofrecord"];
for ($i = $start; $i < $end; $i++) {
    $out[$keys[$i]] =   $rep[$keys[$i]];
}

$ouput = [
    "status" => "success",
    "currentpage" => $_POST["page"],
    "countofpage" => $_POST["countofpage"],
    "countofrecord" => $_POST["countofrecord"],
    "data" => $out,
];
echo json_encode($ouput);
