<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class FINANCIAL_INVOICEBYHOUR_ADMIN
{
	public static function GetInvoicesForDay($start, $end, $category = "cloud")
	{
		$start = str_replace("/", "-", $start);
		$end = str_replace("/", "-", $end);

		$sql = "SELECT * FROM " . $GLOBALS['tbl_financial_invoice_byhour'] . " WHERE "
			.   $GLOBALS['istarttime'] . " >='" . $start . "' AND "
			.   $GLOBALS['iendtime'] . " <= '" . $end . "' and i_uid_fk=525
                 order by " . $GLOBALS['i_uid_fk'] . " desc , " . $GLOBALS['istarttime'] . " asc";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return [
				"status" => "error",
				"message" => "اطلاعات با موفقیت دریافت شد"
			];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			foreach ($listOfRecordType as $l) {
				$m = FINANCIAL_INVOICETREEHOUR_ADMIN::GetPriceListWithByCategory(1);
			}
			$conn->close();
			return [
				"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",$sql,
				$sql, "data" => $listOfRecordType
			];
		}
	}

	public static function GetListByInvoiceByUser($token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoice_byhour"] . " WHERE " . $GLOBALS['i_uid_fk'] . "=" . $uid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
	}
	public static function GetPriceListWithByCategory($catname)
	{
		$sql = "SELECT * FROM " . $GLOBALS["tbl_details_price"] . " WHERE " . $GLOBALS["dp_category"] . " ='" . $catname . "'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
	}
	public static function GetInvoiceDetails($uid, $start)
	{
		$sql = "SELECT * FROM " . $GLOBALS['tbl_financial_invoice_byhour'] . " WHERE " . $GLOBALS['i_uid_fk'] . "='" . $uid . "' AND " .
			$GLOBALS['istarttime'] . "='" . $start . "'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد"];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$conn->close();
			return ["status" => "error", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
		}
	}
	public static function UpdateInvoice($uid, $start, $end)
	{
		$starttime = jDateTime::date("Y/m/d H:00:00");
		$end = jDateTime::date("Y/m/d H:00:00", time() + 3600);
		$r = self::GetInvoiceDetails($uid, $starttime);
		$id = 0;
		if ($r["status"] == "success") {
			$sql = "INSERT INTO " . $GLOBALS['tbl_financial_invoice_byhour'] . " VALUES(0,0,0,0,0,0,'" . $start . "','" . $end . "','" . $uid . "')";
			$conn = GetConnection();
			$conn->query($sql);
			$id  =  $conn->insert_id;
			$conn->close();
		} else {
			$id = $r["data"][0]["iid"];
		}
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $id];
	}
	public static function UpdatePrice($cat, $price = 0, $invoiceid)
	{

		$sql = "UPDATE " . $GLOBALS['tbl_financial_invoice_byhour'] . " SET " . $GLOBALS["i" . $cat]
			. "=(
            select sum(`fitprice`) from  tbl_financial_invoicetreebyhour
            where `fit_ifield`='" . $cat . "' and fit_iid_fk=" . $invoiceid . " )
            where iid =" . $invoiceid;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		return $sql;
	}
	public static function RunJobForCalculateAndGenerateInvoiceForCloudServer()
	{
		$l = CLOUD_SERVER_ADMIN::GetListOfActiveServer();
		$starttime =   jDateTime::date("Y/m/d H:00:00");
		$end =  jDateTime::date("Y/m/d H:00:00", time() + 3600);
		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
		$prc = [];
		foreach ($pricelist["data"] as $pr) {
			$prc[$pr["dp_category"]] = $pr["dp_price"];
		}

		$usercalculated = [];
		foreach ($l["data"] as $a) {

			$uid = $a["uid"];


			$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

			$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
				$invoiceid,
				"سرور ابری IP :" . $a["ServerIP"],
				"cloud",
				$a["ServerID"],
				$a["ServerIP"],
				$starttime,
				$end
			)["id"];
			$ram = $a["ServerRam"];
			$usercalculated["ram"] = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				"مصرف " . $ram . "GB رم",
				$a["ramprice"],
				"RAM",
				$ram,
				$a["ServerID"]
			);

			$cpu = $a["ServerVCPU"];
			$usercalculated["cpu"] = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				"مصرف " . $cpu . "هسته پردازنده",
				$a["cpuprice"],
				"CPU",
				$cpu,
				$a["ServerID"]
			);
			$hard = $a["ServerHard"];
			if (count($a["Volumes"]["data"]) > 0) {
				foreach ($a["Volumes"]["data"] as $c) {
					$usercalculated["hard"] = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
						$invoicetreeid,
						"مصرف " . $c["cv_space"] . "GB فضای ذخیره سازی (" . $c["cv_type"] ." - ".$c["cv_mountpoint"] . ")",
						$c["price"],
						"hard",
						$c["cv_space"],
						$a["ServerID"]
					);
				}
			}
			FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				"مصرف 1 عدد IP اختصاصی : " . $a["ServerIP"],
				$prc["ip"],
				"ip",
				"1",
				$a["ServerID"]
			);

			if ($a["AdditionalIP"] != "NoAdditionalIP") {
				foreach ($a["AdditionalIP"]["data"] as $b) {
					if ($b["IsPublicIP"] == "PublicIP") {
						FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
							$invoicetreeid,
							"مصرف 1 عدد IP اختصاصی : " . $b["AdditionalIP"],
							$prc["additionalip"],
							"additionalip",
							"1",
							$a["ServerID"]
						);
					}
				}
			}
			$snapshots = CLOUD_SERVER_ADMIN::GetListOfSnapShotsWitoutUser($a["ServerID"]);
			if (empty($snapshots["data"]) || !isset($snapshots['data'])) {
			} else {
				foreach ($snapshots["data"] as $sn) {
					if ($sn["cv_type"] != "ssd" && $sn["cv_type"] != "sas"  && $sn["cv_type"] != "nvme") {
						$sn["cv_type"] = "ssd";
					}
					// FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
					// 	$invoicetreeid,
					// 	"مصرف " . $sn["cv_space"] . "GB فضای نگهداری Snapshot: " . $sn["cv_name"],
					// 	$sn["cv_space"] * $prc[$sn["cv_type"]],
					// 	"snapshot",
					// 	$sn["cv_space"],
					// 	$a["ServerID"]
					// );
					// if($uid=="1"){
					//     return [
					//         "space"=>$sn["cv_space"],
					//         "sn"=>$sn,
					//         "prc"=>$prc,
					//         "price"=>$sn["cv_space"] * $prc["snapshot"],
					//         "detail"=>"snapshot",
					//         "sp"=>$sn["cv_space"],
					//         "serverid"=>$a["ServerID"]
					//     ];
					// }
				}
			}
			// if (!in_array($uid, $usercalculated)) {
			//     $Volumes = CLOUD_VOLUME_ADMIN::GetListWithoutToken($uid);
			//     if (empty($Volumes["data"]) || !isset($Volumes['data'])) {
			//         array_push($usercalculated, $uid);
			//     } else {
			//         foreach ($Volumes["data"] as $sn) {
			//             FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
			//                 $invoicetreeid,
			//                 "مصرف " . $sn["VolumeSpace"] . "GB فضای نگهداری Volume: " . $sn["VolumeName"] . " - " . $sn["sid"],
			//                 $sn["VolumeSpace"] * $prc["hard"],
			//                 "Volume",
			//                 $sn["VolumeSpace"],
			//                 $a["ServerID"]
			//             );
			//         }
			//     }
			// }

			$finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
			$fp = intVal($finalprice) * 0.09;
			$ffp = $fp + $finalprice;
			CREADITDETAILS_ADMIN::AddCreditDetails("سرور ابری IP :" . $a["ServerIP"] . "(" . $starttime . "-" . $end . ")", $ffp * (-1), $uid, 9);
			// if ($uid == "1") {
			//     return [
			//         "space" => $sn["cv_space"],
			//         "sn" => $sn,
			//         "prc" => $prc,
			//         "price" => $sn["cv_space"] * $prc["snapshot"],
			//         "detail" => "snapshot",
			//         "sp" => $sn["cv_space"],
			//         "serverid" => $a["ServerID"]
			//     ];
			// }
			self::UpdatePrice("cloud", $ffp, $invoiceid);
		}

		$UnMountedVolumeAndSnapshotList = CLOUD_VOLUME_ADMIN::ReturnUnattatchedVoluemAndSnapShots();
		foreach ($UnMountedVolumeAndSnapshotList["snapshots"] as $sn => $pn) {
			$uid = $sn;


			$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

			$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
				$invoiceid,
				"نگهداری اسنپ شات",
				"cloud",
				0,
				"snapshots",
				$starttime,
				$end
			)["id"];

			$vlsn = CLOUD_VOLUME_ADMIN::ReturnUnattatchedVoluemAndSnapShots();
			// foreach ($vlsn["snapshots"] as $vl => $sn) {
			$fprice = 0;
			foreach ($pn as $s) {
				FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
					$invoicetreeid,
					"مصرف اسنپ شات " . explode("---", $s["cv_name"])[0] . "(" . $s["cv_type"] . ")",
					$s["price"],
					"storage",
					$s["cv_space"],
					0
				);
				$fprice = $fprice + intVal($s["price"]);
			}
			FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
			$fp = intVal($fprice) * 0.09;
			$ffp = $fp + $fprice;
			CREADITDETAILS_ADMIN::AddCreditDetails("مصرف snapshot :" . "(" . $starttime . "-" . $end . ")", $ffp * (-1), $uid, 9);
			self::UpdatePrice("cloud", $ffp, $invoiceid);
		}
		foreach ($UnMountedVolumeAndSnapshotList["volumes"] as $sn => $pn) {
			$uid = $sn;
			$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

			$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
				$invoiceid,
				"نگهداری Volume",
				"cloud",
				0,
				"volume",
				$starttime,
				$end
			)["id"];
			$fprice = 0;
			foreach ($pn as $s) {
				FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
					$invoicetreeid,
					"نگهداری Volume " . explode("---", $s["cv_name"])[0] . "(" . $s["cv_type"] . ")",
					$s["price"],
					"storage",
					$s["cv_space"],
					0
				);
				$fprice = $fprice + intVal($s["price"]);
			}

			$fp = intVal($fprice) * 0.09;
			$ffp = $fp + $fprice;
			FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);

			CREADITDETAILS_ADMIN::AddCreditDetails(
				"نگهداری Volume :" . "(" . $starttime . "-" . $end . ")",
				$ffp * (-1),
				$uid,
				9
			);
			self::UpdatePrice("cloud", $ffp, $invoiceid);
		}
		// self::UpdatePrice("cloud", $finalprice, $invoiceid);
		return INVOICE_LOG_ADMIN::UpdateLastTimeLog("CloudInvoiceHourly", $end);
	}
	public static function RunJobForCalculateAndGenerateInvoiceForLiveStream()
	{
		$l = LIVE_STREAM_ADMIN::GetListOfActiveLive();

		$starttime =   jDateTime::date("Y/m/d H:00:00");
		$end =  jDateTime::date("Y/m/d H:00:00", time() + 3600);

		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("LiveStream");
		$prc = [];
		foreach ($pricelist["data"] as $pr) {
			$prc[$pr["dp_category"]] = $pr["dp_price"];
		}

		foreach ($l["data"] as $a) {

			// $nowArr=explode(" ",$starttime);
			// $nwarr=explode(":",$a["lss_creationdate"]);
			// $m=60-$nwarr[1];
			// $s=60-$nwarr[2];

			//return [$a["lss_creationdate"],sprintf("%02d", $m).":".sprintf("%02d", $s)];

			$uid = $a["lsd_uid_fk"];
			$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

			$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
				$invoiceid,
				"سرویس پخش زنده :" . $a["lssname"],
				"live",
				$a["lssid"],
				$a["lssname"],
				$starttime,
				$end
			)["id"];

			FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				"میزان 1 ساعت سرویس پحش بنده فعال ",
				$prc["ActiveStream"],
				"ActiveStream",
				1,
				$a["lssid"]
			);

			$TotalRequest = 2000; // $a["LiveTotalRequest"];
			FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				" تعداد  " . $TotalRequest . " درخواست سرویس پخش زنده",
				$TotalRequest * $prc["LiveTotalRequest"],
				"LiveTotalRequest",
				$TotalRequest,
				$a["lssid"]
			);

			$LiveTotalTraffic = 1000; //$a["LiveTotalTraffic"];
			FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				"میزان  " . $LiveTotalTraffic . "بایت ترافیک مصرفی سرویس پخش بنده",
				$LiveTotalTraffic * $prc["LiveTotalTraffic"],
				"LiveTotalTraffic",
				$LiveTotalTraffic,
				$a["lssid"]
			);

			$s[$invoicetreeid] = $finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
			// CREADITDETAILS_ADMIN::AddCreditDetails("سرور ابری IP :" . $a["ServerIP"]."(".$starttime."-".$end .")",$finalprice*(-1),$uid ,9);
			self::UpdatePrice("live", $finalprice, $invoiceid);
		}
		return INVOICE_LOG_ADMIN::UpdateLastTimeLog("LiveStreamInvoiceHourly", $end);
	}
	public static function RunJobForCalculateAndGenerateInvoiceForCDN()
	{
		$l = DOMAINS_ADMIN::ADMIN_ReturnAllDomains();

		$l["data"] = $l;
		$starttime =   jDateTime::date("Y/m/d H:00:00");
		$end =  jDateTime::date("Y/m/d H:00:00", time() + 3600);
		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CDN");
		$prc = [];
		foreach ($pricelist["data"] as $pr) {
			$prc[$pr["dp_category"]] = $pr["dp_price"];
		}

		foreach ($l["data"] as $a) {
			$uid = $a["d_user_id_fk"];
			$plan = $a["d_plan"];
			if ($plan != "free") {
				$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

				$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
					$invoiceid,
					"مصرف CDN دامنه  :" . $a["d_name"],
					"cdn",
					$a["domain_id"],
					$a["d_name"],
					$starttime,
					$end
				)["id"];

				$prcf = intVal($prc[$plan]) * 0.09;
				$pff = intVal($prc[$plan]) + $prcf;
				FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
					$invoicetreeid,
					"مصرف CDN دامنه : " . $a["d_name"],
					$pff,
					$plan,
					1,
					$a["domain_id"]
				);

				$finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
				CREADITDETAILS_ADMIN::AddCreditDetails(
					"مصرف CDN دامنه : " . $a["d_name"] . "(" . $starttime . "-" . $end . ")",
					$pff * (-1),
					$uid,
					1
				);
				self::UpdatePrice("cdn", $finalprice, $invoiceid);
			}
		}
		return INVOICE_LOG_ADMIN::UpdateLastTimeLog("CDNInvoiceHourly", $end);
	}
}
