<?php


require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';


class CLOUD_VOLUME_ADMIN
{
    public static function ReturnUnattatchedVoluemAndSnapShots()
    {
        $snapshots = self::GetAllSnapshot();
        $volumes = self::GetAllUnattachedVolume();
        $output = [];
        $output["snapshots"] = [];
        $output["volumes"] = [];

        foreach ($snapshots as $sn) {
            $output["snapshots"][$sn["uid"]][] = $sn;
        }
        foreach ($volumes as $sn) {
            $output["volumes"][$sn["uid"]][] = $sn;
        }
        return $output;
    }
    public static function GetAllUnattachedVolume()
    {
        $sql = "SELECT * FROM tbl_cloud_volume,tbl_users
		 where cv_uid_fk=uid and cv_is_snapshot=0
		  and cv_csid_fk=0
		  order by cv_uid_fk";

		//  $sql="SELECT * FROM tbl_cloud_volume,tbl_users WHERE cv_uid_fk=uid and cv_is_snapshot=0 and `cv_csid_fk` NOT IN ( SELECT csid FROM tbl_cloud_server)  order by cv_uid_fk; ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
        $i = 0;
        $ssdprice = 0;
        $nvmeprice = 0;
        $sasprice = 0;
        foreach ($pricelist["data"] as $ls) {
            if ($ls["dp_category"] == "ssd") {
                $ssdprice = intVal($ls["dp_price"]);
            }
            if ($ls["dp_category"] == "sas") {
                $sasprice = intVal($ls["dp_price"]);
            }
            if ($ls["dp_category"] == "nvme") {
                $nvmeprice = intVal($ls["dp_price"]);
            }
        }
        foreach ($listOfRecordType as $l) {
            switch ($l["cv_type"]) {
                case "ssd":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $ssdprice;
                    break;
                case "nvme":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $nvmeprice;
                    break;
                case "sas":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $sasprice;
                    break;
            }
            $i++;
        }
        return $listOfRecordType;
    }
    public static function GetAllSnapshot()
    {
        $sql = "SELECT * FROM tbl_cloud_volume,tbl_users where cv_uid_fk=uid and cv_is_snapshot=1 order by cv_uid_fk";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
        $i = 0;
        $ssdprice = 0;
        $nvmeprice = 0;
        $sasprice = 0;
        foreach ($pricelist["data"] as $ls) {
            if ($ls["dp_category"] == "ssd") {
                $ssdprice = intVal($ls["dp_price"]);
            }
            if ($ls["dp_category"] == "sas") {
                $sasprice = intVal($ls["dp_price"]);
            }
            if ($ls["dp_category"] == "nvme") {
                $nvmeprice = intVal($ls["dp_price"]);
            }
        }
        foreach ($listOfRecordType as $l) {
            switch ($l["cv_type"]) {
                case "ssd":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $ssdprice;
                    break;
                case "nvme":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $nvmeprice;
                    break;
                case "sas":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $sasprice;
                    break;
                default:
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $ssdprice;
            }
            $i++;
        }

        return $listOfRecordType;
    }
    public static function DeleteVolumeByServer($serverid)
    {
        $sql = "DELETE  FROM " . $GLOBALS["cloud_volume_tablename"]
            . " WHERE " . $GLOBALS['cv_csid_fk'] . "=" . $serverid . " AND " . $GLOBALS['cv_is_snapshot'] . "=0";
        $conn = GetConnection();
        $result = $conn->query($sql);
        // $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد"];
    }
    public static function UpdateNamePathToNull($vlid)
    {
        $sql = "Update tbl_cloud_volume set cv_name=SUBSTRING_INDEX(cv_name, '---',1) WHERE cvid=" . $vlid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function GetVolumeFromAPI($token, $idc)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $GetAllVolume = API_CLOUD_VOLUME_ADMIN::RunGetAllVolume($m, $idc);
        $g = json_decode($GetAllVolume, true);
        if (is_array($g) && count($g) > 0) {
            foreach ($g as $b) {
                if (count($b["attachments"]) > 0) {
                    self::UpdateVolumeName(
                        $b["attachments"][0]["device"],
                        $b["attachments"][0]["volume_id"]
                    ); // $mountedDevice[]=$b;
                }
            }
        }

        $sql = "";
        $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,csid as ServerID,
            " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                    IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
            csname as ServerHostName,cv_type as storage_type from " . $GLOBALS["cloud_volume_tablename"] . "
            LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
            where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=0 AND " . $GLOBALS['cv_idcid_fk'] . "=" . $idc . " ORDER BY cvid desc";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $i = 0;
        foreach ($listOfRecordType as $l) {
            $explodedname = explode("---", $l["VolumeName"]);
            $listOfRecordType[$i]["VolumeName"] = $explodedname[0];
            $listOfRecordType[$i]["Device"] = "";
            if (count($explodedname) > 1) {
                $listOfRecordType[$i]["Device"] = $explodedname[1];
            }
            $i++;
        }
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function UpdateVolumeName($name, $serverid)
    {
        $volumeDetails = self::GetVolumeByServerID($serverid);
        if (count($volumeDetails["data"]) == 0) {
            return;
        }
        $mainname = explode("---", $volumeDetails["data"][0]["cv_name"])[0];
        $sql = "UPDATE tbl_cloud_volume set cv_name='" . $mainname . "---" . $name . "',cv_mountpoint='"
            . $name . "' where cv_serverid='" . $serverid . "'";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function GetVolumeByServerID($serverid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["cloud_volume_tablename"]
            . " WHERE cv_serverid='" . $serverid . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetOneByServerID($serverid, $issnapshot)
    {
        $sql = "SELECT * FROM " . $GLOBALS["cloud_volume_tablename"]
            . " WHERE " . $GLOBALS['cv_csid_fk'] . "=" . $serverid . " AND " . $GLOBALS['cv_is_snapshot'] . "=" . $issnapshot;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
        $i = 0;
        $ssdprice = 0;
        $nvmeprice = 0;
        $sasprice = 0;
        foreach ($pricelist["data"] as $ls) {
            if ($ls["dp_category"] == "ssd") {
                $ssdprice = intVal($ls["dp_price"]);
            }
            if ($ls["dp_category"] == "sas") {
                $sasprice = intVal($ls["dp_price"]);
            }
            if ($ls["dp_category"] == "nvme") {
                $nvmeprice = intVal($ls["dp_price"]);
            }
        }
        foreach ($listOfRecordType as $l) {
            switch ($l["cv_type"]) {
                case "ssd":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $ssdprice;
                    break;
                case "nvme":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $nvmeprice;
                    break;
                case "sas":
                    $listOfRecordType[$i]["price"] = $l["cv_space"] * $sasprice;
                    break;
            }
            $i++;
        }

        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetListOfByIDC($idc, $issnapshot)
    {
        $sql = "SELECT * FROM " . $GLOBALS["cloud_volume_tablename"]
            . " WHERE   cv_idcid_fk=" . $idc . " and " . $GLOBALS['cv_is_snapshot'] . "=" . $issnapshot;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function CheckVolumeIsUsable($vlid)
    {
        $sql = "SELECT " . $GLOBALS['cv_csid_fk'] . " as VolumeID from " . $GLOBALS["cloud_volume_tablename"]
            . " WHERE " . $GLOBALS['cvid'] . "=" . $vlid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetListWithoutToken($uid)
    {
        $sql = "SELECT cv_serverid  as sid," . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
            " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
        IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate
        from " . $GLOBALS["cloud_volume_tablename"] . "
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=0 ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetList($token, $idc, $issnapshot = 0)
    {
        if ($issnapshot == 0)
            return self::GetVolumeFromAPI($token, $idc);
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "";
        if ($issnapshot == 1) {
            $sql = "SELECT csid as ServerID," . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
            " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                    IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
                $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
            csname as ServerHostName,cv_type as storage_type from  " . $GLOBALS["cloud_volume_tablename"] . "
            LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
            where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=" . $issnapshot . " AND " . $GLOBALS['cv_idcid_fk'] . "=" . $idc;
        } else {
            $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,csid as ServerID,
            " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                    IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
                $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
            csname as ServerHostName,cv_type as storage_type from " . $GLOBALS["cloud_volume_tablename"] . "
            LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
            where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=" . $issnapshot . " AND " . $GLOBALS['cv_idcid_fk'] . "=" . $idc . " ORDER BY cvid desc";
        }
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $i = 0;
        foreach ($listOfRecordType as $l) {
            $listOfRecordType[$i]["VolumeName"] = explode("---", $l["VolumeName"])[0];
            $i++;
        }
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetListOfSnapShot($token, $serverid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
            " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
        IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
        csname as ServerHostName from " . $GLOBALS["cloud_volume_tablename"] . "
        LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=1 and cv_csid_fk=" . $serverid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function RemoveAllVolumeAndSnapshotByUser($token, $uid)
    {
        $sql = "SELECT * FROM tbl_cloud_volume where cv_uid_fk=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        foreach ($listOfRecordType as $l) {
            $usersDetails = USERS_ADMIN::GetUserWithoutToken($uid);
            $uid = $usersDetails["userdetail"][0]["uid"];
            $mail = $usersDetails["userdetail"][0]["umail"];
            $m = str_replace("@", "", $mail);
            $m = str_replace(".", "", $m);
            $vdet = CLOUD_VOLUME_ADMIN::GetOneByID($token, $l["cvid"], $uid);


            $cv = CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $l["cvid"]);
            if ($cv["status"] == "error") {
                return ["status" => "error", "message" => "شما اجازه دسترسی به این فضای ذخیره سازی را ندارید"];
            }

            $idc = $vdet["data"][0]["idc"];
            $sid = $vdet["data"][0]["sid"];
            $status = $vdet["data"][0]["VolumeStatus"];
            if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
                return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
            }
            if ($status == "inuse") {
                return ["status" => "error", "message" => "فضای ذخیره سازی درخواستی شما به یک سرور متصل است ابتدا آن را از سرور جدا نموده و سپس حذف نمایید"];
            }

            $now = jDateTime::date("Y/m/d H:i:s");
            $i = "";
            if ($cv["data"][0]["cv_is_snapshot"] == "1") {
                $i =  API_CLOUD_SNAPSHOT_ADMIN::RunRemoveSnapshot($sid, $m, $idc);
                $j = json_decode($i, true);
                if (isset($j["status"]) && $j["status"] == "error") {
                    if ($j["exceptions"][0] == "Invalid volume: Volume status must be available or error or error_restoring or error_extending or error_managing and must not be migrating, attached, belong to a group, have snapshots or be disassociated from snapshots after volume transfer.")
                        $j["exceptions"][0] = "دیسک اصلی  متصل به سرور قابل حذف نمیباشد.";
                    return ["status" => "error", "message" => $j["exceptions"][0]];
                }
            } else {
                $i = API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($sid, $m, $idc);
                $j = json_decode($i, true);
                if (isset($j["status"]) && $j["status"] == "error") {
                    if ($j["exceptions"][0] == "Invalid volume: Volume status must be available or error or error_restoring or error_extending or error_managing and must not be migrating, attached, belong to a group, have snapshots or be disassociated from snapshots after volume transfer.")
                        $j["exceptions"][0] = "دیسک اصلی  متصل به سرور قابل حذف نمیباشد.";
                    return ["status" => "error", "message" => $j["exceptions"][0]];
                }
            }
            $sql = "DELETE FROM   " . $GLOBALS["cloud_volume_tablename"] . " WHERE "  . $GLOBALS['cvid'] . "=" . $l["cvid"];
            $conn = GetConnection();
            $conn->query($sql);
            $conn->close();
        }
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
    public static function RemoveVolume($token, $id, $uid = 0)
    {
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
            }
            $uid = $usersDetails["userdetail"][0]["uid"];
            $mail = $usersDetails["userdetail"][0]["umail"];
            $m = str_replace("@", "", $mail);
            $m = str_replace(".", "", $m);
            $vdet = CLOUD_VOLUME_ADMIN::GetOneByID($token, $id);
        } else {
            $usersDetails = USERS_ADMIN::GetUserWithoutToken($uid);
            $uid = $usersDetails["userdetail"][0]["uid"];
            $mail = $usersDetails["userdetail"][0]["umail"];
            $m = str_replace("@", "", $mail);
            $m = str_replace(".", "", $m);
            $vdet = CLOUD_VOLUME_ADMIN::GetOneByID($token, $id, $uid);
        }


        $cv = CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $id);
        if ($cv["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فضای ذخیره سازی را ندارید"];
        }

        $idc = $vdet["data"][0]["idc"];
        $sid = $vdet["data"][0]["sid"];
        $status = $vdet["data"][0]["VolumeStatus"];
        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        if ($status == "inuse") {
            return ["status" => "error", "message" => "فضای ذخیره سازی درخواستی شما به یک سرور متصل است ابتدا آن را از سرور جدا نموده و سپس حذف نمایید"];
        }

        $now = jDateTime::date("Y/m/d H:i:s");
        $i = "";
        if ($cv["data"][0]["cv_is_snapshot"] == "1") {
            $i =  API_CLOUD_SNAPSHOT_ADMIN::RunRemoveSnapshot($sid, $m, $idc);
            $j = json_decode($i, true);
            if (isset($j["status"]) && $j["status"] == "error") {
                if ($j["exceptions"][0] == "Invalid volume: Volume status must be available or error or error_restoring or error_extending or error_managing and must not be migrating, attached, belong to a group, have snapshots or be disassociated from snapshots after volume transfer.")
                    $j["exceptions"][0] = "دیسک اصلی  متصل به سرور قابل حذف نمیباشد.";
                return ["status" => "error", "message" => $j["exceptions"][0]];
            }
        } else {
            $i = API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($sid, $m, $idc);
            $j = json_decode($i, true);
            if (isset($j["status"]) && $j["status"] == "error") {
                if ($j["exceptions"][0] == "Invalid volume: Volume status must be available or error or error_restoring or error_extending or error_managing and must not be migrating, attached, belong to a group, have snapshots or be disassociated from snapshots after volume transfer.")
                    $j["exceptions"][0] = "دیسک اصلی  متصل به سرور قابل حذف نمیباشد.";
                return ["status" => "error", "message" => $j["exceptions"][0]];
            }
        }
        $sql = "DELETE FROM   " . $GLOBALS["cloud_volume_tablename"] . " WHERE "  . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
    public static function GetOneByID($token, $id, $uid = 0)
    {
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
            }
            $uid = $usersDetails["userdetail"][0]["uid"];
            $mail = $usersDetails["userdetail"][0]["umail"];
            $m = str_replace("@", "", $mail);
            $m = str_replace(".", "", $m);
        } else {
            $usersDetails = USERS_ADMIN::GetUserWithoutToken($uid);
            $uid = $usersDetails["userdetail"][0]["uid"];
            $mail = $usersDetails["userdetail"][0]["umail"];
            $m = str_replace("@", "", $mail);
            $m = str_replace(".", "", $m);
        }


        $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,cv_osname,cv_osid,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate ," . $GLOBALS['cv_idcid_fk'] . " as idc
            ," . $GLOBALS['cv_serverid'] . " as sid
            from " . $GLOBALS["cloud_volume_tablename"] . "
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cvid'] . "=" . $id;


        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToVolume($uid, $id)
    {
        $sql = "SELECT *
            from " . $GLOBALS["cloud_volume_tablename"] . " WHERE " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", $id];
    }
    public static function CheckDuplicatedName($uid, $name)
    {
        $sql = "SELECT * FROM " . $GLOBALS["cloud_volume_tablename"] . "
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cv_name'] . "='" . $name . "'";


        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",  $sql];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function ExtendVolume($token, $idc, $space, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);


        if (filter_var($space, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "مقدار ارسالی برای فضای دیسک اشتباه است"];
        }

        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        if (CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $id)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فضای ذخیره سازی را ندارید"];
        }
        $vdet = CLOUD_VOLUME_ADMIN::GetOneByID($token, $id);
        $CurrentSpace = $vdet["data"][0]["VolumeSpace"];
        $idc = $vdet["data"][0]["idc"];
        $sid = $vdet["data"][0]["sid"];
        $serverid = "0";
        $j = API_CLOUD_VOLUME_ADMIN::RunGetAllVolume($m, $idc);
        $p = json_decode($j, true);

        foreach ($p as $s) {
            if (isset($s["attachments"][0]["server_id"]) && $sid == $s["attachments"][0]["id"]) {
                if ($s["attachments"][0]["device"] == "/dev/vda") {
                    $serverid = $s["attachments"][0]["server_id"];
                }
            }
        }
        if ($space < $CurrentSpace) {
            return ["status" => "error", "message" => "امکان کاهش حجم دیسک ذخیره سازی نیست"];
        }
        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_space'] . "='" . $space
            . "'," . $GLOBALS['cv_update_date'] . "='" . $now . "' WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        API_CLOUD_VOLUME_ADMIN::RunExtendAPIVolume($sid, $m, $idc, $space);
        $d = "";
        if ($serverid != "0") {
            $d = CLOUD_SERVER_ADMIN::ResizeServerVolume($serverid, $space);
        }
        CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "resize volume");
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $p, $d, "sid" => $serverid];

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
    public static function AddValumeRescue($name, $space, $uid, $idcid, $serverid, $volumeid)
    {
        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "INSERT INTO " . $GLOBALS["cloud_volume_tablename"] . " VALUES (0,'" . $name
            . "','" . $uid . "','" . $space . "','" . $serverid . "','0','" . $now . "','" . $now . "',0,'" . $volumeid . "'," .
            $idcid . ",'','',0,'ssd','')";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function RemoveValumeRescue($serverid, $uid)
    {
        $sql = "DELETE  FROM " . $GLOBALS["cloud_volume_tablename"] . "
		WHERE cv_name='rescue' and cv_csid_fk='" . $serverid . "'";
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        $conn->close();
    }
    public static function AddVolume($token, $name, $space, $idcid, $storage_Type)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        if (filter_var($space, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "مقدار ارسالی برای فضای دیسک اشتباه است"];
        }

        if (CLOUD_VOLUME_ADMIN::CheckDuplicatedName($uid, $name)["status"] == "success") {
            return ["status" => "error", "message" => "نام دیسک انتخابی شما تکراری است"];
        }
        if (CLOUD_IDC_ADMIN::GetOneByID($idcid)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        $now = jDateTime::date("Y/m/d H:i:s");
        $name = str_replace("---", "-", $name);

        $sql = "INSERT INTO " . $GLOBALS["cloud_volume_tablename"] . " VALUES (0,'" . $name
            . "','" . $uid . "','" . $space . "','0','0','" . $now . "','" . $now . "',0,''," . $idcid . ",'','',0,'" .
            $storage_Type . "','')";

        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $idcinfo = CLOUD_IDC_ADMIN::GetOneByID($idcid);
        $id = API_CLOUD_VOLUME_ADMIN::RunCreateAPIVOLUME($name, $name, $m, $idcid, $space, "", $idcinfo["data"][0]["ci_storagetype"], $storage_Type);
        $conn->close();
        CLOUD_VOLUME_ADMIN::UpdateIDFromAPI($last_id, $id);
        CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "add server");
        return ["status" => "success", "id" => $last_id, $id, "message" => "اطلاعات با موفقیت ثبت شد"];
    }
    public static function AddVolumeAndAttachToServer($token, $name, $space, $idcid, $osname, $osid, $storage_Type)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        if (filter_var($space, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "مقدار ارسالی برای فضای دیسک اشتباه است"];
        }


        if (CLOUD_IDC_ADMIN::GetOneByID($idcid)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "INSERT INTO " . $GLOBALS["cloud_volume_tablename"] . " VALUES (0,'" . $name
            . "','" . $uid . "','" . $space . "','0','0','" . $now . "','" . $now . "',0,'0'," . $idcid . ",'" . $osname
            . "','" . $osid . "',0,'" . $storage_Type . "','/dev/vda')";

        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $idcinfo = CLOUD_IDC_ADMIN::GetOneByID($idcid);
        $id = API_CLOUD_VOLUME_ADMIN::RunCreateAPIVOLUME($name, $name, $m, $idcid, $space, $osid, $idcinfo["data"][0]["ci_storagetype"], $storage_Type);
        $conn->close();
        CLOUD_VOLUME_ADMIN::UpdateIDFromAPI($last_id, $id);
        CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "add server");
        return [
            "status" => "success", "message" => "اطلاعات با موفقیت ثبت شد",
            "vid" => $id, "id" => $last_id
        ];
    }
    public static function AddVolumeWithSnapShot($token, $name, $space, $idcid, $osname, $osid, $snapshotid, $serverid, $storage_Type)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        if (filter_var($space, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "مقدار ارسالی برای فضای دیسک اشتباه است"];
        }


        if (CLOUD_IDC_ADMIN::GetOneByID($idcid)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        $now = jDateTime::date("Y/m/d H:i:s");
        $idcinfo = CLOUD_IDC_ADMIN::GetOneByID($idcid);

        $id = API_CLOUD_VOLUME_ADMIN::RunCreateAPIVOLUME($name, $name, $m, $idcid, $space, $snapshotid, $idcinfo["data"][0]["ci_storagetype"], $storage_Type);
        if (isset($id["status"]) && $id["status"] == "error") {
            return ["status" => "error", "message" => $id["data"]["exceptions"], "id" => $id];
        }

        $sql = "INSERT INTO " . $GLOBALS["cloud_volume_tablename"] . " VALUES (0,'" . $name
            . "','" . $uid . "','" . $space . "','0','0','" . $now . "','" . $now . "',0,'0'," . $idcid . ",'" .
            $osname . "','" . $osid . "',0,'" . $storage_Type . "','/dev/vda')";

        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $conn->close();
        CLOUD_VOLUME_ADMIN::UpdateIDFromAPI($last_id, $id);
        CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "add server");
        return [
            "status" => "success", "message" => "اطلاعات با موفقیت ثبت شد",
            "vid" => $id, $sql, "id" => $last_id
        ];
    }
    public static function GetMainVolumeForServer($serverid, $idc)
    {
        $sql = "SELECT * FROM  tbl_cloud_volume  where cv_serverid='" . $serverid . "' and cv_idcid_fk=" . $idc;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است", $sql];
            return $result;
        } else {
            $listOfRecordType = [
                "status" => "success",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
            ];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetAllVolume($m, $idc)
    {
        $id = API_CLOUD_VOLUME_ADMIN::RunGetAllVolume($m, $idc);
        if (isset($id["status"]) && $id["status"] == "error") {
            return ["status" => "error", "message" => $id["data"]["exceptions"], "id" => $id];
        }
        return $id;
    }
    public static function UpdateServerIDAfterOSReinstall($OldId, $newID, $serverID)
    {
        // $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET  cv_csid_fk ='0'," .
        //     $GLOBALS['cv_status'] . "='0'  where  cv_csid_fk  ='" . $serverID . "'";
        // $conn = GetConnection();
        // $conn->query($sql);
        // $conn->close();
        //SELECT * FROM `tbl_cloud_volume` WHERE `cv_csid_fk`=325 and `cv_mountpoint` = '/dev/vda';
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET   " .
            $GLOBALS['cv_status'] . "='1',cv_serverid ='" . $newID . "'  where
			cv_csid_fk='" . $serverID . "' and `cv_mountpoint` = '/dev/vda'";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }


    public static function GetVolumeMountedToserver($serverid)
    {
        $sql = "SELECT count(cvid) as cnt FROM tbl_cloud_volume where cv_is_snapshot=0 and  cv_csid_fk =" . $serverid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return $listOfRecordType[0]["cnt"];
    }
    public static function InternalGetVolumeMountedToserver($serverid)
    {
        $sql = "SELECT *,count(cvid) as cnt FROM tbl_cloud_volume where cv_csid_fk =" . $serverid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return $listOfRecordType;
    }



    public static function UpdateIDFromAPI($id, $serverid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_serverid'] . "='" . $serverid
            . "' WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function UpdateServerID($id, $serverid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_csid_fk'] . "='" . $serverid
            . "' WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function UpdateVPSID($vlid, $vpsid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_csid_fk'] . "='" . $vpsid
            . "'," . $GLOBALS['cv_status'] . "='1' where " . $GLOBALS['cvid'] . "=" . $vlid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function UpdateVPSIDNull($vlid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_csid_fk'] . "='0'," .
            $GLOBALS['cv_status'] . "='0'  where " . $GLOBALS['cvid'] . "=" . $vlid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function AddSnapShotVolume($uid, $name, $space, $idcid, $id, $osname, $osid, $vpsid,$type)
    {
        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "INSERT INTO " . $GLOBALS["cloud_volume_tablename"] . "
        (`cvid`, `cv_name`, `cv_uid_fk`, `cv_space`, `cv_csid_fk`, `cv_status`, `cv_creation_date`,
            `cv_update_date`, `cv_bootable`, `cv_serverid`, `cv_idcid_fk`, `cv_osname`, `cv_osid`,
            `cv_is_snapshot`,`cv_type`,`cv_mountpoint`) VALUES
            (0,'" . $name . "','" . $uid . "','" . $space . "','" . $vpsid . "','0','" . $now . "','" . $now . "',0,'" .
            $id . "','" . $idcid . "','" . $osname . "','" . $osid . "',1,'".$type."','')";
        $conn = GetConnection();
        $conn->query($sql);
        $ids = $conn->insert_id;
        $conn->close();
        return $ids;
    }
}
