<?php


require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';


class CLOUD_FLAVOR_ADMIN
{

    public static function ReturnAllOS()
    {
        /**
         *   | ID                                   | Name        | Status |
         *   +--------------------------------------+-------------+--------+
         *   | 14223a43-1e4e-4cda-98b3-3398be026249 | Arch        | active |
         *   | b1fc5bb2-c765-423b-8cf0-2560e64f71b3 | CentOS7     | active |
         *   | 879826a5-9410-4712-8bdd-07ee377cd16f | CentOS8     | active |
         *   | 72b67282-1388-4d4b-a94b-08dbc2a90eda | Debian10    | active |
         *   | e34516da-9380-4c9a-9a59-2502baab4cf3 | Debian11    | active |
         *   | 4c1492dd-5d9e-47c8-9ff4-46aa9f23e57a | Debian9     | active |
         *   | 4ab0566f-817b-4cfd-b11b-9a147d8f27ed | Fedora36    | active |
         *   | c24fe611-cd78-4e5f-9d95-3baeaf7f1c7e | Opensuse    | active |
         *   | 168e6085-bb2c-4558-b97d-6a64113ef788 | Rocky8      | active |
         *   | c2dbb91e-0508-4e1b-8ada-b9c1196e50bc | Windows2012 | active |
         *   | 9b36b06c-4c79-41d1-ba92-72824c67d0fc | Windows2016 | active |
         *   | dee6eb7b-9e30-4fff-b220-b83efd95cd2d | Windows2019 | active |
         *   | 5c4a95e4-9ef1-4764-ab3b-e06254f0e455 | Windows2022 | active |
         *   | 4b431f7a-cb79-43c5-ac17-858a4fb3e791 | ubuntu16    | active |
         *   | 6394d747-4504-445d-a8bd-a1df34e3a50c | ubuntu18    | active |
         *   | 3fb40536-faf8-4bb3-9e5b-e3c7498b7f7f | ubuntu20    | active |
         *   | 1215508c-7270-4293-8e86-b39296211626 | ubuntu22    | active |
         */

        $oss = [
            "2012" => "Windows",
            "2016" => "Windows",
            "2019" => "Windows",
            "2022" => "Windows",
            "V7.9" => "Centos",
            "V8" => "Centos",
            "V16.04" => "Ubuntu",
            "V18.04" => "Ubuntu",
            "V20.04" => "Ubuntu",
            "V22.04" => "Ubuntu",
            "Arch" => "Arch",
            "9" => "Debian",
            "10" => "Debian",
            "11" => "Debian",
            "8.6" => "RockyLinux",
            "36" => "Fedora",
            "15.4" => "OpenSuse",
        ];

        $os = [
            "2012" => "c2dbb91e-0508-4e1b-8ada-b9c1196e50bc", //
            "2016" => "9b36b06c-4c79-41d1-ba92-72824c67d0fc", //
            "2019" => "dee6eb7b-9e30-4fff-b220-b83efd95cd2d", //
            "2022" => "5c4a95e4-9ef1-4764-ab3b-e06254f0e455", //
            "V7.9" => "b1fc5bb2-c765-423b-8cf0-2560e64f71b3", //
            "V8" => "879826a5-9410-4712-8bdd-07ee377cd16f", //

            "V16.04" => "4b431f7a-cb79-43c5-ac17-858a4fb3e791",
            "V18.04" => "6394d747-4504-445d-a8bd-a1df34e3a50c",
            "V20.04" => "3fb40536-faf8-4bb3-9e5b-e3c7498b7f7f",
            "V22.04" => "1215508c-7270-4293-8e86-b39296211626",
            "Arch" => "14223a43-1e4e-4cda-98b3-3398be026249",
            "15.4" => "c24fe611-cd78-4e5f-9d95-3baeaf7f1c7e",

            "9" => "4c1492dd-5d9e-47c8-9ff4-46aa9f23e57a",
            "10" => "72b67282-1388-4d4b-a94b-08dbc2a90eda",
            "11" => "e34516da-9380-4c9a-9a59-2502baab4cf3",
            "8.6" => "168e6085-bb2c-4558-b97d-6a64113ef788",
            "36" => "4ab0566f-817b-4cfd-b11b-9a147d8f27ed",
        ];

        $osByCategory = [
            "Ubuntu" => [
                "V16.04" => "4b431f7a-cb79-43c5-ac17-858a4fb3e791",
                "V18.04" => "6394d747-4504-445d-a8bd-a1df34e3a50c",
                "V20.04" => "3fb40536-faf8-4bb3-9e5b-e3c7498b7f7f",
                "V22.04" => "1215508c-7270-4293-8e86-b39296211626",
            ],
            "Windows" => [
                "2012" => "c2dbb91e-0508-4e1b-8ada-b9c1196e50bc",
                "2016" => "9b36b06c-4c79-41d1-ba92-72824c67d0fc",
                "2019" => "dee6eb7b-9e30-4fff-b220-b83efd95cd2d",
                "2022" => "5c4a95e4-9ef1-4764-ab3b-e06254f0e455"
            ],
            "Centos" => [
                "V7.9" => "b1fc5bb2-c765-423b-8cf0-2560e64f71b3",
                "V8" => "879826a5-9410-4712-8bdd-07ee377cd16f"
            ],
            "RockyLinux" => [
                "8.6" => "168e6085-bb2c-4558-b97d-6a64113ef788"
            ],
            "OpenSuse" => [
                "15.4" => "c24fe611-cd78-4e5f-9d95-3baeaf7f1c7e"
            ],
            "Arch" => [
                "Arch" => "14223a43-1e4e-4cda-98b3-3398be026249"
            ],
            "Fedora" => [
                "36" => "4ab0566f-817b-4cfd-b11b-9a147d8f27ed",
            ],
            "Debian" => [
                "9" => "4c1492dd-5d9e-47c8-9ff4-46aa9f23e57a",
                "10" => "72b67282-1388-4d4b-a94b-08dbc2a90eda",
                "11" => "e34516da-9380-4c9a-9a59-2502baab4cf3"
            ],

        ];
        return ["os" => $os, "osbycat" => $osByCategory, "oss" => $oss];
    }

    public static function ReturnAllPackages()
    {
        $package = [
            "flavor_1_1024"          => "543fd977-d60a-43cc-8c22-6a2246a3b1e4",
            "flavor_1_2048"          => "546b7424-769d-4dfc-81ec-011d8b3b4f94",
            "flavor_1_3072"          => "abf2dca5-2bb1-432a-bb4f-05b13eebf692",
            "flavor_1_4096"          => "49043164-c1da-4b1a-a64f-37ecc869b90f",
            "flavor_1_6144"          => "a60e0185-b0f5-4d9a-8b99-e7a4622745ff",
            "flavor_1_8192"          => "6925af76-b610-4383-a5ae-7976f4efeae1",
            "flavor_1_10240"         => "83539696-a94e-47b8-9121-a91fa0253190",
            "flavor_2_1024"          => "628b4219-17e6-4ced-957f-a4e84fddcbe4",
            "flavor_2_2048"          => "8d51a94c-c315-4355-92e5-77cfcbe13b46",
            "flavor_2_3072"          => "45c9a083-9df2-445e-bc34-03356d8e121a",
            "flavor_2_4096"          => "fe35ea93-7a50-4927-bb14-9cfde8c6ae5a",
            "flavor_2_6144"          => "86918650-620e-4ec2-9587-3cbc80d81e5e",
            "flavor_2_8192"          => "caa04d6d-86a2-4e95-993a-623b335898fa",
            "flavor_2_10240"         => "462f95cf-eecd-4735-bc3d-ebcc2f9428c2",
            "flavor_2_12288"         => "61b6d9b5-1810-4f78-b246-8dfffcb261cc",
            "flavor_2_16384"         => "cc86e03c-16d8-4cfb-8235-99a81892eca0",
            "flavor_3_1024"          => "ce3c5295-f3ac-4b68-9719-12f327ca4e2c",
            "flavor_3_2048"          => "d247cb4e-f137-4ec8-bcfe-7d852fb1010a",
            "flavor_3_3072"          => "463748bf-a5ac-4447-898f-f594fff69d2f",
            "flavor_3_4096"          => "b3e9da02-7cd0-4544-9f9b-1ba43c4e9c47",
            "flavor_3_6144"          => "6a37335d-88d6-4557-a961-6c9001a5d113",
            "flavor_3_8192"          => "e3936fa8-0467-431b-aff4-509ecad3c213",
            "flavor_3_10240"         => "2387b7d4-97dd-4676-9dc2-b578ae1e66d8",
            "flavor_3_12288"         => "05077c79-8723-43de-bd4d-61b9c526deb6",
            "flavor_3_16384"         => "e4be2ece-aa38-4fe3-b8e5-905c37995dc4",
            "flavor_4_1024"          => "b94578ff-bcb6-406d-b179-c171ddbd0411",
            "flavor_4_2048"          => "0d10a83e-473e-4deb-aa52-f501e7d0e4a2",
            "flavor_4_3072"          => "42d7babf-f5ea-4e00-ad9c-d81d05657b6a",
            "flavor_4_4096"          => "6174ced8-b848-408e-ada6-60421b7daeac",
            "flavor_4_6144"          => "67240c37-45cb-4801-b23f-ef71575d8439",
            "flavor_4_8192"          => "b8b5b954-846a-4a4b-aebd-2a3082698f23",
            "flavor_4_10240"         => "e7942817-7f2b-4120-ac40-8e30cbe5aa37",
            "flavor_4_12288"         => "5be70a4c-026c-40e2-9e78-07e2532e45ea",
            "flavor_4_16384"         => "f3a3cbc4-f840-4ca3-8e88-3818a61475c1",
            "flavor_5_1024"          => "486be3bb-7c5a-4300-83a0-0bf627c93d9c",
            "flavor_5_2048"          => "1402ad4b-ec35-4f7a-b27f-11538879f3f9",
            "flavor_5_3072"          => "be722bf3-82cf-4422-b734-1794eb34e764",
            "flavor_5_4096"          => "a1faa196-5817-4bb0-a711-4304bb57e7cb",
            "flavor_5_6144"          => "20e65a45-5fd6-4cb4-99ca-71b056b6b15c",
            "flavor_5_8192"          => "badb440c-2fd0-44ba-9243-91e23f56ae09",
            "flavor_5_10240"         => "d0df6fa4-187d-4c26-9b8f-dc40929f2bdd",
            "flavor_5_12288"         => "b3a028d9-c195-4d13-9020-9a9695d265a7",
            "flavor_5_16384"         => "040e100e-fe18-4ea9-86db-aa6c08a08e2e",
            "flavor_6_1024"          => "364a84d8-53e9-4e05-b686-454924205629",
            "flavor_6_2048"          => "4ce9f2c9-f687-4b05-9e71-e97987cf0054",
            "flavor_6_3072"          => "3e337fab-7e76-4fc1-b433-de5d1187bcff",
            "flavor_6_4096"          => "569b305b-65b4-4a71-ab88-13cb120b5c74",
            "flavor_6_6144"          => "fbbbb615-6d40-4ce3-aaf1-2f9dbf1faaba",
            "flavor_6_8192"          => "6efc48f0-47f5-4a8d-9d37-7f4a4bf3e583",
            "flavor_6_10240"         => "d0077996-b0b5-47f8-8aef-0f7e00c48565",
            "flavor_6_12288"         => "42b3a4c6-d5b1-49a6-b0b7-7948812a265d",
            "flavor_6_16384"         => "976ff5b8-3e52-4757-8507-ffcd6c513059",
            "flavor_7_1024"          => "ec738632-1fef-43dd-b617-98760f026186",
            "flavor_7_2048"          => "f415da00-57c4-4786-834c-0484a5bae423",
            "flavor_7_3072"          => "34be8d49-310c-4c0e-9e44-73a94dfef0fa",
            "flavor_7_4096"          => "b3b83a68-9f5a-4d41-8991-2b8bbaee04c5",
            "flavor_7_6144"          => "3298896b-7c29-47b2-a631-0ccebf4f7487",
            "flavor_7_8192"          => "29302d64-88e7-42a3-92d7-827aa6dd2dfc",
            "flavor_7_10240"         => "00c09c26-e7e7-43cb-ab02-98fc4c60fe86",
            "flavor_7_12288"         => "92db5aef-16ff-40a1-b119-59ff229f3f7a",
            "flavor_7_16384"         => "70279d1b-456a-4e68-af1a-923abf423cf0",
            "flavor_8_1024"          => "9d490fac-8769-4971-844b-bdc4eb673ee5",
            "flavor_8_2048"          => "6ccc3e85-b604-40bf-a4ec-340ce294fb83",
            "flavor_8_3072"          => "c3bb6243-c139-4886-a99b-f4f6b6d6e075",
            "flavor_8_4096"          => "5991390c-282d-4c37-9437-8a6d68090a84",
            "flavor_8_6144"          => "20a11404-64ef-4dcd-a49e-1b757af74aa7",
            "flavor_8_8192"          => "b1435263-47f0-4eb4-9de7-2543f0a2a942",
            "flavor_8_10240"         => "36d6f80f-4e29-4249-b457-12614b88f494",
            "flavor_8_12288"         => "64e23a2a-55b5-47ec-bdcf-bb98efb3b088",
            "flavor_8_16384"         => "d969f9ca-0eca-43a7-a83e-99b1a71e0330",
            "flavor_9_1024"          => "e84c7b12-a181-4f2d-95ac-77f7fc89f053",
            "flavor_9_2048"          => "254d83da-63f7-4926-a262-e6a6bd8129b6",
            "flavor_9_3072"          => "8c11d1f3-e17b-426c-b600-d31c0b4c82f4",
            "flavor_9_4096"          => "0e4eec7c-98ea-4e6b-83f5-ec0e06a75181",
            "flavor_9_6144"          => "93b306b3-54b4-4dce-a427-046648099b85",
            "flavor_9_8192"          => "91d66e65-d199-434d-aa44-bc8ce16c5bac",
            "flavor_9_10240"         => "4714f67d-fd09-4a25-834e-d525f0492bc6",
            "flavor_9_12288"         => "14473b1b-fa91-486b-8efc-95dca98a840f",
            "flavor_9_16384"         => "570c122d-31e6-48a4-8b3c-c9bddee83578",
            "flavor_10_1024"         => "7df63b05-e296-47f5-b80e-391d001c7f9c",
            "flavor_10_2048"         => "a97bfa75-20c6-4050-8026-f59716250190",
            "flavor_10_3072"         => "7161c31f-76b6-4a14-80cb-38565d2be5fc",
            "flavor_10_4096"         => "a1512d6d-9dd7-453c-a76b-990a95456b1f",
            "flavor_10_6144"         => "62cf2fff-95b1-4805-8dcf-4d98212d3080",
            "flavor_10_8192"         => "9cefdcbc-f859-499c-8c7f-e2840a86d8d6",
            "flavor_10_10240"        => "5c95f456-194e-4018-b2e5-ef67802f9851",
            "flavor_10_12288"        => "ecaa5cca-ce6b-465a-a275-6a07cbcaa257",
            "flavor_10_16384"        => "bddb5f88-ca35-48fc-803b-110cbf8bbc62",
            "flavor_11_1024"         => "5993c458-00cc-4517-ba1b-61c3ae161f96",
            "flavor_11_2048"         => "730e178a-3245-4fea-ab64-0cfa4c7d4a04",
            "flavor_11_3072"         => "7e0fc216-6fd3-4ad9-83ed-d501fddd3ede",
            "flavor_11_4096"         => "cf6c105d-247a-42d5-9951-2a4295f9daea",
            "flavor_11_6144"         => "c8a4045c-db21-4a29-81a3-513cb87241f8",
            "flavor_11_8192"         => "2fb3bf72-8d6c-4319-902d-18f40e646f2f",
            "flavor_11_10240"        => "dc438dc7-35a7-4510-91db-c1468544fd9b",
            "flavor_11_12288"        => "bc8e3a55-fd58-4900-a227-009a12d181ad",
            "flavor_11_16384"        => "1c384194-2652-4c77-a847-b3684087744d",
            "flavor_12_1024"         => "5dca2d9e-24f2-454e-89f5-052dcf690a20",
            "flavor_12_2048"         => "508f1904-fc68-42dd-a9d0-0ff63885cd5b",
            "flavor_12_3072"         => "9352746d-fe0e-4873-8d9c-2092c4edb760",
            "flavor_12_4096"         => "6de393c1-1db7-4a15-acd6-bbc21a2748c8",
            "flavor_12_6144"         => "b261e5a8-d6d9-4c86-8043-9188d17d61dd",
            "flavor_12_8192"         => "15a9ae70-7e3b-40dc-9c8b-148dfa8dc16e",
            "flavor_12_10240"        => "5117fbb6-f6ee-4960-92ee-079a015cb7a8",
            "flavor_12_12288"        => "a25de0de-a3b2-4458-b88b-925f9138e152",
            "flavor_12_16384"        => "e4001c20-058b-472e-bef5-1214ebf3f55d",
            "flavor_13_1024"         => "5660f5ab-0817-4fea-9d53-e6f0fbb4bdd3",
            "flavor_13_2048"         => "8e9a532c-43f7-4101-b4c2-f4cd7f444e4b",
            "flavor_13_3072"         => "3897a989-ebb7-4eb6-bfc2-70c5a9583e9c",
            "flavor_13_4096"         => "bd7414b3-e23e-4865-8b84-50bd5e5fe5c5",
            "flavor_13_6144"         => "de9a5835-e1c2-49d4-a45c-57a28c1841d0",
            "flavor_13_8192"         => "5fa6d7e5-a8a5-4fb6-9569-28fa99d5d73c",
            "flavor_13_10240"        => "eafd159e-33ca-4965-8696-f58beee0cff3",
            "flavor_13_12288"        => "f00ab7c5-a5ac-48e1-833d-96215352b8e8",
            "flavor_13_16384"        => "ac9e945a-d4c1-472c-ae18-40148cdc8667",
            "flavor_14_1024"         => "ca2a2203-6b66-44f4-ba0f-e31d4db0c9e5",
            "flavor_14_2048"         => "70e5e869-4ea4-45fb-9638-8a76e8b5fae3",
            "flavor_14_3072"         => "9968c7f8-cf56-4c11-9fe1-23cdf8d5595b",
            "flavor_14_4096"         => "f383f6f4-fd4f-428c-b209-a5b014967bb9",
            "flavor_14_6144"         => "04e59500-308d-4ef9-a168-47d411c7e00e",
            "flavor_14_8192"         => "e35a7029-aad4-47c0-b4a7-526bca0c071b",
            "flavor_14_10240"        => "3188baed-9e64-4198-85ad-f2e54896eabb",
            "flavor_14_12288"        => "b0ab127b-32e6-44d5-b5b7-c3c1e7e7e2a1",
            "flavor_14_16384"        => "8e057f66-bdbf-4682-832f-b70b930375c8",
            "flavor_15_1024"         => "c362f853-d4f1-4cda-9556-a314ce881762",
            "flavor_15_2048"         => "59de7462-f2e9-4cac-ba98-153bc5d2317c",
            "flavor_15_3072"         => "cf7b992b-4062-471b-b591-5e40bf97d11f",
            "flavor_15_4096"         => "094ba57f-e645-4602-b58b-5277dff00e9d",
            "flavor_15_6144"         => "812ff627-1178-4a5b-a05c-37d5b365a551",
            "flavor_15_8192"         => "39a0133b-1714-479e-839b-cdbf8ef81b0e",
            "flavor_15_10240"        => "c7a7f7f9-bd6e-4b9b-b7f9-68301cbfb399",
            "flavor_15_12288"        => "5a3c386c-5bec-4273-b70e-f5465dd0babd",
            "flavor_15_16384"        => "ec0ae6ce-bf97-4bbc-b184-00530843d99c",
            "flavor_16_1024"         => "38bdd974-73b1-45ff-a31f-2c3dc0b8b2a1",
            "flavor_16_2048"         => "f0abe80d-cf02-451f-83ed-ebf2221a41c6",
            "flavor_16_3072"         => "8d41abf5-8c4e-4393-b8e0-5bcc7454169d",
            "flavor_16_4096"         => "6bff4a53-9a37-40c3-a9c5-5d92ca4a8010",
            "flavor_16_6144"         => "213a6390-d303-4ff9-b45e-eb929b42c4e7",
            "flavor_16_8192"         => "2964288c-147d-4472-b8e8-31113f3aeed5",
            "flavor_16_10240"        => "7651bb07-5b6b-4002-9445-d550740f38e6",
            "flavor_16_12288"        => "271ef269-49d3-4e4c-ae1c-9cc3f83a4047",
            "flavor_16_16384"        => "a1efc892-9306-4258-9c72-8e19475ef6dd",
            "flavor_17_1024"         => "b93b2920-37e4-4672-a69d-513b8fcfd009",
            "flavor_17_2048"         => "deef1209-41da-455a-bf26-bcf66aaa7178",
            "flavor_17_3072"         => "56eefd65-63fc-40bc-a983-3f2b8e0ac2ca",
            "flavor_17_4096"         => "9ce6a366-cd9f-4d7a-bce3-87a0ff7af3cd",
            "flavor_17_6144"         => "79631bf6-eecc-4896-bb75-86b820f70aff",
            "flavor_18_1024"         => "1d7780bf-889d-43a6-93dd-9018580eebfe",
            "flavor_18_2048"         => "d24d8dcb-feed-48b2-aea5-f49277a5e267",
            "flavor_18_3072"         => "0da4b2df-be01-471f-b93b-633b44cb1a7e",
            "flavor_18_4096"         => "905c29da-486a-43ac-abd5-a1e24352adcc",
            "flavor_18_6144"         => "5b662d4b-effb-47f0-aedb-ad1905a3c9d6",
            "flavor_18_8192"         => "6e54f2fe-59e0-4c70-ac8e-7940e83dbdbd",
            "flavor_18_10240"        => "d52a75b4-2233-4450-a53b-c82bbb9bdf36",
            "flavor_18_12288"        => "6b959bec-3763-4e67-ae88-8482a5679de1",
            "flavor_18_16384"        => "902b11e3-d290-4f04-9ff1-d7548dc189d2",
            "flavor_19_1024"         => "d951ddc5-7133-401c-816b-d872ed83b499",
            "flavor_19_2048"         => "6b25473e-e3fb-491e-aba6-ae788beeac58",
            "flavor_19_3072"         => "c22f8987-c977-40d6-9089-f0b82d354911",
            "flavor_19_4096"         => "5d9ec80a-2129-4096-baba-8cc761785424",
            "flavor_19_6144"         => "7ba0bca5-4d08-43f7-96f2-60d10c0a4a94",
            "flavor_19_8192"         => "b9d9c73c-7b72-40b2-8c59-4bd7ff365dc6",
            "flavor_19_10240"        => "4adc7981-c66b-4503-a859-bbcce3e87def",
            "flavor_19_12288"        => "34589d08-5866-406a-b996-b567bb56ccd2",
            "flavor_19_16384"        => "9db4e2ef-2c68-4b49-a093-73062d23be0c",
            "flavor_20_1024"         => "77e9079e-104b-4e3c-bf23-2c3890002596",
            "flavor_20_2048"         => "d187d490-f090-44b4-a6a8-cf9b9c0c096e",
            "flavor_20_3072"         => "1800484c-fea2-4551-84a4-c1df4760cfc0",
            "flavor_20_4096"         => "0fc0e3b0-d56f-4cab-915e-72cd971dbdab",
            "flavor_20_6144"         => "773b41ad-ac89-47b4-802a-1e2f7ea763f9",
            "flavor_20_8192"         => "333f6fc7-a446-4a96-9da2-d677180e6720",
            "flavor_20_10240"        => "2338080a-7c74-4a88-a1c3-2fa008b66beb",
            "flavor_20_12288"        => "cddb3b1f-7aeb-4cb9-92d1-f1816e62b81f",
            "flavor_20_16384"        => "05590d69-a143-4435-93a1-92df55491a88",
            "flavor_21_1024"         => "073d9a20-475c-4e4d-8839-ce83e806459c",
            "flavor_21_2048"         => "465d654b-2d17-4e28-a7d2-48197a10c070",
            "flavor_21_3072"         => "334543d7-93cd-4a38-827c-66c0b252f472",
            "flavor_21_4096"         => "276c236b-143e-4bcc-84d5-a9fc64dbdec9",
            "flavor_21_6144"         => "101a069f-92de-4747-8c33-838a95e0554f",
            "flavor_21_8192"         => "1306c9ec-ffad-4894-977f-cdbab235b2b8",
            "flavor_21_10240"        => "548a0008-6247-49bb-a030-37506d76d8d9",
            "flavor_21_12288"        => "77d0e9fb-c6b4-4102-a235-bb2eb168cfbd",
            "flavor_21_16384"        => "8dcc00e9-3fcf-4130-b1a2-1fb94b56179f",
            "flavor_22_1024"         => "a93fabbb-f869-4a17-8757-8e1170642c5a",
            "flavor_22_2048"         => "2b1eff86-cb11-4d98-84be-c96d7a438e82",
            "flavor_22_3072"         => "d322dba2-9ee5-4684-9f2e-cd1d5bf1c267",
            "flavor_22_4096"         => "b1e7aa93-bced-4009-abc7-4782c32b82bc",
            "flavor_22_6144"         => "7c545fb8-9c31-42f3-b86f-7a619df71256",
            "flavor_23_1024"         => "8af12ed8-5092-4d71-8e32-73ddf953d6e9",
            "flavor_23_2048"         => "47ec8ca4-bb87-48b1-8ebc-dd1978c8e1b5",
            "flavor_23_3072"         => "ea498a5e-2031-41a5-aa04-443108c17d9f",
            "flavor_23_4096"         => "fb1cc438-e2c8-4e2a-9988-22a73ea4dc3b",
            "flavor_23_6144"         => "6e0f26a7-709e-4cbf-b1b1-bfccb8e055e0",
            "flavor_23_8192"         => "6b5bf3ac-3597-479b-9196-119c12b61110",
            "flavor_23_10240"        => "31ead63d-db22-460c-9635-275fe1fee860",
            "flavor_23_12288"        => "40c14852-9425-410d-8378-18b8d17444af",
            "flavor_23_16384"        => "9f41fd57-d9c4-4537-82e1-5a4170f8771a",
            "flavor_24_1024"         => "6bc6d3bc-517c-45dd-80a4-ec0b0f04cddc",
            "flavor_24_2048"         => "bff43d7a-7b5a-4f88-8c8c-d106c96094a2",
            "flavor_24_3072"         => "84553bd0-341e-4608-82de-70382ded06ab",
            "flavor_24_4096"         => "7a9008b8-26b4-4596-b755-587458222e43",
            "flavor_24_6144"         => "e147b2bf-5188-45cf-8d02-2150e63aa963",
            "flavor_24_8192"         => "7a2bdfd6-3d8e-4dcb-93f9-53abdfdefcd2",
            "flavor_24_10240"        => "087b5ac1-9716-4782-aeb7-c92b3b770ada",
            "flavor_24_12288"        => "8da5b0f9-6bb3-4487-8073-023324d5351f",
            "flavor_24_16384"        => "10ef8ef0-78ad-4991-ae7f-240827204719",
            "flavor_3_24576"         => "9b6485eb-f35e-47c9-ae32-999aee9046e4",
            "flavor_3_32768"         => "0b109d5d-7431-485a-ad0c-c0187505e53c",
            "flavor_3_36864"         => "efaf7aa8-f6ff-4e39-8a2a-91a23961de6d",
            "flavor_3_43008"         => "d0ff7bd0-de2f-449a-9e5f-327cf8935c23",
            "flavor_3_49152"         => "31e8afa1-806b-4cca-8a98-66ede3ddb806",
            "flavor_3_55296"         => "81803ff9-4f91-402f-b918-185ca72d493d",
            "flavor_3_65536"         => "c3184ab0-4d03-449a-a90d-007494d706e7",
            "flavor_4_24576"         => "3ab0c1ed-8519-4da8-baca-a0fd1b40f4e7",
            "flavor_4_32768"         => "d4df8729-b321-4769-a800-52d3c9d75602",
            "flavor_4_36864"         => "86c833b1-2e4c-427c-baab-394758da9f5e",
            "flavor_4_43008"         => "8ae8264e-d64e-4bb3-b4a4-31e821d227c5",
            "flavor_4_49152"         => "ab28ae10-816f-4df0-9c29-b085cb8a5b31",
            "flavor_4_55296"         => "97552324-2a1e-4fd7-ae85-22fdc4b4659f",
            "flavor_4_65536"         => "876109ff-2725-4906-aeac-c5faafb78753",
            "flavor_5_24576"         => "e2a780c8-e5ec-4f1b-8e79-67cac7858f91",
            "flavor_5_32768"         => "9dc45845-57d6-48f7-a074-3797d43acea7",
            "flavor_5_36864"         => "66112209-20b0-4402-96d6-aabcdef0db55",
            "flavor_5_43008"         => "f21300a6-9787-4fda-8b88-6804cbe80e73",
            "flavor_5_49152"         => "46b742d3-0309-4014-99cc-bd0029f9c121",
            "flavor_5_55296"         => "ef8f50a2-9e05-419d-8ae5-ec3d1dec8c8b",
            "flavor_5_65536"         => "e093a365-a9d5-4efd-bd81-00b636d2b4e4",
            "flavor_6_24576"         => "bcc89350-9a39-4c56-9870-9d6afc55c5db",
            "flavor_7_24576"         => "aff25648-ad5b-4d04-82d5-36b750fffd67",
            "flavor_7_32768"         => "078c90b7-8873-42ff-9f78-f357db76fc79",
            "flavor_7_36864"         => "c2ee697c-4f09-4e77-9dd4-1016a47b20b4",
            "flavor_7_43008"         => "1d7389f7-cba9-493c-a713-b2f6e940f0d7",
            "flavor_7_49152"         => "1f8d1744-3c9c-40b6-a610-8e4f2efeb032",
            "flavor_7_55296"         => "f37a652a-de10-412d-8365-9ca7f77012a6",
            "flavor_7_65536"         => "f0d6b900-7e34-4adf-a068-2b022dfa4137",
            "flavor_8_24576"         => "257ed973-65cd-4440-a596-51a3d1b0c3bc",
            "flavor_8_32768"         => "dfafdc18-b6c9-4220-9309-66c9aa526a61",
            "flavor_8_36864"         => "0ad08d16-cdb3-4ed9-ad04-383c4d2d8a0c",
            "flavor_8_43008"         => "7ef58835-289b-49dd-98f2-714942171e90",
            "flavor_8_49152"         => "5313646c-1ab1-48d2-b105-dc3fe3e840ac",
            "flavor_8_55296"         => "c33ed1d1-a9e7-4e7f-aaa6-a3dad7757ac3",
            "flavor_8_65536"         => "e6da3ca0-b633-479d-a0d8-433c55cfae95",
            "flavor_9_24576"         => "c2e95897-74d1-4094-aa5b-3c2f13501d3e",
            "flavor_9_32768"         => "33005e97-b39d-40a2-af20-1bfbd834707f",
            "flavor_9_36864"         => "f51e9769-e731-42cc-a052-dbcca9b5543d",
            "flavor_9_43008"         => "e8bec26a-90d5-4c02-914b-2fa7d5b19edc",
            "flavor_10_24576"        => "dd2a41c3-b52e-4bcd-a554-fc6a00be46a6",
            "flavor_10_32768"        => "f08d13fd-c071-4138-9169-026009df4a7b",
            "flavor_10_36864"        => "aa1c2860-f7e8-45a9-aab6-51642105f5d3",
            "flavor_10_43008"        => "0e6f36c8-832d-4292-a971-848248e4683f",
            "flavor_10_49152"        => "87d2b370-429a-48c4-bb6a-c3c641e1035b",
            "flavor_10_55296"        => "7109706d-e3e4-4619-ad4f-524ca4f9e1a6",
            "flavor_10_65536"        => "36bada12-68c4-4c69-a3f5-44a71d10967a",
            "flavor_11_24576"        => "86871dc8-3bf8-4726-a75d-2af977900636",
            "flavor_11_32768"        => "e49b6d1d-ef58-420e-afe3-ecc189497e44",
            "flavor_11_36864"        => "544b0ddc-9b4e-4c21-9c11-3a80e824a054",
            "flavor_11_43008"        => "85ed7a1b-e20e-4826-a369-dd0b37970b11",
            "flavor_11_49152"        => "f78bfb26-a4d7-44ed-a29b-415c8109ac16",
            "flavor_11_55296"        => "a46564cf-6756-475c-99ed-0d75653b247a",
            "flavor_11_65536"        => "2711b03a-109a-4a36-95a8-87e6f1faa5a6",
            "flavor_12_24576"        => "dcfecf97-0b71-47a1-86c8-6987f8fd0f8f",
            "flavor_12_32768"        => "b7fd40bc-018a-4707-b746-4bdf9661ba66",
            "flavor_12_36864"        => "e638c0b0-9bc8-4b7d-b4cb-cc06bc88813c",
            "flavor_12_43008"        => "477c0ef0-89f7-4925-ab35-41162dd9b22a",
            "flavor_13_24576"        => "e8ea0625-71da-4315-b61d-aa84b377c939",
            "flavor_13_32768"        => "0415c889-4e3e-4437-a364-43e1fe178250",
            "flavor_13_36864"        => "126cb86d-09cc-47cf-882e-f1d82e1fae5d",
            "flavor_13_43008"        => "85cdd512-14a3-4263-bac2-08ff38fa9309",
            "flavor_13_49152"        => "a50c364d-7451-4ff9-a8d7-fe95c934edfe",
            "flavor_13_55296"        => "4bad61f3-64a9-47cd-95e0-286f70019033",
            "flavor_13_65536"        => "c2f39eff-d3a4-4cc0-b122-7e00c7964a16",
            "flavor_14_24576"        => "33dd9517-3720-459d-b061-19057c8b47ef",
            "flavor_14_32768"        => "0ed80dcb-2f76-4c18-9a54-c2fc25fb8c9e",
            "flavor_15_24576"        => "1e1aed27-7b00-44f7-b42d-7c41eb93d5a6",
            "flavor_15_32768"        => "82d8d7f4-8d8b-4fa9-8947-481257979bdd",
            "flavor_15_36864"        => "2e42fea8-42dd-4275-9497-de6aaa41c798",
            "flavor_15_43008"        => "cd3663cf-5a8b-4fe6-b19e-073c96adfb31",
            "flavor_15_49152"        => "e163144f-3748-4747-82ba-6ce55a1d41ae",
            "flavor_15_55296"        => "1ef6f008-5e60-458c-bbaf-b846ce091c4c",
            "flavor_15_65536"        => "bfb846c1-f52c-4a4a-b6e2-7cc430b4cfaa",
            "flavor_16_24576"        => "e501a92b-c8b8-4e03-9b7e-4acae27ff241",
            "flavor_16_32768"        => "7945b5fc-c39b-4eab-a75d-3017ddfcdde6",
            "flavor_16_36864"        => "2b6d5ab4-c975-4578-a41e-ec8e6b001938",
            "flavor_16_43008"        => "55544322-26d1-4a6b-9db5-4fa7885fd89b",
            "flavor_16_49152"        => "50973733-e456-43f4-ad9a-2ef08d78538c",
            "flavor_16_55296"        => "823d3d78-2ccb-4903-9531-1eb64a8dccde",
            "flavor_16_65536"        => "d1d9c26f-5437-4ef7-988c-24d36e5ba5bd",
            "flavor_17_24576"        => "51c909a0-17b8-4063-892a-b552e0d25091",
            "flavor_17_32768"        => "60d5041d-6662-42e2-9b0e-c5b633bce7d9",
            "flavor_17_36864"        => "58ecfc57-2647-424e-b9ba-44ca95c081cf",
            "flavor_17_43008"        => "a198554a-6455-4f95-9bae-a0f6e4fcd4c1",
            "flavor_17_49152"        => "ab4c3757-fe0d-4623-b6f5-014f7e54cd26",
            "flavor_17_55296"        => "b28082cb-693a-49c1-aa97-d86dc59b17aa",
            "flavor_17_65536"        => "0f075766-fac8-404f-9ed4-295de6332217",
            "flavor_18_24576"        => "69025595-f327-4c7c-94a2-31a19d91a2b8",
            "flavor_18_32768"        => "ae9f8be8-ef7a-4fd2-a954-86cf4422507e",
            "flavor_18_36864"        => "8835f2c4-c8e1-4bb3-9492-cecbfc13fbc3",
            "flavor_18_43008"        => "12f34149-e87e-4f92-979f-ed8778c67080",
            "flavor_18_49152"        => "8d06a263-bf86-48a6-bb79-8551b91a2106",
            "flavor_18_55296"        => "5cadaa6a-604a-41ee-ae53-441ec485ba8b",
            "flavor_18_65536"        => "1f5531ee-351e-49a1-b8f1-ef848d84c4ef",
            "flavor_19_24576"        => "fc3c3f22-d052-4674-b84b-8dea70fb2054",
            "flavor_19_32768"        => "405eafbe-b5e9-4896-b534-c16ec86df451",
            "flavor_19_36864"        => "1981a6ff-73af-48fd-8562-46269797e982",
            "flavor_19_43008"        => "2eb04aab-31a0-4722-8aff-d40461de8e18",
            "flavor_19_49152"        => "11c45d6e-e491-41ac-a8d4-ac2dbbb1b8be",
            "flavor_19_55296"        => "c3af3bca-31c2-4d0c-9fd9-31465831662f",
            "flavor_19_65536"        => "f7b067ba-56d9-4c11-ad3b-c18f119bfb01",
            "flavor_20_24576"        => "98b23fd3-08dd-4f46-a5e5-3c81555bde82",
            "flavor_20_32768"        => "9452734d-34b0-4c83-a36f-0a3f70df4a51",
            "flavor_20_36864"        => "0c04fc78-f46a-45c6-8747-dea4dce8a13a",
            "flavor_20_43008"        => "898407f7-bef9-4793-8b44-c4cac8f5c35d",
            "flavor_20_49152"        => "8e6f9be6-8679-4e83-9d24-072874c07068",
            "flavor_20_55296"        => "f5607aa6-bccd-4b05-b707-3499f9161a80",
            "flavor_20_65536"        => "95c5e84d-85ea-4b0a-aa74-0af9a22b24fe",
            "flavor_21_24576"        => "d240dd08-ce19-4a67-806b-920fae51cc07",
            "flavor_21_32768"        => "27ec17fb-e8eb-43d3-b8a5-d5040a568061",
            "flavor_21_36864"        => "3478d10f-5a8b-43cd-86b3-7862eb7e9930",
            "flavor_21_43008"        => "675ab895-e09c-4a76-bee6-57b0b3bd0aab",
            "flavor_21_49152"        => "e8ad7405-677d-4c6f-8fb4-a80cd4ac4311",
            "flavor_21_55296"        => "9f4b1f81-1aeb-4b4b-83c4-ecbbb4e6fb77",
            "flavor_21_65536"        => "f9d0d3f9-56d8-48f5-b318-9a3897cbdee7",
            "flavor_22_24576"        => "c50c855f-96fd-4e26-8327-06c2357fad42",
            "flavor_22_32768"        => "441acbf0-2998-42a2-829f-0f88f727136e",
            "flavor_22_36864"        => "846472eb-8359-42e9-9d38-7f28456c326d",
            "flavor_22_43008"        => "6a6b6608-fc29-4a1c-bf52-1901c9724b89",
            "flavor_22_49152"        => "993956cc-0639-48c9-842e-ac9505ef7894",
            "flavor_22_55296"        => "1e23e908-94ef-4b94-b023-88d2ce621008",
            "flavor_22_65536"        => "08841a5e-275f-4449-aa63-51d737979a39",
            "flavor_23_24576"        => "b29ce6ec-327c-40d1-accd-3b0f38e99145",
            "flavor_23_32768"        => "8563bd32-7620-45a2-bf63-2914231554c0",
            "flavor_23_36864"        => "2b572bce-9e10-4531-bd30-eac679324662",
            "flavor_23_43008"        => "faa6490c-b7f6-4f56-a834-a0c75ba16266",
            "flavor_23_49152"        => "94b7ee7c-35b4-4394-9ae2-12044fd2b6c3",
            "flavor_23_55296"        => "bf3f47f0-4c32-4169-a223-3eacdf5ce389",
            "flavor_23_65536"        => "ad964582-ffb1-40f3-b51d-5d724e2ce645",
            "flavor_24_24576"        => "8396171e-e34a-42bf-8170-7af43952622a",
            "flavor_24_32768"        => "2c3ae8c4-02ac-4bc2-bd78-6847cbf3ee18",
            "flavor_24_36864"        => "8aad0fe0-c38a-4a80-875e-2b6911d4bb5b",
            "flavor_24_43008"        => "b689720d-e9c5-49ac-b798-92f2583e9708",
            "flavor_24_49152"        => "b7ffb4bc-5495-4b8f-984d-a02647cfbfd5",
            "flavor_24_55296"        => "6552feb4-4b54-43d1-8bdf-b8fae0646205",
            "flavor_24_65536"        => "dbbb83c0-193d-4b0d-a625-d98df45aaa60",
            "flavor_17_8192"         => "562d40c4-8e63-47f4-8269-e221a1baf063",
            "flavor_17_10240"        => "f47bc3c5-fe0d-4fbb-8704-9797eef35189",
            "flavor_17_12288"        => "68be088c-7c2c-4411-bc32-7fd04c49d708",
            "flavor_17_16384"        => "5304905b-6b13-4d49-a91a-2c48eb60ebec",
            "flavor_22_8192"         => "78596ae4-4936-40a1-bbc6-552baf307d9f",
            "flavor_22_10240"        => "ec7c7996-05b5-4f2c-9800-52325d034838",
            "flavor_22_12288"        => "6f199261-17f7-44a4-ae89-bd84de5024e7",
            "flavor_22_16384"        => "bcd8bb4a-71dc-4c39-8cee-28cfd74b239d",
            "flavor_6_32768"         => "50d337da-7192-484b-9bb6-fcb61f0ce209",
            "flavor_6_36864"         => "6dd25897-a8c0-4a8c-a0c8-cb43e284a562",
            "flavor_6_43008"         => "482de674-0e08-46ae-be5b-ab0e64c20ca6",
            "flavor_6_49152"         => "ec6a89b5-49fc-4a44-9239-46c7d1efc9cb",
            "flavor_6_55296"         => "2dda6e61-eb39-46a0-a973-559f32a925c2",
            "flavor_6_65536"         => "321fdbdc-4536-4f93-b430-f9165d468059",
            "flavor_9_49152"         => "213c6333-689c-49c6-952b-4b56a4c3786c",
            "flavor_9_55296"         => "282a9a50-9c12-4915-bbbc-63b29abc49cc",
            "flavor_9_65536"         => "00ea0971-0f45-417d-bf70-d0fe63bbfd22",
            "flavor_12_49152"        => "95762818-121e-4c6b-b9cb-71b4dbb0cf05",
            "flavor_12_55296"        => "2cdfb501-46b7-42ae-b7e2-f23e05562b70",
            "flavor_12_65536"        => "05b6c7e0-7bbf-4a8a-8425-33fcbf459717",
            "flavor_14_36864"        => "7dcd2b93-30df-494b-bbf1-e6391a5b4ccb",
            "flavor_14_43008"        => "33b08604-2ce6-4046-84a6-1f949d3beb0f",
            "flavor_14_49152"        => "9f78f59f-36c6-4eba-b379-c7aa73d14031",
            "flavor_14_55296"        => "7d327d0e-f763-4b85-a76b-eca1a4179155",
            "flavor_14_65536"        => "9a2c2ddf-b174-47a6-af65-cb372094b391",
            "flavor_1_12288"         => "c19c89f1-60d3-4f1f-86f8-0a36d6a8a567",
            "flavor_1_16384"         => "2eb359e3-af5b-4362-9ad9-2558cb47e4c0",
            "flavor_1_24576"         => "b33efede-8409-488e-b1a0-c5f1f52ad6ff",
            "flavor_1_32768"         => "d2ded857-bbc6-4d85-a0e3-2a3f1c9ffe41",
            "flavor_1_36864"         => "ef7b88e6-1210-4a65-81b9-df1b476dc572",
            "flavor_1_43008"         => "6c7773d2-272d-4a4d-b349-8faaca4a32b6",
            "flavor_1_49152"         => "6fc470d9-a5ee-4ea1-be60-24d325bbcff0",
            "flavor_1_55296"         => "64795180-89ff-4cff-8572-ec21e3de78c1",
            "flavor_1_65536"         => "c467eacc-d5af-41e5-80ef-e2aeebfab3ba",
            "flavor_2_24576"         => "996699e4-40b4-4f97-9f95-ed223d66b7b1",
            "flavor_2_32768"         => "1db44133-34de-49eb-9214-45c599b9dea9",
            "flavor_2_36864"         => "96872fcb-8848-42f4-a637-82d0998bae50",
            "flavor_2_43008"         => "1bfb26d6-1b02-450c-b644-c75b50dc46bc",
            "flavor_2_49152"         => "e056441a-109f-4cd8-b06a-b503749f7ea6",
            "flavor_2_55296"         => "503aa1fc-1d84-433a-9d9e-448820ce4b36",
            "flavor_2_65536"         => "695b6481-f171-43f1-9ec8-868556fc21f9",
            "flavor_1_131072"        => "0eb12688-cf03-4c52-9ff2-5a455614b82e",
            "flavor_2_131072"        => "1a96bc04-e587-4b7f-8194-7cdf88761b7c",
            "flavor_3_131072"        => "7c8823f7-4010-4e04-bdfd-af467939580b",
            "flavor_4_131072"        => "71f17fdf-3b10-4c60-9457-6307a8813c82",
            "flavor_6_131072"        => "680d3a1b-6f73-47b0-ac50-ef258f50ad50",
            "flavor_8_131072"        => "c6957bb9-d9c4-41b0-bfe8-aa11e4cc8b0a",
            "flavor_10_131072"       => "bd4d276e-3756-457c-a42e-c18ee392b78d",
            "flavor_9_131072"        => "b8e32a0d-3018-48ee-b141-1f9a0a78ef01",
            "flavor_7_131072"        => "ef3f0291-5883-4b2b-ac91-0846ac3537c2",
            "flavor_5_131072"        => "7b47d41a-ed04-4853-a25e-05fc7ca28561",
            "flavor_11_131072"       => "ff751de1-b821-4bb0-8ac7-e77f4b6c545d",
            "flavor_12_131072"       => "e7eebdfe-00c2-4379-ba97-496334efe75b",
            "flavor_13_131072"       => "959e627d-a54f-485f-a674-244fb288beef",
            "flavor_14_131072"       => "6a94fc9f-e491-43d0-8c77-1c844918e4db",
            "flavor_15_131072"       => "e75fbbc8-6fb0-4a48-a8ca-5e1f3ff3be83",
            "flavor_16_131072"       => "21aa1966-a717-476e-bdbc-206dc0eeb90c",
            "flavor_17_131072"       => "9677a8e9-1c3f-44eb-a08a-c0477955f2e5",
            "flavor_18_131072"       => "9b71ae5f-4156-4356-bcd6-c1b04a0ce23c",
            "flavor_19_131072"       => "1ef61a7e-4130-4295-8e01-08fec21df6d0",
            "flavor_20_131072"       => "a9e9108b-e9e5-46c9-b0f3-d39acda4dd95",
            "flavor_21_131072"       => "30569b1d-d048-4b3b-a21b-22f0c09f6556",
            "flavor_22_131072"       => "8278473f-9ae8-420e-85de-60940c43f84d",
            "flavor_23_131072"       => "6610e6a5-672a-471e-84a5-9f630b82a6f2",
            "flavor_24_131072"       => "34b942fb-7242-465b-8f99-9af4d8f5fcd2",
            "flavor_1_5120"          => "6ad527eb-8c58-45c6-aca7-226d586d4b23",
            "flavor_1_7168"          => "59c95a68-fb18-4fa1-8159-2738bbc7ffe2",
            "flavor_1_9216"          => "48450d30-ad35-4831-a757-ab748dc3f3c1",
            "flavor_1_11264"         => "213bcfc9-3134-4b45-89e6-a6f3c6a78bde",
            "flavor_1_13312"         => "ed6cdbad-7391-4a1d-a470-3cdb361d399e",
            "flavor_1_14336"         => "b25d0a1a-cf7d-45fd-8fb0-1908db9dcc54",
            "flavor_1_15360"         => "df13bf1a-8a50-4ddc-b1c4-d2874d6a2ea0",
            "flavor_1_17408"         => "9f1205c1-e777-4be2-9a6c-3b37c526c000",
            "flavor_1_18432"         => "56846975-d5b4-4d91-84b2-3418b4481cc6",
            "flavor_1_19456"         => "6484321c-96aa-4aae-8ac0-adf1fcdb1d86",
            "flavor_1_20480"         => "ed5ab11f-f455-4112-8e24-fae3fb1bbbe4",
            "flavor_1_21504"         => "1a427f14-60b2-471d-b271-e74fe2f3e1fb",
            "flavor_1_22528"         => "e8e39323-fc28-4ef3-8f0b-5c2667697741",
            "flavor_1_23552"         => "7c5f7d1e-8b8d-482b-a4a2-c2fb20203707",
            "flavor_1_25600"         => "44fd0511-08a7-4c4e-ac3d-11d8bb2a7d35",
            "flavor_1_26624"         => "9f9411aa-6949-43d3-9098-de71d090745e",
            "flavor_1_27648"         => "fa517a69-f911-4169-bfa2-a308ada0f588",
            "flavor_1_28672"         => "4dfc5e51-a271-4427-8d06-fd841a1d4258",
            "flavor_1_29696"         => "3c0b6dcb-b153-4a61-979d-1a44bc6034d3",
            "flavor_1_30720"         => "ca3d0f0b-2022-45b2-8811-c5d1484bf998",
            "flavor_1_31744"         => "5b52127d-92a9-4482-a59e-0c4a32791d7b",
            "flavor_1_33792"         => "9d17a7e6-0941-4694-89ec-14fb08eb1586",
            "flavor_1_34816"         => "46ff0efe-66b4-4860-9ffd-9c447eb549ed",
            "flavor_1_35840"         => "aee6f238-b0ee-4ae9-8eb8-25f6e83d06de",
            "flavor_1_37888"         => "f35f0dfa-8894-4f2b-b780-32e43f88b679",
            "flavor_1_38912"         => "8dcdf2dc-d1c2-46e1-a6da-d1d82ae82ee0",
            "flavor_1_39936"         => "6188be36-a7cd-4bbd-bc99-89bdc32bb298",
            "flavor_1_40960"         => "3bf4c7b5-0a15-44ee-92f9-da7eaeec14ff",
            "flavor_1_41984"         => "4ec5b983-07b3-404c-91fd-6ff44df4134f",
            "flavor_1_44032"         => "7ed4f4c5-5c79-47cf-a8d9-5a72ef7356ce",
            "flavor_1_45056"         => "6a4a0b91-fac3-447b-9b11-7c75270d450a",
            "flavor_1_46080"         => "2412f893-6eca-42a9-8bd3-c0648064ddbc",
            "flavor_1_47104"         => "46da08a5-06d8-4b2e-9cf9-08b35f1247b5",
            "flavor_1_48128"         => "cd330839-352a-4a97-9b97-2b76abe62aa2",
            "flavor_1_50176"         => "8ea67051-fbc4-4930-9576-d81456f9f665",
            "flavor_1_51200"         => "3be1441a-bb3c-45fd-8016-d0e397589431",
            "flavor_1_52224"         => "c07faac2-f146-4c67-990f-66c0eb2b5e24",
            "flavor_1_53248"         => "e44f2afe-283e-4286-ae76-1237207858a6",
            "flavor_1_54272"         => "946a1439-b8b1-47b4-9868-2248f21d301f",
            "flavor_1_56320"         => "f1c7d9db-a661-4bdf-83cc-6278f1dfe1c2",
            "flavor_1_57344"         => "3302ba87-c933-4586-8129-e3ef087a18c5",
            "flavor_1_58368"         => "259abfa0-8eae-4204-bd71-9e0949c7dbc2",
            "flavor_1_59392"         => "bdc0295f-c458-48ce-b50f-209f582625dd",
            "flavor_1_60416"         => "6c908a00-e8c5-4b7a-91cb-0d26e9eb23a4",
            "flavor_1_61440"         => "38fc8e75-a32b-463d-8f6e-fda1c19c0769",
            "flavor_1_62464"         => "9b67c845-3628-4a26-97c1-11bb36078e54",
            "flavor_1_63488"         => "32547fe6-d346-4e2a-afb5-cb50bb4049df",
            "flavor_1_64512"         => "7b6f907f-361f-4e51-936e-b83773b3918f",
            "flavor_1_66560"         => "da68e9b4-713a-437b-9e0c-688600575671",
            "flavor_1_67584"         => "59d2bcd7-641c-4ed3-b98c-375509587fe2",
            "flavor_1_68608"         => "b75624dc-3a83-49ff-a1de-407b7bcec689",
            "flavor_1_69632"         => "9aafa1a2-eba5-4ec3-b748-5302fc29c823",
            "flavor_1_70656"         => "74f37390-456d-4fc8-b851-09e571c04d78",
            "flavor_1_71680"         => "3e72e6b7-894c-4c92-9f41-4ca930c52910",
            "flavor_1_72704"         => "6f6f4300-d934-43ad-8e61-d4b10a3107e0",
            "flavor_1_73728"         => "87540901-65d1-4c90-98f3-e95b1fe435ec",
            "flavor_1_74752"         => "defda167-10ae-4fac-bcc6-f9915c0d610e",
            "flavor_1_75776"         => "b7eea908-e78d-41a4-a92d-7a650aa69c05",
            "flavor_1_76800"         => "c07835f3-71ed-4c1e-84ab-aaae36e5e1c5",
            "flavor_1_77824"         => "8278d296-d8a4-4dd2-be0a-a82fc427e940",
            "flavor_1_78848"         => "31addcd2-ae64-44d6-89b4-e849d077d703",
            "flavor_1_79872"         => "7f2b3843-649c-4f32-97e8-899cf5700ca6",
            "flavor_1_80896"         => "698638f9-9b9b-4171-a459-eba8839324d4",
            "flavor_1_81920"         => "24f21b0c-604f-4862-9126-d3c841b09c3f",
            "flavor_1_82944"         => "0325c3b1-3fe3-48ae-80b5-6fd3154e8000",
            "flavor_1_83968"         => "f42f14ee-96f0-4dce-a3c0-d526a809d5b5",
            "flavor_1_84992"         => "2c97a90f-f4fa-4e45-a3ab-608c69cc245f",
            "flavor_1_86016"         => "681502b9-d833-450a-994a-c1a927ffc953",
            "flavor_1_87040"         => "bbaf2ead-ebdf-46e0-9d79-0ea15c96cadf",
            "flavor_1_88064"         => "a3322a3f-322a-4022-b8cd-685365cebcc5",
            "flavor_1_89088"         => "cf0d1694-44be-41ae-b609-4ce6c6183ce6",
            "flavor_1_90112"         => "8fce9d65-6e47-4b9a-b390-2d1be3e4915f",
            "flavor_1_91136"         => "13cc04ec-e343-402d-9dc3-2e78aba27367",
            "flavor_1_92160"         => "7b3e2f7f-6e47-4976-a195-7132d66acc38",
            "flavor_1_93184"         => "4edc7c0f-5ec7-4026-8dee-9ef93b4d223a",
            "flavor_1_94208"         => "2cea1ad9-4451-4254-9d33-72eeb7141459",
            "flavor_1_95232"         => "cc7fed50-e112-4632-86ab-046235ebc83d",
            "flavor_1_96256"         => "3a2a82a2-4397-4553-a21e-d0a5df16fe45",
            "flavor_1_97280"         => "2c0e5652-e512-4ae9-955c-005e63228e7b",
            "flavor_1_98304"         => "bfa5025d-a254-44bd-b539-920320b9b5dd",
            "flavor_1_99328"         => "63ced44c-cd8b-460b-80d8-8d99b3993b2b",
            "flavor_1_100352"        => "994d1d9a-088c-478a-a11b-2919b6b2f00e",
            "flavor_1_101376"        => "64fe0d19-3893-4f30-91d3-7dd3cc9c35c8",
            "flavor_1_102400"        => "9d196395-2fc8-48af-9367-2c8b8a99a2ff",
            "flavor_1_103424"        => "805099d8-1866-4f09-abce-72556fed9d7a",
            "flavor_1_104448"        => "f511e030-6136-42fe-9672-aa9a52cb89d8",
            "flavor_1_105472"        => "2e82085a-807f-4d0f-8e30-e0b4ce883ddd",
            "flavor_1_106496"        => "1e997ce4-423f-4d40-9a08-5b25b053252e",
            "flavor_1_107520"        => "aba87df7-3f3f-433c-9a76-96b15533859b",
            "flavor_1_108544"        => "74c988d9-cb81-429d-b59c-264e9f4a2788",
            "flavor_1_109568"        => "d133e34f-dd49-4f3b-ba06-3764443828b4",
            "flavor_1_110592"        => "0492cc50-ab0b-4102-8a32-26e1a3c1dca1",
            "flavor_1_111616"        => "210df4c1-d39d-4c30-b37a-58fa48385987",
            "flavor_1_112640"        => "6cdf169f-1eac-4488-b614-be8c5c788398",
            "flavor_1_113664"        => "c7b475ca-3373-4c52-8cb6-06c463bba129",
            "flavor_1_114688"        => "164ac92a-ff2c-4ea2-bae8-2827b468d8c0",
            "flavor_1_115712"        => "a8b69616-7c50-450e-97b9-e543edf679eb",
            "flavor_1_116736"        => "b9582210-ad00-486f-9242-abd6c8437413",
            "flavor_1_117760"        => "43580712-589c-4362-bced-f042e0bf256d",
            "flavor_1_118784"        => "9d74a1a5-d75d-47df-81f5-a460e92abc30",
            "flavor_1_119808"        => "ae153d84-0b86-4b65-b670-f4a36b686d80",
            "flavor_1_120832"        => "a6abdcfe-2c14-4be0-a54b-416ca01231e4",
            "flavor_1_121856"        => "eab4cd6d-b7e6-4738-ae43-7ab24fc02a0c",
            "flavor_1_122880"        => "e724b39b-2fed-4ab4-9d91-02026fdbde1f",
            "flavor_1_123904"        => "6409d41b-8733-4e09-8e18-0b4bdc049d5d",
            "flavor_1_124928"        => "6b72a9e0-7beb-44ff-bea0-a4c63df71c79",
            "flavor_1_125952"        => "a7b57e36-79b1-4d4f-a2ea-14bf40b37710",
            "flavor_1_126976"        => "404b5e10-3974-48e8-9ef9-0aec0d1a284c",
            "flavor_1_128000"        => "986acd7d-c471-47d8-bde4-82db15846e31",
            "flavor_1_129024"        => "69a8f673-5f73-4052-a908-627502d2a51f",
            "flavor_1_130048"        => "e45b3a1a-547c-49be-aa81-5c042e125f9b",
            "flavor_2_5120"          => "2b90fa40-7b1f-424a-8e04-08ec5988c4b4",
            "flavor_2_7168"          => "d4caeb83-03dc-464d-bd20-92ebcb0cd5a4",
            "flavor_2_9216"          => "29bf492d-a9da-4152-80da-adcb84127bef",
            "flavor_2_11264"         => "8c3eecc5-bf9c-4f7d-b8dc-8713cb87d0f9",
            "flavor_2_13312"         => "789f3708-c51b-49dc-8c84-5a443f871569",
            "flavor_2_14336"         => "50b00deb-d3dc-4ba6-8807-1b35355a57c4",
            "flavor_2_15360"         => "46238ab4-a27f-4481-81d0-7404e6755a96",
            "flavor_2_17408"         => "c1a72bfc-1e71-4282-b5b7-53cdd3823519",
            "flavor_2_18432"         => "8e6340a0-226b-49ce-8a50-808e27004565",
            "flavor_2_19456"         => "65b91e48-f642-4c2c-bbe8-10e80760266a",
            "flavor_2_20480"         => "bd14b5d7-c44c-42c5-97dd-ecf7cd7d3baa",
            "flavor_2_21504"         => "2b8ba72f-bafc-4bf3-a361-dd258c013318",
            "flavor_2_22528"         => "3d40096d-9d8e-432a-becf-446ea369f8f0",
            "flavor_2_23552"         => "3db34b93-b9ee-4359-a099-bacd871a9df1",
            "flavor_2_25600"         => "95f1a1a8-3214-4765-b107-b5d480606022",
            "flavor_2_26624"         => "6dbdd233-0a32-4680-b3d0-23531148bbb0",
            "flavor_2_27648"         => "759aac75-22e0-45ef-99bd-45630488fea6",
            "flavor_2_28672"         => "de2b4488-5d19-4dbd-a4a1-05de81f65bc7",
            "flavor_2_29696"         => "725ca10e-42f9-4690-9438-9e67a63cb351",
            "flavor_2_30720"         => "4417d930-1ee3-46f1-9f43-28c9630ba296",
            "flavor_2_31744"         => "469c939c-3e65-405a-b36c-3a19d813b7a2",
            "flavor_2_33792"         => "91e0613c-a6be-4d99-bc0d-62a4fe7b4f65",
            "flavor_2_34816"         => "7335d913-4bdf-4d6e-8c17-3b4247fc937b",
            "flavor_2_35840"         => "63f99d00-e5f7-4ff9-9dc4-0ec8309e320e",
            "flavor_2_37888"         => "b1d29001-9a0e-4d41-a173-1fc28fd4a1d6",
            "flavor_2_38912"         => "85c32ac0-5a93-4390-8f67-9c8e38b79b65",
            "flavor_2_39936"         => "f22e7784-4fca-4d06-8cc4-55e2e850da3c",
            "flavor_2_40960"         => "3a4b8470-11dc-42c1-aa2c-4c7f6a95a9c9",
            "flavor_2_41984"         => "664ea48f-eee3-4435-a9ea-9e2812f20c7a",
            "flavor_2_44032"         => "2091148b-bd94-4350-a2cf-0313bd301b9e",
            "flavor_2_45056"         => "66fa0edd-368c-4545-9457-b1007bbe9e9f",
            "flavor_2_46080"         => "0f89a1ca-e15e-41ce-9ff0-92fa56b81051",
            "flavor_2_47104"         => "88eeb2fb-95d1-41c7-b290-bc78c1703fb4",
            "flavor_2_48128"         => "3a84a5d7-af77-4840-a65a-e7389c85e75f",
            "flavor_2_50176"         => "a838355e-2731-469a-b9ca-394841d7d263",
            "flavor_2_51200"         => "14a8ede5-9947-4b4c-bb17-66c2487601aa",
            "flavor_2_52224"         => "bf6d0614-f0fc-4b78-9889-e914cd3b3f48",
            "flavor_2_53248"         => "75e85597-546a-4731-bbca-8b93e5cf47a0",
            "flavor_2_54272"         => "43d4c94c-a67c-4f55-a97d-9e84d027153b",
            "flavor_2_56320"         => "56c5ec32-7c2a-41fd-a05f-3434cf5398e9",
            "flavor_2_57344"         => "ee4b473a-d2be-47b0-8dd9-dab1fde87c08",
            "flavor_2_58368"         => "90f2b1e5-4554-4b6d-9540-1153586ba348",
            "flavor_2_59392"         => "40b6434c-e862-46bf-ad41-0362cdfad5dd",
            "flavor_2_60416"         => "cfd41049-61fc-450e-b532-f5c3d584ac83",
            "flavor_2_61440"         => "6cbd86d4-63b6-4b3c-9187-c70236d5405e",
            "flavor_2_62464"         => "599bc870-8706-43dc-b6a3-82e0a262e7e2",
            "flavor_2_63488"         => "dbfd834b-77d2-40cb-bc75-cb347b8eaac9",
            "flavor_2_64512"         => "528e1ed3-6caa-4e16-9432-a958aefc5d30",
            "flavor_2_66560"         => "dd8276b1-8010-41ac-b092-c8e3cbe7a766",
            "flavor_2_67584"         => "5f8c8baa-f06b-4010-aaed-ab88f4427b45",
            "flavor_2_68608"         => "e0ef6013-5f73-46e9-a888-db1577d960c9",
            "flavor_2_69632"         => "bc5bd96f-1ae7-4484-b8e0-8cd94d776837",
            "flavor_2_70656"         => "98da74b4-8229-4b20-a21f-238c2e5f8ef3",
            "flavor_2_71680"         => "1721cb37-602a-4e03-b63f-352be4a8b145",
            "flavor_2_72704"         => "73355637-8a47-4aae-993d-0c4f8f226342",
            "flavor_2_73728"         => "f1a8b8c0-8d64-4fb1-8866-cc81566575d6",
            "flavor_2_74752"         => "db862a33-b8e7-4a0a-b172-5e09a3d1c0cc",
            "flavor_2_75776"         => "9de956d6-c71d-450e-94b7-a5dbd061a403",
            "flavor_2_76800"         => "259ea815-4758-414a-b1dc-8e944fd8db9e",
            "flavor_2_77824"         => "139c8dac-72fd-433d-a50a-4fecece5902c",
            "flavor_2_78848"         => "93e8df3f-40cf-4f6e-8152-0b610a862f5e",
            "flavor_2_79872"         => "63adf3d7-06f3-4f3d-b8c1-d596cf317c02",
            "flavor_2_80896"         => "9f99742f-c4be-4475-9f53-9d39e3bdaded",
            "flavor_2_81920"         => "b1d778a6-37e4-4796-a329-83552180a275",
            "flavor_2_82944"         => "8e8a9d07-ea05-48d7-9fc5-baca786c25a5",
            "flavor_2_83968"         => "874c2e51-aaf6-4e81-8186-c5e73aae74f2",
            "flavor_2_84992"         => "6e1d21b5-54ed-438b-8f83-963682372cd5",
            "flavor_2_86016"         => "633a27f4-d574-418e-b0d3-74153f4bdb31",
            "flavor_2_87040"         => "b13b3f18-16f1-4b5b-b338-ce16c0324a90",
            "flavor_2_88064"         => "59a2ab82-b837-4635-8cdf-b62cf2c5b184",
            "flavor_2_89088"         => "6ef785dd-14d6-40e7-827a-78c7a484819a",
            "flavor_2_90112"         => "c514961b-795e-4ae4-b44f-39d115ae105f",
            "flavor_2_91136"         => "ce9f1550-680b-43d9-94b2-598b886faec2",
            "flavor_2_92160"         => "697eccf5-3af6-4914-84e5-837aaf16575a",
            "flavor_2_93184"         => "6a580254-ae72-4a3b-9248-ee97869b2723",
            "flavor_2_94208"         => "c133271a-7361-41f8-be33-5e7524e2da51",
            "flavor_2_95232"         => "1da19d9c-6f8b-4d87-8579-0f7077ca8403",
            "flavor_2_96256"         => "5658b27e-ee92-4800-b27d-b8e02514e81a",
            "flavor_2_97280"         => "625ae53f-a772-437f-8bc8-753c9626ed7f",
            "flavor_2_98304"         => "7895a6ce-2496-4fce-8ca9-bfc2061a903f",
            "flavor_2_99328"         => "2a352c92-a6a9-4389-a1b3-4b9ac6e0a035",
            "flavor_2_100352"        => "6dd73125-ca62-4c7b-bf4b-dfd29f9f03d0",
            "flavor_2_101376"        => "afbc6da7-1a80-461a-b797-2365b8113634",
            "flavor_2_102400"        => "68c67fbb-40a7-4532-b2fd-41f8dcedc4e3",
            "flavor_2_103424"        => "b619410f-1c8f-40a0-a31b-a73eccdd37d0",
            "flavor_2_104448"        => "17b009cb-37e1-4b00-9ee9-52872c68d62a",
            "flavor_2_105472"        => "ac5645df-4207-4837-8eab-d96390a7d240",
            "flavor_2_106496"        => "7033bc36-b180-4d86-a602-4824d1b81071",
            "flavor_2_107520"        => "58c5095c-8eb7-431a-b98f-1e533d673a00",
            "flavor_2_108544"        => "7d233b14-aecc-49fa-9e86-9125add96376",
            "flavor_2_109568"        => "9ebd00db-80aa-4d21-b8e8-7daa5380f66d",
            "flavor_2_110592"        => "b00eb2c0-5d25-4127-beca-1733c7414d3b",
            "flavor_2_111616"        => "81baf700-13ed-4604-8739-b99c60bbcb09",
            "flavor_2_112640"        => "9c1106de-17d9-4d0b-81cf-43200e2407c6",
            "flavor_2_113664"        => "e1732adb-2a81-424d-9033-249d34555543",
            "flavor_2_114688"        => "536495ef-879d-4ab3-8078-5b9c76e7b20b",
            "flavor_2_115712"        => "b984c7e6-809c-4f98-960b-24206187b0f1",
            "flavor_2_116736"        => "e7f12f85-fbb2-4b0c-b073-667deffdc548",
            "flavor_2_117760"        => "d35228c0-3e83-4443-b04f-a427a6bf57ec",
            "flavor_2_118784"        => "ffa778ec-af66-48b2-aee8-d48bc0e88f2d",
            "flavor_2_119808"        => "7fef059f-ea12-4520-9520-1d0a1db35446",
            "flavor_2_120832"        => "6c439eec-c064-4ee1-a522-2f41486456ac",
            "flavor_2_121856"        => "8e33f839-e1a3-4a7a-af9a-487b874beea5",
            "flavor_2_122880"        => "02192387-78f9-4e45-9b5e-2d04603e0ddb",
            "flavor_2_123904"        => "adf91bb6-7a89-441e-b123-7ca099a1eab5",
            "flavor_2_124928"        => "d10f8547-561c-4668-b534-0de4fc6eb659",
            "flavor_2_125952"        => "f0d479a4-9a53-40db-9d41-476ce401c55f",
            "flavor_2_126976"        => "0518aaf5-e6b3-480d-b170-3e79223a2d82",
            "flavor_2_128000"        => "354ecfa7-b77b-4e17-8b62-ee2b9c0d3d29",
            "flavor_2_129024"        => "c4aec844-6cc5-4e25-b48c-46dec61e74f1",
            "flavor_2_130048"        => "a7f246dc-4e4e-4919-9db3-c6ec388412d1",
            "flavor_3_5120"          => "9fbb2821-83e6-408d-83d3-961c4452ef4c",
            "flavor_3_7168"          => "b86e2770-6b83-4ed1-b28a-bed37cb41acd",
            "flavor_3_9216"          => "4550ee95-c61f-49c5-b8d7-5c58a875791b",
            "flavor_3_11264"         => "0e11e075-8506-44aa-bf4d-ad0ba1c52026",
            "flavor_3_13312"         => "fbb06699-3617-4dfa-b693-462fc4cb3872",
            "flavor_3_14336"         => "ed6fc190-79ce-440c-92bc-e72370cf4366",
            "flavor_3_15360"         => "1d47118c-c90c-4dab-85be-bf069b9d8617",
            "flavor_3_17408"         => "3092fe3b-cff4-4556-ac95-568509c2d8fb",
            "flavor_3_18432"         => "7680a790-37cd-4f9c-80d7-d1ae1cc7bc92",
            "flavor_3_19456"         => "264a607c-e58d-438a-ba71-52fb040e3523",
            "flavor_3_20480"         => "fbc52281-7c05-4c7b-9791-3759d1a0a623",
            "flavor_3_21504"         => "03a45d53-8141-4604-a4ee-ce5cb9fe01b1",
            "flavor_3_22528"         => "d3bdb3d5-ca17-49f8-8e0e-50e1f897b201",
            "flavor_3_23552"         => "6623ec44-514b-4c23-962a-9d98c8d26add",
            "flavor_3_25600"         => "1da2be26-6860-4619-9d0e-cc8a70f7a24c",
            "flavor_3_26624"         => "d91398ea-bb3d-4831-8fb9-70ee7977e7e1",
            "flavor_3_27648"         => "0f96ac89-15b6-4f1f-9644-4feb22e52b08",
            "flavor_3_28672"         => "176d1777-d8ad-4657-a3f4-985d0b29885f",
            "flavor_3_29696"         => "d2fa0daa-ca7c-4d27-bdd3-fadbd05fa771",
            "flavor_3_30720"         => "1d5ddbf3-bf7f-43ff-938e-03526bed5de2",
            "flavor_3_31744"         => "d513c1f3-543f-415e-8cb8-b50b84077982",
            "flavor_3_33792"         => "55c9cab8-8e91-4b85-8785-0bcdd31c2ad9",
            "flavor_3_34816"         => "00d3ed24-8781-464b-bece-26e0f555d80f",
            "flavor_3_35840"         => "bfd559b9-ca4d-4376-8bc3-a636abdc7e9c",
            "flavor_3_37888"         => "f0014170-50cf-4036-a06b-ba60fd2b08f8",
            "flavor_3_38912"         => "d400ca21-532e-4dca-a6ad-2be2381d6a33",
            "flavor_3_39936"         => "fca6c0d9-e377-43ba-8fe5-9610f421467c",
            "flavor_3_40960"         => "f233cb5e-8377-4fe8-b59e-c34d2cb19720",
            "flavor_3_41984"         => "7095d738-243e-44a0-8f8d-110ebc67d6e8",
            "flavor_3_44032"         => "0c0d2c4d-3e37-4d9d-8412-6c8ad26e16cf",
            "flavor_3_45056"         => "2346abf8-5a19-4fb7-8ae2-b048f14264c4",
            "flavor_3_46080"         => "6f353c1c-76c3-418b-91de-9e3ce95bac27",
            "flavor_3_47104"         => "110d11f6-cb77-4a0b-889c-c64e7444d7fc",
            "flavor_3_48128"         => "0bba8925-6143-42c4-a2cd-c8f6245f4bca",
            "flavor_3_50176"         => "1a565934-8855-4c0d-a1ce-1520a1d4bae5",
            "flavor_3_51200"         => "c17b79f9-eb65-4e76-82a1-b5d20d2f86de",
            "flavor_3_52224"         => "c8878abe-8b57-4920-ac52-fa1b6a5f82ec",
            "flavor_3_53248"         => "5f87f335-4c69-401d-9cd5-5e6d12385b24",
            "flavor_3_54272"         => "0f19ba3b-a75b-456e-9554-45cfcad45250",
            "flavor_3_56320"         => "bf18b36a-8431-42be-83c7-631874f97810",
            "flavor_3_57344"         => "3878d65d-4d73-43c1-b5cc-a3fde56468dc",
            "flavor_3_58368"         => "aac22980-e856-4436-9c4e-f5f061f4ef01",
            "flavor_3_59392"         => "e204ed13-b8e9-4a4c-bbf1-362952d7f0cc",
            "flavor_3_60416"         => "49664d03-5993-488d-95c1-9e409263ef62",
            "flavor_3_61440"         => "a925987a-9e61-404f-b07c-4d66013203cf",
            "flavor_3_62464"         => "033fbd8a-1f6c-437b-95b3-e17f3ecfda99",
            "flavor_3_63488"         => "39d720de-026d-4059-84ac-0fcf834eb031",
            "flavor_3_64512"         => "775e291d-9721-49d1-87b9-ec30149d3de2",
            "flavor_3_66560"         => "effb4734-f232-4317-8516-2511e38b5c77",
            "flavor_3_67584"         => "df6ac4b4-5fef-4d30-9a04-81e2eb0f1dcf",
            "flavor_3_68608"         => "fe283cec-31b6-4366-bc85-7674001d659b",
            "flavor_3_69632"         => "379a08a3-06c8-4575-9da8-fba2a94f1ec0",
            "flavor_3_70656"         => "26745f6d-201c-493f-a027-6fddf8da787e",
            "flavor_3_71680"         => "1b9437f7-4a7c-4dc1-b40f-05ca7254faa1",
            "flavor_3_72704"         => "65151e0b-87a4-4bd5-80ee-cde659923ab0",
            "flavor_3_73728"         => "12d97d39-bc69-40ea-a5a7-7a291666254f",
            "flavor_3_74752"         => "43bd82e5-8355-4bb0-bc84-2e230d1cd425",
            "flavor_3_75776"         => "1101a520-0bab-4dcf-820b-fc13bfc6ad66",
            "flavor_3_76800"         => "1df9eceb-168f-4ee3-9a1d-9175fc6aba80",
            "flavor_3_77824"         => "80d91c94-2c4a-462a-b657-b1367b140f89",
            "flavor_3_78848"         => "fddc5f5b-1078-4825-9d53-1c8b4da83dd9",
            "flavor_3_79872"         => "a4075778-b0d7-42c4-904e-82d185a1d537",
            "flavor_3_80896"         => "c3e8c8af-2219-4333-aa32-e920a00cdacc",
            "flavor_3_81920"         => "27e73e71-ca16-4935-aded-7688a712afa9",
            "flavor_3_82944"         => "3696628a-961b-46a5-8913-0d9dc852d283",
            "flavor_3_83968"         => "20d3d7b2-ea3f-49c4-a385-9bd8d43c40eb",
            "flavor_3_84992"         => "d3289441-2737-48e6-a31f-30a2e082a67e",
            "flavor_3_86016"         => "2dfd1d55-4a16-4134-96b0-6daac2156c82",
            "flavor_3_87040"         => "55ac8022-72ab-4f5b-a75d-d5594d2eb4e6",
            "flavor_3_88064"         => "85437f8a-1188-41e6-9e60-861c4212f51e",
            "flavor_3_89088"         => "e0ba2cdc-a938-46c1-81dc-f0065f0d7cbe",
            "flavor_3_90112"         => "92e66786-f153-4a17-8610-05213adfa396",
            "flavor_3_91136"         => "cc58976e-9349-49c0-9d21-0e742d17a5e9",
            "flavor_3_92160"         => "8f640410-6d9e-4095-9f36-c5a4047bc6c2",
            "flavor_3_93184"         => "b31d59b4-b115-43b2-9dbe-eccc0a5d6534",
            "flavor_3_94208"         => "c0e1f315-9437-4b14-9aab-d0b11827ddf8",
            "flavor_3_95232"         => "8268d9f1-2f67-4546-8013-be5b90f1fbba",
            "flavor_3_96256"         => "ae650117-dbf7-4b77-acd6-8c72f5dc1df7",
            "flavor_3_97280"         => "8f9ce196-9e12-42a7-9e1e-908188d02eb2",
            "flavor_3_98304"         => "8de39726-daa3-4f92-bbd3-58c2641cc108",
            "flavor_3_99328"         => "aa2dbe6f-6e96-445a-8700-96cda0931182",
            "flavor_3_100352"        => "48139835-361f-417f-b14b-c2c21c7c9f2b",
            "flavor_3_101376"        => "0052e7d0-8427-41c6-9f40-9ee277a5cc37",
            "flavor_3_102400"        => "31e1ee5c-21c1-4c9c-801d-ba2825548cd6",
            "flavor_3_103424"        => "b38d63dc-6194-40e7-8275-995679183217",
            "flavor_3_104448"        => "cf3f63bd-62b6-4e76-9f1c-e9fa7c178b29",
            "flavor_3_105472"        => "5fd00cf0-0941-4cfe-bf85-3da0dda53ece",
            "flavor_3_106496"        => "69df452f-ed03-4267-9b3b-7e5229131122",
            "flavor_3_107520"        => "49d0a413-ead7-436d-b420-73c329c5a58b",
            "flavor_3_108544"        => "06084ce7-12d4-4d39-87e8-bb425e1f13ec",
            "flavor_3_109568"        => "2dc428eb-fa6f-4b9d-9add-4f24f98a3885",
            "flavor_3_110592"        => "f45f94c3-109c-4d37-bd96-859cdf626aa5",
            "flavor_3_111616"        => "6ecf9a96-872b-462b-903a-5247dfb81ecb",
            "flavor_3_112640"        => "5c783602-408d-49d5-859e-b578045adda1",
            "flavor_3_113664"        => "2da6fb38-eb16-4a76-949f-d965d5c2096d",
            "flavor_3_114688"        => "c0022472-5043-442e-a34a-ddbec51c9fbe",
            "flavor_3_115712"        => "7b422a66-0e44-44dc-9a4b-8e66b17d0e62",
            "flavor_3_116736"        => "ad244572-005a-4db2-bc7f-9b9ee99ca32d",
            "flavor_3_117760"        => "165f32cc-cdb8-4675-b198-8a99352acfab",
            "flavor_3_118784"        => "7de1ffc6-34c5-4495-930c-b24645198e76",
            "flavor_3_119808"        => "a30507eb-92b1-4017-a160-87be681a0841",
            "flavor_3_120832"        => "17edbf7d-5f7c-44da-9458-a212ffaeb93d",
            "flavor_3_121856"        => "d5f2027b-0c73-4662-841e-19fa088c31ac",
            "flavor_3_122880"        => "6df5a49f-a797-4ab9-860a-254fe7065a4e",
            "flavor_3_123904"        => "918f0686-2126-4e94-9d5f-0bdee9dd55ab",
            "flavor_3_124928"        => "eb39f39a-3d7b-4bd7-b2b2-e5a55bdc8f80",
            "flavor_3_125952"        => "8e4d1b08-17ef-41ed-b572-78e636b14004",
            "flavor_3_126976"        => "e9a9234f-9964-4df2-8ec0-3cf55015bde4",
            "flavor_3_128000"        => "0fe47a6d-06c4-47da-a3d7-73ba289a1817",
            "flavor_3_129024"        => "60f28523-a6d4-4257-bc6f-78f4280440c6",
            "flavor_3_130048"        => "58cccd0d-afe7-4a66-a1fa-84cd3e3b3662",
            "flavor_4_5120"          => "559dbe56-a80b-4d3e-8c9c-8bc01ff3b858",
            "flavor_4_7168"          => "ed0d35d6-7603-4194-a96a-52fa11ba9aa1",
            "flavor_4_9216"          => "8b5560e8-4486-465f-8413-e71f21b9c60c",
            "flavor_4_11264"         => "fd3c15a0-82e7-4d6a-815f-76c027e48368",
            "flavor_4_13312"         => "6f334a36-bb5a-42de-bbb0-9b2820aeacfc",
            "flavor_4_14336"         => "85f81b59-8b24-4832-b5e3-67bc3b65de57",
            "flavor_4_15360"         => "fd477741-528d-416e-a459-cfdc02396ab3",
            "flavor_4_17408"         => "b4fb0770-661e-4f21-a934-aa8cc377240b",
            "flavor_4_18432"         => "e2ad48b6-8709-43e7-945f-2dc2056dce42",
            "flavor_4_19456"         => "4087e9b4-3f40-439a-8d8f-4569bcda2af2",
            "flavor_4_20480"         => "5912e5a1-dbe5-4d34-8f70-3c545f7d4c83",
            "flavor_4_21504"         => "8985f981-663a-4ed6-9b4e-0a049f78f339",
            "flavor_4_22528"         => "9d1ba187-5fbe-470a-bb31-dc2bbef3160b",
            "flavor_4_23552"         => "d041f2f6-102e-4f32-9e37-d9ed9c3bba5e",
            "flavor_4_25600"         => "505fb5d6-901b-4899-b8c8-92bf81ff4fa5",
            "flavor_4_26624"         => "a2f832ab-054d-4a11-917c-2a93729d0767",
            "flavor_4_27648"         => "121fc293-cd7f-4f36-a579-663aa469a07e",
            "flavor_4_28672"         => "c6a43844-408d-44f3-b591-6ab078d3eaa3",
            "flavor_4_29696"         => "f9e51f29-0083-497e-b987-34c164e38701",
            "flavor_4_30720"         => "947c2749-4191-4f18-a9f1-5284a7f57247",
            "flavor_4_31744"         => "5c584d57-18ea-410e-85c2-84360b4b89d7",
            "flavor_4_33792"         => "5725c108-80be-4c2b-9152-ca814cb3a1ab",
            "flavor_4_34816"         => "aca9ec35-0cb5-4f7e-bfdf-81ba45c3399d",
            "flavor_4_35840"         => "42630e32-72cd-40c9-ae7a-e1d8981cedda",
            "flavor_4_37888"         => "21864ad1-9523-4dec-addd-51d72bb7ed1c",
            "flavor_4_38912"         => "0949e220-ca6f-4e62-86f8-b519f2230a5c",
            "flavor_4_39936"         => "f6a772a8-ff73-410c-ab48-6ae4151e1033",
            "flavor_4_40960"         => "99af565b-2730-4a8c-a78c-d861e01e34da",
            "flavor_4_41984"         => "20c3c0f5-7792-424c-a9e1-3527004477d9",
            "flavor_4_44032"         => "39ed530c-5eb4-488e-bdf2-e02656d02658",
            "flavor_4_45056"         => "9817bf43-8a59-41a7-a0b6-a9de9d5877cf",
            "flavor_4_46080"         => "e5b8a266-9c92-4925-8c99-9c9246e4c0f6",
            "flavor_4_47104"         => "f5237964-2167-4800-8c1f-3c933b56fe27",
            "flavor_4_48128"         => "3bac575f-f913-44d7-8c2f-f7d44fd2a9e6",
            "flavor_4_50176"         => "afe63d85-01be-4c98-882c-6bf6453c0232",
            "flavor_4_51200"         => "302295e6-917d-4f5f-b3d3-9e6bbc214c26",
            "flavor_4_52224"         => "950eee18-9fa6-436e-a2f5-20b9144049f3",
            "flavor_4_53248"         => "83716ae4-96ba-4517-9f81-4024849577b5",
            "flavor_4_54272"         => "cc258587-e9e3-4cce-922c-210ca5f0f604",
            "flavor_4_56320"         => "e705851f-af7f-4367-94e3-82d8bfe713ef",
            "flavor_4_57344"         => "521f48af-a7e4-41ed-8f40-4c66ac4ec4d8",
            "flavor_4_58368"         => "08ac7383-6568-4c92-b405-aaf36e4bb77d",
            "flavor_4_59392"         => "1e20bd02-19b6-467c-ba42-a614ea026fc1",
            "flavor_4_60416"         => "87537462-1cb5-4ecb-8cac-7212ab7eebb4",
            "flavor_4_61440"         => "d52704bc-0d4c-46a0-b843-dc2ae519474f",
            "flavor_4_62464"         => "7860bd7d-a562-4ffd-840a-88d7928cb148",
            "flavor_4_63488"         => "11bee9d4-5343-4659-ad00-29ebc4a4b142",
            "flavor_4_64512"         => "2ca65068-f992-4526-97ea-3f39d398693a",
            "flavor_4_66560"         => "e2afc6ee-bfad-472f-858e-f5451728c5d3",
            "flavor_4_67584"         => "c4761937-c340-4c42-b909-89c785de7878",
            "flavor_4_68608"         => "5a15182b-0b00-4eda-9b0f-760077722f1c",
            "flavor_4_69632"         => "8aa4b1cd-5a48-45c1-9d33-c769e1b4719b",
            "flavor_4_70656"         => "14d1cfc6-8b11-401a-92c9-e4bd4c942553",
            "flavor_4_71680"         => "3c5742b5-641d-4ded-9271-561132b13460",
            "flavor_4_72704"         => "890e77f9-305a-4673-ab12-90d834dad7bb",
            "flavor_4_73728"         => "6d2c3b45-e543-458c-a11b-d2d34693811e",
            "flavor_4_74752"         => "59c55524-49fb-4cad-a37f-d8f600fa6093",
            "flavor_4_75776"         => "fa07c10a-a435-4a5e-8ed3-fc5627f8e1c0",
            "flavor_4_76800"         => "ee717bdb-7747-4832-8107-2cd0a9acedf8",
            "flavor_4_77824"         => "e1edd4a8-dd94-4049-9ab6-10f6db134ad9",
            "flavor_4_78848"         => "8530b744-b064-400f-b565-e64b6ca751b1",
            "flavor_4_79872"         => "9a1c94e5-521f-4b24-af50-4e622f501e0b",
            "flavor_4_80896"         => "35a9d834-7365-4761-9ef4-de72f0d4c82d",
            "flavor_4_81920"         => "4ba3a9e4-70cd-4b46-94b6-9c6047dad1f1",
            "flavor_4_82944"         => "a852cecb-acff-49bb-b406-e191d2d5e64f",
            "flavor_4_83968"         => "213be95c-510b-4d4e-b7af-eb5c5a9c01e6",
            "flavor_4_84992"         => "ece4bff5-1df9-474c-aa4b-61eb71d1ef6e",
            "flavor_4_86016"         => "3a9de50c-82f4-46ea-b077-c725daf4935e",
            "flavor_4_87040"         => "e4b66711-67c2-4af9-b3d7-348f4e3a7129",
            "flavor_4_88064"         => "a38ebce4-a697-43a7-b88f-44637ae6367c",
            "flavor_4_89088"         => "da2b58d8-15c8-4359-8455-9768666f3bfc",
            "flavor_4_90112"         => "a21910c4-42e1-43dc-803e-a015a8882f4d",
            "flavor_4_91136"         => "66273d6d-c423-4031-b092-e634c33c6dbc",
            "flavor_4_92160"         => "d45b3a3f-a057-4dbb-944b-022155e116d1",
            "flavor_4_93184"         => "52913bd7-90e1-497b-9dc5-b38a7bff4de2",
            "flavor_4_94208"         => "12922948-3bca-4b76-98fe-597c35e55c43",
            "flavor_4_95232"         => "f520a818-44df-454c-9ec9-1734aa5367bc",
            "flavor_4_96256"         => "bf9aa789-c875-4769-b637-a529aea89825",
            "flavor_4_97280"         => "310da4f4-fe7a-41d3-af0f-8b142de7de53",
            "flavor_4_98304"         => "f8925c5d-39f1-44c0-b45a-19e2ffef50e7",
            "flavor_4_99328"         => "5d298f2d-88c3-4170-a616-95c9182cdd07",
            "flavor_4_100352"        => "f12e96e5-d3d5-4724-979f-b833691c85c0",
            "flavor_4_101376"        => "6545e96e-a2b2-4e11-8dd3-0ea5c1e28628",
            "flavor_4_102400"        => "1418a87d-1083-4b9e-a725-e405cc8e1aff",
            "flavor_4_103424"        => "7bb26d6e-716b-42d8-ae92-d7dfdf5da210",
            "flavor_4_104448"        => "4718a085-f22e-4d10-b2fb-56c5d90bfff6",
            "flavor_4_105472"        => "56e4c550-f3af-4244-b6b2-ad5f0a36f337",
            "flavor_4_106496"        => "047be0bf-512b-480f-847b-383c025da789",
            "flavor_4_107520"        => "b5cd8e82-9923-483b-bb51-cc8f55e44300",
            "flavor_4_108544"        => "28165ad6-1607-4947-b4b8-d23ee1d20155",
            "flavor_4_109568"        => "c44c260d-c049-4283-93bb-da5b7df9f4a9",
            "flavor_4_110592"        => "16e48877-523c-4ef0-acbc-50362d882336",
            "flavor_4_111616"        => "1e6ac10f-6753-45ab-b1a4-06c80de3c63f",
            "flavor_4_112640"        => "889c42ca-c9be-4dae-a893-af53437b184a",
            "flavor_4_113664"        => "2d4486fe-e3ad-40e9-bdb1-5b35c382747b",
            "flavor_4_114688"        => "4c3e523a-3a50-4cf0-9ac8-fd5eae9bed4d",
            "flavor_4_115712"        => "8cc71761-fa6f-41a9-b0dc-23d994ca0460",
            "flavor_4_116736"        => "112b63d0-7fdd-42d9-8823-4e33bbb4911b",
            "flavor_4_117760"        => "69405b10-f1ca-42df-aeb0-cf9208096314",
            "flavor_4_118784"        => "38094fa6-00f7-4f7b-9a69-9b4fb1745914",
            "flavor_4_119808"        => "0ba21bb3-4cf8-43fe-acd1-798075e0faac",
            "flavor_4_120832"        => "e5d1bbb0-1aa0-4142-8545-9edfeaac066f",
            "flavor_4_121856"        => "e642ab30-25ae-4f26-8e64-3012f1ad4d66",
            "flavor_4_122880"        => "fe700268-71e9-4ba0-8d33-c76480c71730",
            "flavor_4_123904"        => "3d9bbfd7-0d08-4964-b340-3c1cca3eb7be",
            "flavor_4_124928"        => "c33b279f-3bff-46c1-8301-8063884398a1",
            "flavor_4_125952"        => "038043e8-d98e-45ea-9912-a2f6f7f1d3e6",
            "flavor_4_126976"        => "fd292a56-1c53-4862-9f0e-7595bac40840",
            "flavor_4_128000"        => "7efaea04-c736-44ee-b397-9c99d7111de0",
            "flavor_4_129024"        => "174ec952-8ef6-4b25-a85f-b08243ce34a5",
            "flavor_4_130048"        => "55ffdfab-53af-430a-b387-215855c79869",
            "flavor_5_5120"          => "c6a0c691-4d35-4a27-a4a2-970cad23cf5d",
            "flavor_5_7168"          => "7868e20f-6e9c-4373-a7dd-2cdc1a7538bb",
            "flavor_5_9216"          => "0dd7039e-c80e-4818-a07d-fd8c47fb3134",
            "flavor_5_11264"         => "9843b0f7-f959-406d-92c3-230e12bdcbf4",
            "flavor_5_13312"         => "761f1f3e-f593-4754-9c64-4d4abc9e1e9b",
            "flavor_5_14336"         => "11bd9829-5c3c-4252-bd2d-79a332e84df8",
            "flavor_5_15360"         => "fc269e12-c479-43fe-a704-5b322a56959e",
            "flavor_5_17408"         => "488fc735-0e09-42f5-a441-aa670754a55f",
            "flavor_5_18432"         => "a6eb7a3e-9961-4aaa-82d1-a126372c509b",
            "flavor_5_19456"         => "e8aaf224-75b3-4b2c-a89a-e0e7adfa3f5f",
            "flavor_5_20480"         => "a9a56bb6-34fc-4d28-a34d-cb35e16e0c75",
            "flavor_5_21504"         => "83530e00-0907-4e87-ab82-30b8386eb7fe",
            "flavor_5_22528"         => "cc4cfd9d-3a33-4ec4-bdf4-ff66b4a81933",
            "flavor_5_23552"         => "d36e9ca0-fb9d-4118-8b3f-b35f69aad03b",
            "flavor_5_25600"         => "bc496497-2fac-4ed6-832e-fa19c0e96f60",
            "flavor_5_26624"         => "5cbca2f4-02d8-4791-8986-e51389a24611",
            "flavor_5_27648"         => "74bd9f43-17df-47f8-bbf2-03f303c79b3c",
            "flavor_5_28672"         => "ad68d9ed-9c8e-444f-b958-2c44fccd140b",
            "flavor_5_29696"         => "ae762ba0-9325-4b88-b65f-525c68b6b3d3",
            "flavor_5_30720"         => "353f6239-6e4a-4113-a52f-fc9cf8c22e78",
            "flavor_5_31744"         => "c7b1c8ae-0852-4487-820c-8373bd4cb798",
            "flavor_5_33792"         => "27c3dc8b-fa1e-4eee-b3d2-9eebbe66b613",
            "flavor_5_34816"         => "41a77bec-074e-44cd-b127-b0115b2fbfc6",
            "flavor_5_35840"         => "0d674d4c-4636-4e77-a922-8ec196a06dd5",
            "flavor_5_37888"         => "93d4b186-f71e-4571-984c-694a72417b0b",
            "flavor_5_38912"         => "ef92b126-968d-4d49-bcbd-2bf05387b772",
            "flavor_5_39936"         => "3a859238-5674-4dad-b7f2-86073b36c265",
            "flavor_5_40960"         => "ddc81957-67c4-4a07-8314-c7337466be2c",
            "flavor_5_41984"         => "163a2069-9b71-40de-8917-5853bf24bed0",
            "flavor_5_44032"         => "6a0073a4-5662-40cf-adb7-1ec36da72333",
            "flavor_5_45056"         => "2f848c9e-f652-4db7-b8ed-0ce8479f65a2",
            "flavor_5_46080"         => "e4545e7b-108f-43c1-8e25-736a30a316e2",
            "flavor_5_47104"         => "14267448-4113-4761-b4d7-e382b16463c0",
            "flavor_5_48128"         => "58ad874d-029c-40cb-b8ff-81fb3d49777f",
            "flavor_5_50176"         => "45c538cc-8f2c-4584-ac35-72762e8e6f99",
            "flavor_5_51200"         => "e86ee5d6-19e9-4a74-866f-fc1c6b5f89f8",
            "flavor_5_52224"         => "6045824b-1c39-4871-bd10-209d20b2d4d6",
            "flavor_5_53248"         => "1beefac9-fd0a-49dc-9c05-dfe3c7d22617",
            "flavor_5_54272"         => "fe01d994-1d32-4f62-b19b-5d1b651b39e1",
            "flavor_5_56320"         => "3ba8da6c-8f38-4a21-b6f9-a3bae7d62654",
            "flavor_5_57344"         => "97f4572e-40b5-4f0c-ac86-66aa81cbbc38",
            "flavor_5_58368"         => "62126120-d2ef-4c98-aa5a-ff3f2bcbcefd",
            "flavor_5_59392"         => "be26bddf-3068-472e-87e1-c4b7520da17e",
            "flavor_5_60416"         => "100aed82-0b41-4ed8-8fcc-dd85265a9386",
            "flavor_5_61440"         => "8c5fa6a0-3605-487d-904d-697ceba2c5ff",
            "flavor_5_62464"         => "dcb2f0bf-7060-4520-80d9-18db33549270",
            "flavor_5_63488"         => "dde625ec-1385-414a-8f30-ca3bd134dec3",
            "flavor_5_64512"         => "33e844fd-ab31-425f-b4cb-6e509ea8b294",
            "flavor_5_66560"         => "b695117b-1cb6-4a79-b95b-572278f430ee",
            "flavor_5_67584"         => "38e992b0-edcd-4679-90ba-74241b567224",
            "flavor_5_68608"         => "3c805199-1963-484e-b6d0-c72020b06fab",
            "flavor_5_69632"         => "07b9bf56-bf50-428b-8b5c-de4db2b03123",
            "flavor_5_70656"         => "5138b6e2-ff9f-4290-9714-12f1e8da7fed",
            "flavor_5_71680"         => "eee6768e-c5e1-4b37-888e-c922ed0ea664",
            "flavor_5_72704"         => "d5ed993d-14ba-45d1-9a1c-5a24bffcdbe2",
            "flavor_5_73728"         => "5aab1df0-a484-465c-9381-d96ab8f49958",
            "flavor_5_74752"         => "74ba5025-481c-4ffa-9b7d-85319d833c98",
            "flavor_5_75776"         => "bfce789c-90eb-4240-86c8-cace1b3d6655",
            "flavor_5_76800"         => "8bdf3590-79d2-4d0b-a63f-c5ca1bc21382",
            "flavor_5_77824"         => "c003c6f0-6ec6-4cab-86ae-4e3995db5a35",
            "flavor_5_78848"         => "ea4fa274-f4ba-4597-91ab-f540a631e653",
            "flavor_5_79872"         => "ef5e04fe-b19e-46ba-ab7f-47621b58d3b2",
            "flavor_5_80896"         => "1f65032c-80a7-4c6f-8bac-94c9d1c488c8",
            "flavor_5_81920"         => "9716a8d3-0f3d-40dd-8162-8899fa97f164",
            "flavor_5_82944"         => "72ab1d26-2c28-4ba5-8b6c-cd39b3454b62",
            "flavor_5_83968"         => "cee98957-ae24-4f1c-bfab-8c49f9400f26",
            "flavor_5_84992"         => "2945ad82-c0c6-4d98-82b6-6836a9e458fb",
            "flavor_5_86016"         => "35db280e-0e6b-4ded-8ff3-1b5407305336",
            "flavor_5_87040"         => "a8ac2658-dd52-4bae-94b2-f14cae3b24b2",
            "flavor_5_88064"         => "06c8bbf1-1896-414d-a731-f69e5fd39bb2",
            "flavor_5_89088"         => "6a7c95c5-5643-4e26-b293-398f074ec179",
            "flavor_5_90112"         => "ee2f0d4f-bfaf-4efb-aa3f-894a21ded5b4",
            "flavor_5_91136"         => "3c56ece4-a7b6-4e9c-a92c-e8164bcc4e43",
            "flavor_5_92160"         => "d345e52f-98a5-4b4e-85bb-0e408ccba0ed",
            "flavor_5_93184"         => "7a527c71-ee12-4419-977e-a228d72600a1",
            "flavor_5_94208"         => "94b774fa-06cf-4992-a60e-fa37f9ce2bfb",
            "flavor_5_95232"         => "6515958d-8664-413c-81c6-8c3b249fa274",
            "flavor_5_96256"         => "53243992-0681-48e7-bacc-63062af32d27",
            "flavor_5_97280"         => "328cbf4a-98f0-4575-8714-c784b519e41d",
            "flavor_5_98304"         => "8814fd7a-7651-428c-89d8-a6fef274cfeb",
            "flavor_5_99328"         => "ddb24dbb-61e5-467c-8e6b-e7f12822a9ae",
            "flavor_5_100352"        => "63213c86-ceb3-4ca5-9473-40242f60ab73",
            "flavor_5_101376"        => "c8d2d463-5591-4f93-a5fd-9cba91facc23",
            "flavor_5_102400"        => "12520a1a-18e4-42d2-ab83-e55fdd703486",
            "flavor_5_103424"        => "999e0687-14b3-40ba-b3ea-0116a981b3cf",
            "flavor_5_104448"        => "986821e4-5f49-4b00-ab91-4e7a82eebaaf",
            "flavor_5_105472"        => "b00c0342-5321-4e53-95bf-508a97f534ed",
            "flavor_5_106496"        => "7af7cd46-97b7-46ec-9141-121562a3a5fe",
            "flavor_5_107520"        => "4e182f74-0da4-4da4-a29f-1448791c80e2",
            "flavor_5_108544"        => "5732b3d8-1b94-40d8-b635-32570dcb644e",
            "flavor_5_109568"        => "153d3320-7da7-4459-b914-28ba12cbf0eb",
            "flavor_5_110592"        => "a82a50bd-8906-4139-8b42-460a475d702e",
            "flavor_5_111616"        => "a2149e4c-e089-4abf-8825-ca1d469da385",
            "flavor_5_112640"        => "95c3e667-47ff-4ef3-988f-dadbe48d42ea",
            "flavor_5_113664"        => "c298a10c-2ccc-49ba-8946-24c5ad437f03",
            "flavor_5_114688"        => "7175a887-baa3-4464-b538-f1f5cac6fa1f",
            "flavor_5_115712"        => "f23828f5-a8b3-4bfc-bc0d-e9acab516964",
            "flavor_5_116736"        => "961e6628-7641-43b6-9ee9-f60793dba100",
            "flavor_5_117760"        => "4216ab61-1e61-45be-be7e-8526e2e16f3a",
            "flavor_5_118784"        => "d5f2c8dc-434d-4560-9db6-8ff1796d7e93",
            "flavor_5_119808"        => "6f4bb9c9-6d56-4e82-8467-11863edf27a6",
            "flavor_5_120832"        => "96c4fab1-c7b8-4abc-a726-f8b70d2574b2",
            "flavor_5_121856"        => "8232296d-4c61-4b43-a376-9b61ce3a06a0",
            "flavor_5_122880"        => "f3c0cae9-1f94-4258-8463-235522dbfbd6",
            "flavor_5_123904"        => "03cf3299-bd25-4c39-8089-eeb7a70e0db0",
            "flavor_5_124928"        => "621419d5-b3fe-4378-af64-a00a922b7bde",
            "flavor_5_125952"        => "709f26c7-3d42-459f-88b9-1159e9ded5b2",
            "flavor_5_126976"        => "06128876-f98e-4c3f-a132-c8fdfcb1911e",
            "flavor_5_128000"        => "6eff889d-a18b-48f8-aac9-4ac9be26bdd3",
            "flavor_5_129024"        => "10661f49-8e18-4ab1-9e75-38545baa9470",
            "flavor_5_130048"        => "9a8d71b7-0182-49ab-af6d-3615c2cf0a3b",
            "flavor_6_5120"          => "882d3aef-e84e-4a94-a43e-a349efaf5a57",
            "flavor_6_7168"          => "e86fbc85-5ddf-4e79-878b-e76578eae8eb",
            "flavor_6_9216"          => "201d7e47-e8ad-453e-825e-d2a9e71db7a6",
            "flavor_6_11264"         => "52a61b82-3c19-4f9a-9b24-ee01b75698f7",
            "flavor_6_13312"         => "27fd1ccf-761e-4b81-ac84-8b3fcfcfe9d2",
            "flavor_6_14336"         => "962b7e31-0c8b-4a82-955e-0bc6dbebb392",
            "flavor_6_15360"         => "5b4a6a4f-24a7-40cb-9157-f24b42d0adc3",
            "flavor_6_17408"         => "dd81c8df-5566-4645-8315-d16e80da47d7",
            "flavor_6_18432"         => "f800dd94-6f1e-4280-9770-efd902a45319",
            "flavor_6_19456"         => "26254e17-aa27-4f02-819f-e000d00f3638",
            "flavor_6_20480"         => "38e6beb4-6028-4858-9585-9d28be1614c0",
            "flavor_6_21504"         => "bb131fad-b31b-42d0-a54b-02a5dd886062",
            "flavor_6_22528"         => "b72a1f15-19b2-4e22-9b32-a5793911fc25",
            "flavor_6_23552"         => "9629b9d4-0fcb-4833-bf02-a609219ff737",
            "flavor_6_25600"         => "98a00ca1-64c8-4873-b889-dc51aa080d76",
            "flavor_6_26624"         => "afd1a0f3-e533-4f11-bc4e-fe0d9958e642",
            "flavor_6_27648"         => "157cb0ff-53ae-4c73-90bb-19bee41239e3",
            "flavor_6_28672"         => "b0096448-da0f-4ba1-82ec-fcb71e9a2809",
            "flavor_6_29696"         => "63a7e5fe-f434-4f30-afa1-f44cfd63ec0e",
            "flavor_6_30720"         => "9137bb86-2a1e-4e29-9184-a7500b8418fd",
            "flavor_6_31744"         => "03e530f5-2840-4241-936b-6551098fc8a1",
            "flavor_6_33792"         => "6e529e82-edd5-41bd-8164-4263b6ca9295",
            "flavor_6_34816"         => "75ccd423-b0c9-4526-ba6b-79394e0839b5",
            "flavor_6_35840"         => "495db0f2-6cdb-4012-9fbe-e1ba2ad2070f",
            "flavor_6_37888"         => "044a8756-08bc-4412-9040-09a9748cd7b4",
            "flavor_6_38912"         => "ec0069f5-0ae1-4eb8-9ce9-e876c9458864",
            "flavor_6_39936"         => "2422766d-3b66-4d70-845e-b74e3ed690aa",
            "flavor_6_40960"         => "85a90d22-1e0e-4ce6-ad23-1c646e581f09",
            "flavor_6_41984"         => "7a4adc9c-7429-4ac7-994d-b405c5e1bb90",
            "flavor_6_44032"         => "a66a7993-2eb5-45e8-b6a8-b425d65970e5",
            "flavor_6_45056"         => "b721649c-6207-4422-9df7-284db20a741c",
            "flavor_6_46080"         => "ebcfce90-36da-47f7-9b0b-2bbc6288f495",
            "flavor_6_47104"         => "78b9f7a4-f2a2-4420-84a6-cf1e3e5631aa",
            "flavor_6_48128"         => "51003bd9-a2d6-49f6-af1d-6f631d3f86e9",
            "flavor_6_50176"         => "d2c6e1cd-4ba2-4519-89ce-b052c5f1cb72",
            "flavor_6_51200"         => "7142d50b-e3d6-429b-a0e7-0cbdb589ce91",
            "flavor_6_52224"         => "0726ab23-7a05-4da8-bfe6-75d006524f68",
            "flavor_6_53248"         => "9c187048-9c76-4ca5-bfa6-05812234e828",
            "flavor_6_54272"         => "768b4486-4273-46e5-82c1-8db14febff4e",
            "flavor_6_56320"         => "adb74e28-54ac-441c-8ed3-33ec445c5683",
            "flavor_6_57344"         => "305d1039-4032-49f8-a5b8-708ca041a5ca",
            "flavor_6_58368"         => "4d195502-197d-42df-87a1-7e57bf42d9e4",
            "flavor_6_59392"         => "931c8c43-5391-423a-9d1b-fd68ebf88f35",
            "flavor_6_60416"         => "973256d4-7a7c-4b95-b33f-7944510d599e",
            "flavor_6_61440"         => "5cb04c42-6f49-436b-a606-450dc7a1ee77",
            "flavor_6_62464"         => "a012981d-0c7c-4468-8775-f6ed78161d53",
            "flavor_6_63488"         => "62180a09-1ab3-4dc0-9faa-b115fb79dc0f",
            "flavor_6_64512"         => "da663d74-0c47-4243-b2c5-b4853cb73240",
            "flavor_6_66560"         => "64e20b97-acc7-4035-baf2-84ec1f3b7673",
            "flavor_6_67584"         => "edfab041-2166-4468-a4ec-391fd462767b",
            "flavor_6_68608"         => "028f86f2-6628-4508-acf2-363554f012a0",
            "flavor_6_69632"         => "cb82c8c1-989f-41aa-b7fd-c88118539bbf",
            "flavor_6_70656"         => "360411d3-9cf6-49d7-aefc-a461e274dfa6",
            "flavor_6_71680"         => "282aa272-5e1e-4075-aba2-c19c38de227d",
            "flavor_6_72704"         => "b777844d-f182-412f-a79a-9d677d045f20",
            "flavor_6_73728"         => "95b7bd46-b892-4b0f-a3c7-717cb67a1362",
            "flavor_6_74752"         => "ce26195e-18d1-475e-b187-37528f19e365",
            "flavor_6_75776"         => "b70bb5f1-f50e-4be0-8ff2-e9117d80e959",
            "flavor_6_76800"         => "548b5e89-91eb-4017-ae3c-166f4f1bf8b2",
            "flavor_6_77824"         => "f133717e-bf25-41e9-9848-28e1ffc8d486",
            "flavor_6_78848"         => "876a1e14-7ba0-497e-afd5-9b1e69da0bea",
            "flavor_6_79872"         => "54f3940f-ef50-4508-b056-730efa1e8c81",
            "flavor_6_80896"         => "170a0163-7adc-4580-a32c-847a3f55e9bd",
            "flavor_6_81920"         => "1acc8b20-e1e3-432a-9c8b-832b098997dd",
            "flavor_6_82944"         => "302535da-028f-44a0-93d2-581df190238b",
            "flavor_6_83968"         => "38c19eb6-825e-4096-aa10-5bb9240121ab",
            "flavor_6_84992"         => "b0d4dd2b-9dfb-4d3a-9dc7-f552a8eb86ef",
            "flavor_6_86016"         => "31aeb308-3448-41d2-8020-454c7b6a37f4",
            "flavor_6_87040"         => "373c3fb7-ee49-4657-a703-9bc2bf44ca81",
            "flavor_6_88064"         => "566ca4ae-aa85-43ad-8b6c-ebfc8a0fa489",
            "flavor_6_89088"         => "13abfc1f-606e-4f47-9d35-99e4df97f31c",
            "flavor_6_90112"         => "fa3bfebd-08d7-4eb1-a7a4-1ceb66cf9e8b",
            "flavor_6_91136"         => "32d1f9ae-c86f-4230-b290-5f4b6fa63ff5",
            "flavor_6_92160"         => "b3dce4f1-8c52-4b70-b725-40ec436d1c63",
            "flavor_6_93184"         => "ca0245ff-fc83-4515-ac66-b6f2b8ef83fc",
            "flavor_6_94208"         => "621effc3-acc7-4f1d-b584-b4870242e503",
            "flavor_6_95232"         => "6a25b9bf-a97a-4cbd-8b98-df15ddeff29e",
            "flavor_6_96256"         => "dc12fd29-6299-4f68-b1f5-b070b47d5f5c",
            "flavor_6_97280"         => "4ca17775-59c3-44f2-a22e-3e0ae84a4777",
            "flavor_6_98304"         => "a6885360-4e4a-45fc-b234-b827c134d7ef",
            "flavor_6_99328"         => "1349b5e8-baab-41d1-908b-568718b658e2",
            "flavor_6_100352"        => "8cb6f97f-23e4-4b4f-b034-0005aa94e29d",
            "flavor_6_101376"        => "c071b7c7-6456-490a-a807-4537da49216e",
            "flavor_6_102400"        => "0bbfa2e8-0c57-4e3f-9d17-74f7f8a73fe2",
            "flavor_6_103424"        => "83b515af-871b-4279-8c78-18ba4fa1788f",
            "flavor_6_104448"        => "e9069d30-bbbf-427c-9007-d042cba84f00",
            "flavor_6_105472"        => "9521a346-9883-4fcc-8341-d3ab6a113e11",
            "flavor_6_106496"        => "6dbc3ac8-4505-4e81-a026-bd543e0d2aae",
            "flavor_6_107520"        => "b35867e2-603b-4b0b-9a02-2ae8d5fd7216",
            "flavor_6_108544"        => "6223ab61-c690-40ea-b16d-e5d0a91601c7",
            "flavor_6_109568"        => "72e99b85-bd76-49f9-b646-0b6dbb8a1f2c",
            "flavor_6_110592"        => "1ce77ffe-0d7b-48ea-9e80-80d22dae6e87",
            "flavor_6_111616"        => "0b76ec1b-1b8b-4ed1-be87-6b719f884c9b",
            "flavor_6_112640"        => "dfbc6e13-8455-49ea-a77e-d3fbcf7d25eb",
            "flavor_6_113664"        => "5769adf1-b461-49c6-a657-996eb2965e4e",
            "flavor_6_114688"        => "8f3f6d41-d57a-44c1-9150-6022967bc9e4",
            "flavor_6_115712"        => "7a74e3f3-3af3-4f56-a0ae-4e6aedfd9e50",
            "flavor_6_116736"        => "56573213-cd56-4f44-8f7e-2c7226d60a9c",
            "flavor_6_117760"        => "cba131f2-a292-49a7-a42e-9fb0edb448cd",
            "flavor_6_118784"        => "c057dfa2-5771-4ed1-91fa-05bb880d3472",
            "flavor_6_119808"        => "d7269d25-2a29-49b2-b395-d15a74316e41",
            "flavor_6_120832"        => "9f9509e7-26ed-45f9-b4c7-a0592eed47dd",
            "flavor_6_121856"        => "c43cff0d-3aca-48d6-a0d2-d80c32e79feb",
            "flavor_6_122880"        => "ad2e10d7-6309-4420-bca9-989e8bac404b",
            "flavor_6_123904"        => "236579cd-54d3-44bd-83e9-d6287f666ec0",
            "flavor_6_124928"        => "98d5c683-197f-4507-8d42-4fe0a2ed0adf",
            "flavor_6_125952"        => "e2370c74-075a-48b7-8b77-c2b025cc9fa8",
            "flavor_6_126976"        => "1ddce3f2-9f54-4ea9-84ec-93fcb3f9e229",
            "flavor_6_128000"        => "291d2764-85a4-40c5-951d-3ba697cd520f",
            "flavor_6_129024"        => "338d30f4-460c-480f-a04b-8ec85195cb27",
            "flavor_6_130048"        => "6dc97464-fb36-4405-9f36-a520dc8ae476",
            "flavor_7_5120"          => "7af28537-b7ba-447d-a7c1-bb36e956cb91",
            "flavor_7_7168"          => "3e42054c-712d-4ec7-8337-ddca879bb29c",
            "flavor_7_9216"          => "4109d4d1-58a1-4054-a5fc-e6faafe2fe6d",
            "flavor_7_11264"         => "5f6830b7-6512-4802-968e-dc9bbaaa13a8",
            "flavor_7_13312"         => "dc52d658-ac4d-4ab4-b9cd-e3134b79ebde",
            "flavor_7_14336"         => "cde636f2-6fdf-4613-b22f-fead00eefd70",
            "flavor_7_15360"         => "6350fc99-408f-4a3c-a112-ac593ae07e7f",
            "flavor_7_17408"         => "7b55fbbe-9a04-4510-96fd-61283e717b98",
            "flavor_7_18432"         => "be22c56b-fcb3-4c4f-ab0d-a5181f441804",
            "flavor_7_19456"         => "34a7f307-05c9-4af0-b9b2-4bb96c2b10ee",
            "flavor_7_20480"         => "a3e663ae-cec0-43cf-9ab7-c15838e9b74e",
            "flavor_7_21504"         => "61f8481c-cde6-43ba-8dd2-95c2156f2762",
            "flavor_7_22528"         => "97c7fd04-28cb-41be-9461-5ca05f438332",
            "flavor_7_23552"         => "f523bfad-124b-4dcd-8642-6e266589e8e4",
            "flavor_7_25600"         => "8f078041-36e8-4e2d-bb63-617dc191e3c4",
            "flavor_7_26624"         => "9b7f2ff0-d5f5-46db-9ff9-70c179ca2b56",
            "flavor_7_27648"         => "460087df-f470-46e2-ba3f-28a49bacbacb",
            "flavor_7_28672"         => "52c363f3-bd1d-4b67-bedc-52120be37149",
            "flavor_7_29696"         => "8480db13-e542-4517-9730-e830a2031d93",
            "flavor_7_30720"         => "56bcca6f-1959-4b6a-8a06-44cb6965e7b3",
            "flavor_7_31744"         => "ea222763-3335-41c5-b49c-8eec0044d876",
            "flavor_7_33792"         => "179dca11-7d6a-42eb-8211-b4b243df1096",
            "flavor_7_34816"         => "c2815cc5-28c5-46f1-be54-e00576f2da7a",
            "flavor_7_35840"         => "9938bb92-4a6d-4f5d-aba2-7c549dbf9617",
            "flavor_7_37888"         => "bff26e75-d0fa-48db-ab57-ef80e0be5f96",
            "flavor_7_38912"         => "1a0b8c07-9774-47fe-b00a-0babb423db68",
            "flavor_7_39936"         => "5f1ea4ba-216e-4ad3-a212-780bd4d3b508",
            "flavor_7_40960"         => "2a4ec716-9143-4b1c-8346-15fceada1229",
            "flavor_7_41984"         => "1e26b451-f48e-4831-b1dc-f8436927f04a",
            "flavor_7_44032"         => "0ce8f613-9a33-40cf-aba6-edfb458bad83",
            "flavor_7_45056"         => "e9c17304-27cd-4309-9e0e-a18bfa7ba007",
            "flavor_7_46080"         => "65db11c2-d4e1-435f-ba7a-a27458c409d5",
            "flavor_7_47104"         => "38a49996-d14c-4a23-a434-96a5c6e6d1a8",
            "flavor_7_48128"         => "922fe11d-e4ee-44a9-b85b-67f1478a2d23",
            "flavor_7_50176"         => "f1bf0ec2-c92b-4f03-8138-cadb5569072f",
            "flavor_7_51200"         => "53161855-f191-4a02-b745-46d6cc9fc206",
            "flavor_7_52224"         => "9626a7ea-f3d6-4115-9c9e-875ca06f6c1d",
            "flavor_7_53248"         => "87b0a11e-4e4c-4d51-b443-f7e4bb6e0fe9",
            "flavor_7_54272"         => "02d787c3-d5d7-4b73-b36f-fe26b1c48d39",
            "flavor_7_56320"         => "c1dd6d32-715e-4063-9b62-7bc04cae55d0",
            "flavor_7_57344"         => "da7dd0f1-9eed-49eb-a9c6-8a98cfdfac82",
            "flavor_7_58368"         => "0bbe80a1-13ca-445d-9431-f5f1fe55b06e",
            "flavor_7_59392"         => "f28ca34a-37b5-42ba-a599-63d3e8bffe5f",
            "flavor_7_60416"         => "4ceae6ed-6e2d-4ae2-8f71-75c8b87b576b",
            "flavor_7_61440"         => "98908677-3834-4990-a6e6-750ba52731d6",
            "flavor_7_62464"         => "87b0cb3a-ef9e-4e52-93bb-894e4b54d830",
            "flavor_7_63488"         => "d2c9da99-94dc-4dde-880d-7461a044903d",
            "flavor_7_64512"         => "6d0e2908-8c71-4f1d-90d0-5202b937d336",
            "flavor_7_66560"         => "f4cab3cd-8ebf-405e-bbdb-fef80619f180",
            "flavor_7_67584"         => "d70524f8-20d6-4561-b3e9-d228255fea6f",
            "flavor_7_68608"         => "aee7b56d-318e-4525-9fde-eca24e806aa8",
            "flavor_7_69632"         => "dd262b62-01d7-4f16-a7e7-86d9f5541ad0",
            "flavor_7_70656"         => "93c62ec3-8d86-45bd-83fb-c7d6e8c1c284",
            "flavor_7_71680"         => "a542c922-dfa6-40f4-aa85-17ee0a2c5ae1",
            "flavor_7_72704"         => "1b3c7309-ed29-4fc4-a4d8-e0e023ca82b1",
            "flavor_7_73728"         => "9bcde5d3-6e85-44b7-adad-ad8eaac293ac",
            "flavor_7_74752"         => "e25e51c7-2a0f-4c21-b742-472e84e25d78",
            "flavor_7_75776"         => "082972fb-6c77-4d11-af61-1a4b9e93796b",
            "flavor_7_76800"         => "09004bc6-9659-4316-aa15-0bccf708d2a6",
            "flavor_7_77824"         => "9c30a747-b542-497c-bba0-6cc551f690c8",
            "flavor_7_78848"         => "62831302-1cd3-4eea-9332-4daa793420f3",
            "flavor_7_79872"         => "26bf34b6-1c41-462f-8b86-66610acbce12",
            "flavor_7_80896"         => "3594ac6d-36c7-4c00-a212-4b2d450eadfb",
            "flavor_7_81920"         => "e27df872-fe64-4781-bace-36a72e838697",
            "flavor_7_82944"         => "9a76f742-b459-49bd-aa86-bb663222070d",
            "flavor_7_83968"         => "1e5c089e-f5fb-4945-9e48-f1ed9ea5a265",
            "flavor_7_84992"         => "7154fdbf-83fe-43fd-bbc0-5635f66f535d",
            "flavor_7_86016"         => "8ed96df3-a910-4022-9f3b-294427b400b9",
            "flavor_7_87040"         => "16d8d9c9-cd15-49b2-8f46-967a4c7d6680",
            "flavor_7_88064"         => "3063cb89-b188-4529-8b5c-0f273aa0252f",
            "flavor_7_89088"         => "add3b441-63e8-4311-880c-6ac52da0653e",
            "flavor_7_90112"         => "44982d00-8d98-4f20-b813-2b3343b5140d",
            "flavor_7_91136"         => "73f58222-3f5e-4186-8f91-c141fc2d13c2",
            "flavor_7_92160"         => "8486649f-919a-4bb5-979c-3b3f23d81dea",
            "flavor_7_93184"         => "6f017bff-308e-4115-a789-d6652e4acd03",
            "flavor_7_94208"         => "69f494bb-943e-43a2-8e8c-24ef6c76a6d5",
            "flavor_7_95232"         => "1879d6c2-678b-4974-b3dc-8d9e2b1caa43",
            "flavor_7_96256"         => "f8141a2d-3745-4b45-9bb9-a2a76d989c4c",
            "flavor_7_97280"         => "c21803fd-b62c-4669-b2f9-874962c1ed94",
            "flavor_7_98304"         => "2d466fe9-3ee4-4a67-a77a-e3397b746b06",
            "flavor_7_99328"         => "3c33fd89-8077-44b5-9a0c-298eff53a869",
            "flavor_7_100352"        => "e5045d9c-002d-4f7b-af93-e869f7e4b977",
            "flavor_7_101376"        => "b8c06050-4157-47d9-b5ed-7fc6195aedec",
            "flavor_7_102400"        => "7a4f28be-8a42-46c3-9cf8-768c17f468f2",
            "flavor_7_103424"        => "0a5fbf39-97d7-44bd-8042-880673754c1d",
            "flavor_7_104448"        => "ebdcff7d-712c-4214-92f8-4018a8b90554",
            "flavor_7_105472"        => "33e9612b-7ce6-4985-ba07-3136c044cac8",
            "flavor_7_106496"        => "0899db2e-fb83-4967-a003-cb68acb8b2ca",
            "flavor_7_107520"        => "84bf6d97-86d8-432d-bdd5-f38b018036b6",
            "flavor_7_108544"        => "59391db9-482a-424a-9a7c-708fdf6e885b",
            "flavor_7_109568"        => "9e6ded51-b7db-4755-97ac-7b69fa7d2597",
            "flavor_7_110592"        => "866db578-36e6-485e-b667-bc79a53be622",
            "flavor_7_111616"        => "654841f4-5e99-46cb-adaa-0c8355a13570",
            "flavor_7_112640"        => "bc536aba-0a86-4dc8-aa37-7aa66e961b49",
            "flavor_7_113664"        => "2cbeae9f-bb3b-4bc7-94af-632739ca3e4e",
            "flavor_7_114688"        => "84e070a6-02fa-4e76-8212-c36c367aa44a",
            "flavor_7_115712"        => "202563da-b969-400a-af9d-b61afa820f13",
            "flavor_7_116736"        => "91b41da8-32c6-4a25-9d07-c71e3eefc133",
            "flavor_7_117760"        => "4b9a6b8a-b3b2-4629-9328-5281f647b765",
            "flavor_7_118784"        => "d13bfbac-26ec-40d5-b691-5f0ce330b216",
            "flavor_7_119808"        => "de54f218-99b8-47c1-9065-7483ca9b1f23",
            "flavor_7_120832"        => "94b42bfc-075e-4e2a-b7e0-3f1f7679d55d",
            "flavor_7_121856"        => "2320e20b-701c-4056-9de2-8e0820bb9b5f",
            "flavor_7_122880"        => "599f45df-306f-4e3b-a0cf-a8a90c28f91a",
            "flavor_7_123904"        => "360ba1e0-7abf-4a5d-a564-eb1a0d5e93d2",
            "flavor_7_124928"        => "6d35bebb-f2d5-4441-a021-9e9af856ae96",
            "flavor_7_125952"        => "331beddf-76c8-407b-b73b-d4932a9137fe",
            "flavor_7_126976"        => "dbae22c9-a3b3-48c4-bdf9-bc81704a371c",
            "flavor_7_128000"        => "41a56ad8-2327-4f2c-87dc-11d9ba2a8390",
            "flavor_7_129024"        => "4cf2d47e-a5f4-41de-a650-30f98f25cbd8",
            "flavor_7_130048"        => "03a9684f-6c09-4275-bbe8-ab00b1ce1d58",
            "flavor_8_5120"          => "88dd482e-d1ee-4563-bb88-779f1b17010a",
            "flavor_8_7168"          => "b2fdbdd2-8b39-4386-b507-4aafa3895c56",
            "flavor_8_9216"          => "62352956-b00f-421c-b623-3a3673bc5e24",
            "flavor_8_11264"         => "6b7bb363-c53f-4fa3-ba2b-46dc4615b7bd",
            "flavor_8_13312"         => "fe52819d-f84e-46ea-aed8-fd0d17f40dde",
            "flavor_8_14336"         => "a2279cfc-6765-4cbc-83a7-c6de4b2043a3",
            "flavor_8_15360"         => "26a78a33-2003-4fb3-8f67-30e381445d5e",
            "flavor_8_17408"         => "3ef25f85-23a2-4e78-9687-1ca2a64b3bbc",
            "flavor_8_18432"         => "fea4c04c-f59c-4717-9d7c-14e502dcc130",
            "flavor_8_19456"         => "74464ad2-1b99-4fa6-a9db-0013582ca959",
            "flavor_8_20480"         => "9162c38b-6e6e-4181-bc1c-906b2c66ffaa",
            "flavor_8_21504"         => "2207c29d-0514-402f-b692-439438def82d",
            "flavor_8_22528"         => "6510ed4c-b5fd-49b2-a158-bd364485bdaf",
            "flavor_8_23552"         => "3bfa82d6-94b6-412c-9915-218258c83eb9",
            "flavor_8_25600"         => "b15cd28c-ceb1-48fc-ae5b-eee09b66393a",
            "flavor_8_26624"         => "adcc9a34-8928-4606-9146-6ecf430b25ad",
            "flavor_8_27648"         => "fd915aa9-e97a-4958-9b08-9e90eda0fa2e",
            "flavor_8_28672"         => "e66dda2e-531c-46af-ad94-8b0a1ad6e72b",
            "flavor_8_29696"         => "4c26a921-41c2-46d3-a771-1b1841a98b87",
            "flavor_8_30720"         => "3684fbc8-303a-4f21-9895-e4cc3647e340",
            "flavor_8_31744"         => "cf181614-a0ba-45ba-8034-622c1a38c8ea",
            "flavor_8_33792"         => "b5123f65-c167-4125-ab27-bdd25f80703a",
            "flavor_8_34816"         => "2fe7e620-ebda-4a0f-8142-d7efb494d5f1",
            "flavor_8_35840"         => "3630764e-d892-43b8-9ee5-f911beee39fa",
            "flavor_8_37888"         => "4a1ee750-c0b6-4cb2-a7ab-e57df9650289",
            "flavor_8_38912"         => "a35e3d08-8602-47d1-aee5-fe644ce042a1",
            "flavor_8_39936"         => "7ae70ecd-6c88-4c71-bbba-17dab261c07d",
            "flavor_8_40960"         => "f9aa915e-0c9b-4a5d-bb3e-9ed8429dac27",
            "flavor_8_41984"         => "160442ae-74e8-46c3-9aee-580bf95a1e1b",
            "flavor_8_44032"         => "64de9143-0909-4085-bd5b-a29d0f120808",
            "flavor_8_45056"         => "ab52d095-4b94-4c45-88b9-cd1033dd16bf",
            "flavor_8_46080"         => "ccfeab18-ae2e-451c-ad41-97398e31b00a",
            "flavor_8_47104"         => "ee8b493c-5384-4f1d-a421-9a70dadf9cfc",
            "flavor_8_48128"         => "dbfe699a-428a-4d54-99ed-ee35eef5cfb8",
            "flavor_8_50176"         => "31a1085d-23bc-4f2c-9b32-6f193ff66722",
            "flavor_8_51200"         => "1a4dd1b5-2a18-4105-8a75-7fe6be178535",
            "flavor_8_52224"         => "a807f6cf-83a8-4d17-8d4a-88f76e3439b8",
            "flavor_8_53248"         => "7adcca87-65d0-45a0-bf09-ae0d410b6d45",
            "flavor_8_54272"         => "ee46b3f7-7978-49d5-a57e-9a65c32ddf8e",
            "flavor_8_56320"         => "dddde869-88d9-412e-b3e5-f3b2b899ee3c",
            "flavor_8_57344"         => "a750c1d2-a304-42df-a075-9d6c501af2c5",
            "flavor_8_58368"         => "e7056cd8-8a4d-4502-8068-d15e22d025bb",
            "flavor_8_59392"         => "e793a8d8-7158-46ac-b7b3-52045c65ce79",
            "flavor_8_60416"         => "12f355d1-5730-4dc0-acee-33e976f3be10",
            "flavor_8_61440"         => "1c3a9e58-842f-4acf-af1e-db1c0e524443",
            "flavor_8_62464"         => "8d1c8834-b0de-42c2-9137-9a323a18691d",
            "flavor_8_63488"         => "cce7a815-5c2b-457f-8466-05f8953ba1d9",
            "flavor_8_64512"         => "7952dd82-b204-4db5-a740-13c4e47be6a5",
            "flavor_8_66560"         => "c1cd33d7-c0ee-4b69-b226-66d272154fd4",
            "flavor_8_67584"         => "626542b4-49f5-4f18-bd46-5791ab7cac1b",
            "flavor_8_68608"         => "02fa6b8d-d7f6-4676-838f-014f28dd8cf0",
            "flavor_8_69632"         => "5d95dad7-b77d-4c59-bbb0-e62bdee8f272",
            "flavor_8_70656"         => "001dcac2-8ec3-4853-a703-5ab944a36c0b",
            "flavor_8_71680"         => "e30afd45-b752-4f60-bd15-acb5613faea5",
            "flavor_8_72704"         => "1e3c039d-e5a7-4549-9474-ea88fcbd2dcc",
            "flavor_8_73728"         => "bb4d63b5-f6f8-4365-8aa8-57da038e574a",
            "flavor_8_74752"         => "8634c47c-082c-401e-b4fc-7c2c7c6bb8c0",
            "flavor_8_75776"         => "0e383ebd-74e5-4cc3-aa0b-c25ef88fdb13",
            "flavor_8_76800"         => "23964204-69ab-453d-abb8-11f10b1198cb",
            "flavor_8_77824"         => "71811d0a-349d-4a2e-bc70-4e0ca53146d5",
            "flavor_8_78848"         => "6eed9b5f-cebc-4718-9c38-51a5e384f6ed",
            "flavor_8_79872"         => "1446e248-9b1d-4370-aa6f-7c888dc79255",
            "flavor_8_80896"         => "6420a074-01d3-42ec-99c8-54caf11d046a",
            "flavor_8_81920"         => "095fbf3d-e832-4b63-b518-0c9b3af189ce",
            "flavor_8_82944"         => "c585e9ad-ae93-416a-b938-2c33787dd15d",
            "flavor_8_83968"         => "fe976745-fed4-4f50-ac08-a6bf2f9b1029",
            "flavor_8_84992"         => "dd14699a-d4cc-4027-8b38-e45c50f01eb0",
            "flavor_8_86016"         => "3928fda9-e432-4aba-9f9f-a17c668feb69",
            "flavor_8_87040"         => "e643f433-72ea-4e32-9276-a08d24019475",
            "flavor_8_88064"         => "d5fb5b4c-b679-4013-a274-69bd60da349d",
            "flavor_8_89088"         => "1af301ec-2e5a-4619-b650-caa4aa3c040d",
            "flavor_8_90112"         => "2a5a77ae-6568-49f5-852b-3ae753ccdc3c",
            "flavor_8_91136"         => "87cb7229-b5b8-4a69-9432-6e578fe71a7d",
            "flavor_8_92160"         => "de27176c-3c45-41ee-9489-c2e3b40d0b52",
            "flavor_8_93184"         => "01ec02cb-a5ed-42c5-b07d-55d0a7f1d697",
            "flavor_8_94208"         => "09831bc2-1671-4c73-8649-25b99021b710",
            "flavor_8_95232"         => "564a94c4-4129-48ee-a74b-536b97646f1a",
            "flavor_8_96256"         => "e9d153be-cbf5-4240-b8a2-484d6b3cf617",
            "flavor_8_97280"         => "1d620919-af64-4cb5-8631-3c0117161496",
            "flavor_8_98304"         => "386eea6d-f6d8-4dd0-b50a-fa7d31ddd347",
            "flavor_8_99328"         => "9ce0f236-f37b-4281-ad7a-aa778d239741",
            "flavor_8_100352"        => "32a1a29f-3ced-4de1-8dd6-50864e693ff8",
            "flavor_8_101376"        => "91bc18d7-ab83-4274-b0af-7700a1f56b28",
            "flavor_8_102400"        => "daa15077-e1e0-4eb1-b13e-00ff955245fc",
            "flavor_8_103424"        => "87a54383-adc1-4b6d-9dd2-fe8aeb62ee1b",
            "flavor_8_104448"        => "03aebd73-31af-4f4b-8c1b-3c9773926255",
            "flavor_8_105472"        => "503387b8-6bb4-4cab-b1b9-7c87bb768c49",
            "flavor_8_106496"        => "c5bbac27-20fb-494e-9956-cadf72872e81",
            "flavor_8_107520"        => "551c2f9c-0f7c-4c93-99a9-c87339753d2a",
            "flavor_8_108544"        => "f0d65162-0f51-4865-b86c-023c44cb0204",
            "flavor_8_109568"        => "54e7cd36-0be7-4580-b37c-21cf3b5426d4",
            "flavor_8_110592"        => "0b76b712-3e21-4d2d-a460-37d3965eeaf1",
            "flavor_8_111616"        => "35d643e2-59ac-46ea-8a6a-d156957accd3",
            "flavor_8_112640"        => "56cb0f3f-9f6b-49f2-ba34-a698ce5a1139",
            "flavor_8_113664"        => "f8f83c1e-e285-43e7-94e6-7cd12f6aaebd",
            "flavor_8_114688"        => "6aa10323-0933-445f-b1bf-847267a4571a",
            "flavor_8_115712"        => "14bd9233-9dfa-47a8-9df1-abbe910f80d5",
            "flavor_8_116736"        => "11eaaa46-294a-41a2-af2e-7cec7ffa1ba4",
            "flavor_8_117760"        => "3bd9535c-5dfb-472b-bb8d-8952529a8758",
            "flavor_8_118784"        => "e43ad35e-3370-4183-b49e-9a1fa05ef6b6",
            "flavor_8_119808"        => "80b1629c-c7ee-4dae-87f1-9742b7cfcb35",
            "flavor_8_120832"        => "b8968532-127d-480a-a642-d36cc6e61dfa",
            "flavor_8_121856"        => "64fcbdbb-f743-477d-8ebe-90e4ad59198f",
            "flavor_8_122880"        => "f3e7c106-d52c-4d2b-b104-6c708ea2ed38",
            "flavor_8_123904"        => "ef0dafa4-cc1c-4c48-a93d-3471cc37536f",
            "flavor_8_124928"        => "38086d2a-765b-4b40-b8df-2dbac679a6b8",
            "flavor_8_125952"        => "b1ee1a6a-5f50-44c3-b335-aeb9768b717e",
            "flavor_8_126976"        => "08093679-f2d7-4294-83a7-cf1b777cd989",
            "flavor_8_128000"        => "bd139182-864b-41c1-9a58-9b62a23b6410",
            "flavor_8_129024"        => "fe2fdbe8-1370-462a-9bf3-d4fcad66f836",
            "flavor_8_130048"        => "b092ef41-4ad7-4f79-b9a7-40500d6186f6",
            "flavor_9_5120"          => "609e44ec-bdb7-4108-a84b-252c52b5c251",
            "flavor_9_7168"          => "f3e73af5-0885-4286-8032-217c433f18c5",
            "flavor_9_9216"          => "74ad6cd6-5f1e-4721-af05-c48f0809f9c5",
            "flavor_9_11264"         => "636cfd0a-d7d6-4bfe-a513-1aefe4b34fbe",
            "flavor_9_13312"         => "f8865130-5933-45bc-8a1a-3ce708b5dc67",
            "flavor_9_14336"         => "b326c908-26cd-43ba-8241-5c20921170fc",
            "flavor_9_15360"         => "43363e97-14f9-4c06-892a-8e8695974719",
            "flavor_9_17408"         => "3c8748af-4e9a-4318-a94d-617275b1d8bb",
            "flavor_9_18432"         => "2f068c17-808e-4886-b2a3-37462f559ac0",
            "flavor_9_19456"         => "2c9cfe5d-392d-430e-b2c3-281e6746fc2c",
            "flavor_9_20480"         => "79a1e692-8afc-4077-a414-0efdb3782f4c",
            "flavor_9_21504"         => "7e00de27-7e3d-467a-82b5-c3ee3670ac1a",
            "flavor_9_22528"         => "63ce02c2-cf9a-4619-a64d-e5202cd6f4fb",
            "flavor_9_23552"         => "99132751-2148-4ba0-8e62-4fb5f8874e4d",
            "flavor_9_25600"         => "de3292be-5644-4c07-b6f2-d2bc0f139cb7",
            "flavor_9_26624"         => "ce05e8eb-f709-47e1-9b52-d0a0744b93e3",
            "flavor_9_27648"         => "cb193f08-e400-4f06-957b-df297c956d56",
            "flavor_9_28672"         => "12e983b7-8aa3-437e-a28b-cbb0e524afa8",
            "flavor_9_29696"         => "fa9bb485-bece-4773-8bf9-f62bbae8e62c",
            "flavor_9_30720"         => "be5253ac-f89e-48e3-a436-9f27131a08a5",
            "flavor_9_31744"         => "04fc24b3-1c50-4775-bb9b-0eddd1462b6d",
            "flavor_9_33792"         => "00e6a454-5f54-44e7-8e5f-38f48903aae2",
            "flavor_9_34816"         => "3a0d551d-d6b3-40c6-9897-42f82b464f93",
            "flavor_9_35840"         => "3948913d-47cf-447f-8ba8-cf043cfc5922",
            "flavor_9_37888"         => "95ef391e-b650-4365-b677-272d4eaf76c3",
            "flavor_9_38912"         => "1d55a3bc-c46c-40c1-b0d0-3bec4e0e7f23",
            "flavor_9_39936"         => "f1e59ed7-35a3-423f-8878-c2c01847216d",
            "flavor_9_40960"         => "07d43183-f5f3-4433-b661-d7b67a00fe9e",
            "flavor_9_41984"         => "4fa84853-1423-4dfa-9ac4-b6784d730649",
            "flavor_9_44032"         => "92119b12-a89f-40c6-a647-a0d02ef0a3ed",
            "flavor_9_45056"         => "5ff9e10b-92d8-4cac-8bff-e8d3e908ba7c",
            "flavor_9_46080"         => "282650fe-e01b-4b70-b101-219ef33f6c1a",
            "flavor_9_47104"         => "adcab927-4651-4ce0-97c9-f7c4bb309e28",
            "flavor_9_48128"         => "76990bda-a53f-4769-b043-c808eb6ef366",
            "flavor_9_50176"         => "7da657d8-da83-46a5-b6b0-bed10d51bc70",
            "flavor_9_51200"         => "d7b02ce5-77ee-416a-a28b-3a735a6ce1cf",
            "flavor_9_52224"         => "371dcc40-8db2-492b-ab2b-d6dd14c256f9",
            "flavor_9_53248"         => "37db6500-17b5-4cee-8771-20ba08e16ecd",
            "flavor_9_54272"         => "3669463e-40cb-4336-856b-b700c6c28ddd",
            "flavor_9_56320"         => "d5bc2a98-735d-498b-b295-27e20cccdfba",
            "flavor_9_57344"         => "574577bd-6d36-40d7-99fc-2a02b60320bc",
            "flavor_9_58368"         => "86d21652-9a00-4816-b98e-d18ca2c46e8d",
            "flavor_9_59392"         => "7a660424-100e-401f-8057-c21cce40f671",
            "flavor_9_60416"         => "458defed-964e-4b58-a05a-514e76215029",
            "flavor_9_61440"         => "e9145c9a-dffc-473a-9ee2-171204b11f3a",
            "flavor_9_62464"         => "3dfed6c4-3f88-4f6a-ac79-f74a53a9a7c2",
            "flavor_9_63488"         => "711775cb-1488-4519-bb8b-02bbe68687e6",
            "flavor_9_64512"         => "ee4a451f-e854-4ff7-82da-092597db08c6",
            "flavor_9_66560"         => "86af5725-2fea-4107-b78f-6abf2733f5a6",
            "flavor_9_67584"         => "8c7c2197-1051-4f27-b63a-b165500ef4a3",
            "flavor_9_68608"         => "849ddf95-81cb-4a8f-a73a-f1f23351c6d4",
            "flavor_9_69632"         => "3adff7b4-749b-475e-b92c-36f6bceaa51b",
            "flavor_9_70656"         => "456e9ea0-1f8c-46e1-a0cf-fc89d9a9a3a0",
            "flavor_9_71680"         => "6d53e9c4-ec2d-4d6a-907c-40217d652aa3",
            "flavor_9_72704"         => "0577648a-80e2-4646-a458-d812aa7464fb",
            "flavor_9_73728"         => "5132bad0-70f7-41e3-8d24-29560ad8fe57",
            "flavor_9_74752"         => "09dc3fd1-4b08-4429-a3f5-a7ba828c9c17",
            "flavor_9_75776"         => "70614d25-9d4b-4fd7-9019-7f5d04eec2e5",
            "flavor_9_76800"         => "d45ce8c8-6a03-4eea-83fd-2d13ec4ccaa5",
            "flavor_9_77824"         => "74aebd1e-c3ed-4113-aa3c-c42c75e0eaf6",
            "flavor_9_78848"         => "fae66174-e3a8-4d51-9c26-61cd78e8db8b",
            "flavor_9_79872"         => "a92dd375-e79e-4bec-9dc7-a3057874e923",
            "flavor_9_80896"         => "d980d887-1c75-4306-a21b-2df7493fd815",
            "flavor_9_81920"         => "5a7eb7a8-892f-40e0-8f13-bcd567cb6e5e",
            "flavor_9_82944"         => "21748c63-0741-4035-924f-8a8d3f8e06fe",
            "flavor_9_83968"         => "2ed441fe-3439-4450-9651-e38432079636",
            "flavor_9_84992"         => "d2c60bdb-26d3-4954-b632-2b36502bb41d",
            "flavor_9_86016"         => "60d38426-8e72-433f-b623-16b9f19785aa",
            "flavor_9_87040"         => "360e54b1-993f-4eea-9f95-cc2ab0a0ff1d",
            "flavor_9_88064"         => "96b89894-c4a4-480a-a212-effc84d980e2",
            "flavor_9_89088"         => "f76e8edc-1db7-4ab3-9ca3-a27f7746333b",
            "flavor_9_90112"         => "879d7a57-bf22-407b-b0b1-521ec8310431",
            "flavor_9_91136"         => "d1640202-b96e-4577-abb1-a26e3df7fbf4",
            "flavor_9_92160"         => "ec61f3c0-79c9-4fd6-8828-7ee814dc8327",
            "flavor_9_93184"         => "2639d5e6-ea47-400e-967b-29f5f96a14eb",
            "flavor_9_94208"         => "08377cdb-de1f-4ca1-a596-be330d7b2e07",
            "flavor_9_95232"         => "c292abf9-2d82-4fe5-951f-fa31a6b14216",
            "flavor_9_96256"         => "2e8f6699-20b2-4394-aa8e-b388612094a3",
            "flavor_9_97280"         => "5a145202-06f1-4204-9be5-201029df8f25",
            "flavor_9_98304"         => "fa76c05d-0d13-4e7e-896b-52e80629f3c8",
            "flavor_9_99328"         => "141213c1-c3e7-4d54-85ca-56d288db9cab",
            "flavor_9_100352"        => "0976efb2-2e84-4257-9f35-3030b9050d32",
            "flavor_9_101376"        => "0d7b3ab1-2547-44f2-abbe-72da69a08337",
            "flavor_9_102400"        => "8ed0db6a-9db5-4359-97b0-505aa6ee158a",
            "flavor_9_103424"        => "5f242b05-261b-4525-b03a-e391254ab079",
            "flavor_9_104448"        => "6a3a7e0a-419f-4241-83fc-d4e285728763",
            "flavor_9_105472"        => "ffa0a6d1-665f-413d-9d2d-032aa5c57ef6",
            "flavor_9_106496"        => "ae42e159-84d6-4cd6-84b1-bc5ca6d050b6",
            "flavor_9_107520"        => "80fffe32-447d-46b1-9065-493b98ce4527",
            "flavor_9_108544"        => "a7575eea-24e8-4776-8377-3cb93db61141",
            "flavor_9_109568"        => "ec842b82-a930-4efc-bce0-db072461d7db",
            "flavor_9_110592"        => "7ca2d402-9a5b-4c2b-852c-3a81bf8ba6bf",
            "flavor_9_111616"        => "a1076f7c-9383-48a1-a137-7dcabd6b3298",
            "flavor_9_112640"        => "165d6e03-0fad-426b-9994-78df451f3937",
            "flavor_9_113664"        => "01bde343-ed50-430a-93b2-667cbc4e87f8",
            "flavor_9_114688"        => "6afe412b-d0a3-435d-8228-08a24c809fb4",
            "flavor_9_115712"        => "f08bee5f-a068-4eac-bbab-c37af41a6b04",
            "flavor_9_116736"        => "e0e72c61-8ab0-4058-813b-07f22e0d901b",
            "flavor_9_117760"        => "1393f4cb-42a8-4070-a5bd-f121ee43abf9",
            "flavor_9_118784"        => "072e28fa-315c-4ba3-be97-45a73ca5497a",
            "flavor_9_119808"        => "9bb85e08-05dc-4dda-84c7-02f3862d3df2",
            "flavor_9_120832"        => "0cf767ac-5a87-494c-8af0-db5d4e34b024",
            "flavor_9_121856"        => "498d9037-2d5f-444d-9790-cdc6a2edb9b8",
            "flavor_9_122880"        => "cd5d7498-b158-4625-9751-302e740f9218",
            "flavor_9_123904"        => "0ceca915-eee3-4fde-abd7-e625bead1778",
            "flavor_9_124928"        => "a8c870d9-7239-4cf4-9c1f-e62ec3a76b1d",
            "flavor_9_125952"        => "b2a390a6-5c35-488a-a722-4cb9b286e719",
            "flavor_9_126976"        => "bdf391ff-0e83-4cb7-93a7-81c01e3962cb",
            "flavor_9_128000"        => "24499bd4-4bbe-4fd7-8c20-c6b2704ff137",
            "flavor_9_129024"        => "e0bb871e-54a2-4f75-a575-4d44371dfca1",
            "flavor_9_130048"        => "490d61d1-49be-4b33-946c-04ca2e6b8666",
            "flavor_10_5120"         => "b7290577-0015-43b0-9706-fc3cde3c301b",
            "flavor_10_7168"         => "81691daa-cf39-4957-bae2-b9393b19eb4f",
            "flavor_10_9216"         => "21442e54-22e8-492e-84e1-1105ef498c02",
            "flavor_10_11264"        => "27d9b434-283f-4a09-93d8-eab74ca89dee",
            "flavor_10_13312"        => "59d24d0a-56d3-479c-8cdf-d1844fda79f2",
            "flavor_10_14336"        => "9e6b8c16-de1e-4cc1-9277-946c00b93532",
            "flavor_10_15360"        => "deeec5eb-4e90-48a1-8430-f50ab758fe4d",
            "flavor_10_17408"        => "3e7ad062-15f6-4478-ba26-71af3d73304b",
            "flavor_10_18432"        => "cdf19890-6cd0-44a1-96d7-d67d9ac9625c",
            "flavor_10_19456"        => "98497607-979c-498f-b6fa-a2a8d2635f42",
            "flavor_10_20480"        => "d48d8a18-b051-4b39-b37a-d518eb3b2492",
            "flavor_10_21504"        => "0ffcfc14-4abe-4a5c-b691-1affe6d44215",
            "flavor_10_22528"        => "bdef6d2c-b640-47aa-ad8a-5792d7b24e19",
            "flavor_10_23552"        => "965d13dc-cdf1-4acc-a2af-a1dde71f2a97",
            "flavor_10_25600"        => "5211ffeb-0dc3-4f4e-8509-8a3b3fe661af",
            "flavor_10_26624"        => "b6b7ca26-5020-4ce3-81da-b995e7d34e09",
            "flavor_10_27648"        => "205d8a8b-b11e-407f-8dc4-faae3ed57d67",
            "flavor_10_28672"        => "704b79af-e446-4fcc-b584-0a4fed89f2e1",
            "flavor_10_29696"        => "f6214a89-07d7-403c-a07c-1da84311f85e",
            "flavor_10_30720"        => "95a645df-a800-4c8e-ba55-4e7c9bc51af9",
            "flavor_10_31744"        => "4b3505ee-56e4-4a23-b402-201bfbf87837",
            "flavor_10_33792"        => "c08ab0d8-b805-4758-8061-e762e11722c2",
            "flavor_10_34816"        => "81d467c6-ddbd-431e-b327-42d029d1e2c6",
            "flavor_10_35840"        => "2a335f92-d345-4e6e-893a-601dbcb3a6f0",
            "flavor_10_37888"        => "9e52ef52-5c18-4ae6-819a-429ae3f78fc6",
            "flavor_10_38912"        => "8fa9e8b7-1420-4b07-ad2b-6ab221281314",
            "flavor_10_39936"        => "c75bee84-ac5e-4846-96aa-81a6e674933e",
            "flavor_10_40960"        => "18126225-a25d-42bc-8112-c4edd8074600",
            "flavor_10_41984"        => "9e0cf0a4-1d97-4375-8153-4dbe4a5908e0",
            "flavor_10_44032"        => "d7bd67bd-0142-4f58-b57b-aa8e365b2052",
            "flavor_10_45056"        => "93759277-214e-481a-8916-384461d7798f",
            "flavor_10_46080"        => "f14112f5-eee7-4d21-9030-d5d04d255a02",
            "flavor_10_47104"        => "c599a8df-974c-48a9-b413-2b2091b9f8ce",
            "flavor_10_48128"        => "7c393414-2690-4ad9-932f-6795357b8471",
            "flavor_10_50176"        => "07a18fff-9a01-4d5a-8733-5368606dbd05",
            "flavor_10_51200"        => "5561c162-b6d4-42c0-a5ab-e9f3b742cecd",
            "flavor_10_52224"        => "f823c5e5-6d0d-43c1-b86f-a168be6ebe8b",
            "flavor_10_53248"        => "9d069bdc-06c3-4e18-9388-9bf96838ad8f",
            "flavor_10_54272"        => "d9a9b1b4-6108-4053-976c-03b0228bd598",
            "flavor_10_56320"        => "6bcf9a91-9378-47a5-a79e-af6a0b3d492a",
            "flavor_10_57344"        => "feb7f8b3-65d1-4f32-b6e1-29f866baf1be",
            "flavor_10_58368"        => "884a94e6-c7b0-4950-8ba6-5c9471529140",
            "flavor_10_59392"        => "8771ede0-bbbe-41cb-886f-8f01368a3485",
            "flavor_10_60416"        => "b8a7006f-bc70-482b-857d-2f97d94ea089",
            "flavor_10_61440"        => "5be9757e-2414-4e3c-81c3-ba81e302cd60",
            "flavor_10_62464"        => "c9bb4e66-9dae-432d-a98a-beabeaef7a8a",
            "flavor_10_63488"        => "08896d7f-6a85-4dbe-a499-a944be7b3890",
            "flavor_10_64512"        => "d61bfdb3-663f-4b8c-8d57-648c4c191ec3",
            "flavor_10_66560"        => "63b7dfb1-d14c-41c6-ad20-fa5f60a042f3",
            "flavor_10_67584"        => "dbefa7e5-e529-4cf7-840e-7f08ff6822c0",
            "flavor_10_68608"        => "cc985a17-b90b-4308-85fd-68fccb327bc2",
            "flavor_10_69632"        => "24e4575e-c24e-4e18-9222-01161b8fa2b9",
            "flavor_10_70656"        => "5eeb073b-af97-49c4-8a44-b38a850bf3a5",
            "flavor_10_71680"        => "38290c1d-9ad0-4760-815e-77db1cc4fbdb",
            "flavor_10_72704"        => "76fabef2-f24f-4885-8c9f-aa82bf69afda",
            "flavor_10_73728"        => "19f4149c-89a5-4872-9a1a-6f2a66f627fd",
            "flavor_10_74752"        => "483e0cf6-3cda-453a-a552-f8a122c59983",
            "flavor_10_75776"        => "b2c39dae-292d-4bdb-a7ac-83a405bfc8e0",
            "flavor_10_76800"        => "c0095c84-f629-4108-a34a-db11a7c35b2e",
            "flavor_10_77824"        => "2adfe43e-8595-4b19-ac2a-9a8fcfc7d0cc",
            "flavor_10_78848"        => "affe054f-0ea0-463e-a679-74605f010511",
            "flavor_10_79872"        => "c88827ba-21d8-4265-82b0-112b5be7d80f",
            "flavor_10_80896"        => "6f877b6b-2605-44ed-85e9-cba8bceb7a06",
            "flavor_10_81920"        => "bb3bb68b-91e7-4b20-a0f7-b1312874d7f1",
            "flavor_10_82944"        => "77ee5694-e9ec-405b-8895-90a896a5d5ca",
            "flavor_10_83968"        => "8423955e-c123-408c-8d0f-1302428c4922",
            "flavor_10_84992"        => "b68b494c-56e9-4a78-b781-99118483a9c3",
            "flavor_10_86016"        => "54c0bafc-4adc-48c6-8563-f1f9af33978e",
            "flavor_10_87040"        => "aecb3081-b793-476c-b611-1cb6bf2550ec",
            "flavor_10_88064"        => "5b76a849-1489-4cf7-883f-c2358ed574cf",
            "flavor_10_89088"        => "573814ee-d81b-43a2-a766-dd0d11585191",
            "flavor_10_90112"        => "f1c6f8f1-2d29-4183-9c94-11554b961be5",
            "flavor_10_91136"        => "5a73173d-3376-4636-b171-f2ae25037717",
            "flavor_10_92160"        => "826f3f51-b502-45f0-8927-b862bca2027e",
            "flavor_10_93184"        => "4cd3a32d-cd79-45be-8900-d3e6bdb51e6f",
            "flavor_10_94208"        => "dd5781bc-0d2b-4b1b-aebd-693a77bb31e7",
            "flavor_10_95232"        => "18dde632-ed74-44e3-889f-b104f3963e5f",
            "flavor_10_96256"        => "1ae2a181-412a-4dc5-a735-ed6c1f99c1b9",
            "flavor_10_97280"        => "64c90cd8-a354-4c6d-9007-4a345967b81b",
            "flavor_10_98304"        => "e4fdd39e-2bf3-43b3-af37-f06dde60f017",
            "flavor_10_99328"        => "a32e002f-fd04-41ad-b094-6fd62877c9ec",
            "flavor_10_100352"       => "4b3541c3-22e4-4c38-b3e5-5566de1f3d9d",
            "flavor_10_101376"       => "362bf764-d4e2-47d0-b17c-0e8fb7071a65",
            "flavor_10_102400"       => "4752f061-84f3-4fe9-938c-74b4eff96e3a",
            "flavor_10_103424"       => "8f807398-6fa9-46f5-abca-4040fdd2280b",
            "flavor_10_104448"       => "895c9c79-029f-4ed9-b1c6-98f5486fd7e5",
            "flavor_10_105472"       => "0b69b65f-9799-4e74-9bb5-8e39f783cae6",
            "flavor_10_106496"       => "9e04a838-2a27-4fab-b6ee-ed29c88160d8",
            "flavor_10_107520"       => "b9bc4e12-b573-476e-834f-3f020fd11a0c",
            "flavor_10_108544"       => "e980a1d3-dc9f-4a39-ad76-a2e7f88dfabd",
            "flavor_10_109568"       => "fed5ac49-df1a-4388-9458-2577b5347f03",
            "flavor_10_110592"       => "ed81a1a2-b9ff-4d72-a107-ed507f025556",
            "flavor_10_111616"       => "dea54606-0f8c-4618-8958-f7753a5c1626",
            "flavor_10_112640"       => "b0eee2b9-d019-4869-b2c9-1f930b865ff7",
            "flavor_10_113664"       => "b571bfac-868f-4d2f-96f8-6e117c5c76b8",
            "flavor_10_114688"       => "07b6b68b-5fae-48d4-be42-50270578067a",
            "flavor_10_115712"       => "ec0b9cdf-61c3-429f-a919-3f7afa92842c",
            "flavor_10_116736"       => "665cd7ee-2dcc-49fb-b508-c89926973386",
            "flavor_10_117760"       => "8151d857-c18f-452c-8629-c1a0e76f0281",
            "flavor_10_118784"       => "4c2577e3-7b91-46d7-bf83-5c2d34e65171",
            "flavor_10_119808"       => "aa8f7aba-6297-4631-b370-8809a98fea6b",
            "flavor_10_120832"       => "170cd8fd-77b3-4f02-84fa-24256f37b216",
            "flavor_10_121856"       => "74ee762b-8ee0-4966-8d22-7d0d1d45f887",
            "flavor_10_122880"       => "b9cb81ca-a980-4761-8c44-906656ee215c",
            "flavor_10_123904"       => "12760709-1865-42cf-9cca-1fc0abbf9dfc",
            "flavor_10_124928"       => "a6bc53c4-120e-4fe0-836a-6f18d6d728a3",
            "flavor_10_125952"       => "85eb33ca-cdb0-4161-bbfd-e27cde505427",
            "flavor_10_126976"       => "5cd9b02f-a11f-49b1-9f07-96f1ecd5473b",
            "flavor_10_128000"       => "d9b70429-cb97-4f59-b74f-05a338cbc372",
            "flavor_10_129024"       => "f5bba26a-d221-4cd8-b9f3-61f113db1ee1",
            "flavor_10_130048"       => "35a6911d-d645-4ff4-bae7-b15aab43bf23",
            "flavor_11_5120"         => "2cdd55e8-6401-4b9c-b956-f1b66c98c253",
            "flavor_11_7168"         => "15ccb0b4-5053-4662-ab4f-6d125d20eae8",
            "flavor_11_9216"         => "b55046a5-5061-457b-8b04-e98cc95d49b4",
            "flavor_11_11264"        => "074d72a6-5b7c-4b7f-b94a-f59d997682dc",
            "flavor_11_13312"        => "e2f40394-ff63-4dc4-9cca-cdd39375e1d3",
            "flavor_11_14336"        => "6b69a684-0593-42f9-8ed0-2af009647fef",
            "flavor_11_15360"        => "085e853a-d16b-4112-84e7-e89febb96e9a",
            "flavor_11_17408"        => "b10118d0-1ce2-40b7-956c-0830db5bd625",
            "flavor_11_18432"        => "8f3119d5-6cb2-4f3b-b39b-713d541a7750",
            "flavor_11_19456"        => "beee38cf-8bc4-42e2-8b0f-e27dfb43e24b",
            "flavor_11_20480"        => "a932d485-8709-4850-bbb2-387f8b22143a",
            "flavor_11_21504"        => "dda3ac20-c627-4497-82a7-a3d789951466",
            "flavor_11_22528"        => "9322a45d-aa88-495f-9ac9-8220b4abc44d",
            "flavor_11_23552"        => "6b120c7b-aacf-41ef-96ff-344942c3d1a2",
            "flavor_11_25600"        => "0e83691f-ccac-4e82-920f-ebcba3c80e43",
            "flavor_11_26624"        => "ef5d336d-6325-4296-925b-c5a1b68f456f",
            "flavor_11_27648"        => "3671b50a-231c-4ece-b830-495a6f17e241",
            "flavor_11_28672"        => "ad1663ad-0afe-4596-894f-3f1e62365561",
            "flavor_11_29696"        => "67b1309d-ffea-477f-a72e-a1536e91ec6e",
            "flavor_11_30720"        => "961b1990-c7cd-4ef6-b3c6-01b6e9e66864",
            "flavor_11_31744"        => "9788fb43-8561-4857-a4ad-846602eca66e",
            "flavor_11_33792"        => "398fe2d0-1a73-47b6-bd35-f051da51a489",
            "flavor_11_34816"        => "afead35e-98e9-42d5-90ee-ffb110906943",
            "flavor_11_35840"        => "4f7bb992-a2cc-4042-945e-8e620fc87be8",
            "flavor_11_37888"        => "aefe88c2-0f72-4c2b-a51a-3fbf0674abfd",
            "flavor_11_38912"        => "9542be49-3d64-48b4-baef-9821cc91df4d",
            "flavor_11_39936"        => "3b08fbc7-8889-4d89-a58e-73ba87080410",
            "flavor_11_40960"        => "6cb53f8f-541f-44c2-a0a6-ac65a859ffa0",
            "flavor_11_41984"        => "9adc71e8-46da-4734-aae4-7f1d812e47e0",
            "flavor_11_44032"        => "ec5a508d-62cd-4704-a7ee-7b9d3c8fe244",
            "flavor_11_45056"        => "5a41e470-286a-46e2-bee6-b343b18a0dea",
            "flavor_11_46080"        => "3edc4ff5-edb4-45e0-8f56-36bb17b3c485",
            "flavor_11_47104"        => "33dc188a-3535-4b41-946b-bf81984ba81c",
            "flavor_11_48128"        => "67f55e50-be2d-457c-a63f-6be02dbe8d8b",
            "flavor_11_50176"        => "974cc985-09a5-40f9-94ac-7e2afee38f8e",
            "flavor_11_51200"        => "8f1866bf-01ac-49f9-a747-b694352d258b",
            "flavor_11_52224"        => "8b48e26f-4698-4184-8ae5-da1aa913c478",
            "flavor_11_53248"        => "628a0003-29f4-4793-9bc0-958c051d32a3",
            "flavor_11_54272"        => "d2211c41-f754-4edd-aaf7-d973c2b8a7ba",
            "flavor_11_56320"        => "c27e549c-1a9a-444c-91e8-1263174db7d6",
            "flavor_11_57344"        => "6ddde6bd-9f76-44bd-950e-583e656ec5a8",
            "flavor_11_58368"        => "ede726c7-f495-4131-b848-26d64064d6bd",
            "flavor_11_59392"        => "53eb54f2-226c-47fe-8666-5d9497fe5e87",
            "flavor_11_60416"        => "2d459788-1715-4865-bff9-c4bbf3cc4999",
            "flavor_11_61440"        => "afce37ae-56f7-40ec-addb-e978e707f6f4",
            "flavor_11_62464"        => "cd30932a-ca5c-4d9a-b2c2-5dde4910191d",
            "flavor_11_63488"        => "d1ef66bd-6796-4447-a2ec-2bf3c3d89810",
            "flavor_11_64512"        => "f30abb13-6102-4ee4-b1fa-a196d13ff648",
            "flavor_11_66560"        => "3594322c-f23d-4e7d-bada-2022e2d00bfa",
            "flavor_11_67584"        => "63751e18-9fa8-4bec-af01-be68de9f0a10",
            "flavor_11_68608"        => "d20debfa-d6cb-44d2-80fd-19a2b78c83dc",
            "flavor_11_69632"        => "39335778-b1ec-4346-a196-4c29aa11f3b7",
            "flavor_11_70656"        => "e3a35088-cf61-47bc-ae36-631a77d479e8",
            "flavor_11_71680"        => "97eeef90-bcc3-4c8f-8228-20d12dd12880",
            "flavor_11_72704"        => "9dd2e448-2bad-4cfa-ad13-8db65e1ac81d",
            "flavor_11_73728"        => "b43c7352-d886-4fe6-80ed-b140cb0fdec1",
            "flavor_11_74752"        => "ecc0a244-c49e-411b-ae86-6bf0e3e23903",
            "flavor_11_75776"        => "458a4ee5-84c4-410b-9946-1d47da89b157",
            "flavor_11_76800"        => "673e455f-bb94-4474-860d-814e1304bc93",
            "flavor_11_77824"        => "72744888-798c-4fcc-961d-b0d9a5f6d017",
            "flavor_11_78848"        => "e97ca858-6b81-45e1-97b7-5831eae92022",
            "flavor_11_79872"        => "37a59d6b-4669-41f2-a360-e92f5034879e",
            "flavor_11_80896"        => "d08fca5e-64b8-4332-bf96-fded93f4f42a",
            "flavor_11_81920"        => "f4516054-2f5d-4a75-8507-8bb7273de497",
            "flavor_11_82944"        => "d7453c40-b3df-4460-9826-e67f452809d0",
            "flavor_11_83968"        => "b8a41cc3-5902-4798-aa26-0850d9dfb969",
            "flavor_11_84992"        => "15e0b27a-496e-4561-89da-3f857c3fb79c",
            "flavor_11_86016"        => "915063f4-bc1c-4507-8994-1ce19f5e495f",
            "flavor_11_87040"        => "314decc0-b938-4fb1-9b9f-772107f7a0f8",
            "flavor_11_88064"        => "db679d3d-6e1f-491d-b21d-9730f2a0c623",
            "flavor_11_89088"        => "4afc8b83-5e4c-4222-8f5f-4a0587937da6",
            "flavor_11_90112"        => "a53fc0bb-201a-47d0-a2da-bffb44fb8cd6",
            "flavor_11_91136"        => "7573de64-7547-4023-ac08-69addf90be1f",
            "flavor_11_92160"        => "5e23ed5e-baa9-4534-9cc6-9fcefbe657cb",
            "flavor_11_93184"        => "ac891fd5-fe60-4637-a82e-6953bb2d16da",
            "flavor_11_94208"        => "fb04c710-b87c-4c62-8547-7c6421290178",
            "flavor_11_95232"        => "35464791-7e84-4da6-9ac7-d5a64dbb675d",
            "flavor_11_96256"        => "4d77ecd2-8725-420e-8b81-d0e732b360bb",
            "flavor_11_97280"        => "dd0e7a32-7679-4168-abfb-60a33601d392",
            "flavor_11_98304"        => "88fec783-8ce0-44b0-af43-7e350c6651d0",
            "flavor_11_99328"        => "df6b6c90-cac8-4398-a7af-4e7d5311196a",
            "flavor_11_100352"       => "ab015cc0-b556-4074-a488-ce7b9f98241e",
            "flavor_11_101376"       => "c5b2bc58-4a69-4bd4-8cc0-cf1437627734",
            "flavor_11_102400"       => "146f003e-6193-478e-828a-c4e1972ea3e6",
            "flavor_11_103424"       => "13723840-8604-459b-8617-41a057568fc1",
            "flavor_11_104448"       => "8e32f262-54f4-4d1f-bbee-7188f0f3189b",
            "flavor_11_105472"       => "80dfc572-9581-4854-844d-a2c08d348e9a",
            "flavor_11_106496"       => "73e9b162-6860-4d7e-b0e5-29632ba2da0c",
            "flavor_11_107520"       => "8fb464f4-3b8f-4386-809e-997a5d2289c0",
            "flavor_11_108544"       => "d7b5c4ae-ce6d-48ff-8f54-660f61ba1612",
            "flavor_11_109568"       => "81523a13-a967-47ba-a792-2f7e92c238e1",
            "flavor_11_110592"       => "508c6252-8e10-497c-b6f4-362333f5df45",
            "flavor_11_111616"       => "d7fe6bfa-48d3-4aef-89ed-6d1d755df208",
            "flavor_11_112640"       => "f5d513fd-a104-4ced-b86b-2efb0f05db1b",
            "flavor_11_113664"       => "c34ed798-b650-42b0-a734-934adafd1d6d",
            "flavor_11_114688"       => "e4bd743c-7b81-4135-83ff-a2e9541c36fb",
            "flavor_11_115712"       => "18ec2047-c1af-414f-bc6c-a239b3009380",
            "flavor_11_116736"       => "64df1ad3-ced5-4651-ae75-9f1fcc149ca7",
            "flavor_11_117760"       => "426aa58a-4a2f-424a-b8fe-0aa88883e6ba",
            "flavor_11_118784"       => "c0b681c8-2e99-4cfd-98d0-b041f22a2925",
            "flavor_11_119808"       => "c6b7f3e6-6333-417e-89ba-e35c741dec22",
            "flavor_11_120832"       => "aa99752c-cd99-4e1f-b273-def9910daea1",
            "flavor_11_121856"       => "cce3c22e-8112-4bd7-b77c-d41290e8fcf2",
            "flavor_11_122880"       => "814aa0c9-8ded-43cb-a92d-7897742db2da",
            "flavor_11_123904"       => "0071ad14-c698-49d4-a2dd-b1903319b998",
            "flavor_11_124928"       => "3e2f5e7c-bba3-4757-bedb-c91c87822c13",
            "flavor_11_125952"       => "30f86b8a-96ca-4a31-93a7-fa0d6e4f6b81",
            "flavor_11_126976"       => "a82d7a07-417b-4306-908d-666b1cb8a49b",
            "flavor_11_128000"       => "9211bf64-9604-4736-b986-1bd1c12d56d8",
            "flavor_11_129024"       => "01edc1ff-6760-42fa-b4b6-06a383a65b2c",
            "flavor_11_130048"       => "b587ab94-4a27-406d-9f3f-6e1911f65bee",
            "flavor_12_5120"         => "a583e1ad-b1ef-4fa5-814a-9161f05eb465",
            "flavor_12_7168"         => "f7ebf716-f402-4b81-ba29-22b63d638c70",
            "flavor_12_9216"         => "00334f9b-1274-4192-9f3e-1d67f3d31d52",
            "flavor_12_11264"        => "8c13bbd4-180c-49d5-b8ff-bb8312c6d2c5",
            "flavor_12_13312"        => "6efb393a-6032-4b8d-9386-422927976b0f",
            "flavor_12_14336"        => "c670b871-6f24-44c4-a62f-9f17bbe5cc94",
            "flavor_12_15360"        => "dcf19162-4d3b-47d1-a935-58783cedd90a",
            "flavor_12_17408"        => "e4d51572-af56-4a00-8bd6-e1f7f504c6b6",
            "flavor_12_18432"        => "7d69c647-1881-40b7-ab5a-d7e286cd6f63",
            "flavor_12_19456"        => "90279432-7f34-434b-8f6f-36c12c4a45d9",
            "flavor_12_20480"        => "dd51bd51-1c76-491a-aaea-5ad3ee05b0a0",
            "flavor_12_21504"        => "b95ce43a-4256-4d73-87b3-e26481cbaa63",
            "flavor_12_22528"        => "86724c6c-7233-4f61-bb3d-84ac6be036a2",
            "flavor_12_23552"        => "f08f9a2c-62e8-4570-863e-22d04ffe299d",
            "flavor_12_25600"        => "f6105400-3a30-4058-9bd5-b2a5ebec9723",
            "flavor_12_26624"        => "8644c4a6-ec6b-46ce-bce3-f17465f1e50e",
            "flavor_12_27648"        => "8e13d581-7663-471d-924d-500dfcab92b7",
            "flavor_12_28672"        => "87be211d-88c9-418f-a46a-6508f4e7d8d6",
            "flavor_12_29696"        => "f573ac3c-94e3-4a12-8a78-ea859bc33874",
            "flavor_12_30720"        => "a2790146-e9e5-4c2d-8b98-0dcc9d1575ed",
            "flavor_12_31744"        => "72f20ba1-aee1-4d29-adef-73093a1f7966",
            "flavor_12_33792"        => "bc3f0ac1-7102-4cca-9546-b3040dd85280",
            "flavor_12_34816"        => "e93fdedc-4718-40ac-bc79-b0c4794a928a",
            "flavor_12_35840"        => "8844aa74-cab1-4966-857e-b3247767dcf2",
            "flavor_12_37888"        => "9c546ee2-4e7c-4850-bd36-795e80935c60",
            "flavor_12_38912"        => "e6f1a7e6-ee22-47fa-bbef-05409bcf5c3f",
            "flavor_12_39936"        => "688ec8b5-b493-4cfa-bad9-60f63ba7625f",
            "flavor_12_40960"        => "0ebd35f8-3638-4448-adf7-3aa4ed70d5fc",
            "flavor_12_41984"        => "39dbc5e2-299b-4db3-a9be-936e0634ad2f",
            "flavor_12_44032"        => "e667d728-be11-465a-a895-e208fc9194fa",
            "flavor_12_45056"        => "44d78df4-6d02-4fd4-b944-abb14427e3a5",
            "flavor_12_46080"        => "86e5f882-6012-4928-84f7-e9572f17b77d",
            "flavor_12_47104"        => "abc3666a-5cb5-44a4-9cff-bc71f0695363",
            "flavor_12_48128"        => "54b47a65-c3ed-4890-b0f9-259e27b6c384",
            "flavor_12_50176"        => "74f6f611-023d-48f7-b3ca-c2eef3b317d0",
            "flavor_12_51200"        => "6fc6d907-fd7b-4994-86a6-9daf4f5e7893",
            "flavor_12_52224"        => "87759959-b055-4323-995b-d2924d3cf4d1",
            "flavor_12_53248"        => "0c8e641a-a305-4e5b-9090-9ed1fe88c0ab",
            "flavor_12_54272"        => "1e2a48e6-3900-42cb-87fc-4fe56a0de522",
            "flavor_12_56320"        => "ff0990b5-38b7-4df9-9c37-b0bc5990c983",
            "flavor_12_57344"        => "cc5e1cf5-756f-468b-9fac-3f65955fc5cd",
            "flavor_12_58368"        => "e9c1627c-94c3-493b-a3d5-f54bdb2d1c41",
            "flavor_12_59392"        => "4d69cbee-5d6e-4c8f-8543-e30624502fc4",
            "flavor_12_60416"        => "8f96b5b2-fc56-4335-bf66-fe4439dc3cc8",
            "flavor_12_61440"        => "8219ae56-86e4-427f-9fd6-30797c750221",
            "flavor_12_62464"        => "b89ed6f0-a160-42c7-a522-47dfb6c916dc",
            "flavor_12_63488"        => "44a67289-b326-4eff-b6c3-9a5a91d8be28",
            "flavor_12_64512"        => "51629a02-f484-448b-bd65-6d03f3d9728f",
            "flavor_12_66560"        => "2e073369-1a3d-42c4-bd25-ec5c3bb9be27",
            "flavor_12_67584"        => "8a2c07ba-c2df-4ac5-8f9e-5df086829189",
            "flavor_12_68608"        => "f7d6d301-9608-4e83-943d-8be39361141e",
            "flavor_12_69632"        => "42c1d927-c814-4f81-9c95-3a97628dad5e",
            "flavor_12_70656"        => "e2de99c1-5f1c-413b-bac2-3f2b961ef640",
            "flavor_12_71680"        => "5b9665d1-2b0b-4815-9d3e-e09124b9ce2b",
            "flavor_12_72704"        => "8edad237-9bf1-4e2f-b943-52ffbaa382b2",
            "flavor_12_73728"        => "8d261b93-395e-4e87-a7ab-5c0ffd5cf452",
            "flavor_12_74752"        => "53d50098-812f-46a3-8869-d303ea95a90a",
            "flavor_12_75776"        => "2dbb16ce-ac5a-4a4a-bd4a-7c6031ae41fc",
            "flavor_12_76800"        => "5d00e0cc-0f3d-4e0f-a634-c7df5e4fd626",
            "flavor_12_77824"        => "d4560381-e491-466a-b2ce-c71d6f27fe65",
            "flavor_12_78848"        => "c3b3c390-3249-49f5-86f3-1cb3876cd901",
            "flavor_12_79872"        => "d690c6b4-d180-4e38-af60-660ea33da61d",
            "flavor_12_80896"        => "ffe7fe13-c485-4b98-8713-d18237ec7d2a",
            "flavor_12_81920"        => "ffff0d72-9688-4ff3-8952-4ea3ed7d0719",
            "flavor_12_82944"        => "906f168e-b9d3-4f50-9f7b-73b7a0f10ad2",
            "flavor_12_83968"        => "34c65cbf-8fed-4957-8f7b-7f85631fa6bb",
            "flavor_12_84992"        => "ebcb5921-d62b-426a-8ab3-47bf6beeace3",
            "flavor_12_86016"        => "09d524ac-ad1f-4a3c-a65b-138d3b870f31",
            "flavor_12_87040"        => "c10a116f-77ab-414e-ac11-088c18d5a40b",
            "flavor_12_88064"        => "5a465462-08c8-4ec3-af6d-b5bc5f43fd3d",
            "flavor_12_89088"        => "5883b9ad-631d-406b-a112-e967adfb9b78",
            "flavor_12_90112"        => "6fb6a2fa-1c90-4527-b619-c0e97395f5ca",
            "flavor_12_91136"        => "53295d71-586d-4c68-8498-091b43e1adf6",
            "flavor_12_92160"        => "375dedc8-09b5-433a-a137-d04afa3d6eaf",
            "flavor_12_93184"        => "95dcc48d-02fa-4eeb-b56f-251d2d562aef",
            "flavor_12_94208"        => "6fb4234f-cd34-4643-9157-03c50f8195a1",
            "flavor_12_95232"        => "0f0c44fb-5c75-4b74-90a4-cd1c023fe2ee",
            "flavor_12_96256"        => "d97c82be-561a-485b-863c-039ac6960517",
            "flavor_12_97280"        => "bcf6cbc8-a31b-41e1-a47b-ffc6d1ab5ad0",
            "flavor_12_98304"        => "5dd7abab-f7fc-41f6-ba5d-3f103c625ca0",
            "flavor_12_99328"        => "c1bc59ba-aa8e-4128-9bd1-ec3174241129",
            "flavor_12_100352"       => "47cc8d6d-1f5a-4043-a5cf-d704f55aa252",
            "flavor_12_101376"       => "79546695-b340-404f-b30f-778252bede71",
            "flavor_12_102400"       => "d97d2dd1-78f2-4ce7-ad99-0a2a27e3d401",
            "flavor_12_103424"       => "74b62c8c-8e79-40bd-8194-0c4e54b6e134",
            "flavor_12_104448"       => "dd2f3e71-45c6-494a-81da-b82aa5e3c978",
            "flavor_12_105472"       => "4b4e6f83-77ef-4831-b7cb-b6445adf1c48",
            "flavor_12_106496"       => "2824ab25-ec18-4dfc-8d36-1daec3389496",
            "flavor_12_107520"       => "511d34a3-ed3a-40b3-9b8d-bd5f67d0852d",
            "flavor_12_108544"       => "eb4125f6-b66d-449f-bb92-f076d4e93e32",
            "flavor_12_109568"       => "33552005-d22f-499f-9f14-11248e2de8ac",
            "flavor_12_110592"       => "f93a10b7-08c0-461b-9c22-6bbc97f8fb61",
            "flavor_12_111616"       => "6b94491b-8cfd-4e89-9bc6-728baadd0c90",
            "flavor_12_112640"       => "5a6409b9-f1e1-4673-8b92-6dec143bf062",
            "flavor_12_113664"       => "3d95d4ef-4e9e-40bc-b0b3-8dadce5c3e67",
            "flavor_12_114688"       => "c04dee58-be6a-4f67-a92a-85b1998db2fd",
            "flavor_12_115712"       => "b9a40af6-32e4-478e-983d-7dbbd84bec76",
            "flavor_12_116736"       => "686b756e-43ac-4788-833a-3937caef07cf",
            "flavor_12_117760"       => "4e7ed6df-cbe5-4bb9-8d87-5ed281b1ee26",
            "flavor_12_118784"       => "e928c6f8-6988-44ea-9b99-cd36fd7ab57d",
            "flavor_12_119808"       => "bedea840-3dc0-49a6-9b51-13e28d154f3d",
            "flavor_12_120832"       => "0bee6174-d7c2-480e-854c-87690d64079e",
            "flavor_12_121856"       => "7dae5551-d789-4cc4-9dba-63bf935c10b0",
            "flavor_12_122880"       => "1c930742-30ed-45a0-98fd-4778f478305f",
            "flavor_12_123904"       => "cbb97e23-7f6e-4804-9cd3-f63b06968a64",
            "flavor_12_124928"       => "24ab2083-d13c-4e66-9455-d8a6a9ecee10",
            "flavor_12_125952"       => "934e8722-0033-4049-b23c-a0e3b9422d2a",
            "flavor_12_126976"       => "99c74e6f-2a97-4548-afd6-4ff0be467e0b",
            "flavor_12_128000"       => "c2f00855-bd2e-492d-ad99-4991d78e2980",
            "flavor_12_129024"       => "9ddce58f-be67-446c-8a1f-71a25b209e86",
            "flavor_12_130048"       => "be16a667-6af1-4735-be63-d66baa6716f8",
            "flavor_13_5120"         => "233567f3-d980-48ac-aa06-ef9bad6448de",
            "flavor_13_7168"         => "0c22d335-59d0-4d8a-9653-0918c730baaa",
            "flavor_13_9216"         => "4899430a-6b61-4d51-8972-4d5598bad300",
            "flavor_13_11264"        => "69c9c15d-2287-4984-a424-e86193b6094e",
            "flavor_13_13312"        => "32c03e3f-668a-4f5b-a721-4e34457baafc",
            "flavor_13_14336"        => "da7c39c2-16ea-48d8-a684-f97547ae7320",
            "flavor_13_15360"        => "cfd0efbe-56cf-4987-84a0-34ccb05a183b",
            "flavor_13_17408"        => "a0ca7a06-5f6d-415e-9857-9a9e7e9eca4c",
            "flavor_13_18432"        => "7c0fab37-0c95-4dff-9f63-14481e85f5a0",
            "flavor_13_19456"        => "97b96dd1-602a-430d-8b52-4731ee63b283",
            "flavor_13_20480"        => "38e5785b-4d0b-4088-9ffc-f3cf411a3ccc",
            "flavor_13_21504"        => "62622dc8-a36c-4879-bc94-8a902c05703f",
            "flavor_13_22528"        => "514e6a2f-28b7-4f8f-bbe7-c62294be4047",
            "flavor_13_23552"        => "0536ddaa-314d-4569-aa1d-97379debaee9",
            "flavor_13_25600"        => "37c77406-568f-449d-aeb0-13d0e576def2",
            "flavor_13_26624"        => "af81821a-b042-4223-9bb0-6c2a1d0d128f",
            "flavor_13_27648"        => "5e19cdf0-d2f4-46d2-9031-ed902a8b00e2",
            "flavor_13_28672"        => "e7016db9-26fc-427a-92a2-88ef76e5578b",
            "flavor_13_29696"        => "d8879401-4765-434f-97ff-c600369d083b",
            "flavor_13_30720"        => "4ae71c57-ce04-4fb8-a4a0-e4e0f787e249",
            "flavor_13_31744"        => "c8b29349-f81b-491c-adf6-1c6cf28566c7",
            "flavor_13_33792"        => "05ff01f0-5348-447f-abbd-072836924333",
            "flavor_13_34816"        => "0790e1b2-86c7-49ce-8bd6-38535308e742",
            "flavor_13_35840"        => "2f96981e-ca84-40af-8107-1311b5ae152c",
            "flavor_13_37888"        => "a3844c26-3d8b-4adf-9519-7dde69dbc08e",
            "flavor_13_38912"        => "0ed2a3b2-ee83-4a79-8efe-f1260ed03f02",
            "flavor_13_39936"        => "69c56137-290e-4c8e-8e43-79fe0f1fc4fc",
            "flavor_13_40960"        => "22234b9c-20a6-4df4-a95c-55c8a58351ad",
            "flavor_13_41984"        => "2569b3ab-3435-4fa9-9382-bdde123360ba",
            "flavor_13_44032"        => "291da4d7-80f4-4b87-a768-867b738bb69f",
            "flavor_13_45056"        => "09c2fed8-2cfd-4135-849b-96ee7bdd3449",
            "flavor_13_46080"        => "fdc5d8d4-89c6-4b55-995c-335efcfe35ff",
            "flavor_13_47104"        => "1e3d2b6e-d6be-4631-9c4b-d03bcacb9958",
            "flavor_13_48128"        => "e2c991c8-b7d5-454c-8b90-5beedaf1fcb6",
            "flavor_13_50176"        => "6afee481-36fb-43ea-ac97-c0b893e694b6",
            "flavor_13_51200"        => "5f93d53c-8943-4d1a-8d9a-4ec866b807b1",
            "flavor_13_52224"        => "67712de6-f670-4652-9a84-481972cf1e24",
            "flavor_13_53248"        => "84aa7475-29bc-4da2-9fbd-f871dea6fe92",
            "flavor_13_54272"        => "2df60662-ca62-4041-9931-3d880b7992a3",
            "flavor_13_56320"        => "bd6605b7-06c7-4464-8b99-86a8e0085ab0",
            "flavor_13_57344"        => "c9c2b407-1fa9-45d0-ba15-cff00539ce57",
            "flavor_13_58368"        => "3a4d213b-14bc-4382-b4eb-80c54703d435",
            "flavor_13_59392"        => "1b6cec95-2383-4770-bc97-cc216155ba16",
            "flavor_13_60416"        => "9b277840-75e5-49ad-bafd-66a3581c1aa1",
            "flavor_13_61440"        => "a436ee40-5337-4ea4-9300-56676a68845b",
            "flavor_13_62464"        => "ac3c81c0-1a6e-4ee3-8fc1-0ff38f3c6038",
            "flavor_13_63488"        => "b9586bbc-6a3a-4609-b51a-8f7788ce1f18",
            "flavor_13_64512"        => "93d3a7aa-53d3-4f9a-89c5-517927f692ad",
            "flavor_13_66560"        => "e726f9aa-3981-4c07-a979-71fcb3ced815",
            "flavor_13_67584"        => "60196d98-f26c-4eef-b62e-d24e948bb30c",
            "flavor_13_68608"        => "bb370247-6546-4347-94b5-9280265a8ef2",
            "flavor_13_69632"        => "746ddc9b-9bc7-4e17-aebf-43bd1f3e3e93",
            "flavor_13_70656"        => "6ba2b238-3cf2-4523-a24f-394e974a328e",
            "flavor_13_71680"        => "7a891970-58fe-4881-8428-7d329ee12fcb",
            "flavor_13_72704"        => "8c43cfbc-9754-4af9-89a3-603b214e221e",
            "flavor_13_73728"        => "5f6b946e-3b88-49bc-a9ab-de9277cd2601",
            "flavor_13_74752"        => "3169edd6-923b-4e38-bc33-732f95198795",
            "flavor_13_75776"        => "fc9bc8fe-31c4-4310-bcd7-4294cd8cafd6",
            "flavor_13_76800"        => "d17f6a8f-126b-44b0-afd4-dde7e8c77a1b",
            "flavor_13_77824"        => "9de8fcd4-9f5a-41c6-a3b2-e58f8d220cf3",
            "flavor_13_78848"        => "54bc71e8-b543-4524-b301-bfd5250325f0",
            "flavor_13_79872"        => "871d00a3-4c56-4b26-973a-173a3f33f167",
            "flavor_13_80896"        => "ec5869f5-711b-4b77-9366-06f53ffb225d",
            "flavor_13_81920"        => "150ea42f-96f0-4c50-bb47-1865d59dc411",
            "flavor_13_82944"        => "25696b9e-5c5f-4d02-b8f9-62ee6b4a8ad8",
            "flavor_13_83968"        => "72f65977-f8d7-458e-a550-af13049cf02c",
            "flavor_13_84992"        => "6326cbcc-de71-4e0d-9a4e-36657e950a00",
            "flavor_13_86016"        => "dac1d2c5-dc3e-45ac-9ecf-25df42fd29ab",
            "flavor_13_87040"        => "7f72aaed-74d4-45d5-b280-21b332851e98",
            "flavor_13_88064"        => "f338e9c5-9eb0-44db-9eb7-5f1d762c4255",
            "flavor_13_89088"        => "2182c840-ff6f-44c2-aee7-e1cb2744024a",
            "flavor_13_90112"        => "0bd88bd6-c60c-462e-938a-64902f847de5",
            "flavor_13_91136"        => "764b36cd-660f-43f8-91ec-d93fe327851a",
            "flavor_13_92160"        => "aab67672-8ddf-444a-b4a4-2f0fa8fbf553",
            "flavor_13_93184"        => "6a103aec-925a-413a-b09e-f3873f7dfa8d",
            "flavor_13_94208"        => "e5af8075-d50f-4589-8a80-3fcf7ab45615",
            "flavor_13_95232"        => "92efe839-d1fb-4fd6-8310-80c1bffa353f",
            "flavor_13_96256"        => "c5e050c1-c674-4e55-932d-03de0afcc72b",
            "flavor_13_97280"        => "630255d4-c131-4c0f-a790-ce30d708112c",
            "flavor_13_98304"        => "1b94ce6b-8f7a-4fea-ac8e-2c231f852586",
            "flavor_13_99328"        => "b732d447-6da9-40ce-ba5e-b8f9c1748222",
            "flavor_13_100352"       => "c4aba75f-3c9e-4362-b224-1375393eca3e",
            "flavor_13_101376"       => "cdfc8f16-46f7-4f97-985b-cdb71eecb1d4",
            "flavor_13_102400"       => "90ecdd2d-2e4d-48ae-8836-627bc14d26c2",
            "flavor_13_103424"       => "9cae4397-2bfc-4434-ad3f-78ceaae7d725",
            "flavor_13_104448"       => "c1a1414f-367f-4a8e-ae26-65d972d05f1c",
            "flavor_13_105472"       => "4dcd2bda-ceea-437a-bc0f-2f60857446a7",
            "flavor_13_106496"       => "d3bacb9a-ec48-42a7-bd8e-1cf12b0d2ef7",
            "flavor_13_107520"       => "d8014b5f-eea7-479b-a00d-01e0a99e58cb",
            "flavor_13_108544"       => "78709b67-b98a-479c-8934-dd5b8c817276",
            "flavor_13_109568"       => "bc29f8b9-8d37-484b-8f4c-fa2ed0802229",
            "flavor_13_110592"       => "bc77d4d3-2f51-476b-9000-8ea00ef40317",
            "flavor_13_111616"       => "f5173389-dd6b-4778-8639-2849d141cda8",
            "flavor_13_112640"       => "f84c8f41-37a9-4231-bf95-0a68806ed28f",
            "flavor_13_113664"       => "190c1191-8eee-4a10-8844-9734fc20e1c7",
            "flavor_13_114688"       => "a86d1006-22c8-4681-80f2-07e46c6c5919",
            "flavor_13_115712"       => "af6e07be-e07f-49a6-90e9-176beef4c0d2",
            "flavor_13_116736"       => "f96b031b-ca26-45db-9ee2-83a234f08989",
            "flavor_13_117760"       => "dd491a1c-7639-4a38-a808-5886b1c0ffed",
            "flavor_13_118784"       => "c4fa6dde-2ad7-42f0-9179-5890cf5386f4",
            "flavor_13_119808"       => "9de82ed4-4605-4b01-97b4-0df623f0c954",
            "flavor_13_120832"       => "17377495-b521-496a-bc1d-fbb70759bcd8",
            "flavor_13_121856"       => "ba4ffb12-839c-45bb-99e7-b19eb8927a41",
            "flavor_13_122880"       => "a73d2c2e-cb34-4b28-bf86-6422ffd78da1",
            "flavor_13_123904"       => "ff91fce2-c36b-40f7-b816-0d936043a494",
            "flavor_13_124928"       => "5febb688-53df-4bd1-b504-25283fadedb5",
            "flavor_13_125952"       => "81d44542-dde7-4682-9708-a1625df9fc48",
            "flavor_13_126976"       => "93c6f8d9-9832-4a4a-aee4-d4b03be0249d",
            "flavor_13_128000"       => "07e6e78c-368b-44ad-af3e-b3fe289b0fe0",
            "flavor_13_129024"       => "a02a448e-f6d4-4d40-a477-3ddad1b3e92b",
            "flavor_13_130048"       => "2f342072-90d7-4d80-a346-ea289ee1c1d2",
            "flavor_14_5120"         => "c3943a47-f849-421e-be10-05ec7e67966a",
            "flavor_14_7168"         => "959145ab-4fd4-4c80-b89f-98cfc6db17c6",
            "flavor_14_9216"         => "f773ad57-8396-4d26-a3f2-5ec6269e8995",
            "flavor_14_11264"        => "311c189c-ee75-4b1f-bb48-13a00aba9869",
            "flavor_14_13312"        => "e0942eb8-988a-4bef-8dad-5d0a276259ea",
            "flavor_14_14336"        => "f2776916-f7e4-4f1d-9c98-6fd19acd2fb9",
            "flavor_14_15360"        => "def72d4f-196c-4893-babb-a6b82c81d084",
            "flavor_14_17408"        => "8daeaab8-91e4-4727-9422-590b6d928555",
            "flavor_14_18432"        => "eb5aa06a-5ded-4d2f-81b8-d67d5c709382",
            "flavor_14_19456"        => "d49b55f4-c72e-4e7b-951b-d31064516959",
            "flavor_14_20480"        => "797e37cf-cfee-48ad-9a07-227e918d22c5",
            "flavor_14_21504"        => "f145ee4f-88f8-41e0-967b-38324befcf87",
            "flavor_14_22528"        => "046920eb-311b-4ae9-b949-9ccd51dae1df",
            "flavor_14_23552"        => "81736bab-9d7d-4eef-a09c-cd7f0c477de1",
            "flavor_14_25600"        => "a35a2a57-5a56-4ba8-b5f6-5934287f570f",
            "flavor_14_26624"        => "491c5944-56c8-4cd7-bf0a-5c43e3ab06ac",
            "flavor_14_27648"        => "50b22548-705a-4110-9251-b3bc562c75cf",
            "flavor_14_28672"        => "4db010fd-073d-43a6-bf70-b21e21f2bd41",
            "flavor_14_29696"        => "2cc1183a-ad67-477f-b13d-eb5d34fe7efe",
            "flavor_14_30720"        => "e284c077-87ad-4e69-8a94-efea5d3a97f5",
            "flavor_14_31744"        => "b72f28d0-1824-457a-b21a-8d9441be0ab9",
            "flavor_14_33792"        => "bcfa7381-1b4a-45bc-948a-e47deb77b949",
            "flavor_14_34816"        => "a4521477-e3df-4e3e-95cc-2509e2ce06b0",
            "flavor_14_35840"        => "a7bd8ee9-33cb-42a7-ad34-081e2a493f4b",
            "flavor_14_37888"        => "106a3528-23f8-49e0-887f-b255ed15c851",
            "flavor_14_38912"        => "4b19e504-c024-4d94-91bc-da44e37a1f70",
            "flavor_14_39936"        => "1b92dfb7-f683-4e05-81ad-8fc31f2e9a84",
            "flavor_14_40960"        => "18dcd5b5-b12b-4f27-bb45-c933761dff93",
            "flavor_14_41984"        => "b81f7c28-a892-4a8a-b130-a558aa4b4af3",
            "flavor_14_44032"        => "4ddc7545-3cb0-4a8c-83f1-96b3295f4206",
            "flavor_14_45056"        => "bf5a1ed3-6d21-4431-87c4-25a51c568fd3",
            "flavor_14_46080"        => "e1e0f58a-5a11-438d-b7bf-5313e7597e12",
            "flavor_14_47104"        => "0104216c-81d8-4b8f-9651-24028cdd58a9",
            "flavor_14_48128"        => "d1aadf2f-4949-4bc9-b177-303c557fb28a",
            "flavor_14_50176"        => "8c965fac-f095-4ec5-883a-2ecea4cf5cff",
            "flavor_14_51200"        => "f56deec2-267a-4c71-aa8e-c4dd66914c2e",
            "flavor_14_52224"        => "7b7697d9-93cb-497f-a663-3f27373b25cb",
            "flavor_14_53248"        => "36ea0d53-f88c-42d1-a5de-218b623fce5d",
            "flavor_14_54272"        => "227e0d04-c270-46ff-a678-e2235a1e9d0e",
            "flavor_14_56320"        => "5cc36e62-d5ef-4185-bf95-ad28c7b8955e",
            "flavor_14_57344"        => "3078f014-9778-48db-a26b-f528e7e9a120",
            "flavor_14_58368"        => "0d85edbc-1a72-47ad-aa9f-c8203f754226",
            "flavor_14_59392"        => "f152c3bf-cd01-4739-8d0a-eafeb4b0948c",
            "flavor_14_60416"        => "4f37505b-abc7-4b9a-99b0-9c59a2e0decd",
            "flavor_14_61440"        => "ae706a2b-0ff9-446f-8753-66086eeb14ee",
            "flavor_14_62464"        => "61823c9b-04d4-4804-aa7b-7e29c0b6d227",
            "flavor_14_63488"        => "fddf8a1e-c1e1-4f34-a7d6-5dd5412b81a3",
            "flavor_14_64512"        => "721f7b88-55f3-4f0c-8146-287771440e1f",
            "flavor_14_66560"        => "f8acf498-1b6b-4f81-ae54-0f6911af9d7e",
            "flavor_14_67584"        => "474370f7-d095-483e-ad50-2e14afc82574",
            "flavor_14_68608"        => "545bb946-5170-4f1a-98d2-eb7bc83f0d8f",
            "flavor_14_69632"        => "ea0cdb11-481b-4966-a9f7-e52c8d805395",
            "flavor_14_70656"        => "06162104-94b2-4b6d-a7c7-5d50dbe3faf4",
            "flavor_14_71680"        => "60b601e4-7275-4847-931a-f591782957e2",
            "flavor_14_72704"        => "66a64a1b-c7f8-4b86-9ec1-a8ffe34054a9",
            "flavor_14_73728"        => "2fce041a-78d3-46ba-90a3-b7c358d75e83",
            "flavor_14_74752"        => "b738686b-502c-479d-ab0b-5c57598862a4",
            "flavor_14_75776"        => "e90e5c12-48a1-4725-aa85-21f8dd30f165",
            "flavor_14_76800"        => "cbdcf43d-9a7e-456c-a30d-8d52574a3bf8",
            "flavor_14_77824"        => "e71b5f46-62ce-43c3-a850-6492aff92b91",
            "flavor_14_78848"        => "88917b3a-71d0-4f0e-8726-8c1adfcef384",
            "flavor_14_79872"        => "4128a2e8-5529-45ac-8111-61d40d3ee9c8",
            "flavor_14_80896"        => "0b922ea6-c95b-4708-aa5c-cb3efc76e8aa",
            "flavor_14_81920"        => "e30086ad-9440-4462-936a-69580d5d1735",
            "flavor_14_82944"        => "0ce0f991-c3cb-4082-b7e1-2bba73d6383a",
            "flavor_14_83968"        => "b3f64559-1181-42d4-a14e-8ec96facc25c",
            "flavor_14_84992"        => "9ecf37cc-ddb6-4d79-a5c4-90bd0106ab66",
            "flavor_14_86016"        => "888bcdd7-5c29-43af-b20b-bb0ff14e45e5",
            "flavor_14_87040"        => "5631d5e9-f6e3-4b04-b558-e6f2ba334e66",
            "flavor_14_88064"        => "420bc04d-fafd-4c2a-81e3-8c4e67eaac26",
            "flavor_14_89088"        => "98efcece-d5b3-40e6-9672-86f10324e034",
            "flavor_14_90112"        => "ce54f90e-3cc8-4848-92f5-d776456322e6",
            "flavor_14_91136"        => "3688438d-c71f-4802-b9c6-ee24f80b7925",
            "flavor_14_92160"        => "cfebd953-58a0-4301-932c-d6d0f2e1ddf5",
            "flavor_14_93184"        => "37545f59-7c7c-478f-96db-5d949c40ffb9",
            "flavor_14_94208"        => "7f226ac1-2853-42c2-b477-2a41c6ccdd8f",
            "flavor_14_95232"        => "42af56ea-049c-4756-92da-8ea9dd5404c7",
            "flavor_14_96256"        => "60d0436d-e0f9-4895-beaa-9622b9fad2e1",
            "flavor_14_97280"        => "04812604-6faa-41eb-aefc-e89ab2e410ff",
            "flavor_14_98304"        => "adaccea3-e268-438e-aa46-ad7292a5704e",
            "flavor_14_99328"        => "c25077d4-b885-46f0-826e-37d796abc915",
            "flavor_14_100352"       => "4a3e4078-2874-4656-8c01-f13f8b9c2bba",
            "flavor_14_101376"       => "20fe4afa-6224-4064-b803-78367119f982",
            "flavor_14_102400"       => "f413c0d5-f5e2-4d5b-869d-95c5e20130cc",
            "flavor_14_103424"       => "f02f4e23-9a77-4374-95e4-07798aab5acc",
            "flavor_14_104448"       => "f936d3bd-bf37-4206-b20c-c86a27c1ad08",
            "flavor_14_105472"       => "20670455-3525-4743-bb4d-80280419acdf",
            "flavor_14_106496"       => "cc005926-4799-47e8-bf48-7179f74e6128",
            "flavor_14_107520"       => "ecd53082-2055-48e1-8bf1-427900b00b62",
            "flavor_14_108544"       => "dc1881e1-9590-4d57-9413-4b5a8b862aa7",
            "flavor_14_109568"       => "2e7529a0-a6f9-4659-b99e-dc3749736a3e",
            "flavor_14_110592"       => "e067f338-b302-4ef2-aede-7399042dc798",
            "flavor_14_111616"       => "b687d4a1-7add-4af4-ba81-cc12c2f81706",
            "flavor_14_112640"       => "1b01c897-7487-44e6-bcf7-be160abb1cdf",
            "flavor_14_113664"       => "502ec7e9-acfe-4e32-8c1d-ba4e434f40b5",
            "flavor_14_114688"       => "82c761bb-26e4-4e54-901f-5558ed0001ee",
            "flavor_14_115712"       => "d8538ad6-b867-4e99-9544-11798de70bdd",
            "flavor_14_116736"       => "4808f9c2-1579-4c83-856c-6a6a2bf37db1",
            "flavor_14_117760"       => "ab33f092-cc18-4412-a84d-0a9da5e22cbd",
            "flavor_14_118784"       => "9da3172c-8151-4b3b-9686-ec1513c05873",
            "flavor_14_119808"       => "6bc42d40-e5e7-4146-89cf-53f67d89dc50",
            "flavor_14_120832"       => "cfec96c0-2059-4a86-82d9-da8aa760eeb7",
            "flavor_14_121856"       => "049ef61a-9f8f-424c-84f7-ca2f12f89b86",
            "flavor_14_122880"       => "467b7eea-7637-4fbc-bcae-867e2b336f4f",
            "flavor_14_123904"       => "dc68d561-a499-4f65-be54-a4d8257d1bcd",
            "flavor_14_124928"       => "6340847f-c7dd-4c58-ba93-f9b8c1d2eb3d",
            "flavor_14_125952"       => "efbc6409-7c54-4a71-b01f-0ac3256cf9fd",
            "flavor_14_126976"       => "9645b42a-fefd-4c17-a29e-cb44a6192b95",
            "flavor_14_128000"       => "e64e0c31-4bc1-4990-b0ed-f247c8579a6d",
            "flavor_14_129024"       => "4f294a88-08fe-4e27-8ba6-e42364c404df",
            "flavor_14_130048"       => "3c8a61bb-b71a-46b2-8f87-b29f484adfda",
            "flavor_15_5120"         => "bb1dc953-d301-4c1c-b552-dc3af891b9c1",
            "flavor_15_7168"         => "10b26524-3426-4ba7-aab9-eb47ecb8b217",
            "flavor_15_9216"         => "2d8438fc-f7d5-4200-bc64-39be07df30db",
            "flavor_15_11264"        => "19708243-0252-47c8-b3e4-d094594dd97d",
            "flavor_15_13312"        => "34283d6b-193b-40c7-bb04-6cf824541940",
            "flavor_15_14336"        => "7ad1eb99-2030-4599-ae8c-cfa38c9ac5f7",
            "flavor_15_15360"        => "fa4b25c6-6a3a-46d6-b235-248ffc726d29",
            "flavor_15_17408"        => "da3d3ab3-b076-456b-ab5f-d4f80aa8bbe0",
            "flavor_15_18432"        => "816f0391-c85b-419a-902a-1d82e2beafc5",
            "flavor_15_19456"        => "48e7879b-dd82-4d7b-9459-b76b412d4cd8",
            "flavor_15_20480"        => "9606e2e1-20ea-4993-8453-54dfeec6a7de",
            "flavor_15_21504"        => "6efb14c2-3e83-458a-a62a-f79d0c059f96",
            "flavor_15_22528"        => "cfe80c92-08c6-4d84-9b13-69e1c62e9a49",
            "flavor_15_23552"        => "978c11a8-301e-46e1-bb95-b662f6a34acf",
            "flavor_15_25600"        => "8f566cf9-48d4-46a2-a01f-11fe942fcd09",
            "flavor_15_26624"        => "a5034fa9-89d1-47a0-80f1-e2e522dfa526",
            "flavor_15_27648"        => "48cc843b-a4a5-4abc-862a-671ab505907d",
            "flavor_15_28672"        => "a0945864-9dfd-4140-9d62-a01e7620cb4f",
            "flavor_15_29696"        => "7d1e8de0-0468-487c-93d0-526c20742b1b",
            "flavor_15_30720"        => "88365c3b-6a22-4b76-a57c-ac22d02c232f",
            "flavor_15_31744"        => "ba033a9d-2bf2-422a-9877-034863e13615",
            "flavor_15_33792"        => "7bb1517e-0a80-4831-8de8-5d377a96a6fc",
            "flavor_15_34816"        => "886388e3-6a96-4f23-a432-2cac9baf56ad",
            "flavor_15_35840"        => "796f29ee-54f3-421c-aab3-fde013912f43",
            "flavor_15_37888"        => "c75cbc1e-5bb6-47b1-83f1-17bbf1237a91",
            "flavor_15_38912"        => "3ad66e51-4b4b-41d6-8640-55345c7c7799",
            "flavor_15_39936"        => "23798cd6-d79e-4395-bee2-6a9b0ea9d67b",
            "flavor_15_40960"        => "00847604-46e9-4e4a-a1ce-b829051bc26e",
            "flavor_15_41984"        => "067a5fe1-cf8e-412a-9762-b0fb54af0e3b",
            "flavor_15_44032"        => "ddfb3a1f-1013-45c8-91ba-5d9f2da627de",
            "flavor_15_45056"        => "60611320-5992-4439-8e7b-513a0eacf142",
            "flavor_15_46080"        => "e6266b3d-f63d-4740-bd0a-3459919347a7",
            "flavor_15_47104"        => "b87f3913-b8c3-42fc-97db-95fd2f507607",
            "flavor_15_48128"        => "54197c5e-87ee-423f-8afd-81739320193b",
            "flavor_15_50176"        => "fafa9c0d-efba-4768-b388-592cd530b76f",
            "flavor_15_51200"        => "e1e76160-b756-43a0-aab2-b7c295228ed8",
            "flavor_15_52224"        => "301e9c4e-6499-4b31-ad8b-de45464a50a1",
            "flavor_15_53248"        => "4298c852-ff98-4706-a781-b518d5bbdbdc",
            "flavor_15_54272"        => "71ff9c56-6ed6-4aed-86cf-bed20f5fc5d7",
            "flavor_15_56320"        => "c3d5418a-b233-46c7-a928-adf2e96d340a",
            "flavor_15_57344"        => "50f2ffe1-c1e5-4614-ab8b-5edbd237ba9f",
            "flavor_15_58368"        => "2f778f8c-a214-4a3e-9d2e-990d21fe1307",
            "flavor_15_59392"        => "a7363408-f2df-423d-b426-a1a400499261",
            "flavor_15_60416"        => "1da791f1-a490-41a3-9138-3567f6d70622",
            "flavor_15_61440"        => "de853e0e-bdaa-4461-ba2a-f95be4d0045f",
            "flavor_15_62464"        => "a0d9c9ed-602d-4caa-b878-538f8919783b",
            "flavor_15_63488"        => "3bc16eaf-9b9d-4250-8672-5af03042ac78",
            "flavor_15_64512"        => "8131811c-c0af-4129-a329-5b4a08983509",
            "flavor_15_66560"        => "569c5bae-f795-4899-8de5-ff7a8c6eeb08",
            "flavor_15_67584"        => "61041628-64be-4a3c-af68-c38435e9d347",
            "flavor_15_68608"        => "11c9f512-1c7b-44f6-9c11-964c67d66822",
            "flavor_15_69632"        => "4caf6dbc-e84e-4461-976d-4c4450e16bec",
            "flavor_15_70656"        => "db7f1259-4eb8-4e2c-9912-08936f2380f9",
            "flavor_15_71680"        => "cd1880fd-b288-4b09-9978-8fd0ae7a5c62",
            "flavor_15_72704"        => "90e3800c-23a0-4779-af04-4d98317b74da",
            "flavor_15_73728"        => "20c688ea-dead-4cba-b7b8-2a03f1ffb773",
            "flavor_15_74752"        => "3f4f7fbb-4ecb-4b48-b287-102802915e83",
            "flavor_15_75776"        => "46677961-43a8-4318-8eba-eb98475e2c01",
            "flavor_15_76800"        => "e62b1470-eab4-45bf-8df6-91cc14ef85e9",
            "flavor_15_77824"        => "07d9a5af-9686-4346-af83-5011746103c3",
            "flavor_15_78848"        => "0b7ff792-fe49-4b7e-8494-37a28089f4a9",
            "flavor_15_79872"        => "6c7ca6a9-d157-4437-a067-9f1f1dff8530",
            "flavor_15_80896"        => "85a47cfd-e5d3-41c5-94b6-aa16b7b814a3",
            "flavor_15_81920"        => "02c7135e-b57d-4283-9dec-975ccf021911",
            "flavor_15_82944"        => "9ceb969d-0231-43b2-b4d1-e2f709f3fb54",
            "flavor_15_83968"        => "888eea3e-23a7-4afc-83a1-6300d36315d0",
            "flavor_15_84992"        => "b943d7a1-c21d-4fec-8560-dd4473c59466",
            "flavor_15_86016"        => "ae21ee3a-b009-46e2-8c95-682fe34943b0",
            "flavor_15_87040"        => "e2d0a93e-1a52-41ff-9798-aab48dfa9de1",
            "flavor_15_88064"        => "8c3b6351-afe1-4f55-84da-7489ff8700f4",
            "flavor_15_89088"        => "62ebd848-a92c-4d67-b55a-08bd59aa8dc6",
            "flavor_15_90112"        => "ab7824ca-89d5-4166-ace3-ac710004bae6",
            "flavor_15_91136"        => "a034d52c-6f48-47cf-a12b-e8db1100105e",
            "flavor_15_92160"        => "114a0337-91a1-4c05-af7e-93494c5b96a3",
            "flavor_15_93184"        => "b7065c27-4eb5-475a-8065-8c2c1e0b0520",
            "flavor_15_94208"        => "8d68f820-8371-498e-86bb-6a1f31d6c3ea",
            "flavor_15_95232"        => "18659d23-329a-4ad6-8f16-fb54d709fff9",
            "flavor_15_96256"        => "60f3b4d4-b6a5-4da4-979b-779e2d4d5c54",
            "flavor_15_97280"        => "bacb8b08-df2a-4c67-b83a-d388ca999168",
            "flavor_15_98304"        => "3fc31927-93f6-4b9b-acbe-9671c5d69556",
            "flavor_15_99328"        => "461b9c90-6dd7-4fd2-854a-5df0e9e0c306",
            "flavor_15_100352"       => "78d0f695-9920-4a36-9621-c098a6a2a8f1",
            "flavor_15_101376"       => "1ea7677f-9e39-49d2-b8ab-c4b07e283614",
            "flavor_15_102400"       => "59594618-0b27-4fd2-9ab3-4659082ec648",
            "flavor_15_103424"       => "b0b10ae4-1c62-4229-9a1d-2b7f42d8334e",
            "flavor_15_104448"       => "2d6676b2-a349-4a69-a74f-fba00fa80cfa",
            "flavor_15_105472"       => "5e06ca95-6db3-4352-8ea4-e9d8aa522677",
            "flavor_15_106496"       => "c5043d51-61c8-4c3a-89dc-68a67e9b8690",
            "flavor_15_107520"       => "9c6b704d-5947-46eb-87f0-a99355ce74cd",
            "flavor_15_108544"       => "bbb0d441-f144-4147-928b-1cefbf5e161b",
            "flavor_15_109568"       => "7b1bd9e8-f2b1-4672-9fd4-d11abc534e2e",
            "flavor_15_110592"       => "005fc1b9-306b-44c3-af91-35a106932473",
            "flavor_15_111616"       => "9877eaf2-ca95-4cae-ba80-8cb954c1d296",
            "flavor_15_112640"       => "f9be6cd8-3ba3-43e0-80ac-908cb151143e",
            "flavor_15_113664"       => "078b3544-ac69-4fae-9171-1ab5d528d954",
            "flavor_15_114688"       => "dd3f9648-5b89-4f05-82d4-56083b26f580",
            "flavor_15_115712"       => "4ecb153e-0124-4d9f-b8ec-8bbc058da4b7",
            "flavor_15_116736"       => "fe247729-ade6-48d5-af3d-6f279d5fbe18",
            "flavor_15_117760"       => "c1298b5c-7b3a-4a94-8ed5-9cc265dbd777",
            "flavor_15_118784"       => "91372981-73bc-40ce-bb8d-0ce186528ab0",
            "flavor_15_119808"       => "8c8ce0df-e529-421c-8aa5-29915a2aaeb6",
            "flavor_15_120832"       => "343bf14c-3b7f-4e29-9fab-3ed51a0fd9a7",
            "flavor_15_121856"       => "027d05cd-d390-425b-930d-39c3814e8184",
            "flavor_15_122880"       => "3fb372ff-6e9e-4077-9cd6-752099f15652",
            "flavor_15_123904"       => "f5b40b79-bf5f-4d29-830b-cab9d5e18899",
            "flavor_15_124928"       => "9a8b7908-95b8-454f-910e-0adc17249647",
            "flavor_15_125952"       => "6dcb81e2-53aa-4f42-bc5f-6eb94d32aac7",
            "flavor_15_126976"       => "54208981-d490-4a6f-bf7b-6795216ec0bc",
            "flavor_15_128000"       => "4c62657f-b6b5-4c11-b1cf-a780ffef670a",
            "flavor_15_129024"       => "56c4dd4d-22ff-4f2d-b126-9deca8d66f7b",
            "flavor_15_130048"       => "c26ff28b-769a-462d-8b71-a0644ae8a243",
            "flavor_16_5120"         => "de17b9b9-01d4-4521-94bf-c34b3f09b1d4",
            "flavor_16_7168"         => "fc5dd6af-0937-4da1-b1eb-e261bc2e87f9",
            "flavor_16_9216"         => "0bd3c5e0-baa3-45ca-89ea-2234419a48c9",
            "flavor_16_11264"        => "9c985ebe-a872-44f4-8974-45bde916d884",
            "flavor_16_13312"        => "e920a0a9-1de4-49d2-8270-cc1fdc223816",
            "flavor_16_14336"        => "fb238ff0-fd64-44d7-8c74-d66e24c14c66",
            "flavor_16_15360"        => "259dd9da-af22-4460-8020-85a54b6f622d",
            "flavor_16_17408"        => "fd41b026-168c-4afc-bec2-dcb474a3f4ad",
            "flavor_16_18432"        => "952fc559-d998-4ab3-ae33-978ebe2e8987",
            "flavor_16_19456"        => "70005e31-8f7c-48c4-8426-2c0cf0e235bc",
            "flavor_16_20480"        => "ee8e1a9f-9000-4ea8-abc8-55b77b22ac18",
            "flavor_16_21504"        => "0b4b3ed4-3f95-414d-ade4-7f0c994291d0",
            "flavor_16_22528"        => "4c309663-abf7-47ea-8810-f83c4183598f",
            "flavor_16_23552"        => "c359fdb0-24a9-4561-bd4b-86607e752d3b",
            "flavor_16_25600"        => "b04fc4f2-eb71-4f17-87c9-2f1d10ccbfc8",
            "flavor_16_26624"        => "caf19a2c-a03b-4c13-b508-8364d4f7269f",
            "flavor_16_27648"        => "89671862-acf2-4578-b1d2-3717afec0034",
            "flavor_16_28672"        => "2f4f6d13-fb88-4408-a835-6cb71ee88d1c",
            "flavor_16_29696"        => "186d5e82-4b91-4c04-8076-b27e8fdca8cb",
            "flavor_16_30720"        => "60312d86-d5a7-43d2-85c7-cfa4e8272bd4",
            "flavor_16_31744"        => "b2f72a0d-7db9-40e2-939c-414133c4896f",
            "flavor_16_33792"        => "ce0e774e-f13c-4aba-a147-47a3dda08750",
            "flavor_16_34816"        => "443dd55b-3479-43d7-a80a-027ad1787d93",
            "flavor_16_35840"        => "8aa4122b-42d0-4cbb-b75f-6f23ec43998d",
            "flavor_16_37888"        => "4f153a1f-40fc-4b0a-b9f5-762feb760cf3",
            "flavor_16_38912"        => "ba4235d4-eb31-47ab-9996-a4bead4005fe",
            "flavor_16_39936"        => "3e507649-37f5-4673-9436-77d8939219d8",
            "flavor_16_40960"        => "f6e1608e-bbd4-4e29-b7bb-781a9bbcd00c",
            "flavor_16_41984"        => "e6d7690d-ef88-412b-b8ec-b47c86737dc2",
            "flavor_16_44032"        => "297b87bb-b6c9-457a-838a-2e8b9af29aab",
            "flavor_16_45056"        => "5c59cfb4-9766-4e2b-92d3-b44bc476838e",
            "flavor_16_46080"        => "24b494ec-c820-40d3-91a0-130ddf754878",
            "flavor_16_47104"        => "a44bc58e-83c3-4a09-bf01-8e4e77183374",
            "flavor_16_48128"        => "831f6f62-43e8-4090-b4bd-28a9bee5fe12",
            "flavor_16_50176"        => "9155aa43-fbe0-4fa5-99b4-73099880a231",
            "flavor_16_51200"        => "9c1786c9-ca22-4cbe-97bf-6cff1c22595e",
            "flavor_16_52224"        => "6b772bd6-effa-4b0c-96ef-a545b7240a0c",
            "flavor_16_53248"        => "b20f6372-5e50-4a68-ad1c-d45c45dc26e7",
            "flavor_16_54272"        => "442b3347-fac9-4a84-ab65-bac9faed2293",
            "flavor_16_56320"        => "9854eca2-bfc4-410e-91bb-72614ad96b10",
            "flavor_16_57344"        => "2a3921ac-27f6-4fd7-b851-b452db5a5205",
            "flavor_16_58368"        => "202412b4-66e2-4a27-87d4-2434b85408d3",
            "flavor_16_59392"        => "d0c2a497-3f08-49b1-95f5-b19043ebca42",
            "flavor_16_60416"        => "88b42a10-a2b1-449b-8761-7c7589fc285d",
            "flavor_16_61440"        => "89b9f9ce-f5d6-41e3-92bb-cafb9bcd8680",
            "flavor_16_62464"        => "db034d24-417a-4c1c-ba89-b11aee62ca71",
            "flavor_16_63488"        => "90066131-0156-4bd0-a448-ae357e73ae0d",
            "flavor_16_64512"        => "fa9d66b9-3508-4df5-9720-5663356f35e6",
            "flavor_16_66560"        => "03396e65-94b4-43d2-b6ec-baa20169a47a",
            "flavor_16_67584"        => "ff19da0d-04d9-4bed-8f54-be2104fe34ea",
            "flavor_16_68608"        => "a0e00f00-fa7c-4aa4-9602-0892b7b4adc5",
            "flavor_16_69632"        => "3270d4fa-af81-42f9-9b06-46a6961d6377",
            "flavor_16_70656"        => "6c72df6e-08ff-451a-b9ae-d5ad6400cfa2",
            "flavor_16_71680"        => "31834046-d766-4482-bb78-97dbd592a549",
            "flavor_16_72704"        => "6e3da1b6-9eea-42f9-a57b-3c9232b529f1",
            "flavor_16_73728"        => "f8098919-85f0-49e1-b41b-8551c6a3d133",
            "flavor_16_74752"        => "0db82c90-e8ca-47cc-be4a-9a9a55bbec77",
            "flavor_16_75776"        => "126b13f4-5f5b-4f84-9626-9626e6531fba",
            "flavor_16_76800"        => "3bf6249d-acfa-4143-8e29-c5fc2233f7df",
            "flavor_16_77824"        => "99dee153-3076-438e-86f9-2b368c75455b",
            "flavor_16_78848"        => "f6d8a058-28d3-4f39-8c76-81c39a3bdd04",
            "flavor_16_79872"        => "ab9d9632-cc83-4e5e-ab6d-e8f13e69175f",
            "flavor_16_80896"        => "7ff8152a-a89d-4f90-af0d-5572eef616af",
            "flavor_16_81920"        => "487c1c66-bcb5-49c2-a432-b10e7a7b3d30",
            "flavor_16_82944"        => "a9c5cc4b-c75c-4fee-b73c-fbc41535b3a5",
            "flavor_16_83968"        => "547a016f-85b2-4639-919c-5001ec21ecd7",
            "flavor_16_84992"        => "566e4ad3-9e70-4e3a-977f-fc3b9f9b0053",
            "flavor_16_86016"        => "5ffc2f20-0cb4-4487-88dc-07d8584c619c",
            "flavor_16_87040"        => "9cca9453-e710-4604-b38e-ec468f0e6160",
            "flavor_16_88064"        => "71a6fb7d-911f-45f2-a581-9e61d74c1e93",
            "flavor_16_89088"        => "c38d1b83-111b-43d7-8546-20116e346bfe",
            "flavor_16_90112"        => "6f4436de-bf81-4157-bede-c08d12a46c96",
            "flavor_16_91136"        => "94d4fbd8-b153-4be6-a99b-fdeab9a61ceb",
            "flavor_16_92160"        => "ab2df7af-5b2f-453b-a04c-ba7a1de676ae",
            "flavor_16_93184"        => "2baaccb4-9343-44c4-b782-789882198766",
            "flavor_16_94208"        => "553accb7-b108-4a60-af1f-e94867200682",
            "flavor_16_95232"        => "739d607d-5c0f-479d-b0a5-40115e53c5b3",
            "flavor_16_96256"        => "f63cadd7-7c0b-4e53-ae75-3d4886b7b01d",
            "flavor_16_97280"        => "cbebe917-f053-4dfa-94f2-cd893b62c157",
            "flavor_16_98304"        => "bd867171-0ae4-43eb-a453-5f4cc2d6ce3c",
            "flavor_16_99328"        => "0bbde73b-9179-447c-9771-16152654045d",
            "flavor_16_100352"       => "0bbec90f-c67d-4624-8f6d-28d54e99265d",
            "flavor_16_101376"       => "0b78485d-be6e-47f9-974e-8a2c8aa0b58d",
            "flavor_16_102400"       => "1f6bbb53-c043-4be2-9386-af970d39d802",
            "flavor_16_103424"       => "71ebcc1c-a61b-469f-b944-794930e2b6e7",
            "flavor_16_104448"       => "8b253575-1437-4c16-9d36-e44361017e2c",
            "flavor_16_105472"       => "4ea14482-8593-48ac-817b-c0b43a9b6673",
            "flavor_16_106496"       => "1f2c6b67-2198-4fba-99cc-fe83123aa51b",
            "flavor_16_107520"       => "3bf8757b-80d2-4a6f-b2cc-f20532117686",
            "flavor_16_108544"       => "0c1ac1c3-8588-4479-9aa5-ea2a77214e6c",
            "flavor_16_109568"       => "1dbe5c63-0bf1-4d19-ab6b-b41f146d9255",
            "flavor_16_110592"       => "14bd18a1-75b1-41ee-b9d7-b30d6fe6320f",
            "flavor_16_111616"       => "44688c4f-f1de-453f-9926-722245ebbb13",
            "flavor_16_112640"       => "c49566df-2156-45b3-866a-74fec34a0b37",
            "flavor_16_113664"       => "188fedf0-d821-42b0-8200-af643d3906e7",
            "flavor_16_114688"       => "1cce5c3f-e0f3-4d1c-a5b2-03453e59cd35",
            "flavor_16_115712"       => "49c26321-edba-402b-af18-fb3c8537af96",
            "flavor_16_116736"       => "5d0d79bb-1226-4cb8-801a-f801e16d42ee",
            "flavor_16_117760"       => "34be9494-b45a-4929-a80d-9b7edd51be93",
            "flavor_16_118784"       => "056c9cae-2bf6-4933-a413-16e1d491eb2d",
            "flavor_16_119808"       => "47b77fb2-254b-430e-9560-ffd289ba9ec5",
            "flavor_16_120832"       => "230bbc8f-e1e8-475e-a68f-1b48b6155a9d",
            "flavor_16_121856"       => "1af91087-851f-4493-88a0-77aa22f99bf6",
            "flavor_16_122880"       => "611449ae-4fb7-4fbb-88c2-1cb9b94ef2a7",
            "flavor_16_123904"       => "057a9317-672b-400f-8059-5519d8faa201",
            "flavor_16_124928"       => "ccdf2b8f-fba4-4d22-b62b-f60c38865df3",
            "flavor_16_125952"       => "1bf46e39-50a1-4780-bf5d-e9f49570a0d1",
            "flavor_16_126976"       => "89b4596a-311c-41e9-9b37-b919f9fb3d2e",
            "flavor_16_128000"       => "21aae4d1-0a32-4308-83b0-0847ba8e02ad",
            "flavor_16_129024"       => "61232701-5a76-4af6-9c19-2837dbf91741",
            "flavor_16_130048"       => "272c40fd-76f6-45e0-80f1-59c6be5fd3a2",
            "flavor_17_5120"         => "15579080-3f83-41c5-b01f-721782d63977",
            "flavor_17_7168"         => "b199e99a-52f1-4f19-b12e-71d1a89b746b",
            "flavor_17_9216"         => "d6278eb6-4408-4929-b1d8-745234790b56",
            "flavor_17_11264"        => "c27eb76f-fb2b-4b9e-8749-0f7d0cda89a1",
            "flavor_17_13312"        => "b26bb9ee-2cfa-40e6-978b-ba58f21be490",
            "flavor_17_14336"        => "985c5edc-f594-441d-91c1-8bf8ebf3d239",
            "flavor_17_15360"        => "f05cd1af-bea2-448f-ba7b-2f7701a38b3d",
            "flavor_17_17408"        => "afa32247-75a5-406b-acca-b07599e418f4",
            "flavor_17_18432"        => "1215d2b6-3eee-4fc2-b93c-b98b21c44292",
            "flavor_17_19456"        => "5a7ec38e-0a59-4729-9aea-065ed64e44d7",
            "flavor_17_20480"        => "88594d95-33fd-495c-bd23-bb38aa441a69",
            "flavor_17_21504"        => "69db16b7-1847-4eeb-8131-616c3bfc3fed",
            "flavor_17_22528"        => "d0096021-da0b-48fd-bf37-7408ffcde879",
            "flavor_17_23552"        => "b9514ddd-9415-4fce-acf6-16e41e2108bf",
            "flavor_17_25600"        => "80fcf01c-7eec-4909-add8-53a108ca7e05",
            "flavor_17_26624"        => "d391fcfd-5e08-4803-a19e-9d8d896e8833",
            "flavor_17_27648"        => "4e1c5b17-b256-40c8-85a0-d8bc279bb081",
            "flavor_17_28672"        => "46c7057e-6c2e-41f1-a1cd-261f69b9a87e",
            "flavor_17_29696"        => "c11e4b5f-3336-441b-8637-90389492160c",
            "flavor_17_30720"        => "7906a128-2bb5-49c5-9c44-04bad5d07de0",
            "flavor_17_31744"        => "d60311bd-1908-422d-ac2e-b68873c77006",
            "flavor_17_33792"        => "e6900513-3c3a-43fe-aad1-4d827e29db1c",
            "flavor_17_34816"        => "58ee38c0-cbca-4b6b-8745-5b9e47302694",
            "flavor_17_35840"        => "4ab426c8-1d96-4512-814c-4fa97ad35eb6",
            "flavor_17_37888"        => "2f7b5d24-1d28-4867-ae57-10ee32e5780a",
            "flavor_17_38912"        => "1609fe71-5191-45f6-84f3-55de6d0a8ca3",
            "flavor_17_39936"        => "79b40b45-79f0-4263-8d55-c17494440305",
            "flavor_17_40960"        => "8f041491-1f15-475d-90f1-02f8443a8c44",
            "flavor_17_41984"        => "106f84a2-b789-4afa-a6e2-732283ef0d9e",
            "flavor_17_44032"        => "9d049a0a-3d69-4cb4-90cc-086367ac5d4b",
            "flavor_17_45056"        => "2c7a9c56-b858-4c6a-bd82-63adfc7b39f7",
            "flavor_17_46080"        => "af594968-109d-40a8-b3f0-bc7755ec5f40",
            "flavor_17_47104"        => "e5f0e285-e486-43fc-ae17-4dd10bcdc03a",
            "flavor_17_48128"        => "05f18230-116d-4299-8158-8e7fec536332",
            "flavor_17_50176"        => "a95e4895-2019-4bd9-b1ae-ccd439cb480e",
            "flavor_17_51200"        => "9f591645-e17b-4519-8143-ffc638525a67",
            "flavor_17_52224"        => "6a9f3c9e-76e1-4ebe-b77b-d97e60631970",
            "flavor_17_53248"        => "0213ec84-45f4-4a4c-a155-91449cc68e64",
            "flavor_17_54272"        => "b99917ec-a5b4-4fab-80da-d2725c76097c",
            "flavor_17_56320"        => "56725520-9b85-482d-9d81-c4729726a6ea",
            "flavor_17_57344"        => "a3e608a1-50ca-4e04-953c-d7d25f5c3c9e",
            "flavor_17_58368"        => "be4847fb-aa27-4c12-b331-852d1175d712",
            "flavor_17_59392"        => "4922c53b-155b-483f-bbcb-291ebcce7bdc",
            "flavor_17_60416"        => "73bd9574-daf1-4f91-940e-a67c8ca7ade7",
            "flavor_17_61440"        => "a199c358-ea52-4ecf-90b7-5ccc3efdaa43",
            "flavor_17_62464"        => "06775ca0-6518-4857-9773-4a97b6a307fe",
            "flavor_17_63488"        => "471caff1-94e4-4fd6-807c-085a9a304e5d",
            "flavor_17_64512"        => "1bb70990-f1c4-4ae8-a5fe-97c872b632a5",
            "flavor_17_66560"        => "4235623c-7434-4fe9-bcd2-462ffdc4024b",
            "flavor_17_67584"        => "64232db1-36bb-4903-a952-fd77c9ec9f2c",
            "flavor_17_68608"        => "7047608a-ce08-4d6c-aaf8-69d79bb962b7",
            "flavor_17_69632"        => "de6987d8-4a89-456b-b1fe-82877ecc34bf",
            "flavor_17_70656"        => "f402397b-a946-4d76-99fa-3c5d7de05cbf",
            "flavor_17_71680"        => "ec31b31e-17ba-4603-a01a-0ed4a2de1c5e",
            "flavor_17_72704"        => "cffd1ab1-6929-4c1a-80f0-58d6427dac19",
            "flavor_17_73728"        => "e6ba8542-b586-4f4b-abd0-03031c8a781e",
            "flavor_17_74752"        => "da85b56c-451f-476e-aca0-846032cbbed3",
            "flavor_17_75776"        => "99e2104f-0f3d-4783-8197-bddbcdd800cb",
            "flavor_17_76800"        => "8846eb9c-fc21-456b-9646-b2a2ee121f82",
            "flavor_17_77824"        => "e76e294c-be80-4ee0-9f69-2e70a845cf58",
            "flavor_17_78848"        => "1c10bf05-732e-462b-b509-e43ee4bea5d6",
            "flavor_17_79872"        => "65c5c4ef-f983-4344-9aa7-def5ab87b4fe",
            "flavor_17_80896"        => "5bae5c51-00cf-4d74-96d5-db1d35ef99bc",
            "flavor_17_81920"        => "1551f7eb-0d21-4865-9c2c-215e2ec670d8",
            "flavor_17_82944"        => "5c9137d2-f052-4286-835e-57390f6c88e7",
            "flavor_17_83968"        => "afb15c59-f9a2-476f-9768-fbabc8367272",
            "flavor_17_84992"        => "5e3d5395-7325-4336-aed5-d8214a37948c",
            "flavor_17_86016"        => "abc6083e-fe05-4c98-bd76-8d84e1180575",
            "flavor_17_87040"        => "a5138982-b748-44fe-9181-dab21e490f89",
            "flavor_17_88064"        => "101d1736-6820-4561-81cf-a1c0e410274f",
            "flavor_17_89088"        => "f9d56338-c236-43ef-8e03-321169d8dd16",
            "flavor_17_90112"        => "0da4411a-506e-4cd6-87f1-931d97e500e8",
            "flavor_17_91136"        => "233b835b-e0b4-40a9-9049-670bb521d275",
            "flavor_17_92160"        => "d7a68d4f-50d5-4027-8ac1-7498f89bdd04",
            "flavor_17_93184"        => "15d06e6a-0655-422b-a6d0-b10cd314f500",
            "flavor_17_94208"        => "45c8e1c2-e54d-47b9-89b2-7e0e831c1829",
            "flavor_17_95232"        => "3697668d-b2ad-4633-8cb4-cd7a4017e938",
            "flavor_17_96256"        => "6c49aba3-0a25-44d0-a0ca-dd0863fd69f6",
            "flavor_17_97280"        => "b799044a-fe27-471f-9135-fc2058b82070",
            "flavor_17_98304"        => "995ec473-ec0f-4efc-9f9e-8bd21b379bf1",
            "flavor_17_99328"        => "785dc76e-8a05-472a-840a-075ca3967763",
            "flavor_17_100352"       => "6223577e-3411-49ba-95c6-acec97cf72bf",
            "flavor_17_101376"       => "a7b47179-decf-49a4-b345-85ff92e6bf22",
            "flavor_17_102400"       => "3117dbbf-33d5-436f-b61e-9eccd1ab82bc",
            "flavor_17_103424"       => "2a08acb0-8895-45c7-b97a-8a120adae440",
            "flavor_17_104448"       => "0aedb9d6-2f51-4a00-8fb3-9e85727c35f5",
            "flavor_17_105472"       => "54c8f89a-c639-4b9c-a775-bdb5b1e7d591",
            "flavor_17_106496"       => "4bf0eb02-2f12-472a-820c-b94c4dc76e9a",
            "flavor_17_107520"       => "035a8fc0-2681-46eb-b322-645c36642b4a",
            "flavor_17_108544"       => "4db647ec-3951-4532-bc94-73ffbfe3c820",
            "flavor_17_109568"       => "7fefb879-98d1-48fa-befc-5bae2bbc7af8",
            "flavor_17_110592"       => "45e4ed62-92d8-419c-8cbe-195a1db505fa",
            "flavor_17_111616"       => "76b2c721-51a8-401a-a22e-6fb2588b5cfe",
            "flavor_17_112640"       => "181f3e18-baf8-4758-ae8b-1c8aeb33876e",
            "flavor_17_113664"       => "8a5511f0-8931-45b9-b98d-7055da6235dd",
            "flavor_17_114688"       => "53eced18-e37c-442d-a3f4-8e649d65f3bf",
            "flavor_17_115712"       => "641a997b-09ea-49a5-81dd-87c0aa30956c",
            "flavor_17_116736"       => "42a5a17c-ad38-4445-a1a6-6b9c76629df6",
            "flavor_17_117760"       => "8d713ff9-0c49-413c-b40c-8e034349c9f6",
            "flavor_17_118784"       => "7efe3d53-7f24-49d2-8127-0bc52e200a0f",
            "flavor_17_119808"       => "a184453d-d1bc-4d4b-b28d-a171225775fe",
            "flavor_17_120832"       => "50b2f5b3-b9d0-48f7-ae69-d53a1cdb59d0",
            "flavor_17_121856"       => "3f214017-5687-4e71-93e2-ae1584c2dd0e",
            "flavor_17_122880"       => "2136a5e7-2c6d-407e-9667-deb015607114",
            "flavor_17_123904"       => "5d9dac20-cb59-4e43-aa86-49b8b3854ed6",
            "flavor_17_124928"       => "19f4d532-4b4a-4a4f-9d82-b6c631f88d3c",
            "flavor_17_125952"       => "f96bf4f6-639a-4ed4-8311-512bc273bf91",
            "flavor_17_126976"       => "4c51a0df-298a-4c5d-9fa7-da8f98177ac0",
            "flavor_17_128000"       => "b48f6c52-de30-4c46-b1a8-d2dba55073f3",
            "flavor_17_129024"       => "ae3c02f0-d428-4389-8e45-0f5c74c67aea",
            "flavor_17_130048"       => "7882c7c9-6626-43d5-a211-1786ca29c129",
            "flavor_18_5120"         => "0002774c-1b28-46de-b8a0-c210f7955433",
            "flavor_18_7168"         => "d6b917fc-ff0e-4110-a9e2-9e3361de87a7",
            "flavor_18_9216"         => "b63c7d5b-f828-49f7-9d6f-b68bc0d98a39",
            "flavor_18_11264"        => "a78406ee-9c3b-447d-8fb5-6e2456fe9ca1",
            "flavor_18_13312"        => "7d566479-cef0-4b61-a5b7-821fc0951027",
            "flavor_18_14336"        => "38d628c1-3631-4a8a-8918-93958c23a498",
            "flavor_18_15360"        => "3412f93f-b098-4867-9e11-ccc9913f33dc",
            "flavor_18_17408"        => "b4629e9a-a233-4a64-b8bb-72fc5204feaf",
            "flavor_18_18432"        => "28417c38-19fc-4b61-920b-e2301d8cccec",
            "flavor_18_19456"        => "9b2ca3f0-1402-402f-9192-217ea49c59df",
            "flavor_18_20480"        => "48faad0f-d519-43cf-beda-5f3b4bfba8b3",
            "flavor_18_21504"        => "8ef24048-eae1-470f-8c63-e20687da7feb",
            "flavor_18_22528"        => "a67972ce-619d-4fff-a644-322f73fc8da2",
            "flavor_18_23552"        => "b5516040-2464-428a-b468-bcbeb41d940c",
            "flavor_18_25600"        => "db296f93-1190-4435-bf39-8b937e78bc0f",
            "flavor_18_26624"        => "6c5cdc54-c2ed-42ef-ad86-5690a88015aa",
            "flavor_18_27648"        => "aab84c47-5ee5-476e-8f77-1fb8b0fd3545",
            "flavor_18_28672"        => "4fcfda6f-1836-45e1-b4c7-03ec94a19d94",
            "flavor_18_29696"        => "4a1a1069-e2c2-4f19-883a-686eb5d7ff16",
            "flavor_18_30720"        => "e15df22e-46b0-4c77-9df6-50af4c56b0a1",
            "flavor_18_31744"        => "b14fae6a-b06b-49c3-b191-263f71751033",
            "flavor_18_33792"        => "8182ca2e-607b-45d9-b6d7-2a444627ae24",
            "flavor_18_34816"        => "37547d60-95db-4837-b826-2d3bafc54fee",
            "flavor_18_35840"        => "644f11f5-62a2-4704-b589-9aeb1aa4d8f3",
            "flavor_18_37888"        => "f2b3d27d-201a-465a-a301-951a69b54cd6",
            "flavor_18_38912"        => "245c635c-61e7-4c7a-ad12-c1a2730ce9a6",
            "flavor_18_39936"        => "3b2b551a-48fb-41f9-95da-041e63546252",
            "flavor_18_40960"        => "f048cc98-0ef5-4b3b-8376-807a7bb6e2f9",
            "flavor_18_41984"        => "15f8bb84-85b3-4c93-a16e-31e226763770",
            "flavor_18_44032"        => "414acead-b195-4cfd-82a9-11ba1a2baaf1",
            "flavor_18_45056"        => "e4cfae3e-412c-440c-bd0d-91f7d3c93df9",
            "flavor_18_46080"        => "2ebce59b-c3f5-4f0b-8548-0e0786c656b1",
            "flavor_18_47104"        => "2d858460-8c0d-483f-8894-519e23eb9b11",
            "flavor_18_48128"        => "37e8d6ed-d8ec-4b7b-9f11-79d0832b2534",
            "flavor_18_50176"        => "d59946fb-837c-4586-ad5d-23ba9617285f",
            "flavor_18_51200"        => "23716186-494d-4c5e-ab94-50de50c649d9",
            "flavor_18_52224"        => "248b47ea-c33a-4ece-ad46-dc586508de3f",
            "flavor_18_53248"        => "d8efbc44-a916-4c2d-85c5-db620634a467",
            "flavor_18_54272"        => "41625464-22f6-4c5f-ac6f-b0f9c5e5e1f4",
            "flavor_18_56320"        => "d648bafa-27c4-4113-8b54-01353a792051",
            "flavor_18_57344"        => "2e32c282-c51e-4bd4-b904-d8e34a883a26",
            "flavor_18_58368"        => "62d1e018-221a-4aa9-a763-9240509eb8fe",
            "flavor_18_59392"        => "d08d2826-7564-4895-9bd2-57c2ce03959f",
            "flavor_18_60416"        => "c867e9bf-af6e-4ab6-bd43-21e5b7140702",
            "flavor_18_61440"        => "e7890adf-ff34-4a1d-9eb9-7da6ddcabf86",
            "flavor_18_62464"        => "2927305d-460d-47a4-8c69-ed02883dcce6",
            "flavor_18_63488"        => "a96fd65e-7132-4e43-9343-fa9542abdd38",
            "flavor_18_64512"        => "def6dfcb-8a69-4a1c-8f35-71ae158037fa",
            "flavor_18_66560"        => "0a3a605f-54a7-4e9e-ae39-6115f83fd58c",
            "flavor_18_67584"        => "c66220d7-801c-4040-abd4-5d7c21ed5441",
            "flavor_18_68608"        => "c82bfcc8-0cb0-4311-ab42-26549032a42d",
            "flavor_18_69632"        => "01bb2c20-c64d-4fb2-81a8-bf6628eec0a7",
            "flavor_18_70656"        => "99a02cde-2cf9-4cf6-bb51-7965b1f75b4d",
            "flavor_18_71680"        => "fdd05e5c-d018-4166-aaa8-a65f39f891c5",
            "flavor_18_72704"        => "f4e899ce-6c44-48e3-b589-d6265c9ab658",
            "flavor_18_73728"        => "e7babbcc-ebcd-4e13-bcfa-d6c8511ecbc7",
            "flavor_18_74752"        => "c622bc77-41ac-46bc-9128-f113519b6c4c",
            "flavor_18_75776"        => "97523bc4-c590-49b5-bd32-b7be9ee9dbdd",
            "flavor_18_76800"        => "9b29aba7-b1bd-41c2-bfc7-6855708dc989",
            "flavor_18_77824"        => "a9bd9834-912e-433f-8259-85d6bae01145",
            "flavor_18_78848"        => "5781e78f-d423-46bb-86e7-c70969ba301a",
            "flavor_18_79872"        => "66e5d2a6-6bfe-4a9d-9d1e-155905fd4428",
            "flavor_18_80896"        => "f7eaa5d5-d43c-4664-9868-7d16321cc924",
            "flavor_18_81920"        => "856d65e1-17a7-418d-9ae4-a6619e05efe4",
            "flavor_18_82944"        => "9a0a5823-5303-47a3-805d-bc8e8a082087",
            "flavor_18_83968"        => "26ac6109-1161-4809-bd87-3c271a89168f",
            "flavor_18_84992"        => "9c1d162c-27c7-4d75-b3c4-007f6a947639",
            "flavor_18_86016"        => "684132fc-fc17-4d94-be9f-0c1151d9abcc",
            "flavor_18_87040"        => "cb69711b-b9e6-4052-8291-d5507bbc635f",
            "flavor_18_88064"        => "68483f0d-c6d5-4739-a765-607461605087",
            "flavor_18_89088"        => "72e65428-9373-432a-a3c9-75a77545e293",
            "flavor_18_90112"        => "c2366fea-bb35-4109-a811-ae68d49f303e",
            "flavor_18_91136"        => "0de52b1d-c569-4261-9d52-b6e2f4f9908b",
            "flavor_18_92160"        => "86df81ed-9d87-4c9e-b81d-a429a3e04282",
            "flavor_18_93184"        => "063689fe-4f50-46c1-89a7-d7f599c56d19",
            "flavor_18_94208"        => "1e6a791c-af48-4baf-9983-2a49d47d955f",
            "flavor_18_95232"        => "74f19992-8eb9-4a80-b375-a3a55aae31f2",
            "flavor_18_96256"        => "a2f67e39-d3b8-49a5-ac6a-6af256ecdcec",
            "flavor_18_97280"        => "88c34e71-502c-4493-a542-953aa7191cf0",
            "flavor_18_98304"        => "b9b596cb-158b-473c-8ead-b8aadb384f34",
            "flavor_18_99328"        => "0f84c972-e4cd-4085-aab4-02dddfb5ff3e",
            "flavor_18_100352"       => "fa10b347-f91e-47e0-b330-d6f595ad6f8e",
            "flavor_18_101376"       => "d8f04c6f-f0e6-4a9b-8207-71fde9ae270b",
            "flavor_18_102400"       => "2925ad56-03c5-432d-b943-615c0d654a30",
            "flavor_18_103424"       => "10ed4680-e3fc-44ae-ba08-aa7dd451cf13",
            "flavor_18_104448"       => "3bce83bc-f00a-4d7d-a6ca-7df48d9f301e",
            "flavor_18_105472"       => "ffa5ddad-dcf9-455a-99f3-99d6c83c6a0b",
            "flavor_18_106496"       => "fe32ebc7-a50e-4785-ba92-92eae9dbc922",
            "flavor_18_107520"       => "adb42f19-ee21-4841-bf17-4b4afb78baf9",
            "flavor_18_108544"       => "73cdfba8-8528-4507-85e4-c82dddf21dbb",
            "flavor_18_109568"       => "c88f52b8-906e-45ed-99fd-9fc0befa87d3",
            "flavor_18_110592"       => "c6b23a66-df47-401b-a9f7-b590f4015bed",
            "flavor_18_111616"       => "bf57f141-34fb-4aa1-b5d9-8253fdfa0a1b",
            "flavor_18_112640"       => "9dad9f89-52a3-4724-8a8a-9615306b52d7",
            "flavor_18_113664"       => "ab912439-e1b4-4eb4-9c39-8b55c83ea0c6",
            "flavor_18_114688"       => "af3955f8-1396-4dd2-b883-5cddb5f715ed",
            "flavor_18_115712"       => "64b13f73-142d-411b-aa5a-18c4da2304aa",
            "flavor_18_116736"       => "c582e0a5-f565-4d44-82a8-46d7adbb3083",
            "flavor_18_117760"       => "f4738b05-4395-48f4-9dd1-1ea2c769adaf",
            "flavor_18_118784"       => "6643f952-af03-4fd6-8049-447849a0d00d",
            "flavor_18_119808"       => "3e9e7a9c-9f24-4d3f-bda0-42d50a4c83df",
            "flavor_18_120832"       => "4e11f400-cd25-4a26-84be-96d1e04d91a6",
            "flavor_18_121856"       => "88136bc6-2666-47d1-82d2-96c6901f2a45",
            "flavor_18_122880"       => "115fb6d3-566a-4b40-a0d4-67cad28cd08b",
            "flavor_18_123904"       => "45c7d898-deef-4159-a0ba-a8316051f119",
            "flavor_18_124928"       => "3b60791e-4766-4e72-a947-6025a4c3942f",
            "flavor_18_125952"       => "560027e1-3525-48f9-b35a-6e8f863e1207",
            "flavor_18_126976"       => "b6e82e54-f026-40e6-91b5-6269dd5bbd33",
            "flavor_18_128000"       => "e827f3c3-d386-431c-bd3e-5a1a404816d5",
            "flavor_18_129024"       => "51569f55-eee5-4b47-8c49-c444390856cd",
            "flavor_18_130048"       => "db97d71e-93ec-40c9-8cb0-866c0a312dcd",
            "flavor_19_5120"         => "0b8fc30e-35d9-4df1-aeb9-3871164815ad",
            "flavor_19_7168"         => "c59371ea-41d5-43e0-8fa6-08954266b36a",
            "flavor_19_9216"         => "53679ea1-2904-4cd0-8c31-2a9386e7a29e",
            "flavor_19_11264"        => "1cfa0328-7570-4b82-aea3-31031a7026e6",
            "flavor_19_13312"        => "248be54b-45f5-4c17-93d8-d55e0b6e84f7",
            "flavor_19_14336"        => "d8a2ec21-3fe2-4159-939b-29f066b04dc1",
            "flavor_19_15360"        => "a972370d-a1bc-4ecf-956b-eca7b4eda633",
            "flavor_19_17408"        => "6e893a6f-e9cb-40ef-b9c9-64cd10c19d2a",
            "flavor_19_18432"        => "427f6a91-40eb-404c-b5bb-058ae76b1a56",
            "flavor_19_19456"        => "65fa7fa4-cc53-4488-88ce-e01c3bbab227",
            "flavor_19_20480"        => "17c328fe-6023-406c-a56f-75adfc8e9362",
            "flavor_19_21504"        => "dd5034f9-c4eb-4943-8683-ce4696724071",
            "flavor_19_22528"        => "8001dafa-6f9b-4661-a7b0-b834006833d4",
            "flavor_19_23552"        => "74dd079a-8962-4c24-8041-0c5def4ff83a",
            "flavor_19_25600"        => "df91d927-ab46-4858-bb9f-2fec02361c51",
            "flavor_19_26624"        => "86b8c019-e3b5-4db4-9d4a-12a86719fcbc",
            "flavor_19_27648"        => "5e5ced34-0327-4093-b7ab-5b2b6cd97a89",
            "flavor_19_28672"        => "e2001800-cf59-4ca5-bb4e-c831f6b13ae2",
            "flavor_19_29696"        => "e7518052-7207-46f5-912a-1bec0a976fd5",
            "flavor_19_30720"        => "a5ad2200-1cae-49d8-8e47-f01845581ae9",
            "flavor_19_31744"        => "8524ec1e-8d7a-490d-9f0a-44645f255702",
            "flavor_19_33792"        => "b5d23316-43c2-4c62-84e9-5f38396162c2",
            "flavor_19_34816"        => "5c8cb1ec-ea22-4f78-a2cf-393815d4deaf",
            "flavor_19_35840"        => "a492fd9e-d8fe-41f5-8350-2eccbf2ae9d4",
            "flavor_19_37888"        => "3da62c8c-8c3c-491e-9967-a9fa36c947dc",
            "flavor_19_38912"        => "d1f85b44-5cdf-4697-b5bb-f83272d8c592",
            "flavor_19_39936"        => "ea621c9c-f230-4f14-b6c3-78432d5b8e04",
            "flavor_19_40960"        => "7d8a80a6-10c2-4b8b-bd2b-570ac29c3a2a",
            "flavor_19_41984"        => "059483c8-0a5a-4003-ba6c-1d5e9b6e8272",
            "flavor_19_44032"        => "9a42f0ac-c502-41fc-8181-009bdd1f9f17",
            "flavor_19_45056"        => "cf439c1b-6f40-4c01-b859-8ef6db272ab9",
            "flavor_19_46080"        => "1600d63d-e5ab-4aad-8698-fff06df485ed",
            "flavor_19_47104"        => "4ae20c0a-798d-4987-b2da-6dc582e5afe5",
            "flavor_19_48128"        => "d1f01a65-80cd-48ed-87b7-2b8e0fac894a",
            "flavor_19_50176"        => "9d0bcc6c-95aa-41aa-87c6-998c31663944",
            "flavor_19_51200"        => "73a82418-3e77-4ab9-bee9-ab0238e6fd9c",
            "flavor_19_52224"        => "034c53af-4524-465a-969c-e14bea877b65",
            "flavor_19_53248"        => "5b8a6b95-f378-4ce1-8a50-52f7b19526de",
            "flavor_19_54272"        => "60e1781e-f388-4e4b-a6fc-bbf4d47e3f2e",
            "flavor_19_56320"        => "d01fff70-b731-4277-b03b-168d799952b6",
            "flavor_19_57344"        => "59493d27-f44a-436e-b8be-18b8bc709c53",
            "flavor_19_58368"        => "f3058538-6d81-4be6-83e2-e1af7bb35b97",
            "flavor_19_59392"        => "04c08102-d5e1-47bb-bff9-993165488907",
            "flavor_19_60416"        => "d4283d07-36b4-4ef4-a2d2-6cbe21a08cb8",
            "flavor_19_61440"        => "d6899e6c-ecb4-496c-b213-763aaa995523",
            "flavor_19_62464"        => "08739552-a437-40b0-a938-5608f038c37c",
            "flavor_19_63488"        => "6daed47f-487c-42c7-9a48-2634ba3ba8ae",
            "flavor_19_64512"        => "8ca7ab41-824b-4cca-9ec9-e0fde2ab16ac",
            "flavor_19_66560"        => "1742034d-aaa0-4f1f-b219-e283aee9579c",
            "flavor_19_67584"        => "4f5f5e03-0259-4aca-8cfa-68c2c999ab34",
            "flavor_19_68608"        => "12a66ad3-df76-4238-a2ed-ac036124c2e3",
            "flavor_19_69632"        => "03210d6b-e0b6-44ef-96fd-b7c2f244e2f6",
            "flavor_19_70656"        => "73e4b263-1243-4d88-80a3-2555125cdcdc",
            "flavor_19_71680"        => "9754241b-ded4-46b8-8e0a-50e0dd5f9c76",
            "flavor_19_72704"        => "04d66ff6-7e1e-4640-8e59-250a2b7c4ec0",
            "flavor_19_73728"        => "a13dd1e4-806e-4b70-8414-95736fb58dad",
            "flavor_19_74752"        => "9e5e6507-d16c-4ce5-9f00-64fe1b6473d4",
            "flavor_19_75776"        => "9de44a9d-63fb-4687-981a-52784523aa89",
            "flavor_19_76800"        => "99d21258-abb6-4aa6-845e-cde276311118",
            "flavor_19_77824"        => "893380f5-a630-4c06-8312-fab7ea23bf64",
            "flavor_19_78848"        => "c5ec0779-e02a-41e7-8d3b-8c1ca4299653",
            "flavor_19_79872"        => "bd571981-e68c-49a8-bdcb-feac607adaf3",
            "flavor_19_80896"        => "5e986d01-52d4-4f62-b959-b23ee9326de8",
            "flavor_19_81920"        => "989fa91f-77a3-4fc7-90ef-aad7651872d5",
            "flavor_19_82944"        => "0a810383-9380-4952-997a-81ac0c1f2247",
            "flavor_19_83968"        => "5888d7c0-590b-49ac-8bc0-3a99fee9a6b9",
            "flavor_19_84992"        => "dd9fa087-b139-49be-8782-6a55017680c7",
            "flavor_19_86016"        => "827e4730-955e-45e5-9eb5-8541029e1431",
            "flavor_19_87040"        => "99be9538-6196-4359-9237-70fcbe01f0ef",
            "flavor_19_88064"        => "54c747b5-e5a1-4488-a6d9-be7e4843990e",
            "flavor_19_89088"        => "1b1933ac-51e6-4ec6-b320-29c9d3db01de",
            "flavor_19_90112"        => "c62cc1ae-a36d-4c2a-8982-4be181afade9",
            "flavor_19_91136"        => "dc2a838d-3b27-4ae8-b109-3980dfff2607",
            "flavor_19_92160"        => "3f273ebe-de86-4a4a-ba2c-6a64cd63f9f0",
            "flavor_19_93184"        => "749466ba-4475-47af-99ee-5f8a21bd9359",
            "flavor_19_94208"        => "ea611973-e6a4-44bb-a4ce-f98ade3447ab",
            "flavor_19_95232"        => "71dbfedb-49d8-434a-8107-613ca5e709de",
            "flavor_19_96256"        => "b497f89a-67b3-4cfe-ba45-d5976352e4d4",
            "flavor_19_97280"        => "a96f2635-d287-4e01-a86b-4c0cbc8017e7",
            "flavor_19_98304"        => "683da481-a152-4405-adaa-4d9388a8f8b8",
            "flavor_19_99328"        => "8accb1ff-6bda-4243-85e1-440ba8197d29",
            "flavor_19_100352"       => "08785722-88d9-4021-a096-dd0431d9d010",
            "flavor_19_101376"       => "15298e6d-6707-47f9-8763-43f6854b45de",
            "flavor_19_102400"       => "e2a7cf3d-ade9-4e68-94bb-0167543ca2c2",
            "flavor_19_103424"       => "e08426d8-8cc8-4592-a4af-6ee49289338e",
            "flavor_19_104448"       => "c9c1b64a-0967-4d3e-a746-0c7d233c4e34",
            "flavor_19_105472"       => "4594b465-8f8c-4ab8-b04a-13065352bd50",
            "flavor_19_106496"       => "1431dd4a-e9d6-489a-9de5-ebabcafaff65",
            "flavor_19_107520"       => "369b09aa-94b4-4375-9289-22c474c6a91d",
            "flavor_19_108544"       => "64eb94e1-8264-4441-a39e-c7391fdddb11",
            "flavor_19_109568"       => "ea94d870-041f-4688-b032-c48081ef92b0",
            "flavor_19_110592"       => "218087de-adb3-4439-b9df-0d0dbf41391f",
            "flavor_19_111616"       => "888e92fe-c103-41ec-b9da-00808124bc7f",
            "flavor_19_112640"       => "fff73f52-0633-4d27-9a85-ba0b0618f4e7",
            "flavor_19_113664"       => "6ab98ec0-cb45-4a6f-9576-cd481e1c5e3f",
            "flavor_19_114688"       => "97505464-f779-4f3f-8da4-85f98005718b",
            "flavor_19_115712"       => "09e8adee-bb6e-49ee-ac35-885e7bea095d",
            "flavor_19_116736"       => "1363da14-e685-4ecd-b00b-ecfa7aac9aa2",
            "flavor_19_117760"       => "b296b370-9cee-419c-a153-1a27bdd1e4e5",
            "flavor_19_118784"       => "cf65aae2-a31b-464b-bda5-6bbc6d3dd91d",
            "flavor_19_119808"       => "51e2a2fa-58b7-4ccc-a5cf-fe8618af3b3b",
            "flavor_19_120832"       => "1565fee8-a869-4e5b-a294-e71faab45e49",
            "flavor_19_121856"       => "1522fcaa-e4e7-4b68-91d3-587b35e98da8",
            "flavor_19_122880"       => "5e03b6f8-f350-4b4f-b4c5-ff00def56829",
            "flavor_19_123904"       => "24f98a71-86df-466f-a050-aa583d7200d6",
            "flavor_19_124928"       => "199a570d-b3e4-43f2-927c-92fd9d1696e8",
            "flavor_19_125952"       => "fa888a38-dd36-46c8-838a-e5be95dd30d0",
            "flavor_19_126976"       => "d3437342-a210-42ed-9319-94b11924d0f9",
            "flavor_19_128000"       => "1f071902-4f2c-4696-a397-7d7e56c15d61",
            "flavor_19_129024"       => "10719531-5560-40bf-abce-0fdb56d0ee85",
            "flavor_19_130048"       => "3afd4c54-1c93-4a1f-a0e8-ef0abb713d3a",
            "flavor_20_5120"         => "0ff805b2-67a5-4efe-a719-efde20803168",
            "flavor_20_7168"         => "db342eb1-6222-4ade-b73d-2a48aca7334a",
            "flavor_20_9216"         => "14e6b093-4afa-40b9-b2e4-bc065af9ec1a",
            "flavor_20_11264"        => "4468cb48-5bad-4d56-80e0-868f2ce73ccc",
            "flavor_20_13312"        => "19668b0e-1861-463f-bb77-30332bce8b78",
            "flavor_20_14336"        => "e9eaba4c-96fd-4c0b-8782-9becb901b5f0",
            "flavor_20_15360"        => "191061f2-539e-4311-9ac6-83718d3c778c",
            "flavor_20_17408"        => "dd3ae19c-153f-48f1-bbfe-f310a6a15cff",
            "flavor_20_18432"        => "317cbee2-0498-4352-80af-4ac383231fa0",
            "flavor_20_19456"        => "5a22dd2b-0f32-413d-bfd5-c21bfa762943",
            "flavor_20_20480"        => "d7d827a9-681f-4d40-aba9-ce2f698a06d5",
            "flavor_20_21504"        => "7a352515-1e26-493c-9ac4-5e738f74a3fb",
            "flavor_20_22528"        => "12fb73b1-c5e2-427e-9272-91754dee3400",
            "flavor_20_23552"        => "d8297307-0258-4c3a-a21a-d5bbe22c06a8",
            "flavor_20_25600"        => "6223e12b-520c-4d40-805c-7789435372e5",
            "flavor_20_26624"        => "ef9a1cf8-f000-4a89-8ca0-ff821b5467cb",
            "flavor_20_27648"        => "124ae3fe-5026-4e0b-b640-3df5f11ab472",
            "flavor_20_28672"        => "d51fd1a7-1a82-4cb9-8c4b-58cc0b8ac5e7",
            "flavor_20_29696"        => "dacb9298-16fb-46a7-962b-3a76d76acb3f",
            "flavor_20_30720"        => "fbc7ab65-2812-4a41-b913-8529db6d0329",
            "flavor_20_31744"        => "3b0ccb19-4bda-4479-8a0d-9f8be58a7a48",
            "flavor_20_33792"        => "a7a1d709-6929-459e-afe4-fcd33bdbddab",
            "flavor_20_34816"        => "ab6fb572-cd6a-42f9-816e-28d1efeab764",
            "flavor_20_35840"        => "c3fd2c1c-716c-4761-a699-20008c2c35c4",
            "flavor_20_37888"        => "c9309c63-c14f-49e3-a2bd-33fafc27fda8",
            "flavor_20_38912"        => "14d7cd6b-a2db-4a1d-98b4-34139c61416e",
            "flavor_20_39936"        => "9642cbea-204d-444e-9083-c19f0b4740f0",
            "flavor_20_40960"        => "ece1486d-0f7d-4deb-bdbb-f32b2ade1619",
            "flavor_20_41984"        => "21bbb916-ccab-466d-826d-165b5725c2fe",
            "flavor_20_44032"        => "4cc71999-d3e9-40b7-a48d-9ecceb321fbf",
            "flavor_20_45056"        => "ffb1f19c-8cb2-4bca-95e5-bb5aa0c7fa5d",
            "flavor_20_46080"        => "aca6c02c-a6e8-49b3-b0f2-5d509bd1a2af",
            "flavor_20_47104"        => "f8cc54df-848b-47ec-b605-694c80d4d25a",
            "flavor_20_48128"        => "46573877-82d4-45e8-9c29-821090ba3044",
            "flavor_20_50176"        => "2343d36b-10a3-49e8-a191-90c84f08c83f",
            "flavor_20_51200"        => "1a622634-2f0a-4288-9145-b40531881c0f",
            "flavor_20_52224"        => "cbd510a4-c807-4f4c-9812-f98c542a31f3",
            "flavor_20_53248"        => "ae5b447e-0653-4f14-b154-a8ac07c7d788",
            "flavor_20_54272"        => "4a71e5a1-697c-4e9f-b31d-b3a1e9962bf3",
            "flavor_20_56320"        => "065f2a2f-71d5-4f04-83e1-a10067a74ef3",
            "flavor_20_57344"        => "d2e6e630-ab80-4150-ae25-944594994709",
            "flavor_20_58368"        => "12f35f83-d1fc-4150-bdde-b21ff77d12d9",
            "flavor_20_59392"        => "98040f4d-a472-4dae-b36f-6f283b0209ab",
            "flavor_20_60416"        => "c7bb9dc9-7427-4ff9-891c-d2b3c58abcca",
            "flavor_20_61440"        => "7c3c790e-c4de-4f7c-92b8-e114eb725735",
            "flavor_20_62464"        => "a01ebfde-670f-4d1c-aeb8-a6cfb1647b11",
            "flavor_20_63488"        => "72634add-b0a3-4adf-b29c-2bbba3e75e07",
            "flavor_20_64512"        => "066ef7e1-e2c2-4665-ad1d-b9acbd2328e5",
            "flavor_20_66560"        => "b4f49acd-c965-41e9-9665-bb8c0e5f28d9",
            "flavor_20_67584"        => "c896b1c9-3767-47a3-b084-3fe03795ec8e",
            "flavor_20_68608"        => "a5a26bb9-fee3-4ede-97b5-be1fb9701342",
            "flavor_20_69632"        => "c362d91e-5c67-46b0-93c5-df28a4a2dda6",
            "flavor_20_70656"        => "d77cd12e-0fa1-4c5a-ba93-a7a3af84ee1a",
            "flavor_20_71680"        => "a9e5032c-8550-41d8-acc7-30bd3e05a496",
            "flavor_20_72704"        => "984b8442-7d1e-4260-b3ec-ffe73682be89",
            "flavor_20_73728"        => "cb74d08b-ac91-40a8-803e-5de4bef41e5c",
            "flavor_20_74752"        => "8db1af12-6df5-4b26-8f69-43fc01daef89",
            "flavor_20_75776"        => "dd5b25cb-9bd5-478d-ba4f-61f8088ff72d",
            "flavor_20_76800"        => "5d0b9de9-1f73-4c53-8e78-94131649c16c",
            "flavor_20_77824"        => "59cd21c1-306e-4e4d-aeca-37382ad37662",
            "flavor_20_78848"        => "0e93e766-83ae-4536-b7ac-1385c1d15bb3",
            "flavor_20_79872"        => "c8080937-5801-456a-8973-d159adf6966f",
            "flavor_20_80896"        => "cebdf6d3-cb44-4f40-998e-fac6246b02af",
            "flavor_20_81920"        => "59ef17bf-a9ee-42cb-9633-191f0180223a",
            "flavor_20_82944"        => "01845686-d77a-47ca-a700-feb23f71a4fe",
            "flavor_20_83968"        => "c36bd4b2-f7ca-44a6-83c8-2341f5311563",
            "flavor_20_84992"        => "0b0620b2-c1ba-4ff0-a9cb-9019bb88f4f1",
            "flavor_20_86016"        => "96487557-af50-48c2-b1a8-09e5c74682c6",
            "flavor_20_87040"        => "4879b0a0-dbdc-4964-9a0a-3dc939cc8a82",
            "flavor_20_88064"        => "d4d4ba26-eb47-460e-8d78-d668b44baa6a",
            "flavor_20_89088"        => "0c56af30-89de-4646-bc3e-72cb2e555dc3",
            "flavor_20_90112"        => "e92d9255-99a6-4f76-b677-802514246bbf",
            "flavor_20_91136"        => "fe52c612-f025-4d6e-9a16-414e7782dab8",
            "flavor_20_92160"        => "2feb396c-bdcb-472e-8553-41a8745458ae",
            "flavor_20_93184"        => "511a70cb-4fa5-452f-98d0-70485d7bf45d",
            "flavor_20_94208"        => "447fc884-0ce7-46bf-bc7c-788511071b60",
            "flavor_20_95232"        => "ffad2deb-c0aa-4b8a-aacd-f7b437441675",
            "flavor_20_96256"        => "cb299db2-1626-4ee4-9141-39ed06c8c39d",
            "flavor_20_97280"        => "eaa2a9f2-dde8-4fc8-a550-007b73c92077",
            "flavor_20_98304"        => "b27652a1-abe1-4b90-97bc-e1a84f8fd1b6",
            "flavor_20_99328"        => "630f4147-737f-43ca-965b-cc787cc2f26d",
            "flavor_20_100352"       => "c9813b88-ff4d-4bfb-b44e-b405a964c20e",
            "flavor_20_101376"       => "7d092398-9842-47dc-8bec-915c2453c84f",
            "flavor_20_102400"       => "7ed11d0d-c3d5-4685-8c38-c5daa3d9be64",
            "flavor_20_103424"       => "56f7c126-7b86-4102-a8b5-7136886d9549",
            "flavor_20_104448"       => "edfe6813-91f5-4556-927e-1b7607b4ad2a",
            "flavor_20_105472"       => "a32663e6-78ce-4d85-93c1-fc6b6c22902d",
            "flavor_20_106496"       => "624d84d7-cffa-46c9-97ad-7b6622723c65",
            "flavor_20_107520"       => "217703f1-8309-4d01-84d3-9763c34e1272",
            "flavor_20_108544"       => "e4b31686-83cc-45c2-9caf-c4720272a599",
            "flavor_20_109568"       => "c9bb924d-3ad4-4632-923e-2c9ebdfddf34",
            "flavor_20_110592"       => "d9dc6b5e-0d99-4a3b-a418-35b580d92370",
            "flavor_20_111616"       => "ef7c1f40-ab20-4a9d-9229-c131e99fd7f8",
            "flavor_20_112640"       => "27b217b9-8987-40ec-b147-0a729d6c80bd",
            "flavor_20_113664"       => "efd9710c-d147-4f76-be39-6f2fd6b5f60e",
            "flavor_20_114688"       => "a15d4add-ff25-49cf-8f08-405c89894dbb",
            "flavor_20_115712"       => "8feb85d5-955c-4dcb-aa6b-26d19c06fba4",
            "flavor_20_116736"       => "ff117d4b-4792-42fe-aeb1-673621324a3b",
            "flavor_20_117760"       => "b45a3dfa-ff4b-4157-8b7f-b1f33b79c364",
            "flavor_20_118784"       => "314b9ec0-879b-4e84-b2aa-6c5e42366490",
            "flavor_20_119808"       => "994ff9a9-bade-47a3-a2b1-35ea9ff46cb7",
            "flavor_20_120832"       => "0395cea8-2aa0-42ae-beb1-74cdf4a6a77f",
            "flavor_20_121856"       => "49044b9a-f08f-483d-9fc6-8259442bc152",
            "flavor_20_122880"       => "9e25bf7b-6cea-4d4e-8346-140c35c911c4",
            "flavor_20_123904"       => "ca8a3bbf-5bca-4173-bae5-dde1d853b3b2",
            "flavor_20_124928"       => "c7f6db70-1dc1-4ddc-8e52-2c096d2da0f8",
            "flavor_20_125952"       => "d4a9c8b1-d1d2-4345-9843-c938e566254c",
            "flavor_20_126976"       => "f0217d5e-77ee-4f4d-b19f-78e30bfc3906",
            "flavor_20_128000"       => "c5db7f02-9e01-4513-a915-b9f0367d3d6f",
            "flavor_20_129024"       => "910f2401-7b75-4a3e-ab3a-86cc058e607a",
            "flavor_20_130048"       => "0df39a93-80cd-4e29-a854-6d98b0cad80e",
            "flavor_21_5120"         => "85e0a6e6-3289-46a2-8fc9-ad1ce34b14b9",
            "flavor_21_7168"         => "6a04601e-ab84-44f8-87ce-2b8f1e43632b",
            "flavor_21_9216"         => "f9728445-609f-437d-95ba-dff42ae2dbea",
            "flavor_21_11264"        => "d30afe21-109b-426e-b840-12eedbc8ba85",
            "flavor_21_13312"        => "dff41a78-d31f-452b-9a0c-a3934a3f05ff",
            "flavor_21_14336"        => "c79a8644-62d0-4b47-b6a3-acc65c84b1a1",
            "flavor_21_15360"        => "0709c758-bd85-4140-9538-4b1b1c48c777",
            "flavor_21_17408"        => "4aa9de6b-d7b2-4989-acde-74af2d596ee8",
            "flavor_21_18432"        => "691e8134-feda-4823-888e-fd2f3d63e1dd",
            "flavor_21_19456"        => "fbfce7fb-0442-4cba-90d7-106a81874b85",
            "flavor_21_20480"        => "7904051e-06b8-4855-a8a9-2c6cf04e2d0c",
            "flavor_21_21504"        => "c32837bb-27a9-4106-bbd7-c465083a7939",
            "flavor_21_22528"        => "5d0db257-fefc-433b-8c02-0e57584307de",
            "flavor_21_23552"        => "bb7c876d-ee52-4b39-a059-31dae34a4bd2",
            "flavor_21_25600"        => "0d5b08a6-a20d-4040-96c8-0f9756a26510",
            "flavor_21_26624"        => "33443f2f-f6d7-4c4e-842a-134755fee92a",
            "flavor_21_27648"        => "bcd399b4-0609-4c66-a108-7d18323d2ce5",
            "flavor_21_28672"        => "aceba79f-5fbb-48a7-8f12-1074c8dc8359",
            "flavor_21_29696"        => "94a65394-4f71-4bc4-87b0-5ff35090c570",
            "flavor_21_30720"        => "bf60b541-9392-4762-989a-e5da52a1601f",
            "flavor_21_31744"        => "82ae8f05-0b30-4022-8061-8822559057ee",
            "flavor_21_33792"        => "57b22fcb-7cd9-478a-a76e-15223c8d3992",
            "flavor_21_34816"        => "28918fdb-a51c-42a4-8a16-ff086b22fa3b",
            "flavor_21_35840"        => "e1c2b6d8-1e34-4d78-b44a-33b0b1d86114",
            "flavor_21_37888"        => "42ed77a4-a071-4c64-bb50-b5f7a3edcb02",
            "flavor_21_38912"        => "280e21c1-0146-4a04-b7fc-584ef75ddc33",
            "flavor_21_39936"        => "18c6de7f-6f50-4667-801f-5e2864aecd41",
            "flavor_21_40960"        => "f706301d-abb8-40d3-8cf5-d0af6aa260bd",
            "flavor_21_41984"        => "fd7e4f3d-b726-4c79-b52e-016482258f47",
            "flavor_21_44032"        => "9fc14542-3709-43c9-abbc-f7286935d4e5",
            "flavor_21_45056"        => "258b35cc-fb22-4cb5-8f19-efa394ac9994",
            "flavor_21_46080"        => "95ac7358-0a7f-4295-9b0e-15ae66032f42",
            "flavor_21_47104"        => "983939d7-2f57-4136-a2e8-b9cc7f4eddc0",
            "flavor_21_48128"        => "d1bace14-1192-4bd6-aef0-03dca734f1da",
            "flavor_21_50176"        => "442e03cc-d6f3-4dea-98a2-b7ba6252d4b1",
            "flavor_21_51200"        => "5c126a49-3976-4a41-8eca-1f49443821a9",
            "flavor_21_52224"        => "afe58a3f-46bf-4d0d-90de-79e33f765091",
            "flavor_21_53248"        => "a5385ad5-12ed-464d-a0e1-f8ac95b763ab",
            "flavor_21_54272"        => "1051fdcf-9666-4077-92d8-4ce744b72d44",
            "flavor_21_56320"        => "522c1860-c4a1-48be-ba8a-28a9ea3f6d76",
            "flavor_21_57344"        => "cd227a82-7705-4431-afba-f76d9106d40b",
            "flavor_21_58368"        => "c6586926-15b6-4139-a0b8-941e2f191e01",
            "flavor_21_59392"        => "93489c40-6e0b-4f25-b18c-a0c53f6b5c91",
            "flavor_21_60416"        => "abbd15aa-384d-443c-a65e-87642dcccfd9",
            "flavor_21_61440"        => "d3a71bc5-f13a-4e3a-8d4b-e69c97277221",
            "flavor_21_62464"        => "1aa0c448-2eaf-4468-9932-31f654721a2b",
            "flavor_21_63488"        => "e355f76b-04c3-4fcd-b659-4b25c4458256",
            "flavor_21_64512"        => "d25ec517-d60b-4c12-b4ff-b3aa3a8579cf",
            "flavor_21_66560"        => "8f3d9f6a-1787-4d73-8ff9-1bc8187b7cfd",
            "flavor_21_67584"        => "a7f096be-754a-435b-ade9-c19269e45a82",
            "flavor_21_68608"        => "7d971bb4-9a61-49fc-ac22-9caa2fcf84b0",
            "flavor_21_69632"        => "be9e3306-f10f-4aa3-b24d-956ca6bebc10",
            "flavor_21_70656"        => "185c3f58-c594-4288-b469-97b4c5f76aeb",
            "flavor_21_71680"        => "f47e6ceb-3952-4703-b7a3-1c1a73bb6770",
            "flavor_21_72704"        => "7d6d5fa9-9e54-43d8-9ddf-08eb69aad696",
            "flavor_21_73728"        => "ca830b5a-8778-4555-b612-1736363d9373",
            "flavor_21_74752"        => "64809f8a-6d52-40c8-9ffd-6e5276528684",
            "flavor_21_75776"        => "7a5cf6b2-f9d2-4aeb-bbad-18d49770f8f4",
            "flavor_21_76800"        => "4cd0822c-40e9-4177-8ac2-acf2796c223c",
            "flavor_21_77824"        => "2ba3e912-ca1a-45ed-a558-4ca232f37136",
            "flavor_21_78848"        => "ebae97f3-ef8c-4e3c-afab-67eb051fbc14",
            "flavor_21_79872"        => "371326b8-aa30-44c6-a006-915c1717f683",
            "flavor_21_80896"        => "23bf4b55-e571-4e46-bfc8-0abf016fc089",
            "flavor_21_81920"        => "72556771-4a1a-4b36-92ba-f20bc0a8a8cc",
            "flavor_21_82944"        => "17c6fbc7-dc3c-44b6-9240-25723f30f9ef",
            "flavor_21_83968"        => "c1ded811-80d1-42f5-8dff-42e0799d09cd",
            "flavor_21_84992"        => "b6ea8ab1-fbea-44ac-9298-b5950a59ce1e",
            "flavor_21_86016"        => "95ff2fc8-826f-4010-93e9-74aa0b8a3130",
            "flavor_21_87040"        => "5b532e41-fce8-4bf8-95fd-7b719c63e0e6",
            "flavor_21_88064"        => "5cb0eeec-4f0b-4398-a8ac-90191ff71ec7",
            "flavor_21_89088"        => "e6577ec9-0c4c-4b6a-847d-b4593bec15b4",
            "flavor_21_90112"        => "296e9a91-4388-41a6-8e2d-b71c3b10d3fa",
            "flavor_21_91136"        => "f8fcd8c1-57de-41ba-8fba-66dc863839ed",
            "flavor_21_92160"        => "d81b4bdb-b074-4a63-beb6-a120cfe19ef5",
            "flavor_21_93184"        => "7182b3df-5865-40d5-9aee-5022fcaf5636",
            "flavor_21_94208"        => "181d9fa3-3f9c-473b-b721-ea9e535443ab",
            "flavor_21_95232"        => "e1196f1b-de63-4884-9464-a2a93be02c9f",
            "flavor_21_96256"        => "190a3bf5-300a-4685-9c0e-0986588d4271",
            "flavor_21_97280"        => "a59aa55f-a87b-45fb-a740-1bd4d1218169",
            "flavor_21_98304"        => "05bc2e95-c07a-4f9f-a0be-1daa513eb100",
            "flavor_21_99328"        => "9e909cb7-4e0a-4882-8129-1238647d218f",
            "flavor_21_100352"       => "8eb0b17a-9f73-420f-b71c-7d1e36ad79db",
            "flavor_21_101376"       => "65beaf1d-e9ae-4e71-9d22-a91e3bca8bb8",
            "flavor_21_102400"       => "0d99ce6d-6843-43f8-b878-fe4de041c757",
            "flavor_21_103424"       => "8e1f2ee7-e175-4120-93b1-a67bcba6d92f",
            "flavor_21_104448"       => "5dfbf3c9-15aa-4291-933d-9ce5143a2a85",
            "flavor_21_105472"       => "f61c1707-1359-4ba9-b24b-4692bcdff5fb",
            "flavor_21_106496"       => "1429a9c8-3f8e-4f52-96a2-e8876bed4b91",
            "flavor_21_107520"       => "7781e37c-f917-430f-b1d0-482f3a44314f",
            "flavor_21_108544"       => "001196fd-e189-4688-a076-eb25e2f432f9",
            "flavor_21_109568"       => "021ff63f-bfcd-48b8-8725-f4f37bc46f48",
            "flavor_21_110592"       => "e91d9acb-2ecf-4d0e-a50a-f9ca61c5893d",
            "flavor_21_111616"       => "16948a33-7f5d-4033-9958-12be6d30a81c",
            "flavor_21_112640"       => "36d6059f-138c-4bdd-81b5-5bf1dbf2fa8e",
            "flavor_21_113664"       => "0e5a2c9b-fa13-4e77-8e32-aa7bc107aa72",
            "flavor_21_114688"       => "40c74172-9736-4585-bba3-a67cd9beea99",
            "flavor_21_115712"       => "5341ba03-82d1-4510-972a-156f5b68fdb7",
            "flavor_21_116736"       => "36cf9c68-f87b-4a49-85bb-d8e4e612a40c",
            "flavor_21_117760"       => "af0af426-e64c-4ba1-b233-5d467862618a",
            "flavor_21_118784"       => "82da4e84-1761-4682-ad32-b5d25fe2d7bf",
            "flavor_21_119808"       => "fe25f21f-bf85-41e6-ad57-d5c2dc1d2713",
            "flavor_21_120832"       => "e2821fcc-652f-4751-888f-5a9a7f68fe7e",
            "flavor_21_121856"       => "3f637120-5712-441f-82d0-c8604027a532",
            "flavor_21_122880"       => "c0eebed0-a64c-4a57-bb08-f387a9b632fa",
            "flavor_21_123904"       => "c1837bcc-baa6-4d6a-95c7-5ebdba6e06c9",
            "flavor_21_124928"       => "fcd95de7-db84-4b14-9965-574007f1f8af",
            "flavor_21_125952"       => "1e5ac777-f275-45cf-b508-2e5ffd20d73f",
            "flavor_21_126976"       => "57af300c-dcb7-450e-9c98-462b32915fed",
            "flavor_21_128000"       => "49bc524b-8c35-4910-9b23-a8dcd2fa35df",
            "flavor_21_129024"       => "334838be-92b9-4352-97d7-8ca62481f717",
            "flavor_21_130048"       => "3dae040b-5711-4cbb-98a1-5e072d5dc1e4",
            "flavor_22_5120"         => "2baa723b-4dea-4440-bd9e-efca76f4e1d6",
            "flavor_22_7168"         => "5903419b-96b9-4699-b6eb-e5487aa60201",
            "flavor_22_9216"         => "e78483e0-8755-4d81-bf25-a7b1d1bb00c1",
            "flavor_22_11264"        => "81a7c928-1cd6-482b-a23b-e8e329339afa",
            "flavor_22_13312"        => "b2ab61a9-75c1-44b0-a38e-9271565b25dd",
            "flavor_22_14336"        => "0cb60f9f-1c77-4d49-8a69-d1098742a819",
            "flavor_22_15360"        => "9b226859-86f2-4fe1-b9f3-fc31302730c8",
            "flavor_22_17408"        => "24f0fa21-df94-4c40-896d-fe3c71a97b97",
            "flavor_22_18432"        => "aa664e1c-d7c6-4e98-a402-de98ee9fd5d7",
            "flavor_22_19456"        => "62a8f4e6-8ca9-4b85-8dbe-f7a04304f78d",
            "flavor_22_20480"        => "b7878e21-c559-44f0-8d20-60ad8f51ce3a",
            "flavor_22_21504"        => "6aa5aa54-6e3e-4a93-b392-3a8f3bd9a01a",
            "flavor_22_22528"        => "ff4e74bc-948f-4672-87b9-8fcccd100574",
            "flavor_22_23552"        => "2f10691e-18a7-4199-a31f-692be70b42ba",
            "flavor_22_25600"        => "2829099e-f628-4765-9cac-5cf6d8182b82",
            "flavor_22_26624"        => "cfed2354-b2da-4bb8-b868-68a90fc73a37",
            "flavor_22_27648"        => "b390ea34-d614-43e0-a69e-6c6ab33eb4fc",
            "flavor_22_28672"        => "cd3bd2e6-a0c5-4043-b6f8-6afb6ff7c745",
            "flavor_22_29696"        => "c996010f-9a4a-443e-98fd-1b040042832d",
            "flavor_22_30720"        => "5508aef3-e67f-469d-ac6c-a5872c485cf0",
            "flavor_22_31744"        => "3e9b5eef-3b35-4f68-9990-f95b660b140a",
            "flavor_22_33792"        => "59fd1d9c-d67b-404b-bc21-07c5d057f6ab",
            "flavor_22_34816"        => "9591fdfd-43f5-40d0-8d0c-4bdf35f3c808",
            "flavor_22_35840"        => "f777c8eb-3a59-4691-9cc2-14dd447bb411",
            "flavor_22_37888"        => "0bd2f722-b384-48a8-b278-b4dfb93d8f65",
            "flavor_22_38912"        => "a9f4066c-9dd6-4a29-a468-ec3495432b34",
            "flavor_22_39936"        => "22576216-20bf-43dd-b4ef-88bad20a9380",
            "flavor_22_40960"        => "4ed82944-578f-4dcd-b870-a00c6f44de61",
            "flavor_22_41984"        => "dede0ae0-8429-4c3f-8861-aa3f0d86bc2b",
            "flavor_22_44032"        => "b007b067-9896-4063-8e8e-9a465644da70",
            "flavor_22_45056"        => "cbe9d4c5-e1b9-494e-a838-3fb43dcd335c",
            "flavor_22_46080"        => "cbbd8acd-c61a-4745-82df-ed08f3fbc7d4",
            "flavor_22_47104"        => "8ed88894-d268-4fb6-8c26-c95873a8191f",
            "flavor_22_48128"        => "4bc24b0c-89c5-429f-b765-172add790fd8",
            "flavor_22_50176"        => "2cbab40a-63c1-4d51-96e8-d0ec21a1bccd",
            "flavor_22_51200"        => "3428adef-24a1-455b-98b9-8b7f380e67a3",
            "flavor_22_52224"        => "50bbcfc9-4c13-4baa-a8cc-c465bf48176a",
            "flavor_22_53248"        => "ea8e5bfb-282e-4cb3-b3f5-8bcd3bf124e3",
            "flavor_22_54272"        => "c6685702-6047-4ebf-a3bd-3b0dfa9426b0",
            "flavor_22_56320"        => "25081f54-85c5-46fc-9910-be7f086583ff",
            "flavor_22_57344"        => "5a81e838-0171-4e70-aecc-c61dd100ebc8",
            "flavor_22_58368"        => "85329841-f38c-4f0a-90e3-405d6e0fd9ee",
            "flavor_22_59392"        => "0a6ffa3c-a616-4de0-b4cf-9c8acf8ac22d",
            "flavor_22_60416"        => "0138d19d-4d67-479c-8a20-f70702cd640a",
            "flavor_22_61440"        => "46ea5be8-3be9-446f-81f2-cd009a70d980",
            "flavor_22_62464"        => "ac6f35af-6117-487f-b0a4-da9d136762e8",
            "flavor_22_63488"        => "2c974d78-eb11-42ed-aecb-8833f04b62eb",
            "flavor_22_64512"        => "80f2ef05-9d91-4c32-8a02-f9f927347507",
            "flavor_22_66560"        => "a1d8305d-9c3e-4a54-b6d9-c0d1c45f7d1e",
            "flavor_22_67584"        => "ab8cfe75-6c9a-4981-8659-4c78b4036cf0",
            "flavor_22_68608"        => "b6ec2f25-da66-4cac-9a0e-45b476a9ada1",
            "flavor_22_69632"        => "5a1860d0-b297-41b8-97da-c0b864fc11bf",
            "flavor_22_70656"        => "170b36fe-ad4c-4224-b4b2-f36b3748427d",
            "flavor_22_71680"        => "ca559ddd-efb2-4b56-b8b5-079f5ba0c83f",
            "flavor_22_72704"        => "8c79a4d5-93bb-4000-901a-3dc552f24935",
            "flavor_22_73728"        => "fdbb5d92-0920-48e8-a78e-7c749a7354f7",
            "flavor_22_74752"        => "75e6e5e1-80a0-4dc1-ae04-8f10b220bda0",
            "flavor_22_75776"        => "721a2212-5e1f-485c-84d8-113b3821c745",
            "flavor_22_76800"        => "b1c06a5e-6bba-4b93-b466-2393c574663f",
            "flavor_22_77824"        => "5c4f57a9-fd8e-4a3a-9f27-c16617a2cd51",
            "flavor_22_78848"        => "8c2d3b9a-8496-40ca-9096-6674822d3bbc",
            "flavor_22_79872"        => "3169d425-17a2-444f-92d5-40008b9e32fa",
            "flavor_22_80896"        => "6f72f3d9-3b34-4a43-b973-4fd3f6a3ecae",
            "flavor_22_81920"        => "487c91cb-bd0c-4085-bfc4-3e4b9472aaba",
            "flavor_22_82944"        => "acfe4b68-d5a6-45e2-a46e-814d0e73d046",
            "flavor_22_83968"        => "180bf680-ff4d-4d34-b14c-a77880ae51b9",
            "flavor_22_84992"        => "38f6d808-0f2f-4f6b-8509-24c7b2b889cd",
            "flavor_22_86016"        => "ec01062a-0c7f-449f-b3d5-26faa1537714",
            "flavor_22_87040"        => "ce6cc066-a041-4d69-aee4-bbe2a41435ce",
            "flavor_22_88064"        => "8a08f39f-eaf6-43a4-aa29-713221bb866b",
            "flavor_22_89088"        => "6f4e9ffc-0587-42a2-ba1d-3730640c6ad6",
            "flavor_22_90112"        => "b390f63d-f1e8-431a-964d-5619f3c06925",
            "flavor_22_91136"        => "dd59cf95-93f6-4363-9201-72fc8c62ecc3",
            "flavor_22_92160"        => "3b81eceb-d9c2-46fb-b2db-5364b53dd5b7",
            "flavor_22_93184"        => "00cb3a1c-1591-4cca-b647-9264fb6fd2e5",
            "flavor_22_94208"        => "30128688-3c85-4b26-96ac-2d0d5351e9d2",
            "flavor_22_95232"        => "26373367-37b1-48b2-a053-9ed3f486e38a",
            "flavor_22_96256"        => "6b8b497d-8e1d-45b2-a6cb-082184a98957",
            "flavor_22_97280"        => "424ae6a6-23a6-4ca2-97ce-086b2e925a65",
            "flavor_22_98304"        => "16d1abf3-a45f-4a8a-820c-152e7c9ad71f",
            "flavor_22_99328"        => "d930e0dd-db77-476f-a825-f8c1517122c0",
            "flavor_22_100352"       => "1574e347-fb52-4849-b881-435b3ef009fb",
            "flavor_22_101376"       => "3b1c7ddb-3202-45dc-890b-8d0bfbb5ebd0",
            "flavor_22_102400"       => "109db54a-1fac-4ce8-bdf2-437e726ebc86",
            "flavor_22_103424"       => "4d0bf8d4-e91e-41c6-933e-a24f5ad7b80e",
            "flavor_22_104448"       => "b43ec5fd-b96f-4ac7-a3e3-f729e8c1eea4",
            "flavor_22_105472"       => "2460836e-86db-4eb8-a8f4-b4ea560ef646",
            "flavor_22_106496"       => "7743e2be-acb1-4e5a-88e4-9c56b38bf782",
            "flavor_22_107520"       => "ae44e9d7-0335-4a1b-998f-cce27b1c8e98",
            "flavor_22_108544"       => "0c052c27-b52f-4072-b9ec-85fb3d2b4abe",
            "flavor_22_109568"       => "1a3fc6f9-21eb-44ae-867c-625acb3f0c67",
            "flavor_22_110592"       => "9804e02e-692f-4721-98e1-97ef587338ec",
            "flavor_22_111616"       => "ba050fd6-350a-4c8f-b4d6-1ab32bb80756",
            "flavor_22_112640"       => "4c68e5be-5e41-4bf8-ada8-019b087dec0b",
            "flavor_22_113664"       => "6e3816cf-781b-425c-9bc4-6004c67c8f50",
            "flavor_22_114688"       => "f28e6ecc-f606-4f46-b190-89c2220fa83a",
            "flavor_22_115712"       => "48c89511-08e4-495c-a358-f6a58fd5c57f",
            "flavor_22_116736"       => "a166bbcc-511c-4e5b-be1f-9e6988b39299",
            "flavor_22_117760"       => "366a6ebd-1264-4fac-b589-765c23a3f31e",
            "flavor_22_118784"       => "22169887-5000-43be-ba8a-2019e6ecb850",
            "flavor_22_119808"       => "ef15b6f5-2851-4319-ae9b-859d77df6eb5",
            "flavor_22_120832"       => "83127bfd-13ea-4090-99a3-883622da3608",
            "flavor_22_121856"       => "d0ce0c0d-faee-4a18-97ff-7b7471e8bc14",
            "flavor_22_122880"       => "391e441f-a459-48cb-9481-14ae69c372a8",
            "flavor_22_123904"       => "816e0f3d-7d37-4228-8c3c-37304781e8eb",
            "flavor_22_124928"       => "4aef9573-0da2-448b-b913-604fef036b74",
            "flavor_22_125952"       => "797b0dae-6d7f-49f8-b84c-da2117f80a79",
            "flavor_22_126976"       => "c804254d-ccb8-4226-81a3-057553d95aa5",
            "flavor_22_128000"       => "0be2ce86-4cee-4b7a-8477-a80741658e14",
            "flavor_22_129024"       => "8e570cb7-8f89-43a9-8ddc-85098f684cc2",
            "flavor_22_130048"       => "4e5411b2-d6c7-4f2e-a16c-ef6f3d603cd4",
            "flavor_23_5120"         => "1f6fbc0c-fab8-4274-9c25-dc8d49bcfbd2",
            "flavor_23_7168"         => "48a68f5a-1e16-4e35-bdd4-0202d10189de",
            "flavor_23_9216"         => "7b9b02ca-a147-483c-9b98-7c9c6148c55c",
            "flavor_23_11264"        => "37c8852d-de3a-47a2-baaf-e77082d21d4f",
            "flavor_23_13312"        => "8efd21b1-d606-44dc-a6dc-9de8c58ccf8e",
            "flavor_23_14336"        => "e8487c5b-4b6c-4553-9bbe-c32a604d19ab",
            "flavor_23_15360"        => "3967cc8b-b3f1-4df8-9c83-da00f2833548",
            "flavor_23_17408"        => "491322ff-e172-4acb-ac46-5523c481c101",
            "flavor_23_18432"        => "c7ea9d15-b41f-46c2-bd2c-b1a50df3272e",
            "flavor_23_19456"        => "cb545418-e534-474b-a02a-82ae47abd15c",
            "flavor_23_20480"        => "73f7aa2e-7f0a-410a-aa52-28b8e8552859",
            "flavor_23_21504"        => "054f91a5-e08c-4ce4-b7e1-f8fb007be1dc",
            "flavor_23_22528"        => "87349c48-5cba-4bbb-ab05-b272d55b6779",
            "flavor_23_23552"        => "25f1cd05-a6c2-44d5-9f69-263f9430c70c",
            "flavor_23_25600"        => "e7b47d59-02a7-40cc-bc43-37c00cd93417",
            "flavor_23_26624"        => "4422f046-dda3-44ff-ae93-cc66a7a3133f",
            "flavor_23_27648"        => "6541a1f9-92ea-4100-a043-91d77ac800d8",
            "flavor_23_28672"        => "08435a51-7114-4fcb-9b31-056f5a5c2017",
            "flavor_23_29696"        => "d3120033-5ae8-4b2a-9299-6368d0805d4e",
            "flavor_23_30720"        => "8652083b-fd7d-44a2-a392-7caed9271754",
            "flavor_23_31744"        => "693a62ec-98db-49e6-bae3-50f243484721",
            "flavor_23_33792"        => "e8e63ee7-81b6-4052-8d2e-60d6bdc05bc5",
            "flavor_23_34816"        => "fca7d0bc-a148-4a21-8b73-78b7d7cbcc0b",
            "flavor_23_35840"        => "e9b59d27-fa52-4c43-9bcb-ae9a46ad3558",
            "flavor_23_37888"        => "20e408dd-d96b-4c77-9b0c-349f71e5099f",
            "flavor_23_38912"        => "af8fbd94-ee70-4a7a-b3ec-2c70e4e60917",
            "flavor_23_39936"        => "456c69b5-624e-4e67-8864-7595a858ae9b",
            "flavor_23_40960"        => "a64cf740-222b-4e84-a074-1d59c7ab418d",
            "flavor_23_41984"        => "57387ff6-bf16-4c27-b6bf-3774ee1fb1ff",
            "flavor_23_44032"        => "c250bf41-7559-4270-9ce4-75ce7dff0a12",
            "flavor_23_45056"        => "f920d0b2-70e1-428d-85b4-0ef15ad60a59",
            "flavor_23_46080"        => "c5de28ac-8216-4e8c-9e96-9c84e7e5783a",
            "flavor_23_47104"        => "41a3e850-3f8d-4d17-ac33-ac6039d9eae4",
            "flavor_23_48128"        => "603fb922-f726-4d18-9d6d-d920337d1a13",
            "flavor_23_50176"        => "18726edc-7ec8-4548-903c-af776a3a2fff",
            "flavor_23_51200"        => "fb8fa2f6-3829-4adc-bfd3-bf675d20338f",
            "flavor_23_52224"        => "e4599da8-a646-4752-89f4-09e20dfccc36",
            "flavor_23_53248"        => "55918d33-2e0b-498b-bc16-34d976567b59",
            "flavor_23_54272"        => "baf70070-26c5-4fb6-8653-7d3fc237f230",
            "flavor_23_56320"        => "cce79dc4-70d3-4bcd-8b00-4fdc20a09efe",
            "flavor_23_57344"        => "53d99342-b2e4-4e5a-b0ec-881095504e95",
            "flavor_23_58368"        => "17c1b255-30a7-4590-9c11-eed748cdd446",
            "flavor_23_59392"        => "ffc70217-636f-46af-9716-0750eeab3224",
            "flavor_23_60416"        => "a862d2ea-5e3e-46be-b0d6-7d39cf6d97c1",
            "flavor_23_61440"        => "2a9f9be0-7b84-4213-8e90-57186f88b101",
            "flavor_23_62464"        => "a59ee0ec-a17e-4edf-a5e6-e0ebbd9e148e",
            "flavor_23_63488"        => "bfc9ec9d-a5d2-41b4-8a76-b16561e84a5d",
            "flavor_23_64512"        => "b9a602da-aa6d-4002-8265-ccff70992ebc",
            "flavor_23_66560"        => "d843d199-38d4-4c2e-a494-716b062bcf45",
            "flavor_23_67584"        => "85d77677-b690-4a69-bec8-8d6a9c1e22c7",
            "flavor_23_68608"        => "a0fa70f2-a41e-4d98-afb9-d248c37862ae",
            "flavor_23_69632"        => "9b4e4dad-15b8-4158-9b84-5205f2b3e73c",
            "flavor_23_70656"        => "27cd5a46-f380-410f-bdb9-5dbf7078bc66",
            "flavor_23_71680"        => "4776d724-8d86-4546-9bb6-d4e7b20aed57",
            "flavor_23_72704"        => "203a6e88-534c-44ff-a10b-82c55d56dbea",
            "flavor_23_73728"        => "fd529830-1a09-4a18-88ac-25d64fbd7f9e",
            "flavor_23_74752"        => "6d05d61f-0ffd-44a2-82ff-c5947c0a4b86",
            "flavor_23_75776"        => "4c3c4253-b751-444c-befe-bf60807c1210",
            "flavor_23_76800"        => "c379f01d-c772-4f29-8817-46e3532020d2",
            "flavor_23_77824"        => "b7557848-50fa-46b0-bc93-cf02a1181f16",
            "flavor_23_78848"        => "18084128-1cd6-43fd-8ae4-037136ac280c",
            "flavor_23_79872"        => "461fb337-e4ad-46fd-8396-01a51b803152",
            "flavor_23_80896"        => "6330d7df-c68e-4292-8c99-7760457b343a",
            "flavor_23_81920"        => "4e0d2765-501d-44ee-9497-5477da8d9e6b",
            "flavor_23_82944"        => "df2914f3-71e7-4fe4-9597-35374a2d25bb",
            "flavor_23_83968"        => "382cf38d-c788-4730-9324-6abd5804fd35",
            "flavor_23_84992"        => "633e8a3f-96ae-4716-a64f-902a558e0cc7",
            "flavor_23_86016"        => "4a573d0b-414a-4a43-be74-3b0610b2d9bb",
            "flavor_23_87040"        => "d733a972-1086-4caf-8c5e-db39eb6248a4",
            "flavor_23_88064"        => "3ab24efe-8351-464d-a04d-ec4761db7608",
            "flavor_23_89088"        => "aeb94ca4-e0dd-469e-9422-948c06779e79",
            "flavor_23_90112"        => "40220a3f-eddf-4e45-9ae4-a372eb7c8ebe",
            "flavor_23_91136"        => "39f315a8-2e22-4833-8f35-ba31699dbc60",
            "flavor_23_92160"        => "29ec234c-307f-4fd6-b62a-2bff3a204860",
            "flavor_23_93184"        => "e1729700-8b65-4014-b24e-bbc288e258d9",
            "flavor_23_94208"        => "7dfc3b7d-17a5-476b-a5df-9713def241b6",
            "flavor_23_95232"        => "8f3d7fdf-4a1c-4f9f-9746-66aff458ff4f",
            "flavor_23_96256"        => "e1f20424-f713-4cab-b6df-ae0996d21e3b",
            "flavor_23_97280"        => "9aaf00f6-63f5-4c0a-831d-6dbab8e957d9",
            "flavor_23_98304"        => "f7d66f58-ca37-46a6-b133-a7c37138b553",
            "flavor_23_99328"        => "e0d69621-36fe-4be4-91cc-41f61b4741a6",
            "flavor_23_100352"       => "1971e712-58a4-4ba9-9336-675df399ec4c",
            "flavor_23_101376"       => "28d90351-18b7-44c3-88b9-bad703062fbe",
            "flavor_23_102400"       => "f41b802a-8b1d-4902-9726-3f82361429bf",
            "flavor_23_103424"       => "838a62a4-2fd0-4a3d-bdc2-5ab46962fea1",
            "flavor_23_104448"       => "0a48e55e-2228-449c-a784-cb7e69bf1380",
            "flavor_23_105472"       => "fbaf1007-ef2d-488c-9221-5464309cefaa",
            "flavor_23_106496"       => "df342396-83fc-439e-aa7d-b18fab017f90",
            "flavor_23_107520"       => "f9fbd4ba-47db-4f5f-8aaa-7a655b603a92",
            "flavor_23_108544"       => "fd006856-0cf6-4d3b-aac8-5b9a031e8cf6",
            "flavor_23_109568"       => "d109140b-5405-485d-87f2-1e26a43792f2",
            "flavor_23_110592"       => "a8d6e3b2-de13-4e61-a7a8-d6272c3fe18e",
            "flavor_23_111616"       => "423f8ca7-e610-40b9-ad58-7239c56e7efd",
            "flavor_23_112640"       => "0cfedc74-55bf-406f-8959-26ccbda463f6",
            "flavor_23_113664"       => "971457ae-8afb-46f5-82f8-87f3abb673be",
            "flavor_23_114688"       => "9244038d-f719-4c16-8bc6-9b685a942837",
            "flavor_23_115712"       => "6c8a3047-90f3-41c5-9819-e2fe8abcc5c3",
            "flavor_23_116736"       => "40717271-5a5c-4cf1-b77b-afcefaa66c61",
            "flavor_23_117760"       => "d4a66083-0639-4315-9df5-bfa034d29292",
            "flavor_23_118784"       => "8845dfc0-b9e8-4f38-8b14-565c98e0b597",
            "flavor_23_119808"       => "57795c79-a292-4e44-b6be-28fd0c200550",
            "flavor_23_120832"       => "90358ce8-df0f-45a9-8209-5a1115e0885d",
            "flavor_23_121856"       => "8271dcf7-c335-4177-a2ec-d3c5fd00718a",
            "flavor_23_122880"       => "e9864902-a72b-4783-859f-4e8359a423fe",
            "flavor_23_123904"       => "41f42d37-1b85-414a-bdaf-cec322550f32",
            "flavor_23_124928"       => "0d646732-d243-4228-b1ac-1e8270552e38",
            "flavor_23_125952"       => "3a3b0c9c-e77a-4c38-b8bc-e33d318c6b00",
            "flavor_23_126976"       => "14f632eb-f660-4c63-a53f-45011e3a54f5",
            "flavor_23_128000"       => "50dc172d-a89d-4cb2-bdec-43ac56626d0a",
            "flavor_23_129024"       => "e1c53099-13d5-42ee-90b9-10ed9f0b048e",
            "flavor_23_130048"       => "02c78910-d97f-4ace-929f-edb8dd854bec",
            "flavor_24_5120"         => "badd080b-d6b0-45e9-8bad-e136a70a24f7",
            "flavor_24_7168"         => "d5eb8bdc-561d-4390-9f77-cfa5330cd98f",
            "flavor_24_9216"         => "41d0374b-3372-4545-8760-1236be6c1c71",
            "flavor_24_11264"        => "3ea1cea3-80c0-4313-9f3b-c817106ab441",
            "flavor_24_13312"        => "d196b3f0-ad53-4d25-a15f-cf6d295b3f76",
            "flavor_24_14336"        => "00c4d450-0972-4574-9427-8d0672f6dccc",
            "flavor_24_15360"        => "2594cf1d-2dd1-4509-8748-cf4c208c75e1",
            "flavor_24_17408"        => "9c4a43c5-e5ad-4c95-9146-87ee96a3ce2d",
            "flavor_24_18432"        => "1b3a4411-1490-460f-b9df-718257b8cbd3",
            "flavor_24_19456"        => "463e28aa-ae73-4654-a052-356321d691fd",
            "flavor_24_20480"        => "2e602ea4-6d0f-4eed-a259-6bdb81076060",
            "flavor_24_21504"        => "933e6d64-85f0-4f4e-a9ef-29d10acb0711",
            "flavor_24_22528"        => "1ccb821f-9c10-4a53-a9a9-91f2123e8370",
            "flavor_24_23552"        => "b217ce8b-3230-4428-9588-1e1b8244c98e",
            "flavor_24_25600"        => "4fee04b9-180b-421d-ac49-d2f7e13b32a0",
            "flavor_24_26624"        => "287d479b-c9f3-4910-bc0f-b4532ac4c519",
            "flavor_24_27648"        => "b1f3e794-3145-4410-9499-e8d88091a084",
            "flavor_24_28672"        => "1e0d0538-4775-4ec4-939a-ea79ebf5504d",
            "flavor_24_29696"        => "abec9ab2-68dd-47b1-92cf-4be014826581",
            "flavor_24_30720"        => "6939ecdf-d5cf-4523-8804-5c3c72673495",
            "flavor_24_31744"        => "6d1492b4-ca72-4b7e-88c7-1551438cc7e9",
            "flavor_24_33792"        => "b92038a6-f56f-42c6-ab06-6714969cfe5f",
            "flavor_24_34816"        => "586c5691-c6ba-4b37-b46c-0298d410a280",
            "flavor_24_35840"        => "139db55d-4008-4774-9aef-769f6196ea1f",
            "flavor_24_37888"        => "8858eac5-345c-408d-811f-4ec0934c33d8",
            "flavor_24_38912"        => "4dc48dfe-e55f-4a00-b4b2-357c4d8aa19f",
            "flavor_24_39936"        => "996f0a98-4fc5-4eeb-af6f-bc92112558b8",
            "flavor_24_40960"        => "53777db8-4d6a-4a45-b36b-f4d1df44292f",
            "flavor_24_41984"        => "df5205be-1eac-4052-9a00-112c8eeffc21",
            "flavor_24_44032"        => "eb287ca9-61e5-40cb-bb50-cab171af1060",
            "flavor_24_45056"        => "3401655b-980e-4fd1-a1ee-4b980b08c5b7",
            "flavor_24_46080"        => "de164083-47c1-4af2-81cc-9493d89229db",
            "flavor_24_47104"        => "030396b3-dc44-45d6-b080-2ea253060e0b",
            "flavor_24_48128"        => "6e3162bb-a12d-4865-b115-3a33c94f2c77",
            "flavor_24_50176"        => "83362c00-fd2c-4a90-8cc1-1313a0e949d2",
            "flavor_24_51200"        => "8a9079a2-b002-4f18-8cb9-7ae0caee58e0",
            "flavor_24_52224"        => "68a40d5c-d403-4fa7-98ce-2e3b4208599f",
            "flavor_24_53248"        => "b0a0bcd1-2128-4077-ba17-90a06516a959",
            "flavor_24_54272"        => "b941cdc6-a163-489b-9d3d-da3b571e881e",
            "flavor_24_56320"        => "119378cf-9232-4731-92cb-aab1a8304c3c",
            "flavor_24_57344"        => "c4e9bc9b-dafb-459a-9f90-bcd076228189",
            "flavor_24_58368"        => "fa03edba-cba5-48f6-b5d8-2f8b1933b6b5",
            "flavor_24_59392"        => "85f066c6-e17c-406c-b8c1-70f4e5451d93",
            "flavor_24_60416"        => "2f742b96-b73b-444d-a4c8-65bc9e212b5f",
            "flavor_24_61440"        => "fe35ced0-824e-4b96-bea9-1ab57782714a",
            "flavor_24_62464"        => "8cca1805-d3f0-45c3-b607-c3deca54413d",
            "flavor_24_63488"        => "e322b8d6-457b-4d76-819f-cf5986fa3add",
            "flavor_24_64512"        => "dc39c8a7-2c58-4fff-9910-bab046abd34c",
            "flavor_24_66560"        => "8e78966b-583b-4d1d-bfe0-9c2726f8f569",
            "flavor_24_67584"        => "260b537c-545a-46df-899c-7a0394440ef8",
            "flavor_24_68608"        => "97348836-3a1c-415d-af1e-d99fce508070",
            "flavor_24_69632"        => "3dd0672b-5719-41bc-940d-fe7c2bf2ca0c",
            "flavor_24_70656"        => "d91e8144-2af0-4ab6-af65-af51d1e5c41f",
            "flavor_24_71680"        => "5eeaae9b-de4f-42b1-8508-656c84092765",
            "flavor_24_72704"        => "74f8c93a-ca8e-45dd-8ca3-6076b7d5b40b",
            "flavor_24_73728"        => "d7f1e1c0-7dfc-4572-8ad1-8436e353d7e7",
            "flavor_24_74752"        => "43ae611d-90c0-4c27-912f-6eb9ece0931f",
            "flavor_24_75776"        => "ecb52191-128e-4466-ba8f-d2994bb9dc1d",
            "flavor_24_76800"        => "d2d27410-0e73-4a66-bb6a-76fdfc1e0a99",
            "flavor_24_77824"        => "7a553193-569a-4fb4-b225-71ba441ddd65",
            "flavor_24_78848"        => "540e1eca-dc78-4349-a360-8b1976793c4a",
            "flavor_24_79872"        => "f7e6f261-3785-46e3-ba31-0702bc73411a",
            "flavor_24_80896"        => "ac65934b-2120-4fd2-9de1-7597ffb3fb9d",
            "flavor_24_81920"        => "8512b354-f902-4b2b-98bc-1e4ccadb0973",
            "flavor_24_82944"        => "5bb44e8f-1c1e-41ba-a892-41f33b17e274",
            "flavor_24_83968"        => "5e37fb93-3da2-429a-b713-b61aeb09179a",
            "flavor_24_84992"        => "ac71fa6e-f5ad-4dad-b11c-9f55244eb5ff",
            "flavor_24_86016"        => "8af9f5b4-405d-4183-89bd-90e3edb0c13d",
            "flavor_24_87040"        => "bf5dc918-babb-4590-bcf8-536000073782",
            "flavor_24_88064"        => "5ff760bb-7c03-4355-b6c4-b2de6df7173c",
            "flavor_24_89088"        => "4cbaf4e3-4009-4eb7-9f74-7db13d34b38f",
            "flavor_24_90112"        => "5df2e42f-0a01-45f8-a1d7-de3320c2de1c",
            "flavor_24_91136"        => "d336e395-fe97-4642-a36f-2d5a954415d1",
            "flavor_24_92160"        => "acc3f60f-a750-4bab-af4b-60fcf6abb8b9",
            "flavor_24_93184"        => "60242367-7aaf-4a72-aa1b-e484bbb7fcc4",
            "flavor_24_94208"        => "b37578d5-3022-45e0-802b-55056c59c5f0",
            "flavor_24_95232"        => "e1095e71-ab9e-4238-a314-e9cfc7468f3f",
            "flavor_24_96256"        => "5fb96404-6967-4371-8d18-c9cfef4dbd31",
            "flavor_24_97280"        => "d2f25492-b455-4437-af83-6f82b3e38be1",
            "flavor_24_98304"        => "67bfdbf0-462a-4664-88d9-667019a55557",
            "flavor_24_99328"        => "07327e00-ebda-46b5-948d-14de5f16707e",
            "flavor_24_100352"       => "c697ceb7-cf3e-4dcc-b326-70c5d17d80bf",
            "flavor_24_101376"       => "0a63e64a-0c45-4aa3-8454-b4ebfc7d91d9",
            "flavor_24_102400"       => "3603f54d-8baf-4e3b-9e2b-8ca2b6d9be17",
            "flavor_24_103424"       => "9024afd2-4ccc-41ce-b03a-b1ebc8635451",
            "flavor_24_104448"       => "16c3f580-313d-4677-ab1f-a29b08148e87",
            "flavor_24_105472"       => "7743887d-a6d0-40c4-9882-16b8f63132cc",
            "flavor_24_106496"       => "13da2ce8-23e5-4848-a262-131ca4b4bb1a",
            "flavor_24_107520"       => "476824a1-bc56-498b-b958-fc1fecbbd319",
            "flavor_24_108544"       => "7b24e0b4-0d1d-4b19-834d-78853e406f9d",
            "flavor_24_109568"       => "a6c4b7ba-1309-43af-baca-40304f6f85f6",
            "flavor_24_110592"       => "4dd3034b-eca6-442c-a37d-41605f77a9ab",
            "flavor_24_111616"       => "389da23b-62dd-40c1-97f4-33ecd53ed529",
            "flavor_24_112640"       => "bbbd41f7-c9d5-44fe-8114-d2c6c48ffbfb",
            "flavor_24_113664"       => "c3440657-4d18-489e-914d-374deda2ca59",
            "flavor_24_114688"       => "0a29c2ec-2cac-4032-abd7-69fb98fddfc4",
            "flavor_24_115712"       => "358568c6-7caf-464f-a514-8a86c62ce0dc",
            "flavor_24_116736"       => "6a67ba7f-feba-4949-8586-df50377511a1",
            "flavor_24_117760"       => "cfe5db15-7c54-4603-bdc6-0726b1dae9e5",
            "flavor_24_118784"       => "2516deb6-841d-48dd-b305-89e74bb545a7",
            "flavor_24_119808"       => "1efc3bc3-9322-48a6-a7cb-31413983956d",
            "flavor_24_120832"       => "a1813072-08f2-4a3d-8b7f-484bef9fa114",
            "flavor_24_121856"       => "9b9b8ee6-dd59-43c9-aa79-a40a2acaebdf",
            "flavor_24_122880"       => "67e2b355-3c8e-4488-9255-ccd4925c32ca",
            "flavor_24_123904"       => "faa43f9b-5fb2-449b-99a8-ba3738843a64",
            "flavor_24_124928"       => "6aa88096-1a43-452e-84a9-d0ade54c97e9",
            "flavor_24_125952"       => "25b6e40d-2db1-45f6-b999-5dbfa6adc36a",
            "flavor_24_126976"       => "f6efd830-7455-4422-ae46-bb7b989f5e0f",
            "flavor_24_128000"       => "81992c13-e399-4e20-ad92-2fe8d265a2f0",
            "flavor_24_129024"       => "db38715f-165d-47b1-b742-c1e10d4906b0",
            "flavor_24_130048"       => "dc16a618-bf87-43db-8d2e-3f3b71bf0796"
        ];
        return $package;
    }
    public static function ReturnOSID($osname)
    {
        $os = self::ReturnAllOS()["os"];
        if (array_key_exists($osname, $os))
            return ["status" => "success", "os" => $os[$osname], "osname" => $osname];
        else
            return ["status" => "error", $osname, "message" => "سیستم عامل درخواستی شما یافت نشد"];
    }
    public static function ReturnFLAVORID($ram, $vcpu)
    {
        $package = self::ReturnAllPackages();
        $packagename = "flavor_" . $vcpu . "_" . ($ram * 1024);
        if (array_key_exists($packagename, $package))
            return ["status" => "success", "package" => $package[$packagename]];
        else
            return ["status" => "error", "message" => "پکیج انتخابی شما یافت نشد"];
    }
}
