<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class CLOUD_FIREWALLRULES_ADMIN
{

    public static function GetList($token, $fwid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $ca = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if ($ca["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
        }

        $sql = "SELECT cfrid as id ,cfr_traffic_type as trafictype,  cfr_protocol as protocol,
        cfr_port as port, cfr_ip as  ip, cfr_description as description   from " .
            $GLOBALS["tbl_cloud_firewall_rules"] . " WHERE " . $GLOBALS["cfr_cfid_fk"] . "=" . $fwid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function AddAdminFireWallRules($traffictype, $protocol, $port, $ip, $fwid, $iptype)
    {
        $sql = "INSERT INTO " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " VALUES (0,'" . $traffictype . "','" . $protocol . "','" . $port . "','" . $ip . "','" . $fwid . "',''," . $iptype . ",'')";
        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        return [
            "status" => "success",
            "message" => "اطلاعات با موفقیت ثبت شد",
            "id" => $last_id
        ];
    }
    public static function RemoveAllRulesByFirewallID($fwid)
    {
        $sql = "DELETE FROM  " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " WHERE " . $GLOBALS["cfr_cfid_fk"] . "=" . $fwid;
        $conn = GetConnection();
        $conn->query($sql);
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
    }
    public static function AddFireWallRules($token, $traffictype, $protocol, $port, $ip, $fwid, $iptype, $description)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        $ca = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if ($ca["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
        }
        $idcid = $ca["data"][0]["cf_idcid_fk"];
        $security_group_id =  $ca["data"][0]["cf_serverid"];
        $validprotocol = [
            "Any", "Custom TCP Rule", "Custom UDP Rule", "Custom ICMP Rule",
            "Other Protocol", "All ICMP", "All TCP", "All UDP", "TCP", "UDP",
            "DNS", "HTTP", "HTTPS", "IMAP", "IMAPS", "LDAP", "MS SQL", "MYSQL", "POP3", "POP3S", "RDP", "SMTP", "SMTPS", "SSH"
        ];
        $validIPPort = [
			"0"=>"HOPOPT",
			"1"=>"ICMP",
			"2"=>"IGMP",
			"3"=>"GGP",
			"4"=>"IPv4",
			"5"=>"ST",
			"6"=>"TCP",
			"7"=>"CBT",
			"8"=>"EGP",
			"9"=>"IGP",
			"10"=>"BBN-RCC-MON",
			"11"=>"NVP-II",
			"12"=>"PUP",
			"13"=>"ARGUS (deprecated)",
			"14"=>"EMCON",
			"15"=>"XNET",
			"16"=>"CHAOS",
			"17"=>"UDP",
			"18"=>"MUX",
			"19"=>"DCN-MEAS",
			"20"=>"HMP",
			"21"=>"PRM",
			"22"=>"XNS-IDP",
			"23"=>"TRUNK-1",
			"24"=>"TRUNK-2",
			"25"=>"LEAF-1",
			"26"=>"LEAF-2",
			"27"=>"RDP",
			"28"=>"IRTP",
			"29"=>"ISO-TP4",
			"30"=>"NETBLT",
			"31"=>"MFE-NSP",
			"32"=>"MERIT-INP",
			"33"=>"DCCP",
			"34"=>"3PC",
			"35"=>"IDPR",
			"36"=>"XTP",
			"37"=>"DDP",
			"38"=>"IDPR-CMTP",
			"39"=>"TP++",
			"40"=>"IL",
			"41"=>"IPv6",
			"42"=>"SDRP",
			"43"=>"IPv6-Route",
			"44"=>"IPv6-Frag",
			"45"=>"IDRP",
			"46"=>"RSVP",
			"47"=>"GRE",
			"48"=>"DSR",
			"49"=>"BNA",
			"50"=>"ESP",
			"51"=>"AH",
			"52"=>"I-NLSP",
			"53"=>"SWIPE (deprecated)",
			"54"=>"NARP",
			"55"=>"MOBILE",
			"56"=>"TLSP",
			"57"=>"SKIP",
			"58"=>"IPv6-ICMP",
			"59"=>"IPv6-NoNxt",
			"60"=>"IPv6-Opts",
			"61"=>"",
			"62"=>"CFTP",
			"63"=>"",
			"64"=>"SAT-EXPAK",
			"65"=>"KRYPTOLAN",
			"66"=>"RVD",
			"67"=>"IPPC",
			"68"=>"",
			"69"=>"SAT-MON",
			"70"=>"VISA",
			"71"=>"IPCV",
			"72"=>"CPNX",
			"73"=>"CPHB",
			"74"=>"WSN",
			"75"=>"PVP",
			"76"=>"BR-SAT-MON",
			"77"=>"SUN-ND",
			"78"=>"WB-MON",
			"79"=>"WB-EXPAK",
			"80"=>"ISO-IP",
			"81"=>"VMTP",
			"82"=>"SECURE-VMTP",
			"83"=>"VINES",
			"84"=>"TTP",
			"84"=>"IPTM",
			"85"=>"NSFNET-IGP",
			"86"=>"DGP",
			"87"=>"TCF",
			"88"=>"EIGRP",
			"89"=>"OSPFIGP",
			"90"=>"Sprite-RPC",
			"91"=>"LARP",
			"92"=>"MTP",
			"93"=>"AX.25",
			"94"=>"IPIP",
			"95"=>"MICP (deprecated)",
			"96"=>"SCC-SP",
			"97"=>"ETHERIP",
			"98"=>"ENCAP",
			"99"=>"",
			"100"=>"GMTP",
			"101"=>"IFMP",
			"102"=>"PNNI",
			"103"=>"PIM",
			"104"=>"ARIS",
			"105"=>"SCPS",
			"106"=>"QNX",
			"107"=>"A/N",
			"108"=>"IPComp",
			"109"=>"SNP",
			"110"=>"Compaq-Peer",
			"111"=>"IPX-in-IP",
			"112"=>"VRRP",
			"113"=>"PGM",
			"114"=>"",
			"115"=>"L2TP",
			"116"=>"DDX",
			"117"=>"IATP",
			"118"=>"STP",
			"119"=>"SRP",
			"120"=>"UTI",
			"121"=>"SMP",
			"122"=>"SM (deprecated)",
			"123"=>"PTP",
			"124"=>"ISIS over IPv4",
			"125"=>"FIRE",
			"126"=>"CRTP",
			"127"=>"CRUDP",
			"128"=>"SSCOPMCE",
			"129"=>"IPLT",
			"130"=>"SPS",
			"131"=>"PIPE",
			"132"=>"SCTP",
			"133"=>"FC",
			"134"=>"RSVP-E2E-IGNORE",
			"135"=>"Mobility Header",
			"136"=>"UDPLite",
			"137"=>"MPLS-in-IP",
			"138"=>"manet",
			"139"=>"HIP",
			"140"=>"Shim6",
			"141"=>"WESP",
			"142"=>"ROHC",
			"143"=>"Ethernet",
			"144"=>"AGGFRAG",
			"145-252"=>"",
			"253"=>"",
			"254"=>"",
			"255"=>"Reserved"
        ];
        if ($protocol == "Other Protocol") {
            if(!isset($validIPPort[$port])){
                return ["status"=>"error","message"=>"پورت ارسالی نامعتبر است"];
            }
        }
        $port_range_min = 0;
        $port_range_max = 0;

        if ($port != "any") {
            if (strpos($port, '-')) {
                $p = explode("-", $port);
                if (count(($p)) != 2) {
                    return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است"];
                } else {
                    if ($p[0] < 0 || $p[0] > 65535) {
                        return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است"];
                    }
                    if ($p[1] < 0 || $p[1] > 65535) {
                        return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است"];
                    }
                }
                $port_range_min = $p[0];
                $port_range_max = $p[1];
            } else {
                if ($port < 0 || $port > 65535) {
                    return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است"];
                }
                $port_range_min = $port;
                $port_range_max = $port;
            }
        }
        $v = array_map('strtoupper', $validprotocol);
        if (!in_array(strtoupper($protocol), $v)) {
            return ["status" => "error", "message" => "پروتکل ارسالی اشتباه است "];
        }

		$v = array_map('strtoupper', $validprotocol);
        if (!in_array(strtoupper($protocol), $v)) {
            return ["status" => "error", "message" => "پروتکل ارسالی اشتباه است "];
        }
        $validtrafficType = ["inbound", "outbound"];
        if (!in_array($traffictype, $validtrafficType)) {
            return ["status" => "error", "message" => "نوع ترافیک ارسالی اشتباه است"];
        }
        if ($ip == "0.0.0.0/0" || $ip == "::/0") {
        } else {
            if (strpos($ip, '/')) {
                $p = explode("/", $ip);
                if (count(($p)) != 2) {
                    return ["status" => "error", "message" => "IP ارسالی نامعتبر است"];
                } else {
                    if ($p[1] <= 0 || $p[1] >= 32) {
                        return ["status" => "error", "message" => "IP ارسالی نامعتبر است"];
                    }
                    if (!filter_var($p[0], FILTER_VALIDATE_IP)) {
                        return ["status" => "error", "message" => "IP ارسالی نامعتبر است ", $ip];
                    }
                }
            } else {
                if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                    return ["status" => "error", "message" => "IP ارسالی نامعتبر است ", $ip];
                }
            }
        }
        if (CLOUD_FIREWALLRULES_ADMIN::CheckDulicatedRules($traffictype, $protocol, $port, $ip, $fwid)[0]["cid"] != "0") {
            return ["status" => "error", "message" => "قانون درج شده تکراری است"];
        }

        $ethertype = "IPv" . $iptype;

        $projectid = CLOUD_PROJECT_ADMIN::GetUserByIDC($idcid, $uid)["data"][0]["cp_project_id"];

        $direction = $traffictype == "inbound" ? "ingress" : "egress";
        $protocol = $protocol == "any" ? "256" : $protocol;
        $project_id["data"][0]["cp_project_id"] = CLOUD_PROJECT_ADMIN::GetUserByIDC($idcid, $uid);
        $returndid = API_CLOUD_FIREWALLRULES_ADMIN::RunCreateAPIFIREWALLRULES(
            $direction,
            $description,
            $m,
            $idcid,
            $allprotocol[strtoupper($protocol)]["minport"],
            $allprotocol[strtoupper($protocol)]["maxport"],
            $ethertype,
            $ip,
            $security_group_id,
            $allprotocol[strtoupper($protocol)]["proto"],
            $project_id
        );
        $Rarray = json_decode($returndid, true);
        if (isset($Rarray["status"]) && $Rarray["status"] == "error") {
            return ["status" => "error", "message" => "خطا در مقادیر ورودی", $Rarray];
        }
        $sql = "INSERT INTO " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " VALUES (0,'" . $traffictype . "','" . $protocol . "','" . $port . "','" . $ip . "','" . $fwid . "','" .
            self::ReturnServerIDForRules($m, $security_group_id, $idcid) . "'," .
            $iptype . ",'" . $description . "')";
        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $c = self::UpdateServerIDFromAPI($last_id, self::ReturnServerIDForRules($m, $security_group_id, $idcid));
        return ["status" => "success", $returndid, "message" => "اطلاعات با موفقیت ثبت شد", "id" => $last_id];
    }
    public static function UpdateServerIDFromAPI($id, $serverid)
    {
        $sql = "UPDATE " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " SET " . $GLOBALS["cfr_server_id"] . "='" . $serverid . "' WHERE " . $GLOBALS["cfrid"] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function CheckDulicatedRules($trafficType, $protocol, $port, $ip, $fwid)
    {
        $sql = "SELECT count(cfrid) as cid from " . $GLOBALS["tbl_cloud_firewall_rules"] . " WHERE " .
            $GLOBALS["cfr_cfid_fk"] . "='" . $fwid . "' AND " . $GLOBALS["cfr_protocol"] . "='" . $protocol . "' and
        " . $GLOBALS["cfr_traffic_type"] . "='" . $trafficType . "' AND " . $GLOBALS["cfr_port"] . "='" . $port . "' and
        " . $GLOBALS["cfr_ip"] . "='" . $ip . "' ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return $listOfRecordType;
    }
    public static function ReturnServerIDForRules($m, $fwid, $idc)
    {
        $o = API_CLOUD_FIREWALLRULES_ADMIN::RunGetSecurityGroupRules($m, $fwid, $idc);
        $m = str_replace("'", '"', $o);
        $n = json_decode($m, true);
        array_multisort(array_column($n, "created_at"), SORT_DESC, $n);
        return $n[0]["id"];
    }


    public static function GetOneRule($ruleid)
    {
        $sql = "SELECT *  from " .
            $GLOBALS["tbl_cloud_firewall_rules"] . " WHERE " . $GLOBALS["cfrid"] . "=" . $ruleid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function DeleteFireWallRules($token, $fwid, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        $ca = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if ($ca["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
        }
        $sid = self::GetOneRule($id)["data"][0]["cfr_server_id"];

        $sql = "delete  from " . $GLOBALS["tbl_cloud_firewall_rules"] . " WHERE " .
            $GLOBALS['cfrid'] . "=" . $id . " AND " . $GLOBALS["cfr_cfid_fk"] . "=" . $fwid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();

        $out = API_CLOUD_FIREWALLRULES_ADMIN::RunDeleteSecurityGroupRule($m, $sid, $ca["data"][0]["cf_idcid_fk"]);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $out];
    }
}
