<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class MAINPANEL_ADMIN
{

    public static function GetLastestTicketAndDomains($token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);

        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $ticketlist = SUPPORTTICKETS_ADMIN::GetList($uid, 1, 15);
        $domainslist = DOMAINS_ADMIN::GetListOfAllRecordForMainPage($uid);
        $servers = CLOUD_SERVER_ADMIN::GetServerForUser($uid,true);
        return ["status" => "success", "ticket" => $ticketlist, "domains" => $domainslist, "servers" => $servers];
    }

    public static function GetServices($token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);

        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $ticketlist = CLOUD_SERVER_ADMIN::GetServerForUser($uid);
        $domainslist = DOMAINS_ADMIN::GetListOfAllRecordForMainPage($uid);

        return ["status" => "success", "servers" => $ticketlist, "domains" => $domainslist];
    }

    public static function UpdateWebsiteCache($token, $websiteid, $status, $browsercachettl, $servercachettl)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        if (empty($status)) {
            return ["status" => "error", "message" => "امکان خالی بودن وضعیت وجود ندارد"];
        }
        $allowedstatus = ["1", "2", "3", "4"];
        $methods = explode(",", $status);
        $res = [];
        $stat = 1;
        foreach ($methods as $method) {
            if (!in_array(strtoupper($method), $allowedstatus)) {
                $stat = 0;
                array_push(
                    $res,
                    ["status" => "error", "status" => $status, "message" => "وضعیت نامعتبر است"]
                );
            }
        }
        if ($stat == 0) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی"];
        }
        $browser_cache_ttl_array = [
            "30m" => "30", "1h" => "60",
            "2h" => "120", "3h" => "180", "4h" => "240",
            "5h" => "300", "8h" => "480", "12h" => "720", "16h" => "960", "20h" => "1200",
            "1d" => "1440", "2d" => "2880", "3d" => "4320", "4d" => "5760",
            "5d" => "7200", "8d" => "11520", "16d" => "23040",
            "24d" => "34560", "1m" => "43200", "2m" => "86400",
            "6m" => "259200", "1y" => "518400"
        ];
        if (!array_key_exists($browsercachettl, $browser_cache_ttl_array)) {
            return ["status" => "error", "message" => "مقدار ارسالی برای زمان کش اطلاعات در مرورگر کاربر اشتباه است"];
        }
        if (!array_key_exists($servercachettl, $browser_cache_ttl_array)) {
            return ["status" => "error", "message" => "مقدار ارسالی برای زمان کش اطلاعات در سرور های CDN اشتباه است"];
        }
        $serverttl = $browser_cache_ttl_array[$servercachettl];
        $browserttl = $browser_cache_ttl_array[$browsercachettl];

        $sql = "SELECT * FROM " . $GLOBALS["cache_tablename"] .
            " WHERE " . $GLOBALS["mc_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["cache_tablename"] . " (" . $GLOBALS['mc_wid_fk'] . "," . $GLOBALS['mc_type'] . "," . $GLOBALS['mc_browsercache_ttl'] . "," . $GLOBALS['mc_servercache_ttl'] . ")
            VALUE (" . $websiteid . "," . $status . ",'" . $browserttl . "','" . $serverttl . "')";
        } else {
            $ins = "UPDATE " . $GLOBALS["cache_tablename"] . " SET " . $GLOBALS['mc_type'] . "=" . $status . "," . $GLOBALS['mc_browsercache_ttl'] . "='" . $browserttl . "'," .
                $GLOBALS['mc_servercache_ttl'] . "='" . $serverttl . "'
                WHERE " . $GLOBALS['mc_wid_fk'] . "=" . $websiteid;
        }
        $conn->query($ins);
        $conn->close();
        $cacheTypes = ["vqs", "wqs", "nocache"];
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        API_CAHCE_ADMIN::RunCreateAPICacheLevel($dmn, $cacheTypes[$status - 1], null);
        API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, $browserttl, null);
        API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, $serverttl, null);

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
}
