<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/admin/admin_field_web.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/sendrequest/send.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/middlelog/middlelog.php';

class API_CDN_ADMIN
{

    public static function RunCreateAPICDN($domain, $ip, $protocol = "scheme", $port = "80")
    {

        $actionUrl = "api/";
        $postededata["action"] = "http_create";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));
        $postededata["ip"] = $ip;
        $postededata["port"] = $port;
        if ($protocol != "http") {
            if ($protocol != "https") {
                $protocol = "scheme";
            }
        }
        $postededata["protocol"] = strtolower($protocol);
        if (strpos($domain, '.') !== false) {
            $apiOut = SENDAPI::SendCDNAPI($actionUrl, $postededata);
            $cljs = json_encode($postededata);
            str_replace("'", "\'", $cljs);
            // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

            return $apiOut;
        }
    }
    public static function RunDisableAPICDN($domain)
    {
        $actionUrl = "api/";
        $postededata["action"] = "reweb_disable";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));
        $postededata["id"] = md5($domain);
        $apiOut =  SENDAPI::SendCDNAPI($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return $apiOut;
    }
    public static function RunAddWWWRecord($domain, $action)
    {
        $actionUrl = "api/";
        if ($action == "add")
            $postededata["action"] = "http_addwww";
        else
            $postededata["action"] = "reweb_addwww";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));
        $apiOut =  SENDAPI::SendCDNAPI($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return $apiOut;
    }
    public static function RunDeleteDomainCDN($domain)
    {
        $actionUrl = "api/";
        $postededata["action"] = "dns_delete";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
    public static function RunDeleteSignleDomainCDN($domain)
    {
        $actionUrl = "api/";
        $postededata["action"] = "reweb_domain";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
    public static function RunwwwstatusCDN($domain, $status)
    {
        $actionUrl = "api/";
        $postededata["action"] = "http_wwwredirect";
        if ($status == "off")
            $postededata["action"] = "reweb_wwwredirect";
        $postededata["wtype"] = $status;
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
    public static function RunEanbleCDN($domain)
    {
        $actionUrl = "api/";
        $postededata["action"] = "http_enable";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
}
