from django.db import models
from datetime import datetime
from django.utils import timezone
from django.contrib.auth.models import AbstractBaseUser
from .managers import CustomUsersManager


class Users(AbstractBaseUser):
    user_name = models.CharField(max_length=125, null=True, unique=True)
    first_name = models.CharField(max_length=125, null=True)
    last_name = models.CharField(max_length=125, null=True)
    personnel_code = models.CharField(max_length=125, null=True)
    mobile = models.CharField(max_length=255, null=True)
    email = models.EmailField(null=True)
    job_title = models.CharField(max_length=125, null=True)
    department = models.CharField(max_length=125, null=True)
    office_name = models.CharField(max_length=125, null=True)
    national_code = models.CharField(max_length=10, null=True)
    
    is_active = models.BooleanField(default=False)
    is_guest = models.BooleanField(default=False)
    is_admin = models.BooleanField(default=False)
    group_permission = models.BooleanField(default=True)
    role = models.ForeignKey('Roles', on_delete=models.SET_NULL, null=True)
    created_at = models.DateTimeField(auto_now=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, null=True)
    last_login = models.DateTimeField(null=True)
    birthday = models.DateTimeField(null=True)
    password = models.CharField(max_length=250, null=True)
    
    USERNAME_FIELD = "user_name"
    REQUIRED_FIELDS = ["password"]
    
    objects = CustomUsersManager()
    
    class Meta:
        db_table = "users"



class Roles(models.Model):
    
    name = models.CharField(max_length=125, null=False)
    parent = models.ForeignKey('self', on_delete=models.SET_NULL, null=True, blank=True)
    created_at = models.DateTimeField(auto_now=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, null=True)
    
    class Meta:
        db_table = "roles"


class Permissions(models.Model):
    
    name = models.CharField(max_length=125, null=False)
    parent = models.ForeignKey('self', on_delete=models.SET_NULL, null=True, blank=True)
    created_at = models.DateTimeField(auto_now=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, null=True)
    
    class Meta:
        db_table = "permissions"


class PermissionUsers(models.Model):
    
    user = models.ForeignKey("Users", on_delete=models.SET_NULL, null=True, blank=True)
    permission = models.ForeignKey("Permissions", on_delete=models.SET_NULL, null=True, blank=True)
    created_at = models.DateTimeField(auto_now=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, null=True)

    class Meta:
        db_table = "permission_users"


class PermissionRoles(models.Model):
    
    role = models.ForeignKey("Roles", on_delete=models.SET_NULL, null=True, blank=True)
    permission = models.ForeignKey("Permissions", on_delete=models.SET_NULL, null=True, blank=True)
    created_at = models.DateTimeField(auto_now=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, null=True)
    
    class Meta:
        db_table = "permission_roles"


class DailyNotes(models.Model):
    
    user = models.ForeignKey("Users", on_delete=models.SET_NULL, null=True, blank=True)
    note = models.TextField()
    note_date = models.DateField(null=True)
    created_at = models.DateTimeField(auto_now=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, null=True)
    
    class Meta:
        db_table = "daily_notes"
