from django.db import models
from usermanagement.models import Users
from django.contrib.auth import get_user_model


class FieldType(models.Model):
    
    field_type_name = models.CharField(max_length=255, unique=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = 'custom_field_type'


class TicketStatus(models.Model):
    
    status_name = models.CharField(max_length=255, unique=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = 'ticket_status'


class Ticket(models.Model):
    
    title = models.CharField(max_length=255)
    user = models.ForeignKey(Users, on_delete=models.CASCADE, related_name='user')
    status = models.ForeignKey(TicketStatus, on_delete=models.SET_NULL, null=True, blank=True)
    department = models.ForeignKey('TicketDepartment', on_delete=models.CASCADE)
    closed_date = models.DateTimeField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = 'tickets'


class TicketDepartment(models.Model):
    
    department_name = models.CharField(max_length=255, unique=True)
    description = models.TextField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    @property
    def get_department_name(self):
        return self.department_name
    
    class Meta:
        db_table = 'ticket_department'

                                    
class CustomFields(models.Model):
    
    field_name = models.CharField()
    field_type = models.ForeignKey(FieldType, on_delete=models.SET_NULL, null=True, blank=True)
    description = models.TextField(null=True, blank=True)
    select_options = models.JSONField()
    display_order = models.IntegerField()
    required = models.BooleanField(default=False)
    ticket_department = models.ForeignKey(TicketDepartment, on_delete=models.SET_NULL, null=True, blank=True)
    related_field = models.ForeignKey('self', on_delete=models.SET_NULL, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = 'custom_fields'


class CustomFieldValues(models.Model):
    
    custom_field = models.ForeignKey(CustomFields, on_delete=models.CASCADE, related_name='customfield')
    ticket = models.ForeignKey(Ticket, on_delete=models.CASCADE, related_name='ticketid')
    value = models.TextField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = 'custom_field_values'


class Attachment(models.Model):

    reply = models.ForeignKey("TicketReply", on_delete=models.CASCADE)
    file = models.FileField(upload_to='tickets/',max_length=1000)
    created_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = "ticket_attachments"


class TicketReply(models.Model):
    
    ticket = models.ForeignKey(Ticket, on_delete=models.CASCADE)
    user = models.ForeignKey(Users, on_delete=models.CASCADE)
    is_staff = models.BooleanField(default=False)
    staff_name = models.CharField(max_length=255, blank=True, null=True)
    message = models.TextField()
    reply_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = "ticket_replies"





class ITEquipmentUnits(models.Model):
    
    name = models.CharField(max_length=22, unique=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    class Meta:
        db_table = "it_equipment_units"


class ITEquipmentRequests(models.Model):
    
    user = models.ForeignKey(Users, on_delete=models.CASCADE)
    description = models.TextField()
    result = models.TextField()
    status = models.ForeignKey(TicketStatus, on_delete=models.SET_NULL, null=True, blank=True)
    close = models.BooleanField(default=False)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "it_equipment_requests"


class ITEquipmentRequestDetail(models.Model):
    
    it_equipment_request = models.ForeignKey(ITEquipmentRequests, models.CASCADE)
    title = models.CharField(max_length=255)
    unit = models.ForeignKey(ITEquipmentUnits, on_delete=models.SET_NULL, null=True, blank=True)
    count = models.IntegerField()
    description = models.TextField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "it_equipment_request_details"





class MeetingRequestType(models.Model):
    
    name = models.CharField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "meeting_types"


class MeetingRequestServe(models.Model):
    
    name = models.CharField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "meeting_servers"


class MeetingRequestLocation(models.Model):
    
    building = models.CharField()
    room = models.CharField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "meeting_locations"


class MeetingRequestContentType(models.Model):
    
    name = models.CharField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "meeting_content_types"


class MeetingRequest(models.Model):
    
    user = models.ForeignKey(Users, on_delete=models.CASCADE)
    internal_phone = models.CharField(max_length=255)
    title = models.CharField(max_length=255)
    people_count = models.IntegerField()
    meeting_type = models.ForeignKey(MeetingRequestType, on_delete=models.SET_NULL, null=True, blank=True)
    meeting_content_type = models.ForeignKey(MeetingRequestContentType, on_delete=models.SET_NULL, null=True, blank=True)
    meeting_location = models.ForeignKey(MeetingRequestLocation, on_delete=models.SET_NULL, null=True, blank=True)
    meeting_serve = models.ForeignKey(MeetingRequestServe, on_delete=models.SET_NULL, null=True, blank=True)
    start_date_time = models.DateTimeField()
    end_date_time = models.DateTimeField()
    description = models.TextField()
    status = models.ForeignKey(TicketStatus, on_delete=models.SET_NULL, null=True, blank=True)
    close = models.BooleanField(default=False)
    result = models.CharField(max_length=255, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "meetings"




class FurnitureUnits(models.Model):
    
    name = models.CharField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "furniture_units"


class FurnitureRequests(models.Model):
    
    user = models.ForeignKey(Users, on_delete=models.CASCADE)
    description = models.TextField()
    result = models.TextField()
    status = models.ForeignKey(TicketStatus, on_delete=models.SET_NULL, null=True, blank=True)
    close = models.BooleanField(default=False)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "furniture_requests"
    

class FurnitureRequestDetail(models.Model):
    
    furniture_request = models.ForeignKey(FurnitureRequests, models.CASCADE)
    title = models.CharField(max_length=255)
    unit = models.ForeignKey(FurnitureUnits, on_delete=models.SET_NULL, null=True, blank=True)
    count = models.IntegerField()
    description = models.TextField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "furniture_request_details"





class GamingRequestType(models.Model):
    
    name = models.CharField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = "gaming_request_types"


class GamingRoomRequest(models.Model):
    
    start_date_time = models.DateTimeField()
    end_date_time = models.DateTimeField()
    internal_phone = models.CharField(max_length=255)
    result = models.CharField(max_length=255, null=True, blank=True)
    hours_requested = models.FloatField(default=0.00)
    status = models.ForeignKey(TicketStatus, on_delete=models.SET_NULL, null=True, blank=True)
    users = models.ManyToManyField(get_user_model(), related_name='gaming_room_requests')
    game_type = models.ForeignKey(GamingRequestType, on_delete=models.SET_NULL, null=True, blank=True)
    applicant = models.ForeignKey(Users, on_delete=models.CASCADE)
    description = models.TextField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    class Meta:
        db_table = "gaming_room_requests"
        verbose_name_plural = "Gaming Room Requests"


class VersioningSGI(models.Model):
    
    version_number = models.CharField(max_length=255)
    version_date = models.DateTimeField()
    features = models.JSONField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)





class LoanRequest(models.Model):
    
    REQUEST_STATUS = (
        (1, "registerd"),
        (2, "verrified"),
        (3, "failed"),
    )
    
    user = models.ForeignKey(Users, on_delete=models.CASCADE)
    requested_price = models.FloatField(default=0.00)
    description = models.TextField()
    request_status = models.CharField(max_length=225, choices=REQUEST_STATUS)
    result_text = models.CharField()
    
    
    

